@extends('frontend.layouts.app')

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush

@section('content')
<div class="row page-titles">
    <div class="col-md-7 align-self-center">
        <h3 class="text-themecolor">Add New Shipping Address</h3>
    </div>
    {{-- <div class="col-md-5 align-self-center">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ url('tickets') }}">Tickets</a></li>
            <li class="breadcrumb-item">New Ticket</li>
        </ol>
    </div>     --}}
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')
                    {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.store_shipping_address'))->class('form-horizontal')->open() }}
                    <div style="margin-top:10px;" class="col-md-6">
                        <div class="form-group">
                            <label>Address Type <b style="color: red;">*</b></label>
                            <select class="form-control" name="address_type" id="address_type"  required>
                                <option value="">Select</option>
                                <option value="Home">Home</option>
                                <option value="Office/Commercial">Office/Commercial</option>
                              </select>
                        </div>
                        <div class="form-group">
                            <label>Address <b style="color: red;">*</b></label>
                            <textarea class="form-control" id="address" name="address" rows="5"  required></textarea>
                        </div>
                        <div class="form-group">
                            <label>ZipCode <b style="color: red;">*</b></label>
                            <input type="text" class="form-control" id="zip_code" name="zip_code" autocomplete="off" placeholder="Enter Zip/Pin code"  required>
                        </div>

                        <div class="form-group">
                            <label>Country <b style="color: red;">*</b></label>
                                <select class="form-control" id="country-dd" name="country" required>
                                  <option value="">Select Country</option>
                                  @foreach ($items as $key => $value)
                                    <option value="{{ $key  }}">{{ $value }}</option>
                                  @endforeach
                                </select>
                        </div>

                        <div class="form-group">
                            <label>State <b style="color: red;">*</b></label>
                                <select class="form-control" name="state" id="state-dd" required>
                                    <option value=""></option>
                                </select>
                        </div>

                        <div class="form-group">
                            <label>City <b style="color: red;">*</b></label>
                            <input type="text" class="form-control" id="city" name="city" autocomplete="off" placeholder="Enter City"  required>
                        </div>

                        <div class="form-group">
                            <label>Mobile <b style="color: red;">*</b></label>
                            <input type="text" class="form-control" id="mobile" name="mobile" autocomplete="off" placeholder="Enter Mobile number" required>
                        </div>

                        <div class="form-group" style="text-align: center">
                            <button type="submit" class="btn btn-themecolor">Submit</button>
                        </div>
                        {{ html()->closeModelForm() }}  
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection
@push('after-scripts')
<script>
    $(document).ready(function () {
        $('#country-dd').on('change', function () {
            var idCountry = this.value;
            $("#state-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-states')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#state-dd').html('<option value="">Select State</option>');
                    $.each(result.states, function (key, value) {
                        $("#state-dd").append('<option value="'+ value.id + '">' + value.name + '</option>');
                    });
                }
            });
        });
  
    });
  </script>
@endpush