@extends('frontend.layouts.app')

@section('content')

    <div class="row page-titles p-4 pb-0 wrapper">
        <div class="col-12 align-self-center">
            <h3 class="text text-themecolor">{{ __('labels.frontend.user.profile.track_university_aplication') }}
                #{{ $data->appl_id }}
            </h3>
        </div>
    </div>


    <div class="container-fluid mt-2">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        @include('includes.partials.messages')
                        @if ($data->type == 'visa')
                            <h4 class="card-title">{{ $data->country }}</h4>
                            <h5 class="card-subtitle">{{ get_visa_service_type_name($visa_pref->service_type) }} /
                                {{ get_visa_letter_type_name($visa_pref->letter_type) }}</h5>
                            <p style="padding-top:6px;"><span
                                    class="badge rounded-pill bg-danger">{{ $data->status }}</span></p>
                        @elseif($data->type == 'abroad_job')
                            <h4 class="card-title">{{ $data->country }}</h4>
                            <p style="padding-top:6px;"><span
                                    class="badge rounded-pill bg-danger">{{ $data->status }}</span></p>
                        @else
                            <h4 class="card-title">
                                @if ($course_id)
                                    <a target="_blank" href="{{ url('course-finder/course-details/') . '/' . $course_id }}">
                                        {{ $course }}
                                    </a>
                                @else
                                    {{ $course }}
                                @endif
                            </h4>
                            <h5 class="card-subtitle">
                                @if ($uni_id)
                                    <a target="_blank"
                                        href="{{ url('course-finder/university-details/') . '/' . $uni_id }}">{{ $university }}</a>@else{{ $university }}
                                @endif, {{ $country }}
                            </h5>
                            <p style="padding-top:6px;"><span
                                    class="badge rounded-pill bg-danger">{{ $data->status }}</span></p>

                            <div class="row my-4 py-3">
                                <div class="col-12">
                                    <div class="row">
                                        <h4 class="mb-3 p-3 w-100 border-bottom border-bottom"
                                            style="background-color: #f5f6f7">
                                            {{ __('labels.frontend.user.profile.document_requests') }}</h4>
                                    </div>
                                </div>
                                <div class="col-12" style="margin-top: -15px !important;">
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('labels.general.date') }}</th>
                                                    <th>{{ __('labels.frontend.user.profile.document_requested') }}</th>
                                                    <th>{{ __('labels.frontend.user.profile.upload_date') }}</th>
                                                    <th>{{ __('labels.frontend.user.profile.file') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if (count($applicationDocRequest))
                                                    @foreach ($applicationDocRequest as $docRequest)
                                                        <tr>
                                                            <td>{{ date('d M Y h:i A', strtotime($docRequest->created_at)) }}
                                                            </td>
                                                            <td>{{ $docRequest->title }}</td>
                                                            <td>
                                                                @if ($docRequest->uploaded_at)
                                                                    {{ date('d M Y h:i A', strtotime($docRequest->uploaded_at)) }}
                                                                @else
                                                                    --
                                                                @endif
                                                            </td>
                                                            <td class="">
                                                                @if ($docRequest->files)
                                                                    @php
                                                                        $all_files = explode('|', $docRequest->files);
                                                                    @endphp
                                                                    <ul class="list-unstyled">
                                                                        @foreach ($all_files as $file)
                                                                            <li>
                                                                                <a class="small" href="<?php echo url('storage/cert/' . $file); ?>"
                                                                                    target="_blank">{{ $file }}</a>
                                                                            </li>
                                                                        @endforeach
                                                                    </ul>
                                                                @else
                                                                    <form
                                                                        action="{{ route('frontend.user.application.upload-requested-document') }}"
                                                                        method="post" enctype="multipart/form-data">
                                                                        @csrf
                                                                        <input type="hidden" name="doc_request_id"
                                                                            value="{{ $docRequest->id }}">
                                                                        <input type="hidden" name="application_id"
                                                                            value="{{ $data->id }}">
                                                                        <div class="input-group mb-3">
                                                                            <input type="file" name="file_upload[]"
                                                                                id="file_upload"
                                                                                class="form-control file_edu"
                                                                                accept=".doc,.docx,.pdf,.jpeg" multiple
                                                                                required>
                                                                        </div>
                                                                        <button type="submit"
                                                                            class="btn btn-sm btn-themecolor text-white">{{ __('labels.frontend.user.profile.upload') }}</button>
                                                                    </form>
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <tr>
                                                        <td colspan="4" class="text-center">
                                                            {{ __('labels.frontend.user.profile.no_record_round') }}</td>
                                                    </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        @endif
                        <div class="row">
                            <h4 class="my-4 p-3 w-100 border-bottom" style="background-color: #f5f6f7">
                                {{ __('labels.frontend.user.profile.message_history') }}
                            </h4>
                            <div class="col-11 rounded mx-auto my-4 "
                                style="max-height: 300px; min-height:100px; overflow-y: auto; background-color: #EDF2FC !important; border: 1px solid rgb(220 220 220);">
                                @if (count($app_messages) > 0)
                                    @foreach ($app_messages as $msgs)
                                        <ul class="list-unstyled">
                                            <li class="justify-content-end">
                                                <div class="card-body p-0 d-flex w-auto"
                                                    style="max-width: 75%; min-width:40%; @if ($msgs->user_id == $logged_in_user->id) float:right; clear: both; @endif">
                                                    <div class="alert my-2"
                                                        style="@if ($msgs->user_id == $logged_in_user->id) background-color: #d4e5ff;@else background-color: #fff; @endif"
                                                        role="alert">
                                                        @if ($msgs->staff_id)
                                                            <p
                                                                class="fw-bold mb-0  @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                {{ get_user_full_name_by_id($msgs->staff_id) }}</p>
                                                        @else
                                                            <p
                                                                class="fw-bold mb-0 @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                {{ get_user_full_name_by_id($msgs->user_id) }}</p>
                                                        @endif
                                                        <p
                                                            class="mb-0 text-muted @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                            <small>{{ date('d-M-Y h:i A', strtotime($msgs->created_at)) }}</small>
                                                        </p>
                                                        <div class="rounded-3" style="">
                                                            <p style="font-size: 15px; "
                                                                class="@if ($msgs->user_id == Auth::user()->id) text-start @endif">
                                                                {!! nl2br($msgs->message) !!}</p>
                                                            @if ($msgs->attachment_1)
                                                                <p
                                                                    class="m-0 mt-1 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                    <a style="color: #0d6efd!important;"
                                                                        href="<?php echo url('storage/' . $msgs->attachment_1); ?>"
                                                                        target="_blank">{{ substr($msgs->attachment_1, strpos($msgs->attachment_1, '/') + 1) }}</a>
                                                                </p>
                                                            @endif
                                                            @if ($msgs->attachment_2)
                                                                <p
                                                                    class="m-0 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                    <a style="color: #0d6efd!important;"
                                                                        href="<?php echo url('storage/' . $msgs->attachment_2); ?>"
                                                                        target="_blank">{{ substr($msgs->attachment_2, strpos($msgs->attachment_2, '/') + 1) }}</a>
                                                                </p>
                                                            @endif
                                                            @if ($msgs->attachment_3)
                                                                <p
                                                                    class="m-0 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                    <a style="color: #0d6efd!important;"
                                                                        href="<?php echo url('storage/' . $msgs->attachment_3); ?>"
                                                                        target="_blank">{{ substr($msgs->attachment_3, strpos($msgs->attachment_3, '/') + 1) }}</a>
                                                                </p>
                                                            @endif
                                                            @if ($msgs->attachment_4)
                                                                <p
                                                                    class="m-0 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                    <a style="color: #0d6efd!important;"
                                                                        href="<?php echo url('storage/' . $msgs->attachment_4); ?>"
                                                                        target="_blank">{{ substr($msgs->attachment_4, strpos($msgs->attachment_4, '/') + 1) }}</a>
                                                                </p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    @endforeach
                                @else
                                    <div class="container h-100 w-100 d-flex justify-content-center align-items-center">
                                        {{ __('labels.frontend.user.profile.no_messages_found') }}
                                    </div>
                                @endif
                            </div>
                            <div class="col-11 mt-3 mx-auto">
                                <form action="{{ route('frontend.user.applications.message.send') }}" method="POST"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="app_id" value="{{ $data->id }}">
                                    <div class="row">
                                        <div class="col-md-12 p-0">
                                            <div class="form-outline">
                                                <label
                                                    class="timeline-title">{{ __('labels.frontend.user.profile.send_message_to_staff') }}</label>
                                                <div class="row w-75">
                                                    <div class="col-9">
                                                        <textarea class="form-control" placeholder="Type a Message..." id="message" name="message" required
                                                            rows="2"></textarea>
                                                    </div>
                                                    <div class="col-3 d-flex align-items-center">
                                                        <input type="submit" id="sendMsg"
                                                            class="btn btn-themecolor text-white " value="Send Message">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row my-4 p-0">
                                        <div class="col-md-6 p-0">

                                            <label
                                                class="timeline-title">{{ __('labels.frontend.user.profile.attach_files') }}:</label>
                                            <input type="file" name="attachment[]" id="attachment"
                                                accept=".doc,.jpeg,.jpg,.pdf,.docx,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document"
                                                data-max="4" multiple>
                                            <p class="text-danger m-0" id="fileErr"></p>
                                        </div>
                                    </div>



                                </form>
                            </div>


                            <h4 class="mb-3 my-5 p-3 w-100 border-bottom border-bottom" style="background-color: #f5f6f7">
                                {{ __('labels.frontend.user.profile.university_applications_activity') }}</h4>
                            <div class="col-md-8 mx-auto bg-primary">


                            </div>
                            <div class="col-12 mt-3 my-4">
                                @if (count($appActivity))
                                    <ul class="timeline my-2">
                                        @foreach ($appActivity as $activity)
                                            <div class="d-flex align-items-start mb-4">
                                                <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center"
                                                    style="width: 50px; height:50px; color:#EDF2FC">{{ $loop->index + 1 }}
                                                </div>
                                                <div class="ms-4 p-0">
                                                    <div class="d-flex align-items-start ">
                                                        <i class="fa fa-graduation-cap mt-1"></i>
                                                        <p class="text center h4 m-0 ms-2">{!! $activity->title !!}</p>
                                                    </div>
                                                    <p class="my-1"><small class="text-muted "><i
                                                                class="fa-regular fa-clock"></i>
                                                            {{ date('d M Y g:i A', strtotime($activity->created_at)) }}</small>
                                                           
                                                    </p>
                                                    <p class="my-1">
                                                        @if ($activity->detail)
                                                        <p>{!! $activity->detail !!}</p>
                                                    @endif
                                                    @if ($activity->attachment)
                                                        <?php $attachments = explode(',', $activity->attachment); ?>
                                                        @foreach ($attachments as $attachment)
                                                            <p class="m-0 mt-1 small"><a
                                                                    style="color: #0d6efd!important;"
                                                                    href="<?php echo url('storage/app_activity/' . $attachment); ?>"
                                                                    target="_blank">{{ $attachment }}</a></p>
                                                        @endforeach
                                                    @endif
                                                    </p>



                                                </div>
                                            </div>
                                            {{-- <li class="{{($loop->index % 2 != 0)? 'timeline-inverted' : ''}}">
                                    <div class="timeline-badge info"> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{!!$activity->title!!}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($activity->detail)
                                                <span class="text-secondary">Details: {!!$activity->detail!!}</span><br />
                                            @endif
                                            @if ($activity->attachment)
                                            <?php $attachments = explode(',', $activity->attachment); ?>
                                                @foreach ($attachments as $attachment)
                                                <p class="m-0 mt-1 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/app_activity/' . $attachment); ?>" target="_blank">{{$attachment}}</a></p>
                                                @endforeach
                                            @endif
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date('d M Y g:i A', strtotime($activity->created_at)) }}</small> </p>
                                            
                                        </div>
                                    </div>
                                </li> --}}
                                        @endforeach

                                        {{-- @if ($data->doc_ready != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.admission_criteria') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->admission_criteria_met == 'none')
                                            <span class="text-danger">Pending</span>
                                            @else
                                            <span class="text-primary">{{ __('labels.frontend.user.profile.admission_criteria_met') }}?</span><br />
                                            @if ($data->admission_criteria_met == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->admission_criteria_met_ts))}}</small> </p>
                                            @elseif($data->admission_criteria_met == 'no')
                                            <span class="label label-danger">{{ __('labels.general.no') }}</span>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->admission_criteria_met_ts))}}</small> </p>
                                            <p class="text-warning">{{ $data->admission_criteria_met_notes }}</p>
                                            @else
                                            <span class="label label-warning">{{ __('labels.general.partial') }}</span>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->admission_criteria_met_ts))}}</small> </p>
                                            <p class="text-warning">{{ $data->admission_criteria_met_notes }}</p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif --}}
                                        {{-- 
                                @if ($data->admission_criteria_met != 'none')
                                <li class="">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.application_mode') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->application_mode == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            <span class="text-primary">{{ __('labels.frontend.user.profile.how_to_apply') }}</span><br />
                                            <span class="label label-purple">{{ ucfirst($data->application_mode) }}</span>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->application_mode_ts))}}</small> </p>
                                            @if ($data->application_mode == 'portal')
                                            <p>URL is: <a target="_blank" href="{{$data->application_mode_notes}}">{{$data->application_mode_notes}}</a></p>
                                            @else
                                            <p class="text-warning">{{ $data->application_mode_notes }}</p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->application_mode != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.student.fees') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->application_fee_paid == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            <span class="text-primary">{{ __('labels.frontend.user.student.fees_paid') }}</span><br />
                                            @if ($data->application_fee_paid == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->application_fee_paid_ts))}}</small> </p>
                                            @else
                                            <span class="label label-danger">{{ __('labels.general.no') }}</span>
                                            <p class="text-warning">{{ $data->application_fee_paid_notes }}</p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->application_fee_paid != 'none')
                                <li class="">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">Apply to University</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->application_submitted == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            <span class="text-primary">{{ __('labels.frontend.user.profile.application_submitted') }}</span><br/>
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->application_submitted_ts))}}</small> </p>
                                            <p class="text-primary">{{ $data->application_submitted_notes }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->application_submitted != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.application_result') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->offer_letter_received == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->offer_letter_received == 'yes')
                                            @if ($data->offer_letter_type == 'unconditional')
                                            <span class="label label-success">{{ __('labels.frontend.user.profile.offer_letter_received') }}</span>
                                            @if ($data->offer_letter_file)
                                            <p>
                                                <a href="<?php echo url('storage/' . $data->offer_letter_file); ?>" target="_blank" class="btn btn-xs btn-themecolor">{{ __('labels.frontend.user.profile.download') }}</a>
                                            </p>
                                            @endif
                                            <p class="text-primary">{{$data->offer_letter_received_notes}}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->offer_letter_received_ts))}}</small> </p>
                                            @elseif($data->offer_letter_type == 'conditional')
                                            <span class="label label-success">Offer Letter Received (Conditional)</span>
                                            @if ($data->conditional_offer_letter_file)
                                            <a href="<?php echo url('storage/' . $data->conditional_offer_letter_file); ?>" target="_blank" class="btn btn-success">{{ __('labels.frontend.user.profile.download') }}</a>
                                            @endif
                                            <p class="text-primary">{{$data->conditional_offer_letter_received_notes}}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->conditional_offer_letter_received_ts))}}</small> </p>
                                            @endif
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->offer_letter_received != 'none')
                                <li class="">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.funds_under_assessment') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->funds_under_assessment == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->funds_under_assessment == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->funds_under_assessment_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->funds_under_assessment_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->funds_under_assessment != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">COE Received?</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->coe_received == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->coe_received == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->coe_received_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->coe_received_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->coe_received != 'none')
                                <li class="">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.payment_received') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->payment_received == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->payment_received == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->payment_received_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->payment_received_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->payment_received != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">CAS Requested?</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->cas_requested == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->cas_requested == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->cas_requested_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->cas_requested_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->cas_requested != 'none')
                                <li class="">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">CAS Received?</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->cas_received == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->cas_received == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->cas_received_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->cas_received_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->cas_received != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">I-20 Intiated?</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->i20_initiated == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->i20_initiated == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->i20_initiated_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->i20_initiated_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->i20_initiated != 'none')
                                <li class="">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">I-20 Received?</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->i20_received == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->i20_received == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->i20_received_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->i20_received_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->i20_received != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">AIP Received?</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->aip_received == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->aip_received == 'yes')
                                            <span class="label label-success">{{ __('labels.general.yes') }}</span>
                                            <p class="text-primary">{{ $data->aip_received_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->aip_received_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->aip_received != 'none')
                                <li class="">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.visa_status') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->visa_in_process == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->visa_in_process == 'yes')
                                            <span class="label label-success">Visa in Process</span>
                                            <p class="text-primary">{{ $data->visa_in_process_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->visa_in_process_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif

                                @if ($data->visa_in_process != 'none')
                                <li class="timeline-inverted">
                                    <div class="timeline-badge info"><i class="fa fa-graduation-cap"></i> </div>
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.visa_status') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->visa_received == 'none')
                                            <span class="text-danger">{{ __('labels.frontend.user.profile.pending') }}</span>
                                            @else
                                            @if ($data->visa_received == 'yes')
                                            <span class="label label-success">{{ __('labels.frontend.user.profile.visa_received') }}</span>
                                            <p class="text-primary">{{ $data->visa_received_notes }}</p>
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->visa_received_ts))}}</small> </p>
                                            @endif
                                            @endif
                                        </div>
                                    </div>
                                </li>
                                @endif


                                @if ($data->case_closed)
                                <li class="">
                                    <div class="timeline-panel">
                                        <div class="timeline-heading">
                                            <h4 class="timeline-title">{{ __('labels.frontend.user.profile.case_closed') }}</h4>
                                        </div>
                                        <div class="timeline-body">
                                            @if ($data->case_closed_reason == 'admission_complete')
                                            <span class="label label-success">{{ __('labels.frontend.user.profile.admission_complete') }}</span>
                                            @elseif($data->case_closed_reason == 'visa_complete')
                                            <span class="label label-success">{{ __('labels.frontend.user.profile.completed') }}</span>                                            
                                            @elseif($data->case_closed_reason == 'rejected_by_institution')
                                            <span class="label label-danger">{{ __('labels.frontend.user.profile.rejected_by_institution') }}</span>
                                            @elseif($data->case_closed_reason == 'visa_rejected')
                                            <span class="label label-danger">{{ __('labels.frontend.user.profile.visa_rejected') }}</span>
                                            @elseif($data->case_closed_reason == 'other')
                                            <span class="label label-danger">{{ __('labels.frontend.user.profile.other_reasons') }}</span>
                                            @endif
                                            <p><small class="text-muted"><i class="fa fa-clock-o"></i> {{ date("d-M-Y h:i A", strtotime($data->case_closed_ts))}}</small> </p>
                                        </div>
                                    </div>
                                </li>
                                @endif --}}

                                    </ul class="py-4">
                                @else
                                    <span
                                        class="ms-6 text-danger ">{{ __('labels.frontend.user.profile.no_activity_yet') }}</span>
                                    <br>
                                    <br>
                                @endif
                                {{-- @endif --}}

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- ============================================================== -->
    <!-- End Container fluid  -->
    <!-- ============================================================== -->
@endsection
