@extends('frontend.layouts.app')
<?php
$years = array();
$s_yr = date("Y") + 2;
$e_yr = date("Y");
for ($i = $e_yr; $i <= $s_yr; $i++) {
    $years[$i] = $i;
}

$months = array();
for ($i = 1; $i <= 12; $i++) {
    $months[$i] = date('F', strtotime("2019-" . $i . "-01"));
}

$countries = get_study_countries();
?>

@section('content')

<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="col-md-5 align-self-center">
        <h3 class="text text-themecolor">{{ __('labels.frontend.user.profile.my_university_applications') }}</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" style="padding-top:20px">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card card-outline-info">
                
                <div class="text-start text-white fs-20 card-header bg-theme p-2 ps-4" style="">
                    {{ __('labels.frontend.user.profile.university_applications') }}
                </div>
                <div class="card-body">
                    @include('includes.partials.messages')
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>
                                        {{ __('labels.backend.access.users.table.id') }}
                                    </th>
                                    <th>
                                        {{ __('labels.frontend.user.profile.country') }}
                                    </th>
                                    <th style="min-width: 240px !important;">
                                        {{ __('labels.general.details') }}
                                    </th>
                                    <th style="min-width: 160px !important;">
                                        {{ __('labels.backend.access.users.tabs.content.overview.status') }}
                                    </th>
                                    <th style="min-width: 140px;">
                                    </th>
                                </tr>
                            </thead>
                            <tbody>

                                @if (count($data))
                                @foreach ($data as $row)
                                <tr>
                                    <td>
                                        {{ $row['appl_id'] }}
                                    </td>
                                    <td>
                                        {{ $row['country'] }}
                                    </td>
                                    <td>
                                        {!! $row['details'] !!}
                                    </td>
                                    <td>
                                        {{ $row['status'] }}<br />
                                        {{-- @if($row['open_date'])
                                        <span class="card-subtitle"><small>Application Opens:</small></span> <span class="text-danger">{{date('d M Y',strtotime($row['open_date']))}}</span><br />
                                        @endif
                                        @if($row['close_date'])
                                        <span class="card-subtitle"><small>Closes:</small></span> <span class="text-danger">{{date('d M Y',strtotime($row['close_date']))}}</span>
                                        @endif --}}
                                    </td>
                                    <td>
                                        <button onclick="document.location ='{{ route('frontend.user.applications.detail', $row['id']) }}'" type="button" class="btn btn-themecolor btn-rounded text-white">{{ __('labels.general.details') }}<i class="ms-1 fa fa-arrow-right"></i></button>
                                    </td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="5">
                                        {{ __('labels.frontend.user.profile.no_university_applications_found') }}
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
        @if(get_site_config('student_allow_add_new_university_application'))
        <div class="col-md-5 col-sm-12">
            <div class="card card-outline-info">
                <div class="card-header">
                    <h4 class="m-b-0 text-white">Add New Course</h4>
                </div>
                <div class="card-body">
                    {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.applications.add'))->class('form-horizontal')->open() }}

                    <div class="form-group">
                        <label>Country</label>
                        <select class="form-control" name="country" required>
                            @foreach($countries as $country)
                            <option value="{{$country}}">{{$country}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Course</label>
                        <input type="text" name="course" class='form-control' required />
                    </div>
                    <div class="form-group">
                        <label>University</label>
                        <input type="text" name="university" class='form-control' required />
                    </div>
                    <div class="form-group">
                        <label>Year</label>
                        {{ html()->select('year', $years)->class('form-control') }}
                    </div>
                    <div class="form-group">
                        <label>Intake</label><br />
                        {{ html()->select('intake', $months)->class('form-control') }}
                    </div>
                    <div class="form-group mb-0 clearfix">
                        <input type="submit" name="submit" class="btn btn-themecolor" value="Add Course" />
                    </div>
                </div>
            </div>
        </div>
        @endif
        @endif

    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection