@extends('frontend.layouts.app')

@section('content')

<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor"> Certificate</h3>
    </div>
</div>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')

                    {{ html()->form('GET', route('frontend.user.certificate.request'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    <input type="hidden" name="userid" value="{{$userid}}">
                    <h4 class="card-title"> Completed course?</h4>
                    <p> Submit your details and request for your certificate</p>
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">Your Name</label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="name" value="{{ Request::old('name') }} " required>Name as per Marksheet
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">Course</label>
                        <div class="col-sm-6">
                            <select class="form-control" id="courses" name="courses" required>
                                <option>Select Course</option>
                                @foreach($courses as $course)
                                <option value="{{ $course->id }}" @if (old('courses')==$course->id) selected="selected" @endif>{{ $course->title }}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">Branch Studied at</label>
                        <div class="col-sm-6">
                            <select class="form-control" id="branch" name="branch" required>
                                <option value="">Select branch</option>
                                @foreach($branches as $branch)
                                <option value="{{$branch->id}}" {{ Request::old('branch') == $branch->id ? 'selected' : '' }}>
                                    {{$branch->branch_name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label"> Course Start Date</label>
                        <div class="col-sm-6">
                            <input type="text" name="start_date" value="{{ Request::old('start_date') }}" class='form-control mydatepicker' placeholder="DD/MM/YYYY" autocomplete="off" required />

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">Course End Date</label>
                        <div class="col-sm-6">
                            <input type="text" name="end_date" value="{{ Request::old('end_date') }}" class='form-control mydatepicker' placeholder="DD/MM/YYYY" autocomplete="off" required />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">Trainer Name</label>
                        <div class="col-sm-6">
                            <input type="text" name="trainer_name" class='form-control' value="{{ Request::old('trainer_name') }}" required />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">Batch Timings</label>
                        <div class="col-sm-6">
                            <select class="form-control" id="batch" name="batch">
                                <option value="">Select Batch</option>
                                <option value="7am-8am" {{ Request::old('batch') == '7am-8am' ? 'selected' : '' }}>
                                    7am-8am
                                </option>
                                <option value="8am-9am" {{ Request::old('batch') == '8am-9am' ? 'selected' : '' }}>
                                    8am-9am
                                </option>
                                <option value="9am-10am" {{ Request::old('batch') == '9am-10am' ? 'selected' : '' }}>
                                    9am-10am
                                </option>
                                <option value="10am-11am" {{ Request::old('batch') == '10am-11am' ? 'selected' : '' }}>
                                    10am-11am
                                </option>
                                <option value="11am-12pm" {{ Request::old('batch') == '11am-12pm' ? 'selected' : '' }}>
                                    11am-12pm
                                </option>
                                <option value="12pm-01pm" {{ Request::old('batch') == '12pm-01pm' ? 'selected' : '' }}>
                                    12pm-01pm
                                </option>
                                <option value="02pm-03pm" {{ Request::old('batch') == '02pm-03pm' ? 'selected' : '' }}>
                                    02pm-03pm
                                </option>
                                <option value="03pm-04pm" {{ Request::old('batch') == '03pm-04pm' ? 'selected' : '' }}>
                                    03pm-04pm
                                </option>
                                <option value="04pm-05pm" {{ Request::old('batch') == '04pm-05pm' ? 'selected' : '' }}>
                                    04pm-05pm
                                </option>
                                <option value="05pm-06pm" {{ Request::old('batch') == '05pm-06pm' ? 'selected' : '' }}>
                                    05pm-06pm
                                </option>
                                <option value="06pm-07pm" {{ Request::old('batch') == '06pm-07pm' ? 'selected' : '' }}>
                                    06pm-07pm
                                </option>
                                <option value="07pm-08pm" {{ Request::old('batch') == '07pm-08pm' ? 'selected' : '' }}>
                                    07pm-08pm
                                </option>
                                <option value="08pm-09pm" {{ Request::old('batch') == '08pm-09pm' ? 'selected' : '' }}>
                                    08pm-09pm
                                </option>
                            </select>
                        </div>
                    </div>
                    <center>
                        <div class="row">
                            <div class="col">
                                <div class="form-group mb-0 clearfix">
                                    {{ form_submit("Submit") }}
                                </div>
                            </div>
                        </div>
                    </center>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
