@extends('frontend.layouts.app')

@section('content')

<div class="row page-titles pb-0 wrapper" >
    <div class="col-12 align-self-center">
        <h3 class="text mt-2 ms-3 text-themecolor">{{ __('labels.frontend.user.profile.course_suggestions_or_shortlisted') }}</h3>
    </div>
</div>

<div class="container-fluid">
    @include('includes.partials.messages')
    @if(!count($docData) && !count($data))
        <div class="alert alert-secondary mt-5">{{ __('labels.frontend.user.profile.no_course_suggestions_or_bookmarked_courses') }}</div>
    @endif
    
    <div class="row">
        <div class="col-12">
            <?php
            $i = 0;
            if (count($docData)) :
                foreach ($docData as $item) :
                    $feedback_url_yes = route('frontend.user.coursesuggestion.feedback', ['id' => $item['id'], 'value' => 'yes']);
                    $feedback_url_no = route('frontend.user.coursesuggestion.feedback', ['id' => $item['id'], 'value' => 'no']);
                    ?>    
                    <div class="card mt-2 shadow-sm">
                        <div class="card-body">                                 
                            <div class="row" style="margin: -10px -10px;">
                                <div class="col-md-12">
                                    <h4 class="font-weight-bold text-primary">{{ $item['doc'] }}</h4>
                                    <ul class="list-inline font-14">
                                        <li class="pl-2">{{ get_date_formated($item['date']) }} <span class="badge badge-primary">{{ __('labels.frontend.user.profile.staff_suggested') }}</span></li>
                                    </ul>
                                    <p class="font-weight-bold"><a href="{!! $item['file_path'] !!}" target="_blank" class="btn btn-sm btn-rounded btn-success"><i class="uil uil-download-alt me-1"></i> {{ __('labels.frontend.user.profile.download') }}</a></p>
                                    <h5 class="">{{ __('labels.frontend.user.profile.satisfied_with_course_recommendation') }}</h5>

                                    @if($item['satisfied'] == 'none')
                                        <button type="button" class="btn btn-outline-info" onclick="if (confirm('Approve?')) {
                                            window.location = '{!! $feedback_url_yes !!}';
                                        } else {
                                            event.stopPropagation();
                                            event.preventDefault();
                                        }"><i class="uil uil-check m1"></i> {{ __('labels.frontend.user.profile.approve_this_suggestion') }}
                                        </button>
                                    @else
                                        <span class="badge bg-green p-2 rounded-pill"><i class="uil uil-check m1"></i>Approved</span>
                                    @endif
                                </div>                                 
                            </div>
                        </div>
                    </div>                            
                    <?php
                    $i++;
                endforeach;
            endif;
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-12" style="margin-bottom: 50px;">
            @if(count($data))
                @foreach($data as $item)
                    <div class="card my-3 shadow-sm">
                        <div class="card-body">
                            <div class="row" style="margin: -10px -10px;">
                                <div class="col-md-12">
                                    @if($item->course_id)
                                        <h4 class="font-weight-bold"><a href="{{route('frontend.user.course-details', $item->course_id)}}">{{ $item->course_name }}</a></h4>
                                    @else
                                        <h2 class="font-weight-bold">{{ $item->course_name }}</h2>
                                    @endif
                                    <ul class="list-inline font-14">
                                        <li class="pl-2">{{ get_date_formated($item->created_at) }} @if($item->staff_suggested) <span class="badge badge-primary">Staff Suggested</span> @endif</li>
                                    </ul>
                                    @if($item->staff_suggested)
                                        @if(!$item->student_approved)
                                            <p class="text-purple">{{ __('labels.frontend.user.profile.satisfied_with_course_recommendation') }}</p>
                                            <button type="button" class="btn btn-soft-aqua rounded-pill" onclick="if (confirm('Approve?')) {
                                                window.location = '{{route('frontend.user.coursesuggestion.approve', $item->id)}}';
                                            } else {
                                                event.stopPropagation();
                                                event.preventDefault();
                                            }"><i class="uil uil-check m-1"></i> {{ __('labels.frontend.user.profile.approve_this_suggestion') }}</button>
                                        @else
                                        <span class="badge bg-green p-2 rounded-pill"> <i class="uil uil-check m1"></i>{{ __('labels.frontend.user.profile.approved') }}</span>
                                        @endif
                                    @endif

                                    <p class="mt-3">
                                        {{ __('labels.frontend.user.profile.university') }}: <strong><a href="{{route('frontend.user.university-details', $item->university)}}">{{$item->university_name}}</a></strong><br />
                                        {{$item->campus}}<br />
                                        {{get_country_name($item->country)}}<br />
                                        <br />
                                        {{ __('labels.frontend.user.profile.study_level') }}: <strong>@if($item->study_level) {{$item->study_level}} @endif</strong><br />
                                        {{ __('strings.frontend.general.intake') }}: <strong>@if($item->intakes) {{$item->intakes}} @endif</strong><br />
                                        {{ __('labels.frontend.user.profile.duration') }}: <strong>@if($item->duration) {{$item->duration}} @endif</strong><br />
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</div>

<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection