<?php
$countries = get_study_countries();
$months = array();
for ($i = 1; $i <= 12; $i++) {
    $months[$i] = date('F', strtotime("2019-".$i."-01"));
}
?> 
@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Course Selection</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')

                    <h4 class="card-title">In which country you wish to study? Have you identified any course?</h4>
                    <p>Fill the form below, we will send you details of courses that are relevant to you.</p>  

                    {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.courseselection.save'))->class('form-horizontal')->open() }}
                    @method('PATCH')

                    <div class="row m-b-10" style="font-size:0.8em;font-weight: bold;">
                        <div class="col-md-2 col-sm-12">
                            Country
                        </div>
                        <div class="col-md-3 col-sm-12">
                            Course Interested
                        </div>
                        <div class="col-md-2 col-sm-12">
                            University
                        </div>
                        <div class="col-md-5 col-sm-12">
                            Intake
                        </div>    
                    </div>

                    <?php
                    $i = 0;
                    if (count($data)) :
                        foreach ($data as $item) :
                            ?>    
                            <div class="row m-b-20">
                                <div class="col-md-2 col-sm-12">
                                    <select class="form-control" disabled>
                                        <option value="{{ $item['country'] }}" selected>{{ $item['country'] }}</option>
                                    </select>
                                </div>   
                                <div class="col-md-3 col-sm-12">
                                    <input type="text" name="course[<?= $i ?>][course_name]" class='form-control' value="{{ $item['course_name'] }}" disabled />
                                </div>
                                <div class="col-md-2 col-sm-12">
                                    <input type="text" name="course[<?= $i ?>][university]" class='form-control' value="{{ $item['university'] }}" disabled />
                                </div>    
                                <div class="col-md-5 col-sm-12">
                                    {{ $item['intake'] }}
                                </div>                                 
                            </div><!--row-->    
                            <?php
                            $i++;
                        endforeach;

                    else:

                        for ($j = 0; $j < 5; $j++) :
                            ?>
                            <div class="row m-b-20">
                                <div class="col-md-2 col-sm-12">
                                    <select class="form-control" name="course[<?= $j ?>][country]">
                                        <option value=""></option>
                                        @foreach($countries as $country)
                                        <option value="{{$country}}">{{$country}}</option>
                                        @endforeach
                                    </select>
                                </div>   
                                <div class="col-md-3 col-sm-12">
                                    <input type="text" name="course[<?= $j ?>][course_name]" class='form-control' value="" />
                                </div>
                                <div class="col-md-2 col-sm-12">
                                    <input type="text" name="course[<?= $j ?>][university]" class='form-control' placeholder="Optional" value="" />
                                </div>   
                                <div class="col-md-5 col-sm-12">
                                    <select name="course[<?= $j ?>][intake][]" class="select2 select2-multiple" style="width: 100%" multiple="multiple" data-placeholder="Choose">
                                        @foreach($months as $key => $value)
                                        <option value="{{$key}}">{{$value}}</option>
                                        @endforeach                                        
                                    </select>
                                </div>                                   
                                                                
<!--                                <div class="col-md-2 col-sm-12">
                                    <input type="checkbox" id="checkbox1_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="1"><label for="checkbox1_<?= $j ?>">Jan</label>
                                    &nbsp;<input type="checkbox" id="checkbox2_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="2"><label for="checkbox2_<?= $j ?>">Feb</label>
                                    &nbsp;<input type="checkbox" id="checkbox3_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="3"><label for="checkbox3_<?= $j ?>">Mar</label>
                                    &nbsp;<input type="checkbox" id="checkbox4_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="4"><label for="checkbox4_<?= $j ?>">Apr</label>
                                    &nbsp;<input type="checkbox" id="checkbox5_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="5"><label for="checkbox5_<?= $j ?>">May</label>
                                    &nbsp;<input type="checkbox" id="checkbox6_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="6"><label for="checkbox6_<?= $j ?>">Jun</label>
                                    &nbsp;<input type="checkbox" id="checkbox7_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="7"><label for="checkbox7_<?= $j ?>">Jul</label>
                                    &nbsp;<input type="checkbox" id="checkbox8_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="8"><label for="checkbox8_<?= $j ?>">Aug</label>
                                    &nbsp;<input type="checkbox" id="checkbox9_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="9"><label for="checkbox9_<?= $j ?>">Sep</label>
                                    &nbsp;<input type="checkbox" id="checkbox10_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="10"><label for="checkbox10_<?= $j ?>">Oct</label>
                                    &nbsp;<input type="checkbox" id="checkbox11_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="11"><label for="checkbox11_<?= $j ?>">Nov</label>
                                    &nbsp;<input type="checkbox" id="checkbox12_<?= $j ?>" class="filled-in" name="course[<?= $j ?>][intake][]" value="12"><label for="checkbox12_<?= $j ?>">Dec</label>
                                </div>                            -->
                            </div><!--row-->    
                            <?php
                        endfor;
                        ?>

                        <div class="form-group mb-0 clearfix">
                            {{ form_submit("Submit") }}
                        </div><!--form-group-->
                    <?php
                    endif;
                    ?>

                    </form>                        

                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection