<?php
$countries = get_study_countries();
?> 
@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Course Recommendations</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">

            @include('includes.partials.messages')

            <?php
            $i = 0;
            if (count($data)) :
                foreach ($data as $item) :
                    $feedback_url_yes = route('frontend.user.coursesuggestion.feedback', ['id' => $item['id'], 'value' => 'yes']);
                    $feedback_url_no = route('frontend.user.coursesuggestion.feedback', ['id' => $item['id'], 'value' => 'no']);
                    ?>    
                    <div class="card">
                        <div class="card-body">                                 
                            <div class="row m-b-20">
                                <div class="col-md-12">
                                    <p style="font-weight:700;">{{ $item['doc'] }}</p>
                                    <ul class="list-inline font-14"><li class="p-l-10">{{ $item['date'] }}</li></ul>
                                    <p><a href="{!! $item['file_path'] !!}" target="_blank" class="btn btn-rounded btn-success">Download</a></p>
                                    <h5 class="text-info">Are You Satisfied with this Course Recommendation?</h5>
                                    @if($item['satisfied'] == 'none')
                                    <button type="button" class="btn btn-outline-info" onclick="if (confirm('Submit Feedback?')) {
                                                        window.location = '{!! $feedback_url_yes !!}';
                                                    } else {
                                                        event.stopPropagation();
                                                        event.preventDefault();
                                                    }
                                                    ;"><i class="fa fa-heart"></i> Yes</button>
                                    <button type="button" class="btn btn-outline-danger" onclick="if (confirm('Submit Feedback?')) {
                                                        window.location = '{!! $feedback_url_no !!}';
                                                    } else {
                                                        event.stopPropagation();
                                                        event.preventDefault();
                                                    }
                                                    ;"><i class="fa fa-close"></i> No</button>
                                    @else
                                    @php
                                    echo ucfirst($item['satisfied']);
                                    @endphp
                                    @endif
                                </div>                                 
                            </div><!--row-->    
                        </div>
                    </div>                            
                    <?php
                    $i++;
                endforeach;
            else:
                ?>
                <p>No recommendations found.</p>
            <?php
            endif;
            ?>

        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection