@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Demo Classes</h3>
        <ol class="breadcrumb" style="float:left;">
            <?php
            $level = count($folder_breadcrumb);
            for ($i = $level - 1; $i >= 0; $i--) {
//                        if ($i != $level - 1) {
//                            echo " > ";
//                        }
                echo "<li class=\"breadcrumb-item\"><a href=\"" . route('frontend.user.demovideo', $folder_breadcrumb[$i]['id']) . "\">" . $folder_breadcrumb[$i]['name'] . "</a></li>";
            }
            ?>              
        </ol>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->

    <div class="row">
        @foreach($folders as $folder)
        <div class="col-lg-3 col-md-6">
            <a href="<?php echo route('frontend.user.demovideo', $folder['id']); ?>">
                <div class="card">
                    <div class="card-body text-center">
                        <div style="font-size:17px;padding:10px 0;">{{ $folder['name'] }}</div>
                    </div>
                </div>
            </a>
        </div>
        @endforeach
    </div>

    @if($access_denied)
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-danger">
                You do not have permission to access this category. Please contact support.
            </div>
        </div>
    </div>    
    @else
    @if(count($docs)>0)
    <div class="row">
        <div class="col-md-12">
            <div class="card card-outline-success">
                <div class="card-header">
                    <h4 class="m-b-0 text-white">Demo Class Videos</h4>
                </div>
                <div class="card-body">
                    @foreach($docs as $doc)
                    <p style="padding:0px 20px 10px 10px;">
                        <span style="font-size: 1.2em;font-weight: 600;">{{ $doc['title'] }}</span><br />
                        <video width="800" height="448" controls controlsList="nodownload">
                            <source src="{{ $doc['file'] }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>                        
                        @if(strlen($doc['description']))
                        <br />{{ $doc['description'] }}
                        @endif
                    </p>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    @else
    @if($current_folder > 0)
    <div class="row">
        <div class="col-md-12">No videos available in this category</div>
    </div>
    @endif
    @endif
    @endif

</div>
@endsection

@push('after-scripts')
<script>
    $(function () {
        $(this).bind("contextmenu", function (e) {
            e.preventDefault();
        });
    });
</script>
@endpush