@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/dropify/dist/css/dropify.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/dropzone-master/dist/dropzone.css') }}">
@endpush

@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Academic Certificates/Documents Upload</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')
                    <p>You must upload PDF files. You can use PrimoPDF (<a href="https://www.primopdf.com/" target="_blank">download here</a>) Software to convert any file to PDF file (https://www.primopdf.com/). To merge two docs/pdfs/etc., print the first to a new pdf using PrimoPDF. Close it, then print the second and save it as the SAME name as the first pdf. Primo gives you the option to 'append' to the original file.</p>

                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#edu" role="tab"><span class="hidden-sm-up"></span> <span class="hidden-xs-down">Educational</span></a> </li>
                        <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#lang" role="tab"><span class="hidden-sm-up"></span> <span class="hidden-xs-down">Language Certificates</span></a> </li>
                        <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#prof" role="tab"><span class="hidden-sm-up"></span> <span class="hidden-xs-down">Others</span></a> </li>
                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content tabcontent-border">
                        <div class="tab-pane active" id="edu" role="tabpanel">
                            <div class="p-20">
                                {{ html()->form('POST', route('frontend.user.documents.upload'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                @method('PATCH')

                                <div class="row">
                                    @if(get_site_config('student_tenth_certificate'))
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>10th Certificate</label>
                                        @if($class10)
                                        <a class="small" href="<?php echo url('storage/' . $class10) ?>" target="_blank"><?php echo substr($class10, 5); ?></a>
                                        @endif
                                        <input type="file" name="class10" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>10th Marks Sheet</label>
                                        @if($class10)
                                        <a class="small" href="<?php echo url('storage/' . $class10_marks_sheet) ?>" target="_blank"><?php echo substr($class10_marks_sheet, 5); ?></a>
                                        @endif
                                        <input type="file" name="class10_marks_sheet" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    @endif

                                    @if(get_site_config('student_twelth_certificate'))
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>12th Certificate</label>
                                        @if($class12)
                                        <a class="small" href="<?php echo url('storage/' . $class12) ?>" target="_blank"><?php echo substr($class12, 5); ?></a>
                                        @endif
                                        <input type="file" name="class12" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>12th Marks Sheet</label>
                                        @if($class12)
                                        <a class="small" href="<?php echo url('storage/' . $class12_marks_sheet) ?>" target="_blank"><?php echo substr($class12_marks_sheet, 5); ?></a>
                                        @endif
                                        <input type="file" name="class12_marks_sheet" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    @endif
                                    @if(get_site_config('student_diploma'))
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Diploma Certificate</label>
                                        @if($diploma)
                                        <a class="small" href="<?php echo url('storage/' . $diploma) ?>" target="_blank"><?php echo substr($diploma, 5); ?></a>
                                        @endif
                                        <input type="file" name="diploma" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Diploma Marks Sheet</label>
                                        @if($diploma)
                                        <a class="small" href="<?php echo url('storage/' . $diploma_marks_sheet) ?>" target="_blank"><?php echo substr($diploma_marks_sheet, 5); ?></a>
                                        @endif
                                        <input type="file" name="diploma_marks_sheet" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    @endif
                                </div>
                                <div class="row pt-3">
                                    @if(get_site_config('student_degree_completion'))
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Bachelors Certification /Provisional Completion Certificate</label>
                                        @if($grad_degree)
                                        <a class="small" href="<?php echo url('storage/' . $grad_degree) ?>" target="_blank"><?php echo substr($grad_degree, 5); ?></a>
                                        @endif
                                        <input type="file" name="grad_degree" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Bachelors Transcripts</label>
                                        @if($grad_transcripts)
                                        <a class="small" href="<?php echo url('storage/' . $grad_transcripts) ?>" target="_blank"><?php echo substr($grad_transcripts, 5); ?></a>
                                        @endif
                                        <input type="file" name="grad_transcripts" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    @endif
                                    @if(get_site_config('student_bachelors'))
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Bachelors All Semesters Marks Sheets (Single PDF)</label>
                                        @if($grad_all_sem)
                                        <a class="small" href="<?php echo url('storage/' . $grad_all_sem) ?>" target="_blank"><?php echo substr($grad_all_sem, 5); ?></a>
                                        @endif
                                        <input type="file" name="grad_all_sem" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    @endif
                                </div>

                                <div class="row pt-3">
                                    @if(get_site_config('student_masters_completion'))
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Masters Certificate /Provisional Completion</label>
                                        @if($pg_degree)
                                        <a class="small" href="<?php echo url('storage/' . $pg_degree) ?>" target="_blank"><?php echo substr($pg_degree, 5); ?></a>
                                        @endif
                                        <input type="file" name="pg_degree" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Masters Transcripts</label>
                                        @if($pg_transcripts)
                                        <a class="small" href="<?php echo url('storage/' . $pg_transcripts) ?>" target="_blank"><?php echo substr($pg_transcripts, 5); ?></a>
                                        @endif
                                        <input type="file" name="pg_transcripts" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    @endif
                                    @if(get_site_config('student_masters_all_semesters'))
                                    <div class="col-sm-12 col-md-6 p-b-20">
                                        <label>Masters All Semesters Marks Sheets (Single PDF)</label>
                                        @if($pg_all_sem)
                                        <a class="small" href="<?php echo url('storage/' . $pg_all_sem) ?>" target="_blank"><?php echo substr($pg_all_sem, 5); ?></a>
                                        @endif
                                        <input type="file" name="pg_all_sem" id="input-file-now" class="form-control" accept=".pdf">
                                    </div>
                                    @endif
                                </div>

                                <button type="submit" class="btn btn-themecolor">Upload Documents</button>
                                {{ html()->form()->close() }}
                            </div>
                        </div>



                        <div class="tab-pane p-20" id="lang" role="tabpanel">
                            {{ html()->form('POST', route('frontend.user.documents.upload'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                            @method('PATCH')
                            <div class="col-sm-12 col-md-6 p-b-20">
                                <label>IELTS</label>
                                @if($lang_ielts)
                                <a class="small" href="<?php echo url('storage/' . $lang_ielts) ?>" target="_blank"><?php echo substr($lang_ielts, 5); ?></a>
                                @endif
                                <input type="file" name="lang_ielts" id="input-file-now" class="form-control" accept=".pdf">
                            </div>
                            <div class="col-sm-12 col-md-6 p-b-20">
                                <label>PTE</label>
                                @if($lang_pte)
                                <a class="small" href="<?php echo url('storage/' . $lang_pte) ?>" target="_blank"><?php echo substr($lang_pte, 5); ?></a>
                                @endif
                                <input type="file" name="lang_pte" id="input-file-now" class="form-control" accept=".pdf">
                            </div>

                            <div class="col-sm-12 col-md-6 p-b-20">
                                <label>GRE</label>
                                @if($gre)
                                <a class="small" href="<?php echo url('storage/' . $gre) ?>" target="_blank"><?php echo substr($gre, 5); ?></a>
                                @endif
                                <input type="file" name="gre" id="input-file-now" class="form-control" accept=".pdf">
                            </div>
                            <div class="col-sm-12 col-md-6 p-b-20">
                                <label>GMAT</label>
                                @if($gmat)
                                <a class="small" href="<?php echo url('storage/' . $gmat) ?>" target="_blank"><?php echo substr($gmat, 5); ?></a>
                                @endif
                                <input type="file" name="gmat" id="input-file-now" class="form-control" accept=".pdf">
                            </div>

                            <button type="submit" class="btn btn-themecolor">Upload Documents</button>
                            {{ html()->form()->close() }}
                        </div>



                        <div class="tab-pane p-l-20 p-t-20 p-r-20 p-b-20" id="prof" role="tabpanel">
                            <div class="row">
                                <div class="col-sm-12 col-md-12 p-b-20">

                                    <label>SOP</label>
                                    <div class="card">
                                        <div class="card-body">
                                            @if($sop)
                                            <a class="small" href="<?php echo url('storage/' . $sop) ?>" target="_blank"><?php echo substr($sop, 5); ?></a>
                                            @endif

                                            {{ html()->form('POST', route('frontend.user.documents.uploadsop'))->class('form-horizontal dropzone')->id('my-dropzone1')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')
                                            <div class="fallback">
                                                <input type="file" name="file">
                                            </div>
                                            {{ html()->form()->close() }}
                                        </div>
                                    </div>

                                </div>


                                <div class="col-sm-12 col-md-12 p-b-10">
                                    <label>Letter of Recommendation (LOR)</label>
                                    <div class="card">
                                        <div class="card-body">
                                            @if($letter_recom)
                                            <a class="small" href="<?php echo url('storage/' . $letter_recom) ?>" target="_blank"><?php echo substr($letter_recom, 5); ?></a>
                                            @endif

                                            {{ html()->form('POST', route('frontend.user.documents.uploadlor'))->class('form-horizontal dropzone')->id('my-dropzone2')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')
                                            <div class="fallback">
                                                <input type="file" name="file">
                                            </div>
                                            {{ html()->form()->close() }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <br /><br />
                                    <label>Internship Certificates</label>
                                </div>
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">You can upload multiple files</div>
                                        <div class="card-body">
                                            {{ html()->form('POST', route('frontend.user.documents.uploadinternshipdocs'))->class('form-horizontal dropzone')->id('my-dropzone3')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')
                                            @if(count($internships))
                                            @foreach($internships as $internship)
                                            <a class="small" href="<?php echo url('storage/' . $internship) ?>" target="_blank"><?php echo substr($internship, 5); ?></a><br />
                                            @endforeach
                                            @endif
                                            <div class="fallback">
                                                <input type="file" name="file" multiple>
                                            </div>
                                            {{ html()->form()->close() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <br /><br />
                                    <label>Offer Letters</label>
                                </div>
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">You can upload multiple files</div>
                                        <div class="card-body">
                                            {{ html()->form('POST', route('frontend.user.documents.uploadofferletterdocs'))->class('form-horizontal dropzone')->id('my-dropzone4')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')

                                            @if($offerletters)
                                            @foreach($offerletters as $offerletter)
                                            <a class="small" href="<?php echo url('storage/' . $offerletter) ?>" target="_blank"><?php echo substr($offerletter, 5); ?></a>
                                            @endforeach
                                            @endif

                                            <div class="fallback">
                                                <input type="file" name="file" multiple>
                                            </div>
                                            {{ html()->form()->close() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <br /><br />
                                    <label>Experience Certificates</label>
                                </div>
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">You can upload multiple files</div>
                                        <div class="card-body">
                                            {{ html()->form('POST', route('frontend.user.documents.uploadexperiencedocs'))->class('form-horizontal dropzone')->id('my-dropzone5')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')

                                            @if(count($experience))
                                            @foreach($experience as $exp)
                                            <a class="small" href="<?php echo url('storage/' . $exp) ?>" target="_blank"><?php echo substr($exp, 5); ?></a>
                                            @endforeach
                                            @endif

                                            <div class="fallback">
                                                <input type="file" name="file" multiple>
                                            </div>
                                            {{ html()->form()->close() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <br /><br />
                                    <label>Payslips</label>
                                </div>
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">You can upload multiple files</div>
                                        <div class="card-body">
                                            {{ html()->form('POST', route('frontend.user.documents.uploadpayslipsdocs'))->class('form-horizontal dropzone')->id('my-dropzone6')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')

                                            @if(count($payslips))
                                            @foreach($payslips as $payslip)
                                            <a class="small" href="<?php echo url('storage/' . $payslip) ?>" target="_blank"><?php echo substr($payslip, 5); ?></a>
                                            @endforeach
                                            @endif

                                            <div class="fallback">
                                                <input type="file" name="file" multiple>
                                            </div>
                                            {{ html()->form()->close() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <br /><br />
                                    <label>Any Other Certificates /Documents</label>
                                </div>
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">You can upload multiple files</div>
                                        <div class="card-body">
                                            {{ html()->form('POST', route('frontend.user.documents.uploadotherdocs'))->class('form-horizontal dropzone')->id('my-dropzone7')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')

                                            @if(count($otherdocs))
                                            @foreach($otherdocs as $otherdoc)
                                            <a class="small" href="<?php echo url('storage/' . $otherdoc) ?>" target="_blank"><?php echo substr($otherdoc, 5); ?></a>
                                            @endforeach
                                            @endif

                                            <div class="fallback">
                                                <input type="file" name="file" multiple>
                                            </div>
                                            {{ html()->form()->close() }}
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>



</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection
@push('after-scripts')
<script src="{{ asset('assets/plugins/dropzone-master/dist/dropzone.js') }}"></script>
<script>
    Dropzone.options.myDropzone1 = {
        maxFiles: 1,
        acceptedFiles: "application/pdf",
        dictDefaultMessage: "Click here or drop file here to upload",
    };
    Dropzone.options.myDropzone2 = {
        maxFiles: 1,
        acceptedFiles: "application/pdf",
        dictDefaultMessage: "Click here or drop file here to upload",
    };

    Dropzone.options.myDropzone3 = {
        maxFiles: 10,
        acceptedFiles: "application/pdf",
    };    
    Dropzone.options.myDropzone4 = {
        maxFiles: 10,
        acceptedFiles: "application/pdf",
    };
    Dropzone.options.myDropzone5 = {
        maxFiles: 10,
        acceptedFiles: "application/pdf",
    };
    Dropzone.options.myDropzone6 = {
        maxFiles: 10,
        acceptedFiles: "application/pdf",
    };
    Dropzone.options.myDropzone7 = {
        maxFiles: 10,
        acceptedFiles: "application/pdf",
    };    

</script>

{{--
<script src="{{ asset('assets/plugins/dropify/dist/js/dropify.min.js') }}"></script>
<script>
    $(document).ready(function() {
        // Basic
        $('.dropify').dropify();

        // Used events
        var drEvent = $('#input-file-events').dropify();

        drEvent.on('dropify.beforeClear', function(event, element) {
            return confirm("Do you really want to delete \"" + element.file.name + "\" ?");
        });

        drEvent.on('dropify.afterClear', function(event, element) {
            alert('File deleted');
        });

        drEvent.on('dropify.errors', function(event, element) {
            console.log('Has Errors');
        });

        var drDestroy = $('#input-file-to-destroy').dropify();
        drDestroy = drDestroy.data('dropify')
        $('#toggleDropify').on('click', function(e) {
            e.preventDefault();
            if (drDestroy.isDropified()) {
                drDestroy.destroy();
            } else {
                drDestroy.init();
            }
        })

    });
</script>--}}
@endpush