@extends('frontend.layouts.app')
<?php
?>
@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Dashboard</h3>
    </div>
</div>


<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <div id="mycourses-exams" style="display:none"></div>
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <h2>{{$course_info->title}} - {{ucfirst($examObj->type)}} @if($examObj->type != 'mock')Term @endif Exam</h2>
            @if(isset($result_page) && $result_page == 1)
               <div class="card">
                
                  @foreach($exams_validated as $each_exam)
                     <div class="card-body" style="border-top:1px solid #ccc; @if($each_exam->id == $highest_score_id) color:#000; background-color:#c5ffbe; @endif">
                         <h4>Attempt {{$each_exam->attempt}} - Result @if( $each_exam->passed == 1) <span @if($each_exam->id != $highest_score_id)style='color:green;' @endif> - Passed</span  @else <span style='color:red;'> - Failed</span>  @endif </h4>
                         <p class="pl-4 pt-2">
                              Your Score 
                         </p>
                           <h3 class="pl-4"><strong>{{$each_exam->percentage}}%</strong></h3>  
                         <p class="pl-4">
                             Correct Answers: <strong>{{$each_exam->correct_ans_cnt}}</strong> out of {{$each_exam->total_questions}}
                         </p>
                           
                        @if($examObj->objective_question_count > 0)
                         <p class="pl-4">
                             Objective Marks: <strong>{{$each_exam->objective_marks}}</strong> out of {{$examObj->objective_question_mark * $examObj->objective_question_count}}
                         </p>
                        @endif
                        @if($examObj->essay_question_count > 0)
                         <p class="pl-4">
                             Essay Marks: <strong>{{$each_exam->essay_marks}}</strong> out of {{$examObj->essay_question_mark * $examObj->essay_question_count}}
                         </p>
                        @endif
                        @if($examObj->comprehension_question_count > 0)
                         <p class="pl-4">
                             Comprehension Marks: <strong>{{$each_exam->comprehension_marks}}</strong> out of {{$examObj->comprehension_question_mark * $examObj->comprehension_question_count}}
                         </p>
                        @endif
                     </div>
                   @endforeach
                   
                  <div class="card-body">
                      @if($max_attempt < $max_exam_attempt)
                         <p class="pl-4">
                             Want to Improve your Score ? 
                         </p>  
                         <div class="text-center">
                             <a href="{{route('frontend.user.write.exam',[$student_batch_id, $examObj->type, $examObj->id]) }}">
                                 <button class="btn btn-sm btn-outline-info " type="">Retake Exam</button>
                             </a>
                             <a href="{{route('frontend.user.myclasses') }}">
                                 <button class="btn btn-sm btn-outline-info " type="">Done</button>
                             </a>
                         </div>
                      @else
                         <div class="text-center">
                             <a href="{{route('frontend.user.myclasses') }}">
                                 <button class="btn btn-sm btn-outline-info " type="">Done</button>
                             </a>
                         </div>
                      @endif
                  </div> 
                     
            </div>                
            @elseif($question_no === 0)
            <div class="card">
                <div class="card-body">
                    <p class="pl-4">
                         Total Questions : {{$examObj->total_questions}} 
                    </p>
                    <p class="pl-4">
                         Total Marks : {{$examObj->total_marks}}
                    </p>
                    <p class="pl-4">
                       Duration : {{$examObj->duration}} Minutes 
                    </p>                 
                </div>
                <div class="text-center mb-4">
                    <a href="{{route('frontend.user.write.exam.start',[$student_batch_id, $examObj->type, $examObj->id,'start']) }}">
                        <button class="btn btn-sd btn-outline-info" type="button">
                            Start
                        </button>
                    </a>
                </div>
            </div>
           @else
                
            <div class="card">
                @if(!$error_on_question)
                <div class="card-body">
                        @if($question_no == 'Snapshots')
                           <span id="upload_ans_snapshots">
                              <h4>Upload Answer Snapshots <span id='exam_end_timestamp_display' style="float:right; font-size:16px;"> Time remaining : 00 Minutes</span></h4>
                                 <br>
                                 <span>Supported file formats : .jpeg, .jpg, .png (Max file size 15MB) </span>
                                  <span id="dropzone-show-error-msg" style="color:red; font-size:bold; display:none"></span>  
                              {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.write.exam.start',[$student_batch_id, $examObj->type, $examObj->id, 'start']))->class('form-horizontal dropzone')->id('exam-form')->attribute('enctype', 'multipart/form-data')->open() }}
                                    <span id='dropzone-form' style='display:none'></span>
                                  <input type="hidden" name="student_exam_id" value="{{$student_exam_id}}">
                                  <input type="hidden" name="exam_end_time" id="exam_end_time" value="{{$exam_end_time}}">
                                  <input type="hidden" name="sub_all_ans" id="sub_all_ans" value="1">
                                  <div class="fallback">
                                      <input name="exam_snapshots[]" type="file" multiple />
                                  </div>                                
                              {{ html()->closeModelForm() }}
                              <div class="text-center">
                                  <br>
                                  <button type="submit" name="sub_all_answers" id="sub_all_answers" class="btn btn-sm btn-outline-info" value= "1">Submit All Answers</button>
                              </div>
                           </span>
                        @else
                            <h4>Question {{$question_no}} of {{$total_questions}} <span id='exam_end_timestamp_display' style="float:right; font-size:16px;"> Time remaining : 00 Minutes</span></h4>
                           
                           @if($question_details->question_model == 'comprehension') 
                            <div class="form-group row">
                                <div class="p-4">
                                    <p>{!! html_entity_decode($question_details->comprehension_text, ENT_QUOTES, 'UTF-8') !!} </p>
                                </div>
                            </div>
                            @endif
                            
                            
                            {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.write.exam.start',[$student_batch_id, $examObj->type, $examObj->id,'start']))->class('form-horizontal')->id('exam-form')->open() }}
                            <div class="form-group row">
                                <div class="p-4">
                                    <p>{!!$question_details->question!!}</p>
                                </div>
                            </div>
                            <input type="hidden" name="question_model" value="{{$question_details->question_model}}">
                            <input type="hidden" name="question_type" value="{{$question_details->question_type}}">
                            <input type="hidden" name="question_no" value="{{$question_no}}">
                            <input type="hidden" name="sea_id" value="{{$sea_id}}">
                            <input type="hidden" name="attempt" value="{{$attempt}}">
                            <input type="hidden" name="exam_id" value="{{$examObj->id}}">
                            <input type="hidden" name="exam_end_time" id="exam_end_time" value="{{$exam_end_time}}">
                            
                            @if($question_details->question_file_type == 'image')
                                <div class="form-group row">
                                    <input class="pl-4" type="image" src="{{asset('/storage/'.$question_details->question_file)}}" alt="{{$question_details->question}}" width="100%" height="400">
                                </div>
                            @elseif($question_details->question_file_type == 'doc')
                                <div class="form-group row">
                                    <h6><a target="_blank" href="{{asset('/storage/'.$question_details->question_file)}}" class="pl-4 "><strong>View Document</strong></a></h6>
                                </div>
                            @elseif($question_details->question_file_type == 'audio')
                                <div class="form-group row">
                                    <audio class="pl-2" controls="">
                                      <source src="{{asset('/storage/'.$question_details->question_file)}}" type="audio/mpeg">
                                    </audio>
                                </div>
                            @else
                                
                            @endif
                            
                            @if($question_details->question_type == 'essay')
                                
                            <div class="form-group row">
                              <div class="col-12 col-form-label pl-4">
                                <label class="col-md-3 col-form-label" for="answer">Answer</label>
                                <div class="form-check">
                                  <textarea class="form-control" id="answer" rows="9" placeholder="Write your Answer here / Upload answer snapshot in last page" style="height:200px;" name="answer[]">{{$answer_array[0]}}</textarea>
                                </div>
                              </div>
                            </div>
                                
                            @else
                            <div class="form-group row">
                              <div class="col-12 col-form-label pl-4">                          
                                @if($question_details->answer_type == 'single')
                                    @for($i=1;$i<=8;$i++)
                                      @if($question_details->{'option'.$i})
                                          <div class="form-check">
                                            <input style="opacity:1; left:34px;" class="form-check-input" id="radio{{$i}}" type="radio" value="{{$i}}" name="answer[]" @if(in_array($i,$answer_array))}} checked @endif>
                                            <label class="form-check-label" for="radio{{$i}}">{{object_get($question_details, "option{$i}")}}</label>
                                          </div>
                                      @endif
                                   @endfor
                                @endif   
                                @if($question_details->answer_type == 'multiple')
                                    @for($i=1;$i<=8;$i++)
                                        @if($question_details->{'option'.$i})
                                            <div class="form-check checkbox">
                                              <input class="form-check-input" id="check{{$i}}" name="answer[]" type="checkbox" value="{{$i}}" @if(in_array($i,$answer_array))}} checked @endif>
                                              <label class="form-check-label" for="check{{$i}}"> {{object_get($question_details, "option{$i}")}} </label>
                                            </div>
                                        @endif
                                     @endfor   
                                @endif
                                </div>
                            </div>
                            @endif
                            
                            <div class="text-center">
                                @if($question_no > 1)
                                    <button type="submit" name="previous_qs" id="previous_qs" class="btn btn-sm btn-outline-info" value= "{{$question_no-1}}">Previous Question</button>
                                @endif
                                @if($total_questions >= $question_no+1)
                                    <button type="submit" name="next_qs" id="next_qs" class="btn btn-sm btn-outline-info" value= "{{$question_no+1}}">Next Question</button>
                                @endif
                                @if($total_questions == $question_no)
                                   @if($has_essay_questions >= 1)
                                       <button type="submit" name="upload_documents" id="upload_documents" class="btn btn-sm btn-outline-info" value= "1">Upload Snapshots/Submit Answers</button>
                                    @else
                                       <button type="submit" name="sub_all_ans" id="sub_all_ans" class="btn btn-sm btn-outline-info" value= "1">Submit All Answers</button>
                                    @endif
                                @endif
                                
                            </div>
                        {{ html()->closeModelForm() }}
                        @endif
                </div>
                @else
                    <div class="card-body">
                        <h4>Sorry!!! Error Fetching Questions... Please contact admin.</h4>
                    </div>
                @endif
            </div>                
            @endif
                
                
                
                
                
        </div>
    </div>        
        
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection

@push('after-styles')
   <link rel="stylesheet" href="{{ asset('assets/plugins/dropify/dist/css/dropify.min.css') }}">
   <link rel="stylesheet" href="{{ asset('assets/plugins/dropzone-master/dist/dropzone.css') }}">
@endpush

@push('after-scripts')  
   <script src="{{ asset ("/js/frontend_validations.js?v=1.423") }}" type="text/javascript"></script>
   <script src="{{ asset('assets/plugins/dropify/dist/js/dropify.min.js') }}"></script>
   <script src="{{ asset('assets/plugins/dropzone-master/dist/dropzone.js') }}"></script>
    <script type="text/javascript">
    
    if(document.getElementById('dropzone-form')){
        Dropzone.autoDiscover = false;
        
        var myDropzone = new Dropzone(".dropzone", { 
            autoProcessQueue: false,
            paramName:'exam_snapshots',
            acceptedFiles: ".jpeg,.jpg,.png",
            url: '{{route('frontend.user.write.exam.start',[$student_batch_id, $examObj->type, $examObj->id,'start']) }}',
            addRemoveLinks: true,
            dictDefaultMessage: 'Upload your snapshot here',
            parallelUploads: 3, // Number of files process at a time (default 2)
            maxFiles: 3,
            maxFilesize: 15,
            uploadMultiple: true,
            "error": function(file, message, xhr) {
                   if (xhr == null) this.removeFile(file); // perhaps not remove on xhr errors
                   $("#dropzone-show-error-msg").html('<br>Wrong file. Please upload files(.jpeg, .jpg, .png), size less than 15MB');
                   $("#dropzone-show-error-msg").show();
                  // alert();
            },
            init: function () {
               var myDropzone = this;
               
               this.on("addedfile", function (file) {
                  $("#dropzone-show-error-msg").html('');
                  $("#dropzone-show-error-msg").hide();
               });
                this.on('sending', function(file, xhr, formData) {
                    // Append all form inputs to the formData Dropzone will POST
                    var data = $('#exam-form').serializeArray();
                    $.each(data, function(key, el) {
                        formData.append(el.name, el.value);
                    });
                });
               this.on("complete", function (file) {
               });
               this.on("maxfilesexceeded", function (file) {
                     alert("You cannot upload more files.");
                     this.removeFile(file);
               });
               $("#sub_all_answers").click(function (e) {
                   e.preventDefault();
                  if (myDropzone.getQueuedFiles().length > 0) {                        
                     myDropzone.processQueue();  
                  } else {
                     var blob = new Blob();
                     blob.upload = {name:'' };
                     myDropzone.uploadFile(blob);                      
                  }                       
               });
               this.on('success', function( file, resp ){
                     if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length === 0) {
                       var success_text = '<div class="text-center"><b>Your answers submitted successfully!!</b> &nbsp;&nbsp;&nbsp; <a href=" {{route('frontend.user.myclasses') }}" class="btn btn-info ml-1"> &nbsp; << Back to My Courses  </a> </div>';
                       $("#upload_ans_snapshots").html(success_text);
                       setTimeout(function(){ window.location = "{{route('frontend.user.myclasses')}}"; },3000);
                     }
               });               
                
            },
            success: function(file, response)
            {
            }
        });
    }
    </script>
@endpush 
