@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">My Profile</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')

                    <h4 class="card-title">Complete your Profile & Education Details</h4>    
                    <div role="tabpanel">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a href="{{route('frontend.user.basicinfo')}}" class="nav-link">@lang('labels.frontend.user.profile.basic_info')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.academics')}}" class="nav-link">@lang('labels.frontend.user.profile.academics')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.langs')}}" class="nav-link">@lang('labels.frontend.user.profile.languages')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.gregmat')}}" class="nav-link active show">@lang('labels.frontend.user.profile.gre_gmat')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.internships')}}" class="nav-link">@lang('labels.frontend.user.profile.internships')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.experience')}}" class="nav-link">@lang('labels.frontend.user.profile.experience')</a>
                            </li>
                        </ul>

                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane fade show pt-3 active" id="gre_gmat" aria-labelledby="gre_gmat-tab">
                                @include('frontend.user.studentprofile.tabs.gre_gmat')
                            </div><!--tab panel profile-->
                        </div><!--tab content-->
                    </div><!--tab panel-->
                
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection
