@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="col-md-5 align-self-center">
        <h3 class="text text-themecolor">{{ __('labels.frontend.user.profile.country_information') }}</h3>
    </div>
</div>
<div class="row page-titles ps-4 wrapper" >
    <div class="col-md-5 align-self-center">
        <ol class="breadcrumb" style="float:left;">
            <?php
            $level = count($folder_breadcrumb);
            for ($i = $level - 1; $i >= 0; $i--) {
//                        if ($i != $level - 1) {
//                            echo " > ";
//                        }
                echo "<li class=\"breadcrumb-item\"><a href=\"" . route('frontend.user.hostcountryinfo', $folder_breadcrumb[$i]['id']) . "\">" . $folder_breadcrumb[$i]['name'] . "</a></li>";
            }
            ?>              
        </ol>
    </div>
</div>

<div class="container-fluid" style="padding-bottom: 50px;">
    <div class="row">
        @foreach($folders as $folder)
        <div class="col-lg-3 mb-3 col-md-6">
            <a href="<?php echo route('frontend.user.hostcountryinfo', $folder['id']); ?>">
            <div class="card">
                <img class="card-img-top" src="{{ asset('assets/images/page/info.jpg') }}">
                <div class="card-body text-center">
                    <h4 class="card-title">{{ $folder['name'] }}</h4>
                    <p class="card-text">{{ __('labels.frontend.user.profile.browse_documents') }}</p>
                </div>
            </div>
            </a>
        </div>
        @endforeach
    </div>

    @if($access_denied)
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-danger">
                {{ __('labels.frontend.user.profile.do_not_have_permission_contact_support') }}
            </div>
        </div>
    </div>    
    @else
    @if(count($docs)>0)
    <div class="row">
        <div class="col-md-12" >
            <div class="card card-outline-success">
                <div class="card-header">
                    <h4 class="m-b-0 text-white">{{ __('labels.frontend.user.profile.documents') }}</h4>
                </div>
                <div class="card-body">
                    @foreach($docs as $doc)
                    <p class="d-flex align-items-center">
                        <img src="{{ asset('assets/images/page/dwnld.png') }}">
                        <span class="ms-2" style="font-size: 1.2em;font-weight: 600;"><a href="{{ $doc['file'] }}" target="_blank">{{ $doc['title'] }}</a></span>
                        @if(strlen($doc['description']))
                        <br />{{ $doc['description'] }}
                        @endif
                    </p>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <br>
    @else
    @if($current_folder > 0)
    <div class="row">
        <div class="col-md-12">{{ __('labels.frontend.user.profile.no_documents_available') }}</div>
    </div>
    @endif
    @endif
    @endif
    
</div>
@endsection