@extends('frontend.layouts.app-single-col')
@section('content')
    <br />
    <div class="row page-titles">
        <div class="col-md-11 align-self-center">
            @if(!empty($onlineCourseObj))
                <h3 class="text-themecolor">{{$onlineCourseObj->title}}</h3>
            @endif
        </div>
        <div class="col-md-1">
           <a href="{{route('frontend.home')}}">Back</a>
        </div>
    </div>

    <!-- ============================================================== -->
    <!-- Container fluid  -->
    <!-- ============================================================== -->
    <div class="container-fluid">

        <!-- ============================================================== -->
        <!-- Start Page Content -->
        <!-- ============================================================== -->


        <div class="row">
            <div class="col-12">
                <!--    <h2>&nbsp;Assignments</h2> -->
                <div class="card">
                    <div class="card-body">
                        <!-- ============================================================== -->
                        <!-- Start Page Content -->
                        <!-- ============================================================== -->

                        <div class="row">
                            <div class="col-lg-8 col-xlg-9">
                                <div class="card">
                                    <div class="card-body">
                                        @if(!empty($chapterObj['files']['video']))
                                            <div class="embed-responsive embed-responsive-16by9">
                                                @if(!empty($chapterObj['vimeo_video_code']))
                                                    <iframe src="https://player.vimeo.com/video/{{$chapterObj['vimeo_video_code']}}" width="800" height="448" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe>
                                                @else
                                                <video width="800" height="448" controls controlsList="nodownload">
                                                    <source src="{{$chapterObj['files']['video']}}" type="video/mp4">
                                                    Your browser does not support the video tag.
                                                </video>
                                                @endif
                                            </div>
                                            @endif
                                           @if(!empty($chapterObj['files']['image']))
                                                <div class="embed-responsive embed-responsive-16by9">
                                                    <img src="{{asset('/storage/'.$chapterObj['files']['image'])}}">
                                                </div>
                                            @endif
                                            @if(!empty($chapterObj['files']['doc']))
                                                <div class="">
                                                   Document: <a href="{{asset('/storage/'.$chapterObj['files']['doc'])}}">Download</a>
                                                </div>
                                            @endif
                                        <br>
                                            <div class="text-center ">
                                                @if($selected_chapter > 1)
                                                    <a href="{{route('frontend.user.online-course-detail',$courseId)}}?chapter_id={{$selected_chapter - 1}}"><button class="btn btn-sm btn-outline-info" style="float: left;"
                                                            type="button"> < Previous
                                                    </button></a>
                                                @endif
                                                @if($selected_chapter < $chaptersCount)
                                                        <a href="{{route('frontend.user.online-course-detail',$courseId)}}?chapter_id={{$selected_chapter + 1}}"><button class="btn btn-sm btn-outline-info" type="button"
                                                            style="float: right;">Next >
                                                    </button></a>
                                                @endif
                                            </div>
                                    </div>

                                </div>

                                @if(!empty($chapterObj['summary']))
                                    <div>
                                        <p class="bg-light p-2">{!! $chapterObj['summary'] !!}</p>
                                    </div>
                                @endif

                            </div>
                            <div class="col-lg-4 col-xlg-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="card-title text-center">Course Content</h4>
                                        @if($chaptersCount > 0)
                                        <table class="table ">
                                            <tbody>
                                            @foreach($chapters as $key=>$chapter)
                                                <tr>
                                                <td>
                                                    <div class="form-check checkbox">
                                                       {{-- <input class="form-check-input" id="check1" type="checkbox"
                                                               value="">--}}
                                                        <label class="form-check-label" for="check1">
                                                            <a href="{{route('frontend.user.online-course-detail',$courseId)}}?chapter_id={{$chapter['id']}}">
                                                            @if($selected_chapter==$chapter['id']) <b>{{$key + 1}}
                                                                : {{$chapter['title']}}</b> @else
                                                                {{$key + 1}}: {{$chapter['title']}}@endif
                                                            </a>
                                                        </label>

                                                        <br>
                                                        <i class="mdi mdi-arrow-right-drop-circle-outline"></i> {{$chapter['duration']}} Min
                                                    </div>
                                                </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                        @endif
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!-- ============================================================== -->
                        <!-- End PAge Content -->
                        <!-- ============================================================== -->

                    </div>
                </div>
            </div>
        </div>

        <!-- ============================================================== -->
        <!-- End PAge Content -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Container fluid  -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- End Container fluid  -->
    <!-- ============================================================== -->
@endsection