@extends('frontend.layouts.app')
@section('content')
<div class="row page-titles">
    <div class="col-md-11 align-self-center">
        <h3 class="text-themecolor">{{$onlineCourseObj->title}}</h3>
    </div>
    <div class="col-md-1">
        <a href="{{route('frontend.home')}}">Back</a>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4>Curriculum for this Course
                        @if($chaptersCount > 0)
                        <span style="float: right;">{{$chaptersCount}} @if($chaptersCount > 1) Chapters @else
                            Chapter @endif {{$totalDurationInHour}} Hours </span>
                        @endif
                    </h4>
                    <div class="table-responsive pt-4">
                        <table class="table table-hover">
                            <tbody>
                                @if($chaptersCount > 0)
                                @foreach($chapters as $chapter)
                                <tr>
                                    <td>
                                        <a href="{{route('frontend.user.online-course-detail',$courseId)}}?chapter_id={{$chapter['id']}}"><i class="mdi mdi-arrow-right-drop-circle"></i>&nbsp; {{$chapter['title']}}</a>
                                    </td>
                                    <td>&nbsp;{{$chapter['duration']}}</td>
                                </tr>
                                @endforeach
                                @else
                                <h5>No chapters Found</h5>
                                @endif
                            </tbody>
                        </table>
                    </div>

                    @if(!empty($onlineCourseObj->description))
                    <h5 class="pt-4"><strong>Description</strong></h5>
                    <p>{!! $onlineCourseObj->description !!}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection