@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Online Courses</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-6 align-self-center offset-md-3 m-t-30">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="basic-addon1">
                                            <i class="fa fa-search"></i>
                                        </span>
                                    </div>
                                    <select class="form-control search-query" id="select2-search">
                                        <option value=""> Search </option>
                                        @foreach($list_det as $data)
                                        <option value="{{$data->title}}"> {{$data->title}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="container-fluid  m-t-30">
                        <!-- ============================================================== -->
                        <!-- Start Page Content -->
                        <!-- ============================================================== -->
                        <div class="row el-element-overlay">
                            @foreach($list_det as $data)
                            <div class="col-lg-4 col-md-6 staff-container">
                                <div class="card" onclick="document.location='{{route('frontend.view-online-course',$data->id)}}'" style="cursor: pointer;">
                                    <div class="el-card-item">
                                        <div class="el-card-avatar el-overlay-1"> <img src="{!!$data->image ? asset('storage/'.$data->image) : asset('assets/images/page/study.jpg')!!}" alt="">
                                            <div class="el-overlay">
                                            </div>
                                        </div>
                                        <div class="el-card-content">
                                            <h3 style="font-size:18px;" class="box-title bold">{{$data->title}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection

@push('after-scripts')
     <script>
         $(document).ready(function(){
             $('#select2-search').select2();
         });
     </script>
@endpush 