@extends('frontend.layouts.app')

@section('content')
    <div class="row page-titles p-4 pb-0 wrapper">
        <div class="col-md-5  align-self-center">
            <h3 class="text text-themecolor">{{ __('labels.frontend.user.student.my_account') }}</h3>
        </div>
    </div>

    <!-- ============================================================== -->
    <!-- Container fluid  -->
    <!-- ============================================================== -->
    <div class="container-fluid" style="padding-top:20px">

        <!-- ============================================================== -->
        <!-- Start Page Content -->
        <!-- ============================================================== -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        @include('includes.partials.messages')
                        <div class="d-sm-flex justify-content-between align-items-center " style="margin: -20px; margin-bottom: 0px;">
                            <h4 class="card-title">{{ __('labels.frontend.user.profile.your_profile') }}</h4>
                        </div>
                        <div role="tabpanel">
                            <ul class="nav nav-pills border-bottom text-center " role="tablist">

                                {{-- <a href="{{ route('frontend.user.profile') }}" class="nav-link active p-2" aria-controls="basicinfo" role="tab" data-toggle="tab">@lang('labels.frontend.user.profile.basic_info')</a> --}}
                                <li class="nav-item">
                                    <a href="#basicinfo" class="nav-link active show" aria-controls="basicinfo" role="tab" data-toggle="tab">@lang('labels.frontend.user.profile.basic_info')</a>
                                </li>
                                @if(get_site_config('module_student_referral'))
                                <li class="nav-item">
                                    <a href="#affiliate" class="nav-link" aria-controls="affiliate" role="tab" data-toggle="tab">Affiliate</a>
                                </li>
                                <li class="nav-item">
                                    <a href="#payment_pref" class="nav-link" aria-controls="payment_pref" role="tab" data-toggle="tab">Payment Preference</a>
                                </li> 
                                <li class="nav-item">
                                    <a href="#my_earnings" class="nav-link" aria-controls="my_earnings" role="tab" data-toggle="tab">My Earnings</a>
                                </li> 
                                @if(get_site_config('student_agent_terminate_account'))
                                <li class="nav-item">
                                    <a href="#account_removal" class="nav-link" aria-controls="account_removal" role="tab" data-toggle="tab">Account Removal</a>
                                </li> 
                                @endif
                                @endif
                                {{-- <li class="nav-item">
                                <a href="{{route('frontend.user.academics')}}" class="nav-link">@lang('labels.frontend.user.profile.academics')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.langs')}}" class="nav-link">@lang('labels.frontend.user.profile.languages')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.gregmat')}}" class="nav-link">@lang('labels.frontend.user.profile.gre_gmat')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.internships')}}" class="nav-link">@lang('labels.frontend.user.profile.internships')</a>
                            </li>

                            <li class="nav-item">
                                <a href="{{route('frontend.user.experience')}}" class="nav-link">@lang('labels.frontend.user.profile.experience')</a>
                            </li> --}}
                            </ul>

                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane fade show active pt-3 active" id="basicinfo"
                                    aria-labelledby="basicinfo-tab">
                                    @include('frontend.user.studentprofile.tabs.basicinfo')
                                </div><!--tab panel profile-->
                                @if(get_site_config('module_student_referral'))
                                <div role="tabpanel" class="tab-pane pt-3" id="affiliate" aria-labelledby="affiliate-tab">
                                    @include('frontend.user.studentprofile.tabs.affiliate')
                                </div>
                                <div role="tabpanel" class="tab-pane pt-3" id="payment_pref" aria-labelledby="payment_pref-tab">
                                    @include('frontend.user.studentprofile.tabs.payment-preference')
                                </div>
                                <div role="tabpanel" class="tab-pane pt-3" id="my_earnings" aria-labelledby="my_earnings-tab">
                                    @include('frontend.user.studentprofile.tabs.my-earnings')
                                </div>
                                @if(get_site_config('student_agent_terminate_account'))
                                    <div role="tabpanel" class="tab-pane pt-3" id="account_removal" aria-labelledby="account_removal-tab">
                                        @include('frontend.user.studentprofile.tabs.account-removal')
                                    </div>
                                @endif
                                @endif
                            </div><!--tab content-->
                        </div><!--tab panel-->

                    </div>
                </div>
            </div>
        </div>
    </div><br><br>
    <!-- ============================================================== -->
    <!-- End Container fluid  -->
    <!-- ============================================================== -->
@endsection

@push('after-styles')
<style>
    .responsive-set-margin{
        margin: 0px -41px;
    }
</style>
@endpush
@push('after-scripts')
<script>
    $('button.copyButton').click(function(){
        $(this).siblings('input.linkToCopy').select();      
        document.execCommand("copy");
    });
</script>
@endpush
