 
@extends('frontend.layouts.app')

@section('content')

<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Rating & Attendance</h3>
    </div>
</div>
<div class="container-fluid"> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                   
                    <div class="row mt-2"> 

                        <div class="col-md-6 col-sm-12"> 
                            @include('includes.partials.messages') 
                            @foreach($reviews as $review)  
                            {{ html()->form('post', route('frontend.user.review.store',$review->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}   
                            <h4 class="card-title">{{$review->title}} | {{$review->branch_name}}</h4>
                            <h4>Dt: {{date('d F Y')}}</h4>
                            @endforeach

                            @if($ratings == 0)
                            <div class="alert alert-warning mt-4" role="alert">
                                You can add Review only after today's class completion
                            </div>
                            @else
                            <div class="form-group">
                                <label class="col-form-label">
                                    Rate Today's Class
                                </label> 
                            </div> 
                            <div class="stars"> 
                                <fieldset>
                                    <input class="star star-5" id="star-5" type="radio" name="rating" value="5" />

                                    <label class="star star-5" for="star-5"></label>

                                    <input class="star star-4" id="star-4" type="radio" name="rating" value="4" />

                                    <label class="star star-4" for="star-4"></label>

                                    <input class="star star-3" id="star-3" type="radio" name="rating" value="3" />

                                    <label class="star star-3" for="star-3"></label>

                                    <input class="star star-2" id="star-2" type="radio" name="rating" value="2" />

                                    <label class="star star-2" for="star-2"></label>

                                    <input class="star star-1" id="star-1" type="radio" name="rating" value="1" />

                                    <label class="star star-1" for="star-1"></label> 
                                </fieldset>
                            </div> 
                            <div class="form-group">     
                                <textarea class="form-control" id="review" name ="review" rows="4" cols="50" placeholder="Write your feedback or comments about today's class" required></textarea>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group mb-0 clearfix">
                                        {{ form_submit("Submit") }}
                                    </div>
                                </div>
                            </div>
                            @endif   
                            <div class="mt-2">
                                <label class="label label-light-info">Submit your rating & review about todoay's class after each class</label>
                                <label class="label label-light-info">Your rating & comments are not visible to trainer</label>
                            </div>
                            </form>
                        </div>
                        <div class="col-md-6 col-sm-12"> 
                            <h4 class="text-center">Course Completion %</h4>
                            <div class="text-center mt-5">
                                <input data-plugin="knob" data-width="220" data-height="220" data-linecap=round data-fgColor="#01c0c8" value="{{$finalcalc}}" data-skin="tron" data-angleOffset="180" data-readOnly=true data-thickness=".2" />
                            </div>                                
                        </div>
                    </div>
                    <div class="row mt-5 pl-3">
                        <div class="col-12">
                            <h4>Completed Classes</h4>
                            <hr>

                            <div class="table-responsive">
                                <table class="table"> 
                                    <thead>
                                        <tr> 
                                            <th>Date</th>
                                            <th>Topics Covered</th>
                                            <th>Duration</th> 
                                        </tr>
                                    </thead>
                                    <tbody> 
                                        @foreach($pages as $page)
                                        <tr>                     
                                            <td> {{$page->date}} </td>
                                            <td> {{$page->topics}}</td>
                                            <td> {{$page->duration}} Min</td>                      
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@push('after-styles')
<style>
    div.stars {
        display: inline-block; 
    }
    input.star { display: none; }
    label.star {
        float: right;
        padding: 20px;
        font-size: 36px;
        color: #444;
        transition: all .2s;
    }
    input.star:checked ~ label.star:before {
        content: '\f005';
        color: #FD4;
        transition: all .15s;
    }
    label.star:hover { transform: rotate(-10deg) scale(1.3); }
    label.star:before {
        content: '\f006';
        font-family: FontAwesome;
    }
</style>
@endpush

@push('after-scripts')
    <script src="{{ asset('assets/plugins/knob/jquery.knob.js') }}"></script>
    <script>
    $(function() {
        $('[data-plugin="knob"]').knob();
    });
    </script>
@endpush