<?php
$countries = get_study_countries();
$months = array();
for ($i = 1; $i <= 12; $i++) {
    $months[$i] = date('F', strtotime("2019-" . $i . "-01"));
}
?> 
@extends('frontend.layouts.app')

@section('content')


<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="col-md-5  align-self-center">
        <h3 class="text text-themecolor">Resources</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" style="padding-top:20px">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')


                    <div class="row mt-4">
                        <div class="col">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                           
                                        </tr> 
                                    </thead>
                                    <tbody>
                                        
                                        @foreach($folders as $folder)
                                        <tr>  
                                            <td>{{ $folder['title'] }}</td> 
                                            @if($folder['filename'] !='mp4' and $folder['filename'] !='mp3')
                                            <td> 
                                                <a href="{{ url('/storage/'.$folder['file'])}}"> 
                                                    <button type="button" class="btn btn-outline-success btn-rounded"><i class="me-1 fa fa-download"></i> Download   
                                                    </button> 
                                                </a>
                                            </td>          
                                            @else
                                            <td>         
                                                <a href="{{route('frontend.user.viewvideo',$folder['id']) }}"> 
                                                    <button type="button" class="btn btn-success"><span class="btn-label"><i class="ms-1 fa fa-play"></i></span>Play   
                                                    </button> 
                                                </a> 
                                            </td>
                                            @endif    
                                        </tr>
                                        @endforeach 
                                    </tbody>
                                </table>
                               
                                @if (count($folders)<1)
                                <p class="text-center">No Records Found!!</p>
                                @endif
                            </div>
                            <center>
                                <div class="row">
                                    <div class="col p-t-20">  
                                        <a href="{{route('frontend.user.resources') }}" class="btn btn-rounded btn-secondary "><i class="fa fa-backward me-1"></i> Go Back</a>  
                                    </div>  
                                </div>
                            </center> 
                        </div><!--col-->
                    </div><!--row-->
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection