@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">SOP Document</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')

                    <h4 class="card-title">Statement Of Purpose (SOP) Document/ Motivation Letter</h4>
                    <br />
                    @if(count($data))
                        @if($data['status'] == 'requested')
                        <p class='text-warning'>You have requested on {{ date("d M, Y", strtotime($data['date'])) }}</p>
                        @else
                        <p class='text-success'>Your request was completed on {{ date("d M, Y", strtotime($data['date'])) }}</p>
                        @endif
                    @else
                    <a class="btn btn-themecolor" href="{{ route('frontend.user.soprequest') }}">Request SOP Sample</a>
                    @endif
                    <br />
                    <br />
                    <br />
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection