<form method="post" action="{{ route('frontend.user.profile.employment.save') }}">
    @csrf
    <input type="hidden" name="userid" id="add_employment_history_user_id">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.employment_type') }}</label>
                <select class="form-control form-select p-2" required name="employment_histroy_type" id="employment_histroy_type"
                    required>
                    <option value="">Select</option>
                    <option value="Paid" @if (Request::old('employment_histroy_type') == 'Paid') selected @endif>Paid</option>
                    <option value="Unpaid" @if (Request::old('employment_histroy_type') == 'Unpaid') selected @endif>Unpaid</option>
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.currently_working') }}</label>
                <select class="form-control form-select p-2" required name="employment_history_currently_working"
                    id="employment_history_currently_working">
                    <option value="">Select</option>
                    <option value="Yes" @if (Request::old('employment_history_currently_working') == 'Yes') selected @endif>Yes</option>
                    <option value="No" @if (Request::old('employment_history_currently_working') == 'No') selected @endif>No</option>
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.industry_type') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Industry Type"
                    name="employment_history_industry_type" maxlength="50"
                    value="@if (Request::old('employment_history_industry_type')) {{ Request::old('employment_history_industry_type') }} @endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.organisation_name') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Organisation Name"
                    name="employment_history_organisation_name" maxlength="50"
                    value="@if (Request::old('employment_history_organisation_name')) {{ Request::old('employment_history_organisation_name') }} @endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.your_working_designation') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Your Working Designation"
                    name="employment_history_working_position_occupation" maxlength="50"
                    value="@if (Request::old('employment_history_working_position_occupation')) {{ Request::old('employment_history_working_position_occupation') }} @endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.employer_phone') }}</label>
                <input type="text" class="form-control p-2" placeholder="Employer Phone"
                  required  name="employment_history_employer_phone" maxlength="50"
                    value="@if (Request::old('employment_history_employer_phone')) {{ Request::old('employment_history_employer_phone') }} @endif">
            </div>
        </div>
    </div>
    <hr class="my-6" style="height:2px;border-width:0;background-color:#b6b4b482">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.street_address') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Street Address"
                    name="employment_history_address" maxlength="150"
                    value="@if (Request::old('employment_history_address')) {{ Request::old('employment_history_address') }} @endif">
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.country') }}</label>
                <select class="form-control p-2 form-select shadow-none border text-dark border"
                    id="employment_history_country" name="employment_history_country" required>
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}" @if (Request::old('employment_history_country') == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.state') }}</label>
                <select class="form-control form-select p-2" required name="employment_history_state"
                    id="employment_history_state">
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.city') }}</label>
                <input type="text" class="form-control p-2" required placeholder="City"
                    name="employment_history_city" maxlength="50"
                    value="@if (Request::old('employment_history_city')) {{ Request::old('employment_history_city') }} @endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.post_code') }}</label>
                <input type="text" class="form-control p-2" placeholder="Postal Code"
                    name="employment_history_postcode" maxlength="10"
                    value="@if (Request::old('employment_history_postcode')) {{ Request::old('employment_history_postcode') }} @endif">
            </div>
        </div>
    </div>
    <hr class="my-6" style="height:2px;border-width:0;background-color:#b6b4b482">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.contact_person_name') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Contact Person Name"
                    name="employment_history_contact_person_name" maxlength="50"
                    value="@if (Request::old('employment_history_contact_person_name')) {{ Request::old('employment_history_contact_person_name') }} @endif">
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.contact_person_mobile') }} </label>
                <input type="number" class="form-control p-2" placeholder="Contact Person Mobile No"
                    name="employment_history_contact_person_mobile_number" maxlength="50"
                    value="@if (Request::old('employment_history_contact_person_mobile_number')) {{ Request::old('employment_history_contact_person_mobile_number') }} @endif">
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.contact_person_phone') }}</label>
                <input type="number" class="form-control p-2" placeholder="Contact Person Business Phone"
                    name="employment_history_contact_person_business_phone" maxlength="50"
                    value="@if (Request::old('employment_history_contact_person_business_phone')) {{ Request::old('employment_history_contact_person_business_phone') }} @endif">
            </div>
        </div>

    </div>
    <hr class="my-6" style="height:2px;border-width:0;background-color:#b6b4b482">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.date_start_from') }}</label>
                <div class="input-group">
                    <input type="text" class="form-control p-2 mydateFrompicker" autocomplete="off" 
                        name="employment_history_start_date" placeholder="dd-mm-yyyy" required
                        value="@if (Request::old('employment_history_start_date')) {{ date('d-m-Y', strtotime(Request::old('employment_history_start_date'))) }} @endif">
                    <div class="input-group-append">
                        <span class="input-group-text h-100"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.date_working_ended') }}</label>
                <div class="input-group">
                    <input type="text" class="form-control p-2 mydateTopicker" autocomplete="off"
                        name="employment_history_working_ended" placeholder="dd-mm-yyyy"
                        value="@if (Request::old('employment_history_working_ended')) {{ date('d-m-Y', strtotime(Request::old('employment_history_working_ended'))) }} @endif">
                    <div class="input-group-append">
                        <span class="input-group-text h-100"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary" style="padding-left:40px;padding-right:40px;">{{ __('labels.general.buttons.save') }}</button>
    </div>
</form>


<script>
    $(document).ready(function() {
$('.mydateFrompicker, .mydateTopicker').datepicker({
    format: 'dd-mm-yyyy',
    autoclose: true,
    todayHighlight: true,
    zIndexOffset: 100,
    endDate: 'today' 
});

function dateUpTo() {
    if ($(".mydateFrompicker").val()) {
        var fromDate = $(".mydateFrompicker").val(); 
        var dateParts = fromDate.split("-");
        var formattedFromDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]); 
        $('.mydateTopicker').val("");
        $('.mydateTopicker').datepicker('setStartDate', formattedFromDate); 
    }
}

$('.mydateFrompicker').on('changeDate', function() {
    dateUpTo(); 
});




        $('#employment_history_country').on('click', function() {
            var idCountry = this.value;

            $("#employment_history_state").html('');
            $.ajax({
                url: "{{ url('api/fetch-states') }}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#employment_history_state').html(
                        '<option value="">Select State</option>');
                    $.each(result.states, function(key, value) {
                        if (value.id == "{{ old('state') }}") {
                            var selectedState = "selected=\"'selected'\"";
                        } else {
                            var selectedState = "";
                        }
                        $("#employment_history_state").append('<option ' +
                            selectedState +
                            ' value="' + value.id + '">' + value.name +
                            '</option>');
                    });
                }
            });
        });


    });
</script>
