<form method="post" action="{{ route('frontend.user.profile.travel_history.save') }}">
    @csrf
    <input type="hidden" name="user_id" id="add_travel_history_user_id">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.country_visited') }}</label>
                <select class="form-control p-2 form-select shadow-none text-dark border"
                    name="country_visited" required>
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('country_visited') == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.name_used_on_entry') }}</label>
                <input type="text" required class="form-control p-2" placeholder="Name Used on Entry" name="name_used_on_country" maxlength="50" value="@if (Request::old('name_used_on_country')) {{ Request::old('name_used_on_country') }}@endif">
                
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.visa_type') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Visa Type" name="visa_type" maxlength="50" value="@if (Request::old('visa_type')) {{ Request::old('visa_type') }}@endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.visa_issued_at') }}</label>
                <input type="text" required class="form-control p-2" placeholder="Visa issue at" name="visa_issue_at" maxlength="50" value="@if (Request::old('visa_issue_at')) {{ Request::old('visa_issue_at') }}@endif">
                
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.date_from') }} </label>
                <div class="input-group">
                    <input type="text" required class="form-control p-2 mydateFrompicker" autocomplete="off"
                        name="date_from" onchange="dateUpTo()"
                        placeholder="dd-mm-yyyy"
                        value="@if (Request::old('date_from')) {{ date('d-m-Y', strtotime(Request::old('date_from'))) }}@endif">
                    <div class="input-group-append">
                        <span class="input-group-text h-100"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.date_up_to') }} </label>
                <div class="input-group">
                    <input type="text" required class="form-control p-2 mydateTopicker" autocomplete="off"
                        name="date_up_to"
                        placeholder="dd-mm-yyyy"
                        value="@if (Request::old('date_up_to')) {{ date('d-m-Y', strtotime(Request::old('date_up_to'))) }}@endif">
                    <div class="input-group-append">
                        <span class="input-group-text h-100"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.reason_of_visit') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Reason of Visit" name="reason_of_visit" maxlength="50" value="@if (Request::old('reason_of_visit')) {{ Request::old('reason_of_visit') }}@endif">
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary"
            style="padding-left:40px;padding-right:40px;">{{ __('labels.general.buttons.save') }}</button>
    </div>
</form>

<script>


$('.mydateFrompicker, .mydateTopicker').datepicker({
    format: 'dd-mm-yyyy',
    autoclose: true,
    todayHighlight: true,
    zIndexOffset: 100,
    endDate: 'today' 
});

function dateUpTo() {
    if ($(".mydateFrompicker").val()) {
        var fromDate = $(".mydateFrompicker").val(); 
        var dateParts = fromDate.split("-");
        var formattedFromDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]); 
        $('.mydateTopicker').val("");
        $('.mydateTopicker').datepicker('setStartDate', formattedFromDate); 
    }
}

$('.mydateFrompicker').on('changeDate', function() {
    dateUpTo(); 
});

</script>

