<form method="post" action="{{route('frontend.user.family.course_information.save')}}">
    @csrf
    <input type="hidden" id="edit_family_information_user_id" name="userid">
    <input type="hidden" id="family_id" name="family_id" value="{{$profile_family->id}}">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.first_name') }}</label>
                <input type="text" class="form-control p-2" id="first_name" name="first_name" maxlength="50"
                    value="@if (Request::old('first_name')) {{ Request::old('first_name') }}@elseif($profile_family->first_name){{ $profile_family->first_name }} @endif" placeholder="First Name"
                    required>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;"
                    class="required-field">{{ __('labels.frontend.user.profile.last_name') }}</label>
                <input type="text" class="form-control p-2" id="last_name"
                    name="last_name" maxlength="50"
                    value="@if (Request::old('last_name')) {{ Request::old('last_name') }}@elseif($profile_family->last_name){{ $profile_family->last_name }} @endif" placeholder="Last Name"
                    required>
            </div>
        </div>
        <div class="col-md-4">
            <label class="">{{ __('labels.backend.access.users.table.email') }}</label>
            <div class="">
                <input type="text" placeholder="Email ID"
                    class="form-control p-2" name="email"
                    value="@if (Request::old('email')) {{ Request::old('email') }} @elseif($profile_family->email){{ $profile_family->email }} @endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group mb-3">
                <label class="required-field mb-2">{{ __('labels.frontend.user.profile.gender') }}</label>
                <div class="d-flex flex-wrap gap-3">
                    <div class="form-check">
                        <input type="radio"
                               class="form-check-input"
                               name="gender" id="parent_male" value="male"
                               @if (Request::old('gender') == 'male') checked @elseif($profile_family->gender == 'male') checked @endif required>
                        <label class="form-check-label" for="parent_male">{{ __('labels.frontend.user.profile.male') }}</label>
                    </div>
                    <div class="form-check">
                        <input type="radio"
                               class="form-check-input"
                               name="gender" id="parent_female" value="female"
                               @if (Request::old('gender') == 'female') checked @elseif($profile_family->gender == 'female') checked @endif required>
                        <label class="form-check-label" for="parent_female">{{ __('labels.frontend.user.profile.female') }}</label>
                    </div>
                    <div class="form-check">
                        <input type="radio"
                               class="form-check-input"
                               name="gender" id="parent_other" value="other"
                               @if (Request::old('gender') == 'other') checked @elseif($profile_family->gender == 'other') checked @endif required>
                        <label class="form-check-label" for="parent_other">{{ __('labels.frontend.user.profile.other') }}</label>
                    </div>
                </div>
            </div>
            
        </div>
        <div class="col-md-4">
            <label class="">{{ __('labels.frontend.user.profile.mobile') }}</label>
            <div class="input-group">
                <div class="input-group-prepend h-100" style="width: 35%">
                    <select class="form-control form-select shadow-none border text-dark p-2" id="dial_code"
                        name="dial_code"
                        style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                        <option value=''>Dialcode</option>
                        @foreach ($dialcodes as $dialcode)
                            <option
                                 @if(Request::old('dial_code') == $dialcode->code) selected @elseif($profile_family->dial_code == $dialcode->code) selected @endif 
                                value="{{$dialcode->code}}">
                                {{ $dialcode->code }}</option>
                        @endforeach
                    </select>
                </div>
                <input type="text" 
                    class="form-control p-2"
                    name="mobile"
                    placeholder="@if (Request::old('mobile')){{ Request::old('mobile') }}@endif" value="@if($profile_family->mobile){{$profile_family->mobile}}@endif"
                    >
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.date_of_birth') }}</label>
                <div class="input-group">
                    <input type="text" class="form-control mydatepicker" autocomplete="off"
                        id="birth_date" name="birth_date"
                        placeholder="dd-mm-yyyy"
                        value="@if (Request::old('birth_date')) {{ date('d-m-Y', strtotime(Request::old('birth_date'))) }} @elseif($profile_family->birth_date){{$profile_family->birth_date}}@endif">
                    <div class="input-group-append">
                        <span class="input-group-text h-100" ><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.country_of_birth') }}</label>
                <select class="form-control form-select shadow-none border text-dark p-2" id="country_of_birth"
                    name="birth_country">
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('birth_country') == $country->id) selected @elseif($profile_family->birth_country == $country->id) selected @endif >
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.country_of_residence') }}</label>
                <select class="form-control form-select shadow-none border text-dark p-2" id="residence_country"
                    name="residence_country" >
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('residence_country') == $country->id) selected  @elseif($profile_family->residence_country == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.relationship') }}</label>
                <select class="form-control form-select shadow-none border text-dark p-2"
                    name="relationship" required>
                    <option value="">Select</option>
                    <option value="father" @if (Request::old('relationship') == "father") selected  @elseif($profile_family->relationship == 'father') selected @endif >Father</option>
                    <option value="mother" @if (Request::old('relationship') == "mother") selected @elseif($profile_family->relationship == 'mother') selected @endif>Mother</option>
                    <option value="step father" @if (Request::old('relationship') == "step father") selected @elseif($profile_family->relationship == 'step father') selected @endif>Step Father</option>
                    <option value="step mother" @if (Request::old('relationship') == "step mother") selected @elseif($profile_family->relationship == 'step mother') selected @endif>Step Mother</option>
                    <option value="parental grand father" @if (Request::old('relationship') == "parental grand father") selected @elseif($profile_family->relationship == 'parental grand father') selected @endif>Parental Grand Father</option>
                    <option value="parental grand mother" @if (Request::old('relationship') == "parental grand mother") selected @elseif($profile_family->relationship == 'parental grand mother') selected @endif>Parental Grand Mother</option>
                    <option value="maternal grand father" @if (Request::old('relationship') == "maternal grand father") selected @elseif($profile_family->relationship == 'maternal grand father') selected @endif>Maternal Grand Father</option>
                    <option value="maternal grand mother" @if (Request::old('relationship') == "maternal grand mother") selected @elseif($profile_family->relationship == 'maternal grand mother') selected @endif>Maternal Grand Mother</option>
                </select>
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary"
            style="padding-left:40px;padding-right:40px;">{{ __('labels.general.buttons.save') }}</button>
    </div>
</form>

<script>
    $('.mydatepicker').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true,
        zIndexOffset: 100,
        endDate: 'today'
    });
</script>
