<form method="post" class="mb-4" action="{{ route('frontend.user.profile.visa_history.save') }}">
    @csrf
    <input type="hidden" name="user_id" id="edit_visa_history_user_id">
    <input type="hidden" name="visa_id" value="{{$profile_visa_application_history->id}}">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.country_applied_for') }}</label>
                <select class="form-control p-2 form-select shadow-none border text-dark "
                    name="country_applied_for_visa" required>
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('country_applied_for_visa') == $country->id) selected @elseif($profile_visa_application_history->country_applied_for_visa == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.name_used_on_entry') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Name Used" name="name_used_for_visa_apply" maxlength="50" value="@if (Request::old('name_used_for_visa_apply')) {{ Request::old('name_used_for_visa_apply') }} @else {{$profile_visa_application_history->name_used_for_visa_apply}}@endif">
                
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.visa_type') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Visa Name/Type" name="visa_apply_visa_type" maxlength="50" value="@if (Request::old('visa_apply_visa_type')) {{ Request::old('visa_apply_visa_type') }} @else {{$profile_visa_application_history->visa_apply_visa_type}}@endif">
                
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.visa_issued_at') }}</label>
                <div class="input-group">
                    <input type="text" class="form-control p-2 mydatepicker" required autocomplete="off"
                        name="visa_apply_application_date"
                        placeholder="dd-mm-yyyy"
                        value="@if (Request::old('visa_apply_application_date')) {{ date('d-m-Y', strtotime(Request::old('visa_apply_application_date'))) }} @else {{ date('d-m-Y', strtotime($profile_visa_application_history->visa_apply_application_date)) }} @endif">
                    <div class="input-group-append">
                        <span class="input-group-text h-100" ><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.application_number') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Application Number" name="visa_apply_application_number" maxlength="50" value="@if(Request::old('visa_apply_application_number')){{ Request::old('visa_apply_application_number') }}@else{{$profile_visa_application_history->visa_apply_application_number}}@endif">
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">{{ __('labels.frontend.user.profile.outcome') }}</label>
                <input type="text" class="form-control p-2" required placeholder="Outcome" name="visa_apply_outcome" maxlength="50" value="@if (Request::old('visa_apply_outcome')) {{ Request::old('visa_apply_outcome') }} @else {{$profile_visa_application_history->visa_apply_outcome}}@endif">
            </div>
        </div>
    </div>
    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary"
            style="padding-left:40px;padding-right:40px;">{{ __('labels.general.buttons.save') }}</button>
    </div>
</form>

<script>
      $('.mydatepicker').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true,
        zIndexOffset: 100,
        endDate: 'today'
    });
</script>
