@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/dropify/dist/css/dropify.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/dropzone-master/dist/dropzone.css') }}">
@endpush
@extends('frontend.layouts.app')

@section('content')

<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Messages</h3>
    </div>
</div>
<div class="container-fluid">    
    <div class="card">
        <div class="card-body" style="padding: 1rem">
            @include('includes.partials.messages') 

            @foreach($messages as $message)
            <h3>{{$message->title}}</h3>
            @endforeach

            <div class="row mt-4" >  
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <h4>Class Announcements</h4>
                    <div class="card m-b-1">
                        <div class="chat-main-box"> 

                            <div class="chat-rbox" id="broadcast" style="overflow-y:scroll; height:500px; border: 1px solid #ced4da;">
                                <ul class="chat-list p-20" id="chatgroup">

                                </ul>
                            </div>
                        </div>                      
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <h4>Trainer 1-to-1 Messages</h4>
                    <div class="chat-right-aside">
                        <div class="chat-rbox" id="private" style="overflow-y:scroll; height:400px; border: 1px solid #ced4da;">
                            <ul class="chat-list p-20" id="chatmessage">
                            </ul>
                        </div>
                        <div class="b-t b-l" style="padding: 5px;">
                            <div class="row">
                                <div style="width: 70%; margin-left: 15px;">
                                    <textarea id="message" class="form-control b-0" name ="message" rows="2" cols="90" placeholder="Type your message here"></textarea>
                                </div>
                                <div style="margin-left: auto;margin-right: 15px;">
                                    <button type="button" id="sendprivate" class="btn btn-info btn-circle btn-lg"><i class="fa fa-paper-plane-o"></i></button>
                                </div>
                                <input type="hidden" name="studentid" id="studentid" value="{{$userid}}">
                                <input type="hidden" name="trainerids" id="trainerids" value="{{$trainerid->id}}">

                                @foreach($messages as $message)
                                <input type="hidden" name="batchid" id="batchid" value="{{$message->id}}">
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

            </div> 

            </form> 
        </div>
    </div>
</div>
@endsection


@push('after-scripts')
<script>
  $("#message").keypress(function(event) {
  if (event.which == 13)
          {
          event.preventDefault();
          document.getElementById("sendprivate").click();
          }});
  $('#sendprivate').click(function()
          {
          event.preventDefault();
          var message = $('#message').val();
          $('#message').val('');
          var studentid = $('#studentid').val();
          var trainerids = $('#trainerids').val();
          var batchid = $('#batchid').val();
          var languages = [];
          $('.check').each(function(){
          if ($(this).is(":checked"))
                  {
                  languages.push($(this).val());
                  }
          });
          languages = languages.toString();
          $.ajax({
          url: '{{route("frontend.user.studentchat.save")}}',
                  method:"POST",
                  data:{
                  "_token": "{{ csrf_token() }}",
                          message:message,
                          trainerids:trainerids,
                          batchid:batchid,
                          studentid:studentid,
                          languages:languages,
                  },
                  dataType:"json",
                  success:function(response)
                  {
                  displayChat();
                  },
                  });
          });
  $(document).ready(function () {
  displayChat();
  });
  function chatScroll(){
  var element = document.getElementById("private");
  element.scrollTop = element.scrollHeight;
  }

  var $last_chat_id = 0;
  function displayChat() {
  $.ajax({
  url: '{{route("frontend.user.studentchat.get",$message->id)}}',
          type: 'get',
          dataType: 'json',
          success: function(privatechat)
          {
          var $len = privatechat.length;
          for (var i = $len - 1; i >= 0; i--)
          {
          $message = privatechat[i].message;
          $date = privatechat[i].created_at;
          $first_name = privatechat[i].first_name;
          $sender = privatechat[i].sender;
          $msg_id = privatechat[i].id;
          if ($msg_id <= $last_chat_id)
          {
          continue;
          }
          else
          {

          if ($sender == {{$userid}})
                  document.getElementById('chatmessage').innerHTML += '<li class="reverse" style="margin-top:10px;"><div class="chat-content"><h5>' + $first_name + '</h5><div class="box bg-light-inverse">' + $message + '</div></div><div class="chat-time" style="margin-right:10px; width:105px; text-align:right;">' + $date + '</div></li>';
          else
                  document.getElementById('chatmessage').innerHTML += '<li style="margin-top:10px;"><div class="chat-content"><h5>' + $first_name + '</h5><div class="box bg-light-info">' + $message + '</div></div><div class="chat-time" style="margin-left:10px; width:105px; text-align:left;">' + $date + '</div></li>';
          $last_chat_id = $msg_id;
          }
          chatScroll();
          // console.log($msg_id ,$last_chat_id);
      }
    },
  });
  }

  setInterval(displayChat, 5000);
  var $last_msg_id = 0;
  $(document).ready(function () {
  displayAnnounce();
  });
  function announceScroll(){
  var element = document.getElementById("broadcast");
  element.scrollTop = element.scrollHeight;
  }

  function displayAnnounce()
  {
  $.ajax({
  url: '{{route("frontend.user.classannouncements.get",$message->id)}}',
          type: 'get',
          dataType: 'json',
          success: function(groupchat)
          {
          flag = 1;
          var $len = groupchat.length;
          for (var i = $len - 1; i >= 0; i--)
          {
          $message = groupchat[i].message;
          $date = groupchat[i].created_at;
          $first_name = groupchat[i].first_name;
          $msg_id = groupchat[i].id;
          if ($msg_id <= $last_msg_id)
          {
          continue;
          }
          else
          {
          document.getElementById('chatgroup').innerHTML += '<li style="margin-top:10px;"><div class="chat-content"><h5>' + $first_name + '</h5><div class="box bg-light-info">' + $message + '</div></div><div class="chat-time" style="margin-left:10px; width:105px; text-align:left;">' + $date + '</div></li>';
          $last_msg_id = $msg_id;
          }
          // console.log(groupchat[i].id);
          announceScroll();
          }
          },
  });
  }
  setInterval(displayAnnounce, 5000);

</script>
@endpush
