{{ html()->form('POST', route('frontend.auth.change-payment-preference'))->class('form-horizontal')->open() }}
<input type="hidden" name="user_id" value="{{$logged_in_user->id}}">
    <div class="row">
        <div class="col-sm-12 col-md-6">
            <div class="form-group">
                <p>
                    {{ html()->label('How do you want to receive your payments / referral commission?')->for('details') }}
                </p>
                {{ html()->label('Mode')->for('pay_mode') }}
                <select class="form-control form-select" name="mode" required>
                    <option value="">Select</option>
                    @foreach(get_student_referral_payout_modes() as $value)
                        <option value="{{$value}}" @if($userDetails){{($userDetails->payment_pref_mode == $value)? 'selected' : ''}}@endif>{{$value}}</option>
                    @endforeach
                </select>
            </div><!--form-group-->
        </div><!--col-->
    </div><!--row-->

    <div class="row my-4">
        <div class="col-sm-12 col-md-6">
            <div class="form-group">
                {{ html()->label('Details')->for('details') }}
                <textarea name="details" class="form-control" required>@if($userDetails){{$userDetails->payment_pref_detail}}@endif</textarea>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12 col-md-6">
            <div class="form-group mb-0 clearfix">
                {{ form_submit(__('labels.general.buttons.update')) }}
            </div><!--form-group-->
        </div><!--col-->
    </div><!--row-->
{{ html()->form()->close() }}
@push('after-styles')
<style>
     .form-select,.form-control{
            box-shadow: none !important;
        }
        .form-select.form-control{ border: 1px solid rgba(8, 60, 130, 0.2)!important;  }
        .form-control:focus{border: 2px solid #9fbcf0;}
</style>
@endpush