@extends('frontend.layouts.app')
@section('title'){{'University Course Details'}}@endsection
@guest
    @section('public_content') 
@endguest

@auth
    @section('content') 
@endauth
<div class="row page-titles ms-3 mt-5">
    <div class="col-md-8 align-self-center">
        <h3 class="text-themecolor">University Course Details</h3>
    </div>
    </div>

    <!-- ============================================================== -->
    <!-- Container fluid  -->
    <!-- ============================================================== -->
    <div class="container-fluid">

        <!-- ============================================================== -->
        <!-- Start Page Content -->
        <!-- ============================================================== -->
<div class="row">
    <div class="col-12">
<div class="card mt-3">
    <div class="card-header bg-primary text-white h5">Course:<p style="font-size:1.4em;">{{$course->course_name}}</p></div>
    <div class="card-body pt-3">
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>University</b>
            </div>
            <div class="col-md-6">
                <a href="{{route('frontend.user.university-details', $course->university)}}">{{get_university_data($course->university)->university_name}}({{get_country_name(get_university_data($course->university)->country)}})</a> 
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Study Level</b>
            </div>
            <div class="col-md-6">
                @if($course->study_level) {{$course->study_level}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Campus</b>
            </div>
            <div class="col-md-6">
                @if($course->campus) {{$course->campus}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Intakes</b>
            </div>
            <div class="col-md-6">
                @if($course->intakes) {{$course->intakes}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Duration</b>
            </div>
            <div class="col-md-6">
                @if($course->duration) {{$course->duration}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Course Url</b>
            </div>
            <div class="col-md-6">
                @if($course->website_url)
                <?php $link = substr($course->website_url, 0, 30) . '...'; ?>
                <a href="{{$course->website_url}}" target="_blank" class="text-primary"><?php echo $link ?></a>
                @else --
                @endif
            </div>
        </div>
                {{-- //New fields --}}
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        {{-- <b>Yearly Tuition Fees Onshore</b> --}}
                        <b>Yearly Tuition Fees</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->yearly_tuition_fee) {{$course->currency}} {{get_currency_symbol($course->currency)}}{{$course->yearly_tuition_fee}} @else -- @endif
                    </div>
                </div>
                {{-- <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Yearly Tuition Fees Offshore</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->tuition_fee_offshore) {{$course->tuition_fee_offshore}} @else -- @endif
                    </div>
                </div> --}}
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Yearly Non Tuition Fee</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->non_tuition_fee) {{$course->currency}} {{get_currency_symbol($course->currency)}}{{$course->non_tuition_fee}} @else -- @endif
                    </div>
                </div>
        
        
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Course Details</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->course_details) {!!$course->course_details!!} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Occupation Outcome</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->occupation_outcome) {{$course->occupation_outcome}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Practical Work</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->practical_work) {{$course->practical_work}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Course Content/Learning</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->course_content) {!!$course->course_content!!} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Qualify for extended Visa</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->qualify_extended_visa) {{$course->qualify_extended_visa}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Regional Location</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->regional_location) {{$course->regional_location}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Country students not accepted</b>
                    </div>
                    <div class="col-md-6">
                        @if($course->country_students_not_accepted) {{$course->country_students_not_accepted}} @else -- @endif
                    </div>
                </div>
                {{-- //New fields --}}
        
         <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Application Deadline</b>
            </div>
            <div class="col-md-6">
                @if($course->application_deadline) {{$course->application_deadline}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Application Fee</b>
            </div>
            <div class="col-md-6">
                @if($course->application_fee) {{$course->currency}} {{get_currency_symbol($course->currency)}}{{$course->application_fee}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Scholarship Available</b>
            </div>
            <div class="col-md-6">
                @if($course->scholarship_available) {{$course->scholarship_available}} @else -- @endif
            </div>
        </div>
        @if($course->scholarship_available)
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Scholarship Detail</b>
            </div>
            <div class="col-md-6">
                @if($course->scholarship_detail && filter_var($course->scholarship_detail, FILTER_VALIDATE_URL))
                    <?php $link2 = substr($course->scholarship_detail, 0, 30) . '...'; ?>
                    <a href="{{$course->scholarship_detail}}" class="text-primary" target="_blank"><?php echo $link2 ?></a>
                @elseif($course->scholarship_detail) {{$course->scholarship_detail}} @else -- @endif
            </div>
        </div>
        @endif
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>Backlog Range</b>
            </div>
            <div class="col-md-6">
                @if($course->backlog_range) {{$course->backlog_range}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>University Applications Mode</b>
            </div>
            <div class="col-md-6">
                @if($course->applicationmode) {{$course->applicationmode}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-3">
                <b>DET Score</b>
            </div>
            <div class="col-md-6">
                @if($course->detscore) {{$course->detscore}} @else -- @endif
            </div>
        </div>
    </div>
</div>
<!-- //English -->
<div class="card mt-3">
    <div class="card-header bg-primary text-white h5">English Proficiency Test Requirements</div>
    <div class="card-body pt-3">
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>IELTS Overall</b>
            </div>
            <div class="col-md-6">
                @if($course->ielts_score) {{$course->ielts_score}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>IELTS No Band Less Than</b>
            </div>
            <div class="col-md-6">
                @if($course->ielts_no_band_less_than) {{$course->ielts_no_band_less_than}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>TOEFL Overall</b>
            </div>
            <div class="col-md-6">
                @if($course->toefl_score) {{$course->toefl_score}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>TOEFL No Band Less Than</b>
            </div>
            <div class="col-md-6">
                @if($course->toefl_no_band_less_than) {{$course->toefl_no_band_less_than}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>PTE Overall</b>
            </div>
            <div class="col-md-6">
                @if($course->pte_score) {{$course->pte_score}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>PTE No Band Less Than</b>
            </div>
            <div class="col-md-6">
                @if($course->pte_no_band_less_than) {{$course->pte_no_band_less_than}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3 border-bottom">
            <div class="col-md-3">
                <b>GRE Score</b>
            </div>
            <div class="col-md-6">
                @if($course->gre_score) {{$course->gre_score}} @else -- @endif
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-3">
                <b>GMAT Score</b>
            </div>
            <div class="col-md-6">
                @if($course->gmat_score) {{$course->gmat_score}} @else -- @endif
            </div>
        </div>
    </div>
</div>

<!-- //Entry Req. -->
<div class="card mt-3">
    <div class="card-header bg-primary text-white h5">Entry Requirements</div>
    <div class="card-body pt-3">
        <div class="row mt-3">
            <div class="col-md-12">
                <p>@if($course->entry_requirements) {{$course->entry_requirements}} @else -- @endif</p>
            </div>
        </div>
    </div>
</div>
<!-- //Remarks -->
<div class="card mt-3">
    <div class="card-header bg-primary text-white h5">Remarks</div>
    <div class="card-body pt-3">
        <div class="row mt-3">
            <div class="col-md-12">
                <p>@if($course->remarks) {{$course->remarks}} @else -- @endif</p>
            </div>
        </div>
    </div>
</div>
<div class="card mt-3 mb-3">
    <div class="card-body pt-3">
    <div class="col-md-12">
        <p><b>Notes: </b> All Fees are in Local Currency as per Educational Institution Location.</p>
    </div>
    </div>
</div>
@endsection
@push('after-scripts')
<script type="text/javascript">
</script>
@endpush