@extends('frontend.layouts.app')
@section('title'){{'University Course Finder'}}@endsection
@section('content')
<div class="row page-titles">
    <div class="col-md-8 align-self-center">
        <h3 class="text-themecolor">University Course Finder</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body pt-3">
                    <form id="cf_form">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group" style="margin-bottom:15px !important;">
                                    <label style="margin-bottom: 0.2rem;" class="required-field">Country</label>
                                    <select name="country[]" id="country" class="form-control form-select" required>
                                        <option value="">Select Country</option>
                                        @foreach($countries as $country)
                                        <option value="{{ get_country_id_by_name($country) }}">{{ $country }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group" style="margin-bottom:15px !important;">
                                    <label style="margin-bottom: 0.2rem;">Campus/City</label>
                                    <select name="campus" id="campus" class="form-select form-control">
                                        <option value="">Select Campus/City</option>
                                    </select>
                                </div>
                            </div>
                            {{-- <div class="col-md-2">
                                <label class="">Year</label>
                                <select name="year" class="form-control form-select">
                                    <option value="">Select</option>
                                    @foreach($years as $year)
                                    <option value="{{ $year }}">{{ $year }}</option>
                                    @endforeach
                                </select>
                            </div> --}}
                            <div class="col-md-3">
                                <label class="required-field">Study Level</label>
                                <select name="study_level" class="form-control form-select" required>
                                    <option value="">Select</option>
                                    @foreach($levels as $level)
                                    <option value="{{ $level }}">{{ $level }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group" style="margin-bottom:15px !important;">
                                    <label style="margin-bottom: 0.2rem;" class="">Intake</label>
                                    <select name="intake[]" class="form-control form-select select2" multiple="multiple">
                                        <option value="Jan">January</option>
                                        <option value="Feb">February</option>
                                        <option value="Mar">March</option>
                                        <option value="Apr">April</option>
                                        <option value="May">May</option>
                                        <option value="Jun">June</option>
                                        <option value="Jul">July</option>
                                        <option value="Aug">August</option>
                                        <option value="Sep">September</option>
                                        <option value="Oct">October</option>
                                        <option value="Nov">November</option>
                                        <option value="Dec">December</option>
                                        <option value="Spring">Spring</option>
                                        <option value="Summer">Summer</option>
                                        <option value="Fall">Fall</option>
                                        <option value="Winter">Winter</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-3">
                                <label class="">Study Area</label>
                                <select name="category" id="category" class="form-control form-select">
                                    <option value="">Select</option>
                                    @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}">{{ $cat->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="">Discipline Area</label>
                                <select name="sub_category" id="sub-cat" class="form-control form-select">
                                    <option value="">Select</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Duration</label>
                                    <select name="duration" class="form-control form-select">
                                        <option value="">Select</option>
                                        @if(count($durations))
                                        @foreach($durations as $duration)
                                            <option value="{{$duration->duration}}">{{$duration->duration}}</option>
                                        @endforeach
                                        @endif
                                        {{-- <option value="12">0-1 year</option>
                                        <option value="24">1-2 years</option>
                                        <option value="36">2-3 years</option>
                                        <option value="48">3-4 years</option>
                                        <option value="60">4+ years</option> --}}
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group" style="margin-bottom:15px !important;">
                                    <label style="margin-bottom: 0.2rem;">Course/University</label>
                                    <input type="text" class="form-control" placeholder="Course/University" name="course" maxlength="100">
                                </div>
                            </div>
                        </div>

                        <span class="btn btn-sm btn-outline-primary" id="see_more_btn">See More <i class="mdi mdi-chevron-down" style="font-size: 15px;"></i></span>
                        <div class="row mt-2" id="see-more" style="display: none;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>IELTS Score</label>
                                    <input type="number" step="0.5" placeholder="IELTS Score" name="ielts" value="" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>IELTS No Band Less Than</label>
                                    <input type="number" step="0.5" placeholder="IELTS No Band Less Than" name="ielts_no_band" value="" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>TOEFL Score</label>
                                    <input type="number" step="1" placeholder="TOEFL Score" name="toefl" value="" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>TOEFL No Band Less Than</label>
                                    <input type="number" step="1" placeholder="TOEFL No Band Less Than" name="toefl_no_band" value="" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group mb-3">
                                    <label>PTE Score</label>
                                    <input type="number" step="1" placeholder="PTE Score" name="pte" value="" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group mb-3">
                                    <label>PTE No Band Less Than</label>
                                    <input type="number" step="1" placeholder="PTE No Band Less Than" name="pte_no_band" value="" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group mb-3">
                                    <label>GRE Score</label>
                                    <input type="number" step="1" placeholder="GRE Score" name="gre" value="" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group mb-3">
                                    <label>GMAT Score</label>
                                    <input type="number" step="1" placeholder="GMAT Score" name="gmat" value="" class="form-control">
                                </div>
                            </div>
                        </div>
                        <span class="btn btn-sm btn-outline-primary" id="see_less_btn" style="display: none;">See Less <i class="mdi mdi-chevron-up" style="font-size: 15px;"></i></span>
                        <div class="form-group mt-4" style="text-align: center">
                            <input type="submit" class="btn btn-themecolor" value="Search Courses">
                        </div>
                    </form>
                    <div id="result_body" style="">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('after-scripts')
<script type="text/javascript">
    $(document).ready(function() {
        var html = '';
        $('#category').on('change', function() {
            var idCat = this.value;
            $("#sub-cat").html('');
            $.ajax({
                url: "{{route('frontend.user.fetchSubCat')}}",
                type: "POST",
                data: {
                    category_id: idCat,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#sub-cat').html('<option value="">Select Discipline Area</option>');
                    $.each(result.subcategories, function(key, value) {
                        $("#sub-cat").append('<option value="' + value
                            .id + '">' + value.title + '</option>');
                    });
                }
            });
        });

        $('#see_more_btn').on('click', function() {
            $('#see-more').toggle(300);
            $('#see_less_btn').toggle();
            $('#see_more_btn').toggle();
        });
        $('#see_less_btn').on('click', function() {
            $('#see-more').toggle(300);
            $('#see_less_btn').toggle();
            $('#see_more_btn').toggle();
        });

        $('#country').on('change', function() {
            var idCountry = this.value;
            $("#campus").html('');
            $.ajax({
                url: "{{route('frontend.user.fetchCampus')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#campus').html('<option value="">Select Campus/City</option>');
                    $.each(result.campus, function(key, value) {
                        $("#campus").append('<option value="' + value
                            .campus + '">' + value.campus + '</option>');
                    });
                }
            });
        });
    });
    $('#cf_form').on('submit', function(e) {
        var html = '<h3 class="text-center mt-4 p-5">Searching...</h3>';
        e.preventDefault();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "{{route('frontend.user.course-finder.get-result')}}",
            type: "POST",
            data: $('#cf_form').serialize(),
            success: function(response) {
                html = '';
                if (response.data.length > 0) {
                    html += '<div class="card-header bg-primary p-2 pt-3 mt-4 text-white"><p class="h6"><b>' + response.data.length + ' COURSE(S) FOUND</b></p></div>';
                    for (var count = 0; count < response.data.length; count++) {
                        var duration = "";
                        var intakes = "";
                        var tuition_fee_onshore = "";
                        if(response.data[count].duration){
                            var duration = response.data[count].duration;
                        }else{
                            var duration = "--";
                        }
                        if(response.data[count].intakes){
                            var intakes = response.data[count].intakes;
                        }else{
                            var intakes = "--";
                        }
                        // if(response.data[count].tuition_fee_onshore){
                        //     var tuition_fee_onshore = response.data[count].tuition_fee_onshore;
                        // }else{
                        //     var tuition_fee_onshore = "--";
                        // }
                        if(response.data[count].yearly_tuition_fee){
                            var yearly_tuition_fee = response.data[count].yearly_tuition_fee;
                        }else{
                            var yearly_tuition_fee = "--";
                        }
                        if(response.data[count].currency){
                            var currency = response.data[count].currency;
                        }else{
                            var currency = "";
                        }

                        var link = "{{url('course-finder/course-details/')}}/" + response.data[count].id;
                        var uni_link = "{{url('course-finder/university-details/')}}/" + response.data[count].uni_id;
                        html += '<div class="row mt-4 m-2" style="padding-bottom:20px;border-bottom:1px solid #e2e2e2;">';
                        html += '<div class="col-sm-12 col-md-9"><a href="' + link + '" target="_blank">';
                        html += '<p class="h5"><b>' + response.data[count].course_name + '</b></p></a>';
                        html += '<p class="mb-1 text-dark"><b>University:</b> <a class="text-primary" target="_blank" href="'+uni_link+'">' + response.data[count].university_name + '</a></p>';
                        html += '<p class="mb-1 text-dark"><b>Country:</b> ' + response.data[count].country + '</p>';
                        html += '<p class="mb-1 text-dark"><b>Duration:</b> ' + duration + ' </p>';
                        html += '<p class="mb-1 text-dark"><b>Intakes:</b> ' + currency +' '+ yearly_tuition_fee + '</p>';
                        html += '<p class="mb-1 text-dark"><b>Tuition Fees:</b> ' + tuition_fee_onshore + '</p>';
                        html += '</div>';
                        html += '<div class="col-sm-12 col-md-3"><button class="btn btn-warning" onclick="javascript:bookmark_course(' + response.data[count].id + ')">Bookmark</button></div>';
                        html += '</div>';
                        //console.log(response.data);
                    }
                } else {
                    html = '<h5 class="text-center p-5">No Data Found</h5>';
                }
                $('#result_body').html(html);
            },
            error: function(response) {

            },
        });
        $('#result_body').html(html);
    });
</script>
@endpush

@push('after-scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="sweetalert2.all.min.js"></script>
<script>

    function bookmark_course(id) {
        // console.log("bookmark:" + id);
        // var formData = new FormData();
        // formData.append('course_id', id);

        // $.ajaxSetup({
        //     headers: {
        //         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //     }
        // });        

        $.ajax({
            type: 'POST',
            url: "{{ route('frontend.user.course-finder.add-bookmark') }}",
            data: {
                course_id: id,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
            success: function(data) {
                if (data.res == 'success') {
                    //console.log(data);
                    Swal.fire(
                    'Success!',
                    data.message,
                    'success'
                    )
                } else {
                    alert(data.message);
                }
            },
            error: function(response) {
                alert(response.responseJSON.message);
            }
        });
    }
</script>
@endpush