@extends('frontend.layouts.app')

@section('public_content')
<br>
<div class="container-lg mx-auto">
    <main class="inner cover mb-4">
        <h2 class="cover-heading fw-bold text-themecolor">Explore Top Study Abroad Universities & Courses</h2>
    </main>
    <span id="courses_count"></span>
    <div class="row mt-3 card">
        <div class="col-12 card-body">
            <div class="row">
                <div class="col-md-3">
                    <label class="fw-bold ">Study Level</label>
                    <select class="form-select form-control" name="study_level" id="study_level">
                        <option hidden>Select Study Level</option>
                        @foreach(get_study_levels() as $level)
                            <option value="{{$level}}">{{ $level }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mt-3 mt-xl-0">
                    <label class="fw-bold text-dark">Select Country</label>
                    <select name="country[]" id="country" class="form-control form-select select2 select2country" style="height: 10px !important; width: 100%;" multiple>
                        {{-- <option value="">Select Country</option> --}}
                        @foreach($countries as $country)
                        <option value="{{ get_country_id_by_name($country) }}">{{ $country }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 mt-3 mt-xl-0">
                    <label class="fw-bold text-dark">Enter a Keyword</label>
                    <input type="search" id="course" class="form-control" placeholder="Course, University...">
                </div>
                <div class="col-12" style="margin-top: 27px;">
                    <div class="row justify-content-center">
                        <div class="col-6 text-center">
                            <button type="button" id="search_btn" class="btn btn-themecolor">Search</button>
                            <button type="button" onClick="window.location.reload();" class="btn btn-secondary">Clear</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-3 card py-3">
            <div class="row">
                <div class="col-md-12 mt-3">
                    <label for="filterstudyArea" class="form-label mb-0 fw-bold text-dark">Study Area</label>
                    <select class="form-select" id="filterstudyArea">
                        <option value="">Study Area</option>
                        @foreach($categories as $cat)
                            <option {{(isset(Session::get('course_finder_filters')['study_area']) && Session::get('course_finder_filters')['study_area'] == $cat->id) ? 'selected' : ''}} value="{{ $cat->id }}">{{ $cat->title }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-12 my-3">
                    <label for="filterdisciplineArea" class="form-label mb-0 fw-bold text-dark">Discipline Area</label>
                    <select class="form-select" id="filterdisciplineArea">
                        <option value="">Any</option>
                    </select>
                </div>
                <div class="col-md-12 mt-3" style="height:2px; border-width:0; background-color:#a4a4a482;"></div>
                <div class="col-md-12 mt-3">
                    <label for="search_intake" class="form-label mb-0 fw-bold text-dark">Intake</label>
                    <select class="form-select select2" style="width:100%;" name="intake[]" id="search_intake" multiple="multiple">
                            {{-- <option value="">Any</option> --}}
                            <option value="Jan">January</option>
                            <option value="Feb">February</option>
                            <option value="Mar">March</option>
                            <option value="Apr">April</option>
                            <option value="May">May</option>
                            <option value="Jun">June</option>
                            <option value="Jul">July</option>
                            <option value="Aug">August</option>
                            <option value="Sep">September</option>
                            <option value="Oct">October</option>
                            <option value="Nov">November</option>
                            <option value="Dec">December</option>
                            <option value="Spring">Spring</option>
                            <option value="Summer">Summer</option>
                            <option value="Fall">Fall</option>
                            <option value="Winter">Winter</option>
                    </select>
                </div>
                <div class="col-md-12 mb-3 mt-3">
                    <label for="search_duration" class="form-label mb-0 fw-bold text-dark">Duration</label>
                    <select class="form-select fltrs" id="search_duration">
                        <option value="">Any</option>
                        <option value="12">0-1 year</option>
                        <option value="24">1-2 years</option>
                        <option value="36">2-3 years</option>
                        <option value="48">3-4 years</option>
                        <option value="60">4+ years</option>
                    </select>
                </div>
                <div class="col-md-12 mt-3" style="height:2px; border-width:0; background-color:#a4a4a482;"></div>
                <div class="col-md-12 my-3">
                    <div class="dropdown">
                        <label for="filterdisciplineArea" class="form-label mb-0 fw-bold text-dark">Sort</label>
                        <select name="sort_by" id="sort_by" class="form-select">
                            <option value="">Sort By</option>
                            <option value="ielts_lth">IELTS Score Low to High</option>
                            <option value="ielts_htl">IELTS Score High to Low</option>
                            <option value="course_name">Course Name</option>
                            <option value="fee_lth">Course Fee Low to High</option>
                            <option value="fee_htl">Course Fee High to Low</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-12 mt-3" style="height:2px; border-width:0; background-color:#a4a4a482;"></div>

                <div class="row mt-3">
                    <div class="col-12">
                        <label for="ielts_score" class="form-label mb-0 fw-bold text-dark">IELTS Score</label>
                        <input class="form-control " type="number" id="ielts_score" step="0.5" placeholder="IELTS Score" name="ielts" value="">
                    </div>
    
                    <div class="col-md-12">
                        <label for="ielts_no_band_score" class="form-label mb-0 fw-bold text-dark">IELTS No Band Less Than</label>
                        <input type="number" id="ielts_no_band_score" step="0.5" placeholder="IELTS No Band Less Than" name="ielts_no_band" value="" class="form-control">
                    </div>
                </div>
                <div class="col-md-12 mt-3" style="height:2px; border-width:0; background-color:#a4a4a482;"></div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <label for="toefl_score" class="form-label mb-0 fw-bold text-dark">TOEFL Score</label>
                        <input type="number" id="toefl_score" step="1" placeholder="TOEFL Score" name="toefl" value="" class="form-control">
                    </div>

                    <div class="col-md-12 mt-3">
                        <label for="toefl_no_band_score" class="form-label mb-0 fw-bold text-dark">TOEFL No Band Less Than</label>
                        <input type="number" id="toefl_no_band_score" step="1" placeholder="TOEFL No Band Less Than" name="toefl_no_band" value="" class="form-control">
                    </div>
                </div>
                <div class="col-md-12 mt-3" style="height:2px; border-width:0; background-color:#a4a4a482;"></div>

                <div class="row mt-3">
                    <div class="col-md-12 ">
                        <label for="pte_score" class="form-label mb-0 fw-bold text-dark">PTE Score</label>
                        <input type="number" id="pte_score" step="1" placeholder="PTE Score" name="pte" value="" class="form-control">
                    </div>
    
                    <div class="col-md-12 mt-3">
                        <label for="pte_no_band_score" class="form-label mb-0 fw-bold text-dark">PTE No Band Less Than</label>
                        <input type="number" id="pte_no_band_score" step="1" placeholder="PTE No Band Less Than" name="pte_no_band" value="" class="form-control">
                    </div>
                </div>
                <div class="col-md-12 mt-3" style="height:2px; border-width:0; background-color:#a4a4a482;"></div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <label for="gre_score" class="form-label mb-0 fw-bold text-dark" >GRE Score</label>
                        <input type="number" id="gre_score" step="1" placeholder="GRE Score" name="gre" value="" class="form-control">
                    </div>
    
                    <div class="col-md-12 mt-3">
                        <label for="gmat_score" class="form-label mb-0 fw-bold text-dark" >GMAT Score</label>
                        <input type="number" id="gmat_score" step="1" placeholder="GMAT Score" name="gmat" value="" class="form-control">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-9">
            {{-- <div class="row" id="result_body">
                <h3 class="mt-5 text-align-center">Select a Country and Study Level to search!</h3>
            </div> --}}
            <div class="card-body " style="width: 103%;">
                <div class="row">
                    <h3 id="default_txt" class="text-align-center">Select a Country and Study Level to search!</h3>
                    <div class="table-responsive" id="result_table" style="display: none;">  
                        <table class="table w-100 fixTableHead border-none" id="course_list">
                            <thead class="border-none">
                                <tr class="border-none">
                                    <th style="width:200px;"></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div> 
            </div>
        </div>
    </div>
    <br>
    
</div>

<div class="modal fade" id="coursePreferenceModal" aria-labelledby="coursePreferenceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border" style="margin: 0px !important; padding: 15px !important;">
                <h5 class="modal-title">Select Intake</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body border" id="courseBody" style="margin: 0px !important; padding: 15px !important;">
                <h6><b class="text-secondary">Course:</b> <span id="course_preference_name"></span></h6>
                <h6><b class="text-secondary">University:</b> <span id="course_preference_uni"></span></h6>
                <h6><b class="text-secondary">Country:</b> <span id="course_preference_country"></span></h6>
                <div class="col-md-12 mt-3" style="height:2px; border-width:0; background-color:#a4a4a482;"></div>
                <form class="form" style="margin: 0px !important; padding: 15px !important;" id="assign_course_preference_form" method="GET" action="{{route('frontend.course-finder.apply-course')}}">
                    <input type="hidden" id="assign_preference_course_id" name="preference_course_id" value="">
                    <input type="hidden" id="assign_course_preference_country" name="course_preference_country" value="">
                    <input type="hidden" id="assign_course_preference_uni" name="course_preference_uni" value=""> 
                    <div class="row mb-3">
                        <div class="col-sm-12 col-md-12">
                            <label for="intake" class="required-field">Intake</label>
                            <select name="intake" style="width:100%;" id="intake" class="form-select form-control select2intake" required>
                                <option value="">Intake</option>
                                <?php $month = date('n'); // current month
                                for ($x = 0; $x < 24; $x++) { ?>
                                <option value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                                <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                                <?php } ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <input type="submit" class="btn btn-primary" value="Apply">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<style>
    .modal-half-right {
        position: fixed;
        top: 0;
        right: 0;
        width: 50%;
        height: 100%;
        margin: 0;
    }
    .mdl_cntnt {
        height: 100%;
        overflow-y: auto;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__rendered{
        height: 37px !important;
        border-color: rgb(208,214,219);
    }

    span > .select2-selection__rendered{
        height: 50px !important;
    }
    .select2-selection--multiple{
        height: 50px !important;
    }
    .select2-selection--single{
        height: 40px !important;
    }

    .dataTables_empty{
        padding-top: 40px !important;
    }
    #course_list_info{
        padding-bottom: 15px !important;
    }
    .paginate_button{
        border: 1px solid rgb(25, 135, 232) !important;
        padding: 10px 20px;
        /* border-radius: 5px; */
    }

    #course_list_previous{
        cursor: pointer;
        border-top-left-radius: 5px;
        border-bottom-left-radius: 5px;
    }
    #course_list_paginate span{
        cursor: pointer;
    }
    #course_list_next{
        cursor: pointer;
        border-top-right-radius: 5px;
        border-bottom-right-radius: 5px;
    }
</style>

@endsection

@push('before-styles')
<style>
    .card-columns {
        display: flex;
        justify-content: space-between;
    }
    .card-columns .column {
        flex: 1;
    }
    .table td{
        border: none !important;
        background-color: rgb(251,251,251);
    }
    #course_list_length{
        display: none !important;
    }
    #course_list_wrapper{
        margin-top: -38px !important;
    }
    #result_table{
        margin-top: -32px !important;
    }
</style>    <style>
        .select2-selection { background-color: #FEFEFE !important }
        .select2-container--default .select2-selection--multiple:focus-within { border: 2px solid #9fbcf0 !important; }
        .select2-container--default .select2-selection--multiple ,.form-select{ border: 1px solid rgba(8, 60, 130, 0.2)!important;  }
        .form-select,.form-control{
            box-shadow: none !important;
        }
        .form-control:focus{border: 2px solid #9fbcf0;}
        .input-box-inner-style {
            padding: 7px 10px !important;
        }

        .responsive-set-margin{
            margin: 0px -41px;
        }
        
        .responsive-set-margin-blocks{
            margin: -41px -41px;
        }

        .tab{
            background-color: #E0E4FA !important; 
            padding: 4px 25px !important; 
        }

        .tab-heading{
            font-size: 18px;
        }
        
        @media (max-width: 769px) {
            .sub-card{
                margin: 10px -25px;
            }
        }

        @media (max-width: 845px) {
            .tab{
                background-color: #E0E4FA !important; 
                padding: 0px 10px !important; 
            }
            .tab-heading{
                font-size: 14px;
            }
        }
    </style>

@endpush

@push('after-scripts')
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/DataTables-1.12.1/js/jquery.dataTables.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="sweetalert2.all.min.js"></script>
<script>
    $(document).ready(function() {
        $(".select2country").select2({
            placeholder: "Select Country",
        });

        $(".select2intake").select2({
            placeholder: "Select Intake",
            dropdownParent: $("#coursePreferenceModal"),
        });
        
        $('#filterstudyArea').on('change', function() {
            var idCat = this.value;
            $("#filterdisciplineArea").html('');
            $.ajax({
                url: "{{route('frontend.fetchSubCat')}}",
                type: "POST",
                data: {
                    category_id: idCat,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    
                    $('#filterdisciplineArea').html('<option value="">Any</option>');
                    $.each(result.subcategories, function(key, value) {
                        if(value.id == "{{(isset(Session::get('course_finder_filters')['discipline_area']))? Session::get('course_finder_filters')['discipline_area'] : ''}}"){
                            var selectedSubCat = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedSubCat = "";
                        }
                        $("#filterdisciplineArea").append('<option '+selectedSubCat +' value="' + value
                            .id + '">' + value.title + '</option>');
                    });
                },
                async: true,
            });
    });
    //$('#filterstudyArea').trigger('change');
    // function loadData(myData) {
    //     if(($('#country').val()).length == 0){
    //         alert("Please select a Country!");
    //         return;
    //     }
    //     var html = '<h3 class="text-center mt-4 p-5">Searching...</h3>';
    //     $.ajaxSetup({
    //         headers: {
    //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //         }
    //     });
        
    //     $.ajax({
    //         url: "{{route('frontend.course-finder.fetch-result')}}",
    //         type: "POST",
    //         data: {
    //             'study_level': $('#study_level').val(),
    //             'course': $('#course').val(),
    //             'country': $('#country').val(),
    //             'sort_by': $('#sort_by').val(),
    //             'filterstudyArea': $('#filterstudyArea').val(),
    //             'filterdisciplineArea': $('#filterdisciplineArea').val(),
                
    //         },
    //         success: function(response) {
    //             html = '';
    //             $("#courses_count").html("<h2>"+response.res_count+" Courses found</h2>");
    //             if (response.data.length > 0) {
    //                 html = response.data;
    //             } else {
    //                 html = '<h5 class="text-center p-5">No Data Found</h5>';
    //             }
    //             $('#result_body').html(html);
    //             $('#cat_name').html(response.cat_name);
    //         },
            
    //         error: function(response) {
    //         },
    //     });
    //     $('#result_body').html(html);
    // }

    // loadData();
    // $('#study_level,#sort_by,#country,#filterstudyArea,#filterdisciplineArea').change(function() {
    //     loadData();
    // });

    function loadData(myCourses) {
        $("#default_txt").hide();
        $("#result_table").show();
        var table = $('#course_list').DataTable({
            dom: '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: ""
            },
            searching:false,
            autoWidth: true,
            responsive: true,
            pageLength: 10,
            "lengthMenu": [10,25, 50, 100],
            "ajax": {
                "url": "{{route('frontend.course-finder.fetch-result')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'course_university_search': $('#course_university_search').val(),
                    'country': $('#country').val(),
                    'course': $('#course').val(),
                    // 'category': $('#category').val(),
                    // 'sub_category': $('#sub-cat').val(),
                    'universities': $('#universities').val(),
                    'study_level': $('#study_level').val(),
                    'filterstudyArea': $('#filterstudyArea').val(),
                    'filterdisciplineArea': $('#filterdisciplineArea').val(),
                    'search_intake': $('#search_intake').val(),
                    'search_duration': $('#search_duration').val(),
                    'campus': $('#campus').val(),
                    'sort_by': $('#sort_by').val(),
                    'toefl': $('#toefl_score').val(),
                    'toefl_no_band': $('#toefl_no_band_score').val(),
                    'ielts_no_band': $('#ielts_no_band_score').val(),
                    'ielts': $('#ielts_score').val(),
                    'pte': $('#pte_score').val(),
                    'pte_no_band': $('#pte_no_band_score').val(),
                    'gre': $('#gre_score').val(),
                    'gmat': $('#gmat_score').val(),
                },
            },
            "drawCallback": function( settings ) {
                if ($('#course_list tr').length < 11){
                    $('#course_list_info').hide();                
                    $('#course_list_paginate').hide();                
                }
            },
            columns: [
                {
                    data: 'course_name',
                },
            ],
            order: [[0, 'asc']],
        });
    }

    // function check_allBox() {
    //         if ($("input:checkbox[name='check_all']").prop("checked")) {
    //             $("input:checkbox[name='multiselect']").prop("checked", true);
    //         } else {
    //             $("input:checkbox[name='multiselect']").prop("checked", false);
    //         }
    //         checkboxCheckSelected();
    //     }

    //     function checkboxCheckSelected() {
    //         var total_check_boxes = $("input:checkbox[name='multiselect']").length;
    //         var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
    //         if (total_check_boxes === total_checked_boxes) {
    //             $("#check_all").prop("checked", true);
    //         } else {
    //             $("#check_all").prop("checked", false);
    //         }
    //         if (total_checked_boxes > 0) {
    //             $(".process-selected").show();
    //         } else {
    //             $(".process-selected").hide();
    //         }
    //     }

        // function processBulkSuggest() {
        //     var dataArray = new Array();
        //     $("input:checkbox[name=multiselect]:checked").each(function() {
        //         dataArray.push($(this).val());
        //     });
        //     $('#courseMultiModal').modal("show");
        //     $('#assign_multi_course').val(dataArray).show();
        // }

        // function processBulkDownload() {
        //     var dataArray = new Array();
        //     $("input:checkbox[name=multiselect]:checked").each(function() {
        //         dataArray.push($(this).val());
        //     });
        //     $('#download_multi_course').val(dataArray).show();
        // }

    function searchTable() {
        $("#course_list").dataTable().fnDestroy();
        loadData();
    }
    function clearTable() {
        $('#course_university_search').val('');
        $("#country").val('');
        $('#universities').val('');
        $('#study_level').val('');
        $("#search_intake").select2('destroy').val('').select2();
        $('#yearly_tuition_fee').val('');
        $('#institution_turnaround_time').val('');
        $("#course_list").dataTable().fnDestroy();
        loadData();
    }

    $('#search_btn').click(function() {
        searchTable();
        //loadData();
    }); 

    $('#filterstudyArea,#filterdisciplineArea,#sort_by,#search_intake,#search_duration').change(function() {
        // $("#course_list").dataTable().fnDestroy();
        // loadData();
        searchTable();
    }); 

    $('#toefl_score,#toefl_no_band_score,#ielts_score,#ielts_no_band_score,#pte_score,#pte_no_band_score,#gre_score,#gmat_score').keyup(function() {
        searchTable();
    }); 

    // $(document).ready(function() {
    //     let study_level_array = $("#study_level").val();
    //     @foreach(get_course_suggest_levels() as $level)
    //         $('#study_level_{{$level}}').click(function() {
    //             if($(this).prop('checked')){
    //                 study_level_array = [...study_level_array, '{{$level}}'];
    //                 $("#study_level").val(study_level_array);
    //                 // $("#course_list").dataTable().fnDestroy();
    //                 // loadData();
    //                 searchTable();
    //             } else{
    //                 study_level_array = study_level_array.filter((study_level) => study_level != '{{$level}}' );
    //                 $("#study_level").val(study_level_array);
    //                 // $("#course_list").dataTable().fnDestroy();
    //                 // loadData();
    //                 searchTable();
    //             }
    //         });
    //     @endforeach
    // });

    $(document).ready(function() {
        let study_level_array = $("#study_level").val();
            $(".study_level_val").click(function() {
                if($(this).is(":checked")) {
                    console.log(this.value);
                    study_level_array = [...study_level_array, this.value];
                    $("#study_level").val(study_level_array);
                    searchTable();
                } else{
                    study_level_array = study_level_array.filter((study_level) => study_level != this.value);
                    $("#study_level").val(study_level_array);
                    searchTable();
                }
            });
    });

    
    // $('#apply_filter').on('click', function() {
    //     getSelected();
    //     if($('#filterStudyLevel').val()!=""){
    //         const selectEles = $('.stu_lvl_sel');
    //         var sel1 = $(selectEles[1]).val();
    //         selectEles[0].value = sel1;
    //     }
    //     $('#filterModal').modal('hide');
    //     loadData();
    // });
    // const selectEles = $('.stu_lvl_sel');
    // $(selectEles[0]).on('change', function() {
    //     selectEles[1].value = $(this).val();
    // });

    // $("#course").on("keyup search", function () {
    //     var value = $(this).val().toLowerCase();
    //     $("#result_body .card").filter(function () {
    //         // change here to the parent as if you hide card only card will hide but col will still take the place
    //         $(this).parent().toggle($(this).text().toLowerCase().indexOf(value) > -1)
    //     });
    //  });

     $(document).on('click', '#coursePreferenceButton', function(event) {
        event.preventDefault();
        let btn = $(this);
        let href = "{{url('course-finder/fetch-course-info/')}}/" + $(this).attr('data-id');
        $.ajax({
            url: href,
            beforeSend: function() {
                btn.html('Wait...');
                //btn.addClass('btn-secondary');
            },
            // return the result
            success: function(result) {
                $('#course_preference_name').html(result.data['course_name']).show();
                $('#course_preference_uni').html(result.data['course_uni']).show();
                $('#course_preference_country').html(result.data['course_country']).show();
                
                $('#assign_preference_course_id').val(result.data['id']).show();
                $('#assign_course_preference_country').val(result.data['university_country_id']).show();
                $('#assign_course_preference_uni').val(result.data['university_id']).show();
                $('#coursePreferenceModal').modal("show");
            },
            complete: function() {
                btn.html('Apply');
            },
            error: function(jqXHR, testStatus, error) {
                console.log(error);
                alert("Page " + href + " cannot open. Error:" + error);
                btn.html('Apply');
            },
            timeout: 8000
        })
    });
   
});
function getSelected() {
  // using spread operator to convert collection to array
  // using array filter methods to create a new array with select which have value
  let k = [...document.getElementsByClassName('fltrs')].filter(item => {
    if(item.id == 'filtercourseFeesRange' && item.value == "50000"){
        return item.value == ''
    }
    return item.value !== ''
  })
  // this will give number of selects whose value is nit empty
  $("#fltr_cnt").html('('+k.length+')');
}

function bookmark_course(id) {
        $.ajax({
            type: 'POST',
            url: "{{ route('frontend.course-finder.add-bookmark') }}",
            data: {
                course_id: id,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
            success: function(data) {
                if (data.res == 'success') {
                    //console.log(data);
                    Swal.fire(
                    'Success!',
                    data.message,
                    'success'
                    )
                } else {
                    alert(data.message);
                }
            },
            error: function(response) {
                alert(response.responseJSON.message);
            }
        });
    }

</script>
@endpush
