@extends('frontend.layouts.app')
@section('title'){{ __('strings.frontend.general.apply_for_study_abroad') }}@endsection

@php
// $countries = get_study_countries();
$months = array();
for ($i = 1; $i <= 12; $i++) { $months[$i]=date('F', strtotime("2000-".$i."-01")); } @endphp @section('content') 
    <div class="row page-titles p-4 pb-0 wrapper mx-3" >
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor">{{ __('strings.frontend.general.apply_for_study_abroad') }}</h3>
        </div>
    </div>

    <div class="container-fluid" style="padding-top:20px; padding-bottom: 30px;">
        @include('includes.partials.messages')
        <!-- Nav tabs -->
        <ul class="nav nav-tabs customtab2" role="tablist">
            <li class="nav-item"> <a class="nav-link border tab" href="{{route('frontend.user.studyabroad.profile')}}" role="tab"><span class="hidden-sm-up"><i class="ti-user"></i></span> <span class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.profile') }}</span></a> </li>&nbsp;
            <li class="nav-item"> <a class="nav-link border tab active" href="{{route('frontend.user.studyabroad.coursepreference')}}" role="tab"><span class="hidden-sm-up"><i class="ti-book"></i></span> <span class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.course_preferences') }}</span></a> </li>&nbsp; 
            <li class="nav-item"> <a class="nav-link border tab" href="{{route('frontend.user.studyabroad.documents')}}" role="tab"><span class="hidden-sm-up"><i class="ti-folder"></i></span> <span class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.documents') }}</span></a> </li>
        </ul>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <!-- Tab panes -->
                        <div class="tab-content" style="margin: -30px -30px 0px -30px !important;">
                            <div class="tab-pane active" id="course" role="tabpanel">
                                <div class="p-t-20">
                                    @if($profile_pending)
                                    <div class="alert alert-danger" role="alert">
                                        {{ __('strings.frontend.general.complete_your_profile') }}
                                    </div>
                                    @endif
                                    @if(!$profile_pending && !$can_edit)
                                    <div class="alert alert-success" role="alert">
                                        {{ __('strings.frontend.general.completed_this_step') }}
                                    </div>
                                    @endif

                                        <div class="row">
                                            <div class="col-md-12">
                                                @if(!$logged_in_user->overseas_study_level)
                                                    <div class="alert alert-danger my-3 " role="alert">
                                                        {{ __('strings.frontend.general.update_Profile') }}
                                                    </div>
                                                @endif
                                                @if($logged_in_user->overseas_study_level)
                                                <div class="text-start text-white fs-20 card-header bg-theme p-2 ps-4" style="">
                                                    {{ __('strings.frontend.general.program_preferences') }}
                                                </div>
                                                <h5 class="mt-3 ms-3">{{ __('strings.frontend.general.add_new_program') }}</h5>

                                                <div class="row mb-5" style="margin-top: -20px;">
                                                    <div class="col-12">
                                                        <div class="container w-100" id="collapseOneTitle" style="margin-bottom:0;margin-top:30px;">
                                                            <a class="collapsed " href="#collapseOne" data-toggle="collapse" aria-expanded="false" aria-controls="collapseOne">
                                                                <div class="text-start text-white fs-20 rounded " style="background-color: #E0E4FA; border-color: rgb(235,235,235); margin: -5px -15px 0px;">
                                                                    <h4 class="m-b-0 ms-4 p-1 text-dark d-flex align-items-center"><i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>{{ __('strings.frontend.general.Search_course_select_program') }}</h4>
                                                                </div>
                                                            </a>
                                                        </div>
                                                        <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                                            <div class="accordion-body">                         
                                                                <div id="course-search" class="mt-3 mx-3">
                                                                    <form method="post" class="pref_form row" action="{{route('frontend.user.studyabroad.coursepreference.save')}}">
                                                                        @csrf
                                                                        <input type="hidden" name="user_id" value="{{$logged_in_user->id}}">
                                                                        <div class="col-md-4 form-group">
                                                                            <label for="country" class="required-field">{{ __('labels.frontend.user.profile.country') }}</label>
                                                                            <select class="form-control form-select" style="width:100%;" id="country" name="country" required>
                                                                                <option value="">{{ __('labels.frontend.user.profile.country') }}</option>
                                                                                @foreach($countries as $country)
                                                                                <option @if(old('country')==$country->id) selected @endif value="{{$country->id}}">{{$country->name}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-8 form-group">
                                                                            <label for="university-select" class="required-field">{{ __('labels.frontend.user.profile.university') }}</label>
                                                                            <select name="university" id="university-select" style="width:100%;" placeholder="university" class='form-control form-select ' type="text">
                                                                                <option value="">{{ __('labels.frontend.user.profile.select') }} {{ __('labels.frontend.user.profile.university') }}</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-8 form-group">
                                                                            <label for="course-select" class="required-field">{{ __('labels.frontend.user.profile.course') }}</label>
                                                                            <select name="course" id="course-select" style="width:100%" placeholder="Course" class='form-control form-select' type="text" required>
                                                                                <option value="">{{ __('labels.frontend.user.profile.select') }} {{ __('labels.frontend.user.profile.course') }}</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-4 form-group">
                                                                            <label for="intake" class="required-field">{{ __('strings.frontend.general.intake') }}</label>
                                                                            <select name="intake" style="width:100%;" class="form-select form-control " required>
                                                                                <option value="">{{ __('strings.frontend.general.intake') }}</option>
                                                                                <?php $month = date('n'); // current month
                                                                                for ($x = 0; $x < 24; $x++) { ?>
                                                                                <option value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                                                                                <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                                                                                <?php } ?></option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-sm-3 mx-auto" style="padding-top:30px">
                                                                            <button type="submit" class=" btn addBtn btn-themecolor "><i class="fa fa-plus-circle"></i>&nbsp;{{ __('strings.frontend.general.add_program') }}</button>
                                                                        </div>
                                                                    </form>
                                                                </div>                                        
                                                            </div>
                                                        </div>
                                                        {{-- Second Section --}}
                                                        <div class="container w-100" id="collapseTwoTitle" style="margin-bottom:0;margin-top:30px;">
                                                            <a class="collapsed" href="#collapseTwo" data-toggle="collapse" aria-expanded="false" aria-controls="collapseTwo">
                                                                <div class="text-start text-white fs-20 rounded"  style="background-color: #E0E4FA; border-color: rgb(235,235,235); margin: -5px -15px 0px;">
                                                                    <h4 class="m-b-0 ms-4 p-1 text-dark d-flex align-items-center"><i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>{{ __('strings.frontend.general.manually_add_program') }}</h4>          </div>
                                                            </a>
                                                        </div>
                                                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                                            <div class="accordion-body">
                                                                <div id="course-search" class="mx-3">
                                                                    <form method="post" class="pref_form row mt-3" action="{{route('frontend.user.studyabroad.coursepreference.save')}}">
                                                                        @csrf
                                                                        <input type="hidden" name="user_id" value="{{$logged_in_user->id}}">
                                                                        <div class="col-md-4 form-group">
                                                                            <label for="manually-country" class="required-field">{{ __('labels.frontend.user.profile.country') }}</label>
                                                                            <select class="form-control form-select" id="manually-country" name="country" required>
                                                                                <option value="">{{ __('labels.frontend.user.profile.country') }}</option>
                                                                                @foreach($countries as $country)
                                                                                <option @if(old('country')==$country->id) selected @endif value="{{$country->id}}">{{$country->name}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-8 form-group">
                                                                            <label for="university" class="required-field">{{ __('labels.frontend.user.profile.university') }}</label>
                                                                            <input type="text" name="university" id="university" placeholder="{{ __('labels.frontend.user.profile.university') }}" class='form-control'>
                                                                        </div>
                                                                        <div class="col-md-8 form-group">
                                                                            <label for="course" class="required-field">{{ __('labels.frontend.user.profile.course') }}</label>
                                                                            <input type="text" name="course" id="course" placeholder="{{ __('labels.frontend.user.profile.course') }}" class='form-control'>
                                                                        </div>
                                                                        <div class="col-md-4 form-group">
                                                                            <label for="intake" id="manually-intake" class="required-field">{{ __('strings.frontend.general.intake') }}</label>
                                                                            <select name="intake" class="form-select form-control" id="manually-intake" required>
                                                                                <option value="">{{ __('strings.frontend.general.intake') }}</option>
                                                                                <?php $month = date('n'); // current month
                                                                                for ($x = 0; $x < 24; $x++) { ?>
                                                                                <option value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                                                                                <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                                                                                <?php } ?></option>
                                                                            </select>
                                                                        </div>
                                                                        
                                                                        <div class="col-sm-3 mx-auto" style="padding-top:30px">
                                                                            <button type="submit" class=" btn  addBtn btn-themecolor"><i class="fa fa-plus-circle"></i>&nbsp;{{ __('strings.frontend.general.add_program') }}</button>
                                                                        </div>

                                                                    </form>
                                                                </div> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                @endif
                                                {{-- <hr> --}}
                                                <div class="row mx-1">
                                                    <div class="text-start text-white fs-20 card-header bg-theme p-2 ps-4" style="">
                                                        {{ __('strings.frontend.general.selected_programs') }}
                                                    </div>
                                            
                                                @if($logged_in_user->coursepreferences)
                                                @foreach($logged_in_user->coursepreferences as $coursepreference)
                                                    @if($loop->first)
                                                        <div class="card">
                                                    @else
                                                        <div class="" style="margin-top: -15px;">
                                                    @endif

                                                    <div class="card-body rounded-0 py-0">
                                                        <div class="row  border-bottom p-2 ">
                                                            <div class="col-md-4 my-auto">
                                                                <i class="mdi mdi-earth text-themecolor"></i> &nbsp; {{ get_country_name($coursepreference['country_id']) }} <br>
                                                            </div>
                                                            <div class="col-md-8 pt-3">
                                                                <?php $course_url = url('course-finder/course-details/')."/".$coursepreference['course_id'];
                                                                    $uni_url = url('course-finder/university-details/')."/".$coursepreference['university_id'];
                                                                ?>
                                                                {{-- {!! ($coursepreference['course_id']) ? "<a class='text-primary' target='_blank' href='$course_url'><h4 class='text-primary'>".get_university_course_data($coursepreference['course_id'])->course_name."</h4></a>" : "<h4>".$coursepreference['course_other']."</h4>" !!} --}}
                                                                @if($coursepreference['course_id'])
                                                                    @if(get_university_course_data($coursepreference['course_id']))
                                                                        <a class='text-primary' target='_blank' href='{{$course_url}}'><h4 class='text-primary'>{{get_university_course_data($coursepreference['course_id'])->course_name}}</h4></a>
                                                                        {{-- ID: <span class="d-inline-block mb-2">{{$coursepreference['course_id']}}</span><br> --}}
                                                                    @else
                                                                        -- <br>
                                                                    @endif
                                                                @else
                                                                    <h4>{{$coursepreference['course_other']}}</h4>
                                                                @endif
                                                                <i class="fa fa-university text-themecolor"></i> &nbsp; {!! ($coursepreference['university_id'] && get_university_data($coursepreference['university_id'])) ? "<a class='text-primary' target='_blank' href='$uni_url'>".get_university_data($coursepreference['university_id'])->university_name."</a>" : $coursepreference['university_other'] !!} <br>
                                                                <i class="fa fa-calendar text-themecolor"></i> &nbsp;&nbsp;&nbsp;Intake: @if($coursepreference['intake_year'] && $coursepreference['intake']) {{ $coursepreference['intake'] }} {{$coursepreference['intake_year']}} @elseif($coursepreference['intake_year']) {{$coursepreference['intake_year']}} @elseif($coursepreference['intake']) {{ $coursepreference['intake'] }} @else -- @endif <br><br>
                                                                <p class="text-muted" style="font-style: italic">{{ __('strings.frontend.general.added_by') }} 
                                                                    @if($coursepreference['created_by']) 
                                                                        @if($coursepreference['created_by'] == $logged_in_user->id)
                                                                            You on {{date("d M Y", strtotime($coursepreference['created_at']))}}
                                                                        @else
                                                                            {{get_user_full_name_by_id($coursepreference['created_by'])}} on {{date("d M Y", strtotime($coursepreference['created_at']))}}
                                                                        @endif
                                                                    @else -- 
                                                                    @endif 
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                                @else
                                                <p class="p-2">No programs found!</p>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="text-center py-4" style="margin-left: auto; width: 150px; ">
                                            <button id="documentNext"  class="btn btn-success text-white " style="">{{ __('labels.frontend.user.profile.next') }} >></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('after-styles')
    <style>
       
            .form-select,.form-control{
            box-shadow: none !important;
        }
        
        .input-box-inner-style {
            padding: 7px 10px !important;
        }

        .responsive-set-margin{
            margin: 0px -41px;
        }
        
        .responsive-set-margin-blocks{
            margin: -20px -41px;
        }

        .tab{
            background-color: #E0E4FA !important; 
            padding: 6px 36px !important; 
        }

        .tab-heading{
            font-size: 18px;
        }
        
        @media (max-width: 769px) {
            .sub-card{
                margin: 10px -25px;
            }
        }

        @media (max-width: 810px) {
            .tab{
                background-color: #E0E4FA !important; 
                padding: 0px 10px !important; 
            }
            .tab-heading{
                font-size: 14px;
            }
        }
    </style>
@endpush

@push('after-scripts')
<script>
    $(document).ready(function() {

        $('#documentNext').click(function(){
            let course = @json($logged_in_user->profile_complete);
            if(course == "course"){
                window.location.href = "{{route('frontend.user.studyabroad.documents')}}";
            }else{
                alert("{{ __('labels.frontend.user.profile.update_study_level_and_course_preferences') }}");
            }
        });

        var s_level = $('#overseas_study_level').find(":selected").val();

        $('#collapseOneTitle').on('click', function() {
            $('#collapseTwo').removeClass("show");
        });
        $('#collapseTwoTitle').on('click', function() {
            $('#collapseOne').removeClass("show");
        });

        $('#overseas_study_level').on('change', function() {
            s_level = $('#overseas_study_level').find(":selected").val();
        });
        

        $('#courseSelect').select2({
        minimumInputLength: 3,
        tags: true,
        placeholder: "Course*",
        selectOnClose: true,
        ajax: {
            url: '{{ route("frontend.searchCourse") }}',
            type: "POST",
            dataType: 'json',
            data: function(params) {
                return {
                    s_level: s_level,
                    q: params.term, // search term
                    _token: '{{csrf_token()}}'
                };
            },
        },
    });

    $('#universitySelect').select2({
        minimumInputLength: 3,
        placeholder: "University",
        selectOnClose: true,
        ajax: {
            url: '{{ route("frontend.searchUniversity") }}',
            type: "POST",
            dataType: 'json',
            data: function(params) {
                return {
                    q: params.term, // search term
                    _token: '{{csrf_token()}}'
                };
            },
        },
    });
    $('#universitySelect').select2({
            minimumInputLength: 3,
            tags: true,
            placeholder: "University",
            selectOnClose: true,
            ajax: {
                url: '{{ route("frontend.searchUniversity") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });
    });

    $('#country').on('change', function () {
            var idCountry = this.value;
            $("#university-select").html('');
            $.ajax({
                url: "{{url('api/fetch-university')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#university-select').html('<option value="">Select University</option>');
                    $.each(result.university, function (key, value) {
                       if(value.id == "{{old('university')}}"){
                            var selectedUniversity = "selected=\"'selected'\"";
                       }
                       else{
                            var selectedUniversity = "";
                       }
                        $("#university-select").append('<option '+selectedUniversity+' value="'+ value.id + '">' + value.university_name + '</option>');
                    });
                }
            });
        });

        $('#university-select').on('change', function () {
            var idUniversity = this.value;
            var s_level = "{{$logged_in_user->overseas_study_level_selection}}";
            $("#course-select").html('');
            $.ajax({
                url: "{{url('api/fetch-course')}}",
                type: "POST",
                data: {
                    university_id: idUniversity,
                    s_level: s_level,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#course-select').html('<option value="">Select Course</option>');
                    $.each(result.course, function (key, value) {
                       if(value.id == "{{old('course')}}"){
                            var selectedCourse = "selected=\"'selected'\"";
                       }
                       else{
                            var selectedCourse = "";
                       }
                        $("#course-select").append('<option '+selectedCourse+' value="'+ value.id + '">' + value.course_name + '</option>');
                    });
                }
            });
        });
</script>

@endpush