@extends('frontend.layouts.app')
@section('title')
    {{ __('strings.frontend.general.apply_for_study_abroad') }}
@endsection

<?php
$docs_conf = get_student_doc_configs();
$my_study_level = get_my_study_level($logged_in_user);

$maxfilesize = config('app.doc_single_max_size') * 1024 * 1024;
$max_sop_files = config('app.max_sop_files');
$max_pass_files = config('app.max_pass_files');
$max_lor_files = config('app.max_lor_files');
$max_experience_files = config('app.max_experience_files');
$max_other_files = config('app.max_other_files');

$pass_files_left = $max_pass_files - get_pass_count(\Auth::user()->id);
$lor_files_left = $max_lor_files - get_lor_count(\Auth::user()->id);
$exp_files_left = $max_experience_files - get_exp_count(\Auth::user()->id);
$other_files_left = $max_other_files - get_other_count(\Auth::user()->id);
?>

@section('content')
    <div class="row page-titles p-4 pb-0 wrapper" >
        <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">{{ __('strings.frontend.general.apply_for_study_abroad') }}</h3>
        </div>
    </div>

    <div class="container-fluid"  style="padding-top:20px; margin-bottom: 20px;">
        @include('includes.partials.messages')

        <ul class="nav nav-tabs customtab2" role="tablist">
            <li class="nav-item"> <a class="nav-link border tab" href="{{ route('frontend.user.studyabroad.profile') }}" role="tab"><span class="hidden-sm-up"><i class="ti-user"></i></span> <span class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.profile') }}</span></a> </li>&nbsp;
            <li class="nav-item"> <a class="nav-link border tab" href="{{ route('frontend.user.studyabroad.coursepreference') }}" role="tab"><span class="hidden-sm-up"><i class="ti-book"></i></span> <span class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.course_preferences') }}</span></a>
            </li> &nbsp;
            <li class="nav-item"> <a class="nav-link border active tab" href="{{ route('frontend.user.studyabroad.documents') }}" role="tab"><span class="hidden-sm-up"><i class="ti-folder"></i></span> <span class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.documents') }}</span></a> </li>
        </ul>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content" style="margin: -30px -30px 0px -30px !important;">
                            <div class="tab-pane active" id="docs" role="tabpanel">
                                <div class="p-t-20">
                                    @if (!$logged_in_user->overseas_study_level)
                                        <div class="alert alert-danger" role="alert">
                                            {{ __('strings.frontend.general.must_update_study_level') }}
                                        </div>
                                    @else
                                        @if ($coursepref_pending)
                                            <div class="alert alert-danger" role="alert">
                                                {{ __('strings.frontend.general.must_complete_profile') }}
                                            </div>
                                        @endif
                                        
                                        
                                        <h3 class="mt-2">{{ __('strings.frontend.general.academic_certificates_and_document') }}</h3>
                                        
                                        <p class="text-danger">{{ __('strings.frontend.general.file_size') }}
                                            {{ config('app.doc_single_max_size') }} MB.</p>


                                        <div class="row mt-4 px-2">
                                            @if ($docs_conf[$my_study_level]['class10']['certificate']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">

                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4 "
                                                        style="">
                                                     {{ _label('class_10_certificate') }}
                                                    </div>
                                                    <div class="card card-outline-info col-md-12">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($class10)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $class10); ?>"
                                                                                target="_blank"><?php echo substr($class10, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="class10" id="file_tenth"
                                                                            class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['class10']['certificate']['mandatory'] && !$class10)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
    
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
    
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['class10']['marks_sheet']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start mt-4 text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{ _label('class_10_marks_sheet') }}
                                                    </div>
                                                
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($class10_marks_sheet)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $class10_marks_sheet); ?>"
                                                                                target="_blank"><?php echo substr($class10_marks_sheet, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="class10_marks_sheet"
                                                                            id="file_tenthMarkSheet"
                                                                            class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['class10']['marks_sheet']['mandatory'] && !$class10_marks_sheet)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
    
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
    
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['class12']['certificate']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{ _label('class_12_certificate') }}
                                                    </div>
                                                
    
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($class12)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $class12); ?>"
                                                                                target="_blank"><?php echo substr($class12, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="class12"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['class12']['certificate']['mandatory'] && !$class12)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
    
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['class12']['marks_sheet']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{ _label('class_12_marks_sheet') }}
                                                    </div>
                                               
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($class12_marks_sheet)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $class12_marks_sheet); ?>"
                                                                                target="_blank"><?php echo substr($class12_marks_sheet, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
    
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="class12_marks_sheet"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['class12']['marks_sheet']['mandatory'] && !$class12_marks_sheet)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['diploma']['certificate']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{ _label('diploma_certificate') }}
                                                    </div>
                                                
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($diploma)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $diploma); ?>"
                                                                                target="_blank"><?php echo substr($diploma, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
    
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="diploma"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['diploma']['marks_sheet']['mandatory'] && !$diploma)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['diploma']['marks_sheet']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{ _label('diploma_marks_sheet') }}
                                                    </div>
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($diploma_marks_sheet)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $diploma_marks_sheet); ?>"
                                                                                target="_blank"><?php echo substr($diploma_marks_sheet, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="diploma_marks_sheet"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['diploma']['marks_sheet']['mandatory'] && !$diploma_marks_sheet)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif


                                            @if ($docs_conf[$my_study_level]['degree']['certificate']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{ _label('bachelors_certificate') }}
                                                    </div>
                                                    <div class="card card-outline-info col-md-12">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($grad_degree)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $grad_degree); ?>"
                                                                                target="_blank"><?php echo substr($grad_degree, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="grad_degree"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['degree']['certificate']['mandatory'] && !$grad_degree)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['degree']['marks_sheet']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{-- Bachelors Marks Sheet/Transcripts --}}
                                                        {{ _label('bachelors_marks_sheet') }}
                                                    </div>
                                                    <div class="card card-outline-info col-md-12">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($grad_transcripts)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $grad_transcripts); ?>"
                                                                                target="_blank"><?php echo substr($grad_transcripts, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="grad_transcripts"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['degree']['marks_sheet']['mandatory'] && !$grad_transcripts)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['degree']['provisional']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{-- Bachelors Provisional Certificate --}}
                                                        {{ _label('bachelors_provisional_certificate') }}
                                                    </div>
                                                
    
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($grad_provisional)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $grad_provisional); ?>"
                                                                                target="_blank"><?php echo substr($grad_provisional, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="grad_provisional"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['degree']['provisional']['mandatory'] && !$grad_provisional)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif


                                            @if ($docs_conf[$my_study_level]['degree']['all_sem']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{-- Bachelors All Semesters Marks Sheets (Single PDF) --}}
                                                        {{ _label('bachelors_marks_sheets_all_semesters') }}
                                                    </div>
                                                
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($grad_all_sem)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $grad_all_sem); ?>"
                                                                                target="_blank"><?php echo substr($grad_all_sem, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="grad_all_sem"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg"> 
                                                                        <span class="text-danger input-err"></span>
                                                                        <span>{{ __('strings.frontend.general.merged_file_size') }}
                                                                            {{ config('app.doc_allsem_max_size') }} MB.</span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['degree']['all_sem']['mandatory'] && !$grad_all_sem)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['pg_degree']['certificate']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{-- Masters Certificate --}}
                                                        {{ _label('masters_certificate') }}
                                                    </div>
                                                
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($pg_degree)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $pg_degree); ?>"
                                                                                target="_blank"><?php echo substr($pg_degree, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="pg_degree"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['pg_degree']['certificate']['mandatory'] && !$pg_degree)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['pg_degree']['marks_sheet']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{-- Masters Marks Sheet/Transcripts --}}
                                                        {{ _label('masters_marks_sheet') }}
                                                    </div>
                                                
                                                    <div class="card card-outline-info col-md-12">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($pg_transcripts)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $pg_transcripts); ?>"
                                                                                target="_blank"><?php echo substr($pg_transcripts, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="pg_transcripts"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['pg_degree']['marks_sheet']['mandatory'] && !$pg_transcripts)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif


                                            @if ($docs_conf[$my_study_level]['pg_degree']['provisional']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{-- Masters Provisional Certificate --}}
                                                        {{ _label('masters_provisional_certificate') }}
                                                    </div>
                                                
                                                    <div class="card card-outline-info col-md-12">
    
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($pg_provisional)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $pg_provisional); ?>"
                                                                                target="_blank"><?php echo substr($pg_provisional, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="pg_provisional"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['pg_degree']['provisional']['mandatory'] && !$pg_provisional)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if ($docs_conf[$my_study_level]['pg_degree']['all_sem']['enable'])
                                            <div class="col-12">
                                                <div class="row mt-4">
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{-- Masters All Semesters Marks Sheet/Transcripts (Single PDF) --}}
                                                        {{ _label('masters_marks_sheets_all_semesters') }}
                                                    </div>
                                                
                                                    <div class="card card-outline-info col-md-12">

                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-12 col-md-12 p-b-20 doc-upload-card">
                                                                    @if ($pg_all_sem)
                                                                        <div>{{ __('strings.frontend.general.uploaded_file') }}
                                                                            <a class="" href="<?php echo url('storage/' . $pg_all_sem); ?>"
                                                                                target="_blank"><?php echo substr($pg_all_sem, 5); ?></a>
                                                                        </div>
                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                    @endif
                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input type="file" name="pg_all_sem"
                                                                            id="input-file-now" class="form-control file_edu"
                                                                            accept=".pdf, .jpeg, .jpg">
                                                                        <span class="text-danger input-err"></span>
                                                                        <span>{{ __('strings.frontend.general.merged_file_size') }}
                                                                            {{ config('app.doc_allsem_max_size') }} MB.</span>
                                                                    </form>
                                                                    @if ($docs_conf[$my_study_level]['pg_degree']['all_sem']['mandatory'] && !$pg_all_sem)
                                                                        <span class="text-danger"
                                                                            style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                    @endif
                                                                    <span
                                                                        style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                        id="tenth_marksheet_loading"
                                                                        class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif


                                            {{-- //Additional docs One --}}
                                            @if (count($additional_docs_one) > 0)
                                                @foreach ($additional_docs_one as $adc)
                                                <div class="col-12">
                                                    <div class="row mt-4">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                            style="">
                                                            {{ $adc->title }}
                                                        </div>
                                                        <div class="card card-outline-info col-md-12">
    
                                                            <div class="card-body">
                                                                <div class="row p-t-10">
                                                                    <div class="col-12 doc-upload-card">
                                                                        @if (count(get_additional_docs(\Auth::user()->id, $adc->doc_type)))
                                                                            {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                            @foreach (get_additional_docs(\Auth::user()->id, $adc->doc_type) as $docs)
                                                                                <a class="" href="<?php echo url('storage/' . $docs->file); ?>"
                                                                                    target="_blank"><?php echo substr($docs->file, 5); ?></a>
                                                                                <a title="delete document"
                                                                                    data-additional_id="{{ $docs->id }}"
                                                                                    href="javascript:void(0)"
                                                                                    class="ml-1 del-additional-btn"><i class="fa-solid fa-trash-can" style="color: #d52032; font-size: 12px;"></i></a>
                                                                                <br>
                                                                            @endforeach
                                                                        @endif
    
                                                                        <form action="" method="post"
                                                                            enctype="multipart/form-data">
                                                                            <input class="form-control" type="file"
                                                                                id="{{ $adc->doc_type }}"
                                                                                name="{{ $adc->doc_type }}{{ $adc->file_count > 1 ? '[]' : '' }}"
                                                                                {{ $adc->file_count > 1 ? 'multiple' : '' }}
                                                                                accept="{{ $adc->file_types }}">
                                                                        </form>
                                                                        <span style="display:none;"
                                                                            id="{{ $adc->doc_type }}_loading"
                                                                            class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                        <span id="{{ $adc->doc_type }}-file-input-error"
                                                                            class="text-danger"></span>
    
                                                                        <p class="card-subtitle mt-2 mb-0 text-dark">{{ __('labels.frontend.user.profile.allowed_file_types') }}: {{ $adc->file_types }}</p>
                                                                        @if ($adc->file_count > 1)
                                                                            <small>{{ __('strings.frontend.general.maximum') }}
                                                                                <?= $adc->file_count ?> files.</small>
                                                                        @endif
                                                                        @if ($adc->doc_notes)
                                                                            <small>Notes: {{ $adc->doc_notes }}</small><br>
                                                                        @endif
                                                                    </div>
                                                                </div>
    
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            @endif
                                            {{-- //Additional docs One --}}

                                        </div>

                                        <h3 class="mt-4">
                                            {{ __('strings.frontend.general.tests_or_english_certificates') }}</h3>
                                        <h6 class="card-subtitle mb-2">
                                            {{ __('strings.frontend.general.upload_applicable_certificates') }} <i class="fa-solid fa-file"></i>
                                        </h6>
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                    style="">
                                                    IELTS
                                                </div>
                                                <div class="card card-outline-info">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-sm-12 col-md-12 p-b-20" style="margin: -20px -25px;">
                                                                @if ($lang_ielts)
                                                                    <div>
                                                                        {{ __('strings.frontend.general.uploaded_file') }}
                                                                        <a class="" href="<?php echo url('storage/' . $lang_ielts); ?>"
                                                                            target="_blank"><?php echo substr($lang_ielts, 5); ?></a>
                                                                    </div>
                                                                    <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                @endif
                                                                <form action="" method="post"
                                                                    enctype="multipart/form-data">
                                                                    <input type="file" name="lang_ielts"
                                                                        id="input-file-now" class="form-control file_edu"
                                                                        accept=".pdf, .jpeg, .jpg">
                                                                    <span class="text-danger input-err"></span>
                                                                </form>
                                                                <span
                                                                    style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                    id="tenth_marksheet_loading"
                                                                    class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                    style="">
                                                    PTE
                                                </div>
                                                <div class="card card-outline-info">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-sm-12 col-md-12 p-b-20" style="margin: -20px -25px;">
                                                                @if ($lang_pte)
                                                                    <div>
                                                                        {{ __('strings.frontend.general.uploaded_file') }}
                                                                        <a class="" href="<?php echo url('storage/' . $lang_pte); ?>"
                                                                            target="_blank"><?php echo substr($lang_pte, 5); ?></a>
                                                                    </div>
                                                                    <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                @endif
                                                                <form action="" method="post"
                                                                    enctype="multipart/form-data">
                                                                    <input type="file" name="lang_pte"
                                                                        id="input-file-now" class="form-control file_edu"
                                                                        accept=".pdf, .jpeg, .jpg">
                                                                    <span class="text-danger input-err"></span>
                                                                </form>
                                                                <span
                                                                    style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                    id="tenth_marksheet_loading"
                                                                    class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b>
                                                                </span>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-4">
                                            <div class="col-md-6">
                                                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                    style="">
                                                    GRE
                                                </div>

                                                <div class="card card-outline-info">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-sm-12 col-md-12 p-b-20" style="margin: -20px -25px;">
                                                                @if ($gre)
                                                                    <div>
                                                                        {{ __('strings.frontend.general.uploaded_file') }}
                                                                        <a class="" href="<?php echo url('storage/' . $gre); ?>"
                                                                            target="_blank"><?php echo substr($gre, 5); ?></a>
                                                                    </div>
                                                                    <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                @endif
                                                                <form action="" method="post"
                                                                    enctype="multipart/form-data">
                                                                    <input type="file" name="gre"
                                                                        id="input-file-now" class="form-control file_edu"
                                                                        accept=".pdf, .jpeg, .jpg">
                                                                    <span class="text-danger input-err"></span>
                                                                </form>
                                                                <span
                                                                    style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                    id="tenth_marksheet_loading"
                                                                    class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                    style="">
                                                    GMAT
                                                </div>
                                                <div class="card card-outline-info">

                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-sm-12 col-md-12 p-b-20" style="margin: -20px -25px;">
                                                                @if ($gmat)
                                                                    <div>
                                                                        {{ __('strings.frontend.general.uploaded_file') }}
                                                                        <a class="" href="<?php echo url('storage/' . $gmat); ?>"
                                                                            target="_blank"><?php echo substr($gmat, 5); ?></a>
                                                                    </div>
                                                                    <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                @endif
                                                                <form action="" method="post"
                                                                    enctype="multipart/form-data">
                                                                    <input type="file" name="gmat"
                                                                        id="input-file-now" class="form-control file_edu"
                                                                        accept=".pdf, .jpeg, .jpg">
                                                                    <span class="text-danger input-err"></span>
                                                                </form>
                                                                <span
                                                                    style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                    id="tenth_marksheet_loading"
                                                                    class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-4">
                                            <div class="col-md-6">
                                                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                    style="">
                                                    TOEFL
                                                </div>
                                                <div class="card card-outline-info">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-sm-12 col-md-12 p-b-20" style="margin: -20px -25px;">
                                                                @if ($toefl)
                                                                    <div>
                                                                        {{ __('strings.frontend.general.uploaded_file') }}
                                                                        <a class="" href="<?php echo url('storage/' . $toefl); ?>"
                                                                            target="_blank"><?php echo substr($toefl, 5); ?></a>
                                                                    </div>
                                                                    <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                @endif
                                                                <form action="" method="post"
                                                                    enctype="multipart/form-data">
                                                                    <input type="file" name="toefl"
                                                                        id="input-file-now" class="form-control file_edu"
                                                                        accept=".pdf, .jpeg, .jpg">
                                                                    <span class="text-danger input-err"></span>
                                                                </form>
                                                                <span
                                                                    style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                    id="tenth_marksheet_loading"
                                                                    class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                    style="">
                                                    Duolingo
                                                </div>

                                                <div class="card card-outline-info">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-sm-12 col-md-12 p-b-20" style="margin: -20px -25px;">
                                                                @if ($duolingo)
                                                                    <div>
                                                                        {{ __('strings.frontend.general.uploaded_file') }}
                                                                        <a class="" href="<?php echo url('storage/' . $duolingo); ?>"
                                                                            target="_blank"><?php echo substr($duolingo, 5); ?></a>
                                                                    </div>
                                                                    <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                @endif
                                                                <form action="" method="post"
                                                                    enctype="multipart/form-data">
                                                                    <input type="file" name="duolingo"
                                                                        id="input-file-now" class="form-control file_edu"
                                                                        accept=".pdf, .jpeg, .jpg">
                                                                    <span class="text-danger input-err"></span>
                                                                </form>
                                                                <span
                                                                    style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                    id="tenth_marksheet_loading"
                                                                    class="text-success p-3 loding"><b>{{ __('strings.frontend.general.uploading') }}</b>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            {{-- //Additional docs Two --}}
                                            @if (count($additional_docs_two) > 0)
                                                @foreach ($additional_docs_two as $adc)
                                                    <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                        style="">
                                                        {{ $adc->title }}
                                                    </div>

                                                    <div class="card card-outline-info col-md-12">

                                                        <div class="card-body">
                                                            <div class="row p-t-10">
                                                                <div class="col-12 doc-upload-card">
                                                                    @if (count(get_additional_docs(\Auth::user()->id, $adc->doc_type)))
                                                                        {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                        @foreach (get_additional_docs(\Auth::user()->id, $adc->doc_type) as $docs)
                                                                            <a class="" href="<?php echo url('storage/' . $docs->file); ?>"
                                                                                target="_blank"><?php echo substr($docs->file, 5); ?></a>
                                                                            <a title="delete document"
                                                                                data-additional_id="{{ $docs->id }}"
                                                                                href="javascript:void(0)"
                                                                                class="ml-1 del-additional-btn"><i class="fa-solid fa-trash-can" style="color: #d52032; font-size: 12px;"></i></a>
                                                                            <br>
                                                                        @endforeach
                                                                    @endif

                                                                    <form action="" method="post"
                                                                        enctype="multipart/form-data">
                                                                        <input class="form-control" type="file"
                                                                            id="{{ $adc->doc_type }}"
                                                                            name="{{ $adc->doc_type }}{{ $adc->file_count > 1 ? '[]' : '' }}"
                                                                            {{ $adc->file_count > 1 ? 'multiple' : '' }}
                                                                            accept="{{ $adc->file_types }}">
                                                                    </form>
                                                                    <span style="display:none;"
                                                                        id="{{ $adc->doc_type }}_loading"
                                                                        class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                    <span id="{{ $adc->doc_type }}-file-input-error"
                                                                        class="text-danger"></span>

                                                                    <p class="card-subtitle mt-2 mb-0 text-dark">
                                                                        {{ __('labels.frontend.user.profile.allowed_file_types') }}: {{ $adc->file_types }}</p>
                                                                    @if ($adc->file_count > 1)
                                                                        <small>{{ __('strings.frontend.general.maximum') }}
                                                                            <?= $adc->file_count ?> files.</small>
                                                                    @endif
                                                                    @if ($adc->doc_notes)
                                                                        <small>Notes: {{ $adc->doc_notes }}</small><br>
                                                                    @endif
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                            {{-- //Additional docs Two --}}
                                        </div>

                                        <div class="col-12">
                                            <div class="row mx-0 mt-4">

                                                @if ($docs_conf[$my_study_level]['passport']['enable'])
                                                <h3 class="mx-0 ps-0">{{ __('strings.frontend.general.other_certificates') }}</h3>
                                                <div class="col-12">
                                                    <div class="row">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                            style="">
                                                            {{ __('labels.frontend.user.profile.passport') }}
                                                        </div>
    
    
                                                        <div class="card card-outline-info col-md-12">
                                                            <div class="card-body">
                                                                @if (count($passports) > 0)
                                                                    <div class="row">
                                                                        <div class="col-12 doc-other-upload-card">
                                                                            {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                            @foreach ($passports as $passport)
                                                                                <a class="" href="<?php echo url('storage/' . $passport->file); ?>"
                                                                                    target="_blank"><?php echo substr($passport->file, 5); ?></a>
                                                                                <a title="delete document"
                                                                                    data-pass="{{ $passport->id }}"
                                                                                    href="javascript:void(0)"
                                                                                    class="cross del-pass-btn ml-1"></a>
                                                                                <br>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                <div class="row">
                                                                    <div class="col-12 doc-other-upload-card">
                                                                        <form action="" method="post"
                                                                            enctype="multipart/form-data">
                                                                            <input class="form-control" id="file_passport"
                                                                                accept=".pdf, .jpeg, .jpg" type="file"
                                                                                name="file[]" multiple>
                                                                            <span class="text-danger input-err"></span>
                                                                        </form>
                                                                        @if ($docs_conf[$my_study_level]['passport']['mandatory'])
                                                                            <span
                                                                                class="text-danger">{{ __('strings.frontend.general.required') }}</span>
                                                                        @endif
                                                                        <span
                                                                            style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                            id="passport_loading"
                                                                            class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                        <span id="pass-file-input-error"
                                                                            class="text-danger"></span>
                                                                    </div>
                                                                    <div class="col-12 d-flex align-items-center doc-other-upload-card">
                                                                        <i class="fa-solid fa-file"></i>
                                                                        <small class="p-2">{{ __('strings.frontend.general.maximum') }}
                                                                            <?= $max_lor_files ?> files.</small>
                                                                    </div>
                                                                </div>
        
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                @endif
    
                                                @if ($docs_conf[$my_study_level]['cv']['enable'])
                                                <div class="col-12">
                                                    <div class="row mt-4">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                            style="">
                                                            CV
                                                        </div>

                                                        <div class="card card-outline-info m-t-10 col-md-12">
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-12">
                                                                        @if (get_site_config('sample_cv'))
                                                                            <a class="btn btn-secondary btn-xs"
                                                                                href="{{ url('storage/' . get_site_config('sample_cv')) }}"
                                                                                target="_blank">{{ __('strings.frontend.general.download_sample_cv') }}
                                                                                <i class="fa fa-download"></i></a><br>
                                                                        @endif
                                                                        <br />
                                                                        @if ($cv)
                                                                            <div>
                                                                                {{ __('strings.frontend.general.uploaded_file') }}
                                                                                <a class="" href="<?php echo url('storage/' . $cv); ?>"
                                                                                    target="_blank"><?php echo substr($cv, 5); ?></a>
                                                                            </div>
                                                                            <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                        @endif
                                                                    </div>
                                                                    <div class="col-6">
                                                                        <form action="" method="post"
                                                                            enctype="multipart/form-data">
                                                                            <input class="form-control" id="file_cv"
                                                                                accept=".doc,.docx,.pdf" type="file"
                                                                                name="file">
                                                                            <span class="text-danger input-err"></span>
                                                                        </form>
                                                                        @if ($docs_conf[$my_study_level]['cv']['mandatory'] && !$cv)
                                                                            <span class="text-danger"
                                                                                style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                        @endif
                                                                        <span
                                                                            style="display:none;font-weight: 700;padding-left:0px!important;"
                                                                            id="cv_loading"
                                                                            class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                        <span id="cv-file-input-error" class="text-danger"></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
    
                                                @if ($docs_conf[$my_study_level]['lor']['enable'])
                                                <div class="col-12">
                                                    <div class="row mt-4">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                                style="">
                                                                Letter of Recommendation (LOR)
                                                            </div>
                                                        
                                                            <div class="card card-outline-info col-md-12">
                                                               
                                                                <div class="card-body">
                                                                    @if (get_site_config('sample_professional_lor'))
                                                                        {{-- <label>If you want to know how to write an LOR Professional, download the sample file. --}}
                                                                        <a class="btn btn-secondary btn-xs"
                                                                            href="{{ url('storage/' . get_site_config('sample_professional_lor')) }}"
                                                                            target="_blank">Download Sample LOR Professional <i
                                                                                class="fa fa-download"></i></a>
                                                                    @endif
                                                                    @if (get_site_config('sample_academic_lor'))
                                                                        {{-- <label>If you want to know how to write an LOR Academic, download the sample file. --}}
                                                                        <a class="btn btn-secondary btn-xs"
                                                                            href="{{ url('storage/' . get_site_config('sample_academic_lor')) }}"
                                                                            target="_blank">Download Sample LOR Academic <i
                                                                                class="fa fa-download"></i></a>
                                                                    @endif
                                                                    @if (count($lors) > 0)
                                                                        <div class="row mt-5">
                                                                            <div class="col-12">
                                                                                {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                                <span id="ref_lor">
                                                                                    @foreach ($lors as $lor)
                                                                                        <a class="" href="<?php echo url('storage/' . $lor->file); ?>"
                                                                                            target="_blank"><?php echo substr($lor->file, 5); ?></a>
                                                                                        <a title="delete document"
                                                                                            data-lor="{{ $lor->id }}"
                                                                                            href="javascript:void(0)"
                                                                                            class="del-lor-btn ml-1"><i class="fa-solid fa-trash-can" style="color: #d52032; font-size: 12px;"></i></a>
                                                                                        <br>
                                                                                    @endforeach
                                                                                </span>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    <div class="row">
                                                                        <div class="col-12">
                                                                            <form action="" method="post"
                                                                                enctype="multipart/form-data">
                                                                                <input type="file" id="file_lor"
                                                                                    class="form-control" name="file_lor[]" multiple
                                                                                    accept="application/pdf">
                                                                            </form>
                                                                            @if ($docs_conf[$my_study_level]['lor']['mandatory'])
                                                                                <span
                                                                                    class="text-danger">{{ __('strings.frontend.general.required') }}</span>
                                                                            @endif
                                                                            <span style="display:none;" id="lor_loading"
                                                                                class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                            <span id="lor-file-input-error"
                                                                                class="text-danger"></span>
                                                                        </div>
                                                                        <div class="col-12 d-flex align-items-center">
                                                                            <i class="fa-solid fa-file"></i>
                                                                            <small class="p-2">{{ __('strings.frontend.general.maximum') }}
                                                                                <?= $max_lor_files ?> files.</small>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>    
                                                </div>    
                                                @endif
    
                                                @if ($docs_conf[$my_study_level]['sop']['enable'])
                                                <div class="col-12">
                                                    <div class="row mt-4">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                                style="">
                                                                SOP
                                                            </div>
                                                        
                                                        <div class="card card-outline-info col-md-12 m-t-30">
                                                            
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-12 table-responsive">
                                                                        @if (get_site_config('sample_sop'))
                                                                            <label>If you want to know how to write an SOP, download
                                                                                the
                                                                                sample SOP.
                                                                                <a class="btn btn-secondary btn-xs"
                                                                                    href="{{ url('storage/' . get_site_config('sample_sop')) }}"
                                                                                    target="_blank">Download Sample SOP <i
                                                                                        class="fa fa-download"></i></a>
                                                                        @endif
                                                                        <br />
                                                                        <table class="table table-bordered mt-4">
                                                                            <thead>
                                                                                <td><b>{{ __('labels.frontend.user.profile.course') }}</b>
                                                                                </td>
                                                                                <td><b>{{ __('labels.frontend.user.profile.university') }}</b>
                                                                                </td>
                                                                                <td><b>Upload
                                                                                        SOP</b><br /><small>{{ __('strings.frontend.general.upload_essay') }}
                                                                                        .docx,.doc</small> <i class="fa-solid fa-file"></i></td>
                                                                            </thead>
                                                                            <tbody>
                                                                                @if (count($course_pref) > 0)
                                                                                    @foreach ($course_pref as $cpf)
                                                                                        <tr>
                                                                                            {{-- <td>{{ ($cpf->course_id) ? get_university_course_data($cpf->course_id)->course_name : $cpf->course_other}}</td> --}}
                                                                                            <td>
                                                                                                @if ($cpf->course_id)
                                                                                                    @if (get_university_course_data($cpf->course_id))
                                                                                                        <h5 class=''>
                                                                                                            {{ get_university_course_data($cpf->course_id)->course_name }}
                                                                                                        </h5>
                                                                                                    @else
                                                                                                        -- <br>
                                                                                                    @endif
                                                                                                @else
                                                                                                    <h5>{{ $cpf->course_other }}
                                                                                                    </h5>
                                                                                                @endif
                                                                                            </td>
                                                                                            {{-- <td>{{($cpf->university_id) ? get_university_data($cpf->university_id)->university_name : '-'}}</td> --}}
                                                                                            <td>{{
                                                                                                    $cpf->university_id ? 
                                                                                                    get_university_data($cpf->university_id) ? get_university_data($cpf->university_id)->university_name : "" : 
                                                                                                    $cpf->university_other 
                                                                                                }}
                                                                                            </td>
                                                                                            <td style="width:40%;">
                                                                                                <span class="ref_sop">
                                                                                                    @if (get_lead_sop_list($cpf->id))
                                                                                                        {{ __('strings.frontend.general.uploaded_file') }}
                                                                                                        <a class=""
                                                                                                            href="<?php echo url('storage/' . get_lead_sop_list($cpf->id)->file); ?>"
                                                                                                            target="_blank"><?php echo substr(get_lead_sop_list($cpf->id)->file, 5); ?></a><br>
                                                                                                        <label>{{ __('strings.frontend.general.replace_file') }}</label>
                                                                                                    @endif
                                                                                                </span>
                                                                                                <form action=""
                                                                                                    method="post"
                                                                                                    enctype="multipart/form-data">
                                                                                                    <input type="hidden"
                                                                                                        class="input-group"
                                                                                                        value="{{ $cpf->id }}"
                                                                                                        name="course_pref_id">
                                                                                                    <input type="file"
                                                                                                        style=""
                                                                                                        class="form-control"
                                                                                                        id="file_sop{{ $cpf->id }}"
                                                                                                        accept=".doc,.docx"
                                                                                                        name="file_sop">
                                                                                                </form>
                                                                                                @if ($docs_conf[$my_study_level]['sop']['mandatory'] && !get_lead_sop_list($cpf->id))
                                                                                                    <span class="text-danger"
                                                                                                        style="font-size: 15px">{{ __('strings.frontend.general.required') }}</span>
                                                                                                @endif
                                                                                                <span style="display:none;"
                                                                                                    id="sop_loading"
                                                                                                    class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                                                <span id="sop-file-input-error"
                                                                                                    class="text-danger"></span>
                                                                                            </td>
                                                                                        </tr>
                                                                                    @endforeach
                                                                                @endif
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
    
    
                                                {{-- //essay --}}
                                                @if ($docs_conf[$my_study_level]['essay']['enable'])
                                                <div class="col-12">
                                                    <div class="row mt-4">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                                style="">
                                                                Essay
                                                            </div>
                                                        
                                                        <div class="card card-outline-info col-md-12 m-t-30">
                                                            
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-12 table-responsive">
                                                                        <table class="table table-bordered mt-4">
                                                                            <thead>
                                                                                <td><b>{{ __('labels.frontend.user.profile.course') }}</b>
                                                                                </td>
                                                                                <td><b>{{ __('labels.frontend.user.profile.university') }}</b>
                                                                                </td>
                                                                                <td><b>{{ __('strings.frontend.general.upload_essay') }}</b><br /><small>{{ __('strings.frontend.general.must_be') }}
                                                                                        .docx,.doc</small> <i class="fa-solid fa-file"></i></td>
                                                                            </thead>
                                                                            <tbody>
                                                                                @if (count($course_pref) > 0)
                                                                                    @foreach ($course_pref as $cpf)
                                                                                        <tr>
                                                                                            <td>
                                                                                                @if ($cpf->course_id)
                                                                                                    @if (get_university_course_data($cpf->course_id))
                                                                                                        <h5 class=''>
                                                                                                            {{ get_university_course_data($cpf->course_id)->course_name }}
                                                                                                        </h5>
                                                                                                    @else
                                                                                                        -- <br>
                                                                                                    @endif
                                                                                                @else
                                                                                                    <h5>{{ $cpf->course_other }}
                                                                                                    </h5>
                                                                                                @endif
                                                                                            </td>
                                                                                            {{-- <td>{{($cpf->university_id) ? get_university_data($cpf->university_id)->university_name : '-'}}</td> --}}
                                                                                            <td>{{ ($cpf->university_id && get_university_data($cpf->university_id)) ? get_university_data($cpf->university_id)->university_name : $cpf->university_other }}
                                                                                            </td>
                                                                                            <td style="width:40%;">
                                                                                                <span class="ref_essay">
        
                                                                                                    @if (count(get_essay_list($cpf->id)))
                                                                                                        {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                                                        @foreach (get_essay_list($cpf->id) as $essay)
                                                                                                            <a class=""
                                                                                                                href="<?php echo url('storage/' . $essay->file); ?>"
                                                                                                                target="_blank"><?php echo substr($essay->file, 5); ?></a>
                                                                                                            <a title="delete document"
                                                                                                                data-type="Essay"
                                                                                                                data-id="{{ $essay->id }}"
                                                                                                                href="javascript:void(0)"
                                                                                                                class="cross del-pro-btn ml-1"></a>
                                                                                                            <br />
                                                                                                        @endforeach
                                                                                                    @endif
        
                                                                                                </span>
                                                                                                <form action=""
                                                                                                    method="post"
                                                                                                    enctype="multipart/form-data">
                                                                                                    <input type="hidden"
                                                                                                        class="input-group"
                                                                                                        value="{{ $cpf->id }}"
                                                                                                        name="course_pref_id">
                                                                                                    <input type="file"
                                                                                                        style=""
                                                                                                        class="form-control"
                                                                                                        id="file_essay{{ $cpf->id }}"
                                                                                                        accept=".doc,.docx,.pdf"
                                                                                                        name="file_essay[]"
                                                                                                        multiple>
                                                                                                </form>
                                                                                                <span style="display:none;"
                                                                                                    id="essay_loading"
                                                                                                    class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                                                <span id="essay-file-input-error"
                                                                                                    class="text-danger"></span>
                                                                                            </td>
                                                                                        </tr>
                                                                                    @endforeach
                                                                                @endif
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                {{-- //essay --}}
    
                                                @if ($docs_conf[$my_study_level]['experience']['enable'])
                                                <div class="col-12">
                                                    <div class="row mt-4">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                                style="">
                                                                {{ __('strings.frontend.general.experience_letters') }}
                                                            </div>
                                                        
                                                        <div class="card card-outline-info col-md-12">
                                                            
                                                            <div class="card-body">
                                                                @if (count($experience) > 0)
                                                                    <div class="row">
                                                                        <div class="col-12">
                                                                            {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                            @foreach ($experience as $exp)
                                                                                <a class="" href="<?php echo url('storage/' . $exp->file); ?>"
                                                                                    target="_blank"><?php echo substr($exp->file, 5); ?></a>
                                                                                <a title="delete document"
                                                                                    data-exp="{{ $exp->id }}"
                                                                                    href="javascript:void(0)"
                                                                                    class="ml-1 del-exp-btn"><i class="fa-solid fa-trash-can" style="color: #d52032; font-size: 12px;"></i></a>
                                                                                <br>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                <div class="row">
                                                                    <div class="col-12">
                                                                        <form action="" method="post"
                                                                            enctype="multipart/form-data">
                                                                            <input class="form-control" type="file"
                                                                                id="file_exp" name="file_exp[]" multiple
                                                                                accept="application/pdf">
                                                                        </form>
                                                                        @if ($docs_conf[$my_study_level]['experience']['mandatory'])
                                                                            <span
                                                                                class="text-danger">{{ __('strings.frontend.general.required') }}</span>
                                                                        @endif
                                                                        <span style="display:none;" id="file_exp_loading"
                                                                            class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                        <span id="file-exp-file-input-error"
                                                                            class="text-danger"></span>
                                                                    </div>
                                                                    <div class="col-12 d-flex align-items-center">
                                                                        <i class="fa-solid fa-file"></i>
                                                                        <small class="p-2">{{ __('strings.frontend.general.maximum') }}
                                                                            <?= $max_lor_files ?> files.</small>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
    
    
                                                @if ($docs_conf[$my_study_level]['other_cert']['enable'])
                                                <div class="col-12">
                                                    <div class="row mt-4">
                                                        <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                                style="">
                                                                {{ __('strings.frontend.general.other_certificates_documents') }}
                                                            </div>
                                                        
                                                        <div class="card card-outline-info col-md-12">
                                                            
                                                            <div class="card-body">
                                                                <div class="row p-t-10">
                                                                    @if (get_site_config('sample_mou'))
                                                                        <label>If you want to know how to write an MOU, download the
                                                                            sample
                                                                            MOU.
                                                                            <a class="btn btn-secondary btn-xs"
                                                                                href="{{ url('storage/' . get_site_config('sample_mou')) }}"
                                                                                target="_blank">Download Sample MOU <i
                                                                                    class="fa fa-download"></i></a>
                                                                    @endif
                                                                    <div class="col-12">
                                                                        @if (count($otherdocs))
                                                                            {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                            @foreach ($otherdocs as $otherdoc)
                                                                                <a class="" href="<?php echo url('storage/' . $otherdoc->file); ?>"
                                                                                    target="_blank"><?php echo substr($otherdoc->file, 5); ?></a>
                                                                                <a title="delete document"
                                                                                    data-other="{{ $otherdoc->id }}"
                                                                                    href="javascript:void(0)"
                                                                                    class="ml-1 del-other-btn"><i class="fa-solid fa-trash-can" style="color: #d52032; font-size: 12px;"></i></a>
                                                                                <br>
                                                                            @endforeach
                                                                        @endif
        
                                                                        <form action="" method="post"
                                                                            enctype="multipart/form-data">
                                                                            <input class="form-control" type="file"
                                                                                id="file_other" name="file_other[]" multiple
                                                                                accept="application/pdf">
                                                                        </form>
                                                                        @if ($docs_conf[$my_study_level]['other_cert']['mandatory'])
                                                                            <span
                                                                                class="text-danger">{{ __('strings.frontend.general.required') }}</span>
                                                                        @endif
                                                                        <span style="display:none;" id="file_other_loading"
                                                                            class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                        <span id="file-other-file-input-error"
                                                                            class="text-danger"></span>
        
                                                                            <div class="col-12 d-flex align-items-center">
                                                                                <i class="fa-solid fa-file"></i>
                                                                                <small class="p-2">{{ __('strings.frontend.general.maximum') }}
                                                                                    <?= $max_lor_files ?> files.</small>
                                                                            </div>
                                                                    </div>
                                                                </div>
        
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
    
                                                {{-- //Additional docs Three --}}
                                                @if (count($additional_docs_three) > 0)
                                                    @foreach ($additional_docs_three as $adc)
                                                    <div class="col-12">
                                                        <div class="row mt-4">
                                                            <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4"
                                                                    style="">
                                                                    {{ $adc->title }}
                                                                </div>
                                                            
                                                            <div class="card card-outline-info col-md-12">
                                                                
                                                                <div class="card-body">
                                                                    <div class="row p-t-10">
                                                                        <div class="col-12">
                                                                            @if (count(get_additional_docs(\Auth::user()->id, $adc->doc_type)))
                                                                                {{ __('strings.frontend.general.uploaded_file') }}<br>
                                                                                @foreach (get_additional_docs(\Auth::user()->id, $adc->doc_type) as $docs)
                                                                                    <a class="" href="<?php echo url('storage/' . $docs->file); ?>"
                                                                                        target="_blank"><?php echo substr($docs->file, 5); ?></a>
                                                                                    <a title="delete document"
                                                                                        data-additional_id="{{ $docs->id }}"
                                                                                        href="javascript:void(0)"
                                                                                        class="ml-1 del-additional-btn"><i class="fa-solid fa-trash-can" style="color: #d52032; font-size: 12px;"></i></a>
                                                                                    <br>
                                                                                @endforeach
                                                                            @endif
        
                                                                            <form action="" method="post"
                                                                                enctype="multipart/form-data">
                                                                                <input class="form-control" type="file"
                                                                                    id="{{ $adc->doc_type }}"
                                                                                    name="{{ $adc->doc_type }}{{ $adc->file_count > 1 ? '[]' : '' }}"
                                                                                    {{ $adc->file_count > 1 ? 'multiple' : '' }}
                                                                                    accept="{{ $adc->file_types }}">
                                                                            </form>
                                                                            {{-- @if ($docs_conf[$my_study_level]['other_cert']['mandatory']) <span class="text-danger input-err">{{ __('strings.frontend.general.required') }}</span> @endif --}}
                                                                            <span style="display:none;"
                                                                                id="{{ $adc->doc_type }}_loading"
                                                                                class="text-success p-3"><b>{{ __('strings.frontend.general.uploading') }}</b></span>
                                                                            <span id="{{ $adc->doc_type }}-file-input-error"
                                                                                class="text-danger"></span>
        
                                                                            <p class="card-subtitle mt-2 mb-0 text-dark">{{ __('labels.frontend.user.profile.allowed_file_types') }}: {{ $adc->file_types }}</p>
                                                                            @if ($adc->file_count > 1)
                                                                                <small>{{ __('strings.frontend.general.maximum') }}
                                                                                    <?= $adc->file_count ?> files.</small>
                                                                            @endif
                                                                            @if ($adc->doc_notes)
                                                                                <small>Notes: {{ $adc->doc_notes }}</small><br>
                                                                            @endif
                                                                        </div>
                                                                    </div>
        
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endforeach
                                                @endif
                                                {{-- //Additional docs Three --}}

                                            </div>
                                        </div>
                                </div>


                                <form id="submitApplForm" method="post"
                                    action="{{ route('frontend.user.studyabroad.documents.submitapplication') }}">
                                    @csrf
                                    @if ($terms_content)
                                        <h5>Terms & Conditions</h5>
                                        <div
                                            style="font-size:12px;padding:5px;height:200px;overflow-y:scroll;border:1px solid #ccc;margin-bottom:4px;">
                                            {!! $terms_content !!}
                                        </div>
                                        <div class="form-group">
                                            <input type="checkbox" class="form-check-input" name="terms" id="terms" 
                                                value="1">
                                            <label
                                                for="terms">{{ __('strings.frontend.general.agree_to_above_terms_and_conditions') }}</label>
                                        </div>
                                    @else
                                        <input type="hidden" name="terms" value="1">
                                    @endif

                                    <div class="mt-4 text-center">
                                        @if ($can_edit)
                                            <button type="button" class="btn btn-themecolor btn-themecolor mb-4"
                                                id="submitBtn">{{ __('strings.frontend.general.submit_application') }}</button>
                                        @else
                                            <button type="button" class="btn btn-secondary mb-4" style="cursor:no-drop;"
                                                disabled>{{ __('strings.frontend.general.submit_application') }}</button>
                                            @if (!$coursepref_pending && $logged_in_user->application_submit_date)
                                                <div><span
                                                        class="badge badge-success">{{ __('strings.frontend.general.you_have_submitted_application') }}
                                                        {{ date('j M, Y') }}</span></div>
                                            @endif
                                        @endif
                                    </div>
                                </form>

                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection

@push('after-styles')
    <!-- <link rel="stylesheet" href="{{ asset('assets/plugins/dropzone-master/dist/dropzone.css') }}"> -->
    <link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
    <style>
        .cross {
            display: inline-block;
            box-sizing: border-box;
            width: 12px;
            height: 12px;
            border-width: 3px;
            border-style: solid;
            border-color: red;
            border-radius: 100%;
            background: -webkit-linear-gradient(-45deg, transparent 0%, transparent 46%, white 46%, white 56%, transparent 56%, transparent 100%), -webkit-linear-gradient(45deg, transparent 0%, transparent 46%, white 46%, white 56%, transparent 56%, transparent 100%);
            background-color: red;
            transition: all 0.3s ease;
        }

        .tab{
            background-color: #E0E4FA !important; 
            padding: 6px 36px !important; 
        }

        .tab-heading{
            font-size: 18px;
        }
        
        @media (max-width: 769px) {
            .sub-card{
                margin: 10px -25px;
            }

            .doc-upload-card{
                margin: -20px -37px;
            }
            
            .doc-other-upload-card{
                margin: -20px -40px 14px;
            }
        }

        @media (max-width: 810px) {
            .tab{
                background-color: #E0E4FA !important; 
                padding: 0px 10px !important; 
            }
            .tab-heading{
                font-size: 14px;
            }
        }
    </style>
@endpush
@push('after-scripts')
    <!-- <script src="{{ asset('assets/plugins/dropzone-master/dist/dropzone.js') }}"></script> -->
    <script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
    <script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $('.file_edu').change(function(e) {
            e.preventDefault();
            $(this).closest('div').find('.loding').show();
            var formData = new FormData();
            var file = $(this).prop('files')[0];
            var type = $(this).attr('name');
            formData.append('type', type);
            formData.append('file', file);
            $(this).closest('div').find('.input-err').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('frontend.user.studyabroad.documents.save') }}",
                data: formData,
                contentType: false,
                processData: false,
                context: this,
                success: function(data) {
                    $(this).closest('div').find('.loding').hide();
                    if (data.res == 'success') {
                        $(this).val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    } else {
                        $(this).closest('div').find('.loding').hide();
                        $(this).closest('div').find('.input-err').text(data.message);
                    }
                },
                error: function(response) {
                    var row = $(this);
                    $.each(response.responseJSON.errors, function(key, value) {
                        row.closest('div').find('.loding').hide();
                        row.closest('div').find('.input-err').text(value[0]);
                    });
                    //$(this).closest('div').find('.input-err').text(response.responseJSON.message);
                }
            });
        });

        $('#file_cv').change(function(e) {
            e.preventDefault();
            $('#cv_loading').show();
            var formData = new FormData();
            var file = $('#file_cv').prop('files')[0];
            formData.append('file', file);
            $('#cv-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('frontend.user.studyabroad.documents.cv.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#cv_loading').hide();
                    if (data == 'success') {
                        $('#file_cv').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'CV has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                },
                error: function(response) {
                    $('#cv_loading').hide();
                    $.each(response.responseJSON.errors, function(key, value) {
                        $('#cv-file-input-error').html(value[0]);
                    });
                }
            });
        });

        $('#file_passport').change(function(e) {
            e.preventDefault();
            $('#passport_loading').show();

            var formData = new FormData();

            var files = $('#file_passport')[0].files;
            console.log(files.length);
            var files_left = <?= $pass_files_left ?>;

            if (files.length > files_left) {
                $('#passport_loading').hide();
                if (files_left == 0) {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                } else {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more than ' + files_left + ' documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                }
            } else {

                for (var i = 0; i < files.length; i++) {
                    formData.append("files[]", files[i], files[i]['name']);
                }

                $('#pass-file-input-error').text('');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('frontend.user.studyabroad.documents.passport.upload') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        $('#passport_loading').hide();
                        if (data == 'success') {
                            $('#file_passport').val('');
                            console.log(data);
                            $.toast({
                                heading: 'Success',
                                text: 'Passport has been uploaded successfully',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 1000,
                                stack: 6
                            });
                            location.reload();
                            // $("#ref_lor").load(location.href + " #ref_lor");
                        }
                        if (data == 'error') {
                            $('#file_passport').val('');
                            console.log(data);
                            $('#pass-file-input-error').text('Something went wrong');
                        }
                    },
                    error: function(response) {
                        $('#passport_loading').hide();
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#pass-file-input-error').html(value[0]);
                            //$("#" + key).next().removeClass('d-none');
                        });
                        //$('#lor-file-input-error').text(response.responseJSON.errors);
                    }
                });
            }
        });

        $('#file_lor').change(function(e) {
            e.preventDefault();
            $('#lor_loading').show();

            var formData = new FormData();

            var files = $('#file_lor')[0].files;
            console.log(files.length);
            var files_left = <?= $lor_files_left ?>;

            if (files.length > files_left) {
                $('#lor_loading').hide();
                if (files_left == 0) {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                } else {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more than ' + files_left + ' documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                }
            } else {

                for (var i = 0; i < files.length; i++) {
                    formData.append("files[]", files[i], files[i]['name']);
                }

                $('#lor-file-input-error').text('');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('frontend.user.studyabroad.documents.lor.upload') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        $('#lor_loading').hide();
                        if (data == 'success') {
                            $('#file_lor').val('');
                            console.log(data);
                            $.toast({
                                heading: 'Success',
                                text: 'LOR has been uploaded successfully',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 1000,
                                stack: 6
                            });
                            location.reload();
                            // $("#ref_lor").load(location.href + " #ref_lor");
                        }
                        if (data == 'error') {
                            $('#file_lor').val('');
                            console.log(data);
                            $('#lor-file-input-error').text('Something went wrong');
                        }
                    },
                    error: function(response) {
                        $('#lor_loading').hide();
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#lor-file-input-error').html(value[0]);
                            //$("#" + key).next().removeClass('d-none');
                        });
                        //$('#lor-file-input-error').text(response.responseJSON.errors);
                    }
                });
            }
        });

        $('#file_exp').change(function(e) {
            e.preventDefault();
            $('#file_exp_loading').show();

            var formData = new FormData();

            var files = $('#file_exp')[0].files;
            console.log(files.length);

            var exp_files_left = <?= $exp_files_left ?>;

            if (files.length > exp_files_left) {
                $('#file_exp_loading').hide();
                if (exp_files_left == 0) {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                } else {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more than ' + exp_files_left + ' documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                }
            } else {
                for (var i = 0; i < files.length; i++) {
                    formData.append("files[]", files[i], files[i]['name']);
                }
                $('#file-exp-file-input-error').text('');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('frontend.user.studyabroad.documents.experience.upload') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        $('#file_exp_loading').hide();
                        if (data == 'success') {
                            $('#file_exp').val('');
                            console.log(data);
                            $.toast({
                                heading: 'Success',
                                text: 'Work Experience Letter has been uploaded successfully',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 1000,
                                stack: 6
                            });
                            location.reload();
                        }
                        if (data == 'error') {
                            $('#file_exp').val('');
                            console.log(data);
                            $('#file-exp-file-input-error').text('Something went wrong');
                        }
                    },

                    error: function(response) {
                        $('#file_exp_loading').hide();
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#file-exp-file-input-error').html(value[0]);
                        });
                    }
                });
            }
        });


        $('#file_other').change(function(e) {
            e.preventDefault();
            $('#file_other_loading').show();

            var formData = new FormData();

            var files = $('#file_other')[0].files;
            console.log(files.length);

            var other_files_left = <?= $other_files_left ?>;

            if (files.length > other_files_left) {
                $('#file_other_loading').hide();
                if (other_files_left == 0) {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                } else {
                    $.toast({
                        heading: 'Warning',
                        text: 'You cannot upload more than ' + other_files_left + ' documents.',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'warning',
                        hideAfter: 4000,
                        stack: 6
                    });
                }
            } else {
                for (var i = 0; i < files.length; i++) {
                    formData.append("files[]", files[i], files[i]['name']);
                }
                $('#file-other-file-input-error').text('');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('frontend.user.studyabroad.documents.other.upload') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        $('#file_other_loading').hide();
                        if (data == 'success') {
                            $('#file_other').val('');
                            console.log(data);
                            $.toast({
                                heading: 'Success',
                                text: 'Other Certificate has been uploaded successfully',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 1000,
                                stack: 6
                            });
                            location.reload();
                        }
                        if (data == 'error') {
                            $('#file_other').val('');
                            console.log(data);
                            $('#file-other-file-input-error').text('Something went wrong');
                        }
                    },
                    error: function(response) {
                        $('#file_other_loading').hide();
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#file-other-file-input-error').html(value[0]);
                        });
                    }
                });
            }
        });


        @if (count($additional_docs_one) > 0)
            @foreach ($additional_docs_one as $adc)
                <?php $add_files_left = $adc->file_count - get_docs_count(\Auth::user()->id, $adc->doc_type); ?>
                $("#{{ $adc->doc_type }}").change(function(e) {
                    e.preventDefault();
                    var $loading = $(this).closest('div').find("#{{ $adc->doc_type }}_loading");
                    var $err = $(this).closest('div').find("#{{ $adc->doc_type }}-file-input-error");
                    $loading.show();

                    var formData = new FormData();
                    var files = $('#{{ $adc->doc_type }}')[0].files;

                    var add_files_left = <?= $add_files_left ?>;

                    if (files.length > add_files_left) {
                        $loading.hide();
                        if (add_files_left == 0) {
                            $.toast({
                                heading: 'Warning',
                                text: 'You cannot upload more documents.',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'warning',
                                hideAfter: 4000,
                                stack: 6
                            });
                        } else {
                            $.toast({
                                heading: 'Warning',
                                text: 'You cannot upload more than ' + add_files_left + ' documents.',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'warning',
                                hideAfter: 4000,
                                stack: 6
                            });
                        }
                    } else {
                        for (var i = 0; i < files.length; i++) {
                            formData.append("files[]", files[i], files[i]['name']);
                        }
                        formData.append('doc_type', "{{ $adc->doc_type }}");
                        formData.append('file_types', "{{ $adc->file_types }}");

                        $err.text('');
                        $.ajax({
                            type: 'POST',
                            url: "{{ route('frontend.user.studyabroad.documents.additional.upload') }}",
                            data: formData,
                            contentType: false,
                            processData: false,
                            success: function(data) {
                                $loading.hide();
                                console.log(data);
                                if (data == 'success') {
                                    $(this).val('');
                                    $.toast({
                                        heading: 'Success',
                                        text: '{{ $adc->title }} document has been uploaded successfully',
                                        position: 'top-right',
                                        loaderBg: '#ff6849',
                                        icon: 'success',
                                        hideAfter: 1000,
                                        stack: 6
                                    });
                                    location.reload();
                                }
                            },
                            error: function(response) {
                                $loading.hide();
                                $.each(response.responseJSON.errors, function(key, value) {
                                    $err.html(value[0]);
                                });
                            }
                        });
                    }
                });
            @endforeach
        @endif


        @if (count($additional_docs_two) > 0)
            @foreach ($additional_docs_two as $adc)
                <?php $add_files_left = $adc->file_count - get_docs_count(\Auth::user()->id, $adc->doc_type); ?>
                $("#{{ $adc->doc_type }}").change(function(e) {
                    e.preventDefault();
                    var $loading = $(this).closest('div').find("#{{ $adc->doc_type }}_loading");
                    var $err = $(this).closest('div').find("#{{ $adc->doc_type }}-file-input-error");
                    $loading.show();

                    var formData = new FormData();
                    var files = $('#{{ $adc->doc_type }}')[0].files;

                    var add_files_left = <?= $add_files_left ?>;

                    if (files.length > add_files_left) {
                        $loading.hide();
                        if (add_files_left == 0) {
                            $.toast({
                                heading: 'Warning',
                                text: 'You cannot upload more documents.',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'warning',
                                hideAfter: 4000,
                                stack: 6
                            });
                        } else {
                            $.toast({
                                heading: 'Warning',
                                text: 'You cannot upload more than ' + add_files_left + ' documents.',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'warning',
                                hideAfter: 4000,
                                stack: 6
                            });
                        }
                    } else {
                        for (var i = 0; i < files.length; i++) {
                            formData.append("files[]", files[i], files[i]['name']);
                        }
                        formData.append('doc_type', "{{ $adc->doc_type }}");
                        formData.append('file_types', "{{ $adc->file_types }}");

                        $err.text('');
                        $.ajax({
                            type: 'POST',
                            url: "{{ route('frontend.user.studyabroad.documents.additional.upload') }}",
                            data: formData,
                            contentType: false,
                            processData: false,
                            success: function(data) {
                                $loading.hide();
                                console.log(data);
                                if (data == 'success') {
                                    $(this).val('');
                                    $.toast({
                                        heading: 'Success',
                                        text: '{{ $adc->title }} document has been uploaded successfully',
                                        position: 'top-right',
                                        loaderBg: '#ff6849',
                                        icon: 'success',
                                        hideAfter: 1000,
                                        stack: 6
                                    });
                                    location.reload();
                                }
                            },
                            error: function(response) {
                                $loading.hide();
                                $.each(response.responseJSON.errors, function(key, value) {
                                    $err.html(value[0]);
                                });
                            }
                        });
                    }
                });
            @endforeach
        @endif


        @if (count($additional_docs_three) > 0)
            @foreach ($additional_docs_three as $adc)
                <?php $add_files_left = $adc->file_count - get_docs_count(\Auth::user()->id, $adc->doc_type); ?>
                $("#{{ $adc->doc_type }}").change(function(e) {
                    e.preventDefault();
                    var $loading = $(this).closest('div').find("#{{ $adc->doc_type }}_loading");
                    var $err = $(this).closest('div').find("#{{ $adc->doc_type }}-file-input-error");
                    $loading.show();

                    var formData = new FormData();
                    var files = $('#{{ $adc->doc_type }}')[0].files;

                    var add_files_left = <?= $add_files_left ?>;

                    if (files.length > add_files_left) {
                        $loading.hide();
                        if (add_files_left == 0) {
                            $.toast({
                                heading: 'Warning',
                                text: 'You cannot upload more documents.',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'warning',
                                hideAfter: 4000,
                                stack: 6
                            });
                        } else {
                            $.toast({
                                heading: 'Warning',
                                text: 'You cannot upload more than ' + add_files_left + ' documents.',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'warning',
                                hideAfter: 4000,
                                stack: 6
                            });
                        }
                    } else {
                        for (var i = 0; i < files.length; i++) {
                            formData.append("files[]", files[i], files[i]['name']);
                        }
                        formData.append('doc_type', "{{ $adc->doc_type }}");
                        formData.append('file_types', "{{ $adc->file_types }}");

                        $err.text('');
                        $.ajax({
                            type: 'POST',
                            url: "{{ route('frontend.user.studyabroad.documents.additional.upload') }}",
                            data: formData,
                            contentType: false,
                            processData: false,
                            success: function(data) {
                                $loading.hide();
                                console.log(data);
                                if (data == 'success') {
                                    $(this).val('');
                                    $.toast({
                                        heading: 'Success',
                                        text: '{{ $adc->title }} document has been uploaded successfully',
                                        position: 'top-right',
                                        loaderBg: '#ff6849',
                                        icon: 'success',
                                        hideAfter: 1000,
                                        stack: 6
                                    });
                                    location.reload();
                                }
                            },
                            error: function(response) {
                                $loading.hide();
                                $.each(response.responseJSON.errors, function(key, value) {
                                    $err.html(value[0]);
                                });
                            }
                        });
                    }
                });
            @endforeach
        @endif



        @if (count($course_pref) > 0)
            @foreach ($course_pref as $cpf)
                var cnt = "{{ $cpf->id }}";
                $('#file_sop' + cnt).change(function(e) {
                    e.preventDefault();
                    var $loading = $(this).closest('tr').find('#sop_loading');
                    var $err = $(this).closest('tr').find('#sop-file-input-error');
                    $loading.show();
                    var formData = new FormData();
                    var file = $(this).prop('files')[0];
                    var course_pref_id = $(this).closest('tr').find("input[name='course_pref_id']").val();

                    formData.append('file', file);
                    formData.append('course_pref_id', course_pref_id);

                    $err.text('');
                    $.ajax({
                        type: 'POST',
                        url: "{{ route('frontend.user.studyabroad.documents.sop.upload') }}",
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function(data) {
                            $loading.hide();
                            if (data == 'success') {
                                $(this).val('');
                                $.toast({
                                    heading: 'Success',
                                    text: 'SOP has been uploaded successfully',
                                    position: 'top-right',
                                    loaderBg: '#ff6849',
                                    icon: 'success',
                                    hideAfter: 1000,
                                    stack: 6
                                });
                                location.reload();
                            }
                        },
                        error: function(response) {
                            $loading.hide();
                            $.each(response.responseJSON.errors, function(key, value) {
                                $err.html(value[0]);
                            });
                        }
                    });
                });

                // Essay
                $('#file_essay' + cnt).change(function(e) {
                    e.preventDefault();
                    var $loading = $(this).closest('tr').find('#essay_loading');
                    var $err = $(this).closest('tr').find('#essay-file-input-error');
                    $loading.show();
                    var formData = new FormData();
                    //var file = $(this).prop('files')[0];
                    var course_pref_id = $(this).closest('tr').find("input[name='course_pref_id']").val();

                    let totalFiles = $(this).prop('files').length;
                    let files = $(this).prop('files');

                    for (var i = 0; i < totalFiles; i++) {
                        formData.append("files[]", files[i], files[i].name);
                    }
                    formData.append('totalFiles', totalFiles);
                    formData.append('course_pref_id', course_pref_id);
                    formData.append('_token', '{{ csrf_token() }}');

                    $err.text('');
                    $.ajax({
                        type: 'POST',
                        url: "{{ route('frontend.user.studyabroad.documents.essay.upload') }}",
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function(data) {
                            console.log("Return: " + data);
                            $loading.hide();
                            if (data == 'success') {
                                $(this).val('');
                                $.toast({
                                    heading: 'Success',
                                    text: 'Essay has been uploaded successfully',
                                    position: 'top-right',
                                    loaderBg: '#ff6849',
                                    icon: 'success',
                                    hideAfter: 3000,
                                    stack: 6
                                });
                                location.reload();
                            }
                            if (data == 'error_max_files') {
                                $(this).val('');
                                $.toast({
                                    heading: 'Error',
                                    text: 'You can upload upto {{ env('MAX_ESSAY_FILES') }} essays for each course preference',
                                    position: 'top-right',
                                    loaderBg: '#ff6849',
                                    icon: 'error',
                                    hideAfter: 3000,
                                    stack: 8
                                });
                                //  location.reload();
                            }
                        },
                        error: function(response) {
                            $loading.hide();
                            $err.text(response.responseJSON.message);
                        }
                    });
                });
                //essay
            @endforeach
        @endif

        $(".del-pass-btn").on("click", function() {
            var pass_id = $(this).data('pass');
            swal({
                title: "{{ __('strings.frontend.general.are_you_sure') }}?",
                text: "{{ __('strings.frontend.general.want_to_delete') }}",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "{{ __('strings.frontend.general.delete_it') }}",
                closeOnConfirm: true
            }, function() {
                $.ajax({
                    url: "{{ route('frontend.user.studyabroad.documents.pass.delete') }}",
                    type: "POST",
                    data: {
                        pass_id: pass_id,
                        _token: '{{ csrf_token() }}'
                    },
                    context: this,
                    success: function(result) {
                        $.toast({
                            heading: 'Deleted',
                            text: result.message,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                });
            });
        });

        $(".del-lor-btn").on("click", function() {
            var lor_id = $(this).data('lor');
            swal({
                title: "{{ __('strings.frontend.general.are_you_sure') }}?",
                text: "{{ __('strings.frontend.general.want_to_delete') }}",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "{{ __('strings.frontend.general.delete_it') }}",
                closeOnConfirm: true
            }, function() {
                $.ajax({
                    url: "{{ route('frontend.user.studyabroad.documents.lor.delete') }}",
                    type: "POST",
                    data: {
                        lor_id: lor_id,
                        _token: '{{ csrf_token() }}'
                    },
                    context: this,
                    success: function(result) {
                        $.toast({
                            heading: 'Deleted',
                            text: result.message,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                        // $("#ref_lor").load(location.href + " #ref_lor");
                    }
                });
            });

        });

        $(".del-exp-btn").on("click", function() {
            var exp_id = $(this).data('exp');
            swal({
                title: "{{ __('strings.frontend.general.are_you_sure') }}?",
                text: "{{ __('strings.frontend.general.want_to_delete') }}",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "{{ __('strings.frontend.general.delete_it') }}",
                closeOnConfirm: true
            }, function() {
                $.ajax({
                    url: "{{ route('frontend.user.studyabroad.documents.exp.delete') }}",
                    type: "POST",
                    data: {
                        exp_id: exp_id,
                        _token: '{{ csrf_token() }}'
                    },
                    context: this,
                    success: function(result) {
                        $.toast({
                            heading: 'Deleted',
                            text: result.message,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                        // $("#ref_lor").load(location.href + " #ref_lor");
                    }
                });
            });
        });

        $(".del-other-btn").on("click", function() {
            var other_id = $(this).data('other');
            swal({
                title: "{{ __('strings.frontend.general.are_you_sure') }}?",
                text: "{{ __('strings.frontend.general.want_to_delete') }}",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "{{ __('strings.frontend.general.delete_it') }}",
                closeOnConfirm: true
            }, function() {
                $.ajax({
                    url: "{{ route('frontend.user.studyabroad.documents.other.delete') }}",
                    type: "POST",
                    data: {
                        other_id: other_id,
                        _token: '{{ csrf_token() }}'
                    },
                    context: this,
                    success: function(result) {
                        $.toast({
                            heading: 'Deleted',
                            text: result.message,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                        // $("#ref_lor").load(location.href + " #ref_lor");
                    }
                });
            });
        });

        $(".del-additional-btn").on("click", function() {
            var additional_id = $(this).data('additional_id');
            swal({
                title: "{{ __('strings.frontend.general.are_you_sure') }}?",
                text: "{{ __('strings.frontend.general.want_to_delete') }}",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "{{ __('strings.frontend.general.delete_it') }}",
                closeOnConfirm: true
            }, function() {
                $.ajax({
                    url: "{{ route('frontend.user.studyabroad.documents.additional.delete') }}",
                    type: "POST",
                    data: {
                        additional_id: additional_id,
                        _token: '{{ csrf_token() }}'
                    },
                    context: this,
                    success: function(result) {
                        $.toast({
                            heading: 'Deleted',
                            text: result.message,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                        // $("#ref_lor").load(location.href + " #ref_lor");
                    }
                });
            });
        });

        $(".del-pro-btn").on("click", function() {
            var id = $(this).data('id');
            var type = $(this).data('type');

            swal({
                title: "{{ __('strings.frontend.general.are_you_sure') }}",
                text: "{{ __('strings.frontend.general.want_to_delete') }}",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "{{ __('strings.frontend.general.delete_it') }}",
                closeOnConfirm: true
            }, function() {
                $.ajax({
                    url: "{{ route('frontend.user.studyabroad.documents.essay.delete') }}",
                    type: "POST",
                    data: {
                        id: id,
                        type: type,
                        _token: '{{ csrf_token() }}'
                    },
                    context: this,
                    success: function(result) {
                        $.toast({
                            heading: 'Deleted',
                            text: result.message,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                });
            });

        });


        $(document).ready(function() {
            $("#submitBtn").click(function() {
                @if ($terms_content)
                    if (!$('#terms').prop("checked")) {
                        alert("You must accept the terms & conditions to proceed!");
                        return false;
                    }
                @endif
                $("#submitApplForm").submit();
            });
        });
    </script>
@endpush
