{{-- @php echo "<pre>"; print_r($logged_in_user); exit(); @endphp --}}

@extends('frontend.layouts.app')
@section('title')
    {{ __('strings.frontend.general.apply_for_overseas') }}
@endsection

@section('content')
    <div class="container-fluid main-card">
        <div class="row  ge-titles p-4 pb-0 wrapper main-card">
            <div class="col-md-5 align-self-center">
                <h3 class="text-themecolor">{{ __('strings.frontend.general.apply_for_study_abroad') }}</h3>
            </div>
        </div>

        <div class="container-fluid" style="padding-top:20px">
            <!-- Nav tabs -->
            <ul class="nav nav-tabs customtab2" role="tablist">
                <li class="nav-item">
                    <a class="nav-link border active tab" style=""
                        href="{{ route('frontend.user.studyabroad.profile') }}" role="tab">
                        <span class="hidden-sm-up"><i class="ti-user"></i></span>
                        <span class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.profile') }}</span>
                    </a>
                </li>&nbsp;
                <li class="nav-item"> <a class="nav-link border tab"
                        href="{{ route('frontend.user.studyabroad.coursepreference') }}" role="tab"><span
                            class="hidden-sm-up"><i class="ti-book"></i></span> <span
                            class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.course_preferences') }}</span></a>
                </li>&nbsp;
                <li class="nav-item"> <a class="nav-link border tab"
                        href="{{ route('frontend.user.studyabroad.documents') }}" role="tab"><span
                            class="hidden-sm-up"><i class="ti-folder"></i></span> <span
                            class="hidden-xs-down tab-heading">{{ __('navs.frontend.user.documents') }}</span></a> </li>
            </ul>

            <div class="row">
                <div class="col-12">
                    <div class="card" style="border-top-left-radius: 0px">
                        <div class="card-body">
                            @include('includes.partials.messages')
                            <!-- Tab panes -->
                            <div class="tab-content" style="margin: -15px -15px 0px -15px !important;">
                                <div class="tab-pane active" id="profile" role="tabpanel">
                                    <div class=" main-card">
                                        <h3 class="">{{ __('strings.frontend.student.profile') }}</h3>
                                        <h6 class="card-subtitle">{{ __('strings.frontend.student.profile_subheading') }}
                                        </h6>
                                        <form method="post" id="profile_form"
                                            action="{{ route('frontend.user.studyabroad.profile.basic.save') }}"
                                            class="mt-4 needs-validation" novalidate enctype="multipart/form-data">
                                            @csrf
                                            <p class="mb-3 ms-1">Fields marked with an asterisk (<span
                                                    class="text-red">*</span>) are mandatory</p>

                                            <div class="card card-outline-info sub-card">
                                                <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-2"
                                                    style="padding: 7px 12px !important;">
                                                    {{ __('labels.frontend.user.profile.personal_info') }}
                                                </div>
                                                <div class="card-body">
                                                    <div class="row responsive-set-margin">
                                                        <div class="col-lg-2">
                                                            <div
                                                                style="width:120px; height:100px;margin:2px 10px 2px 1px; ">
                                                                @if ($logged_in_user->avatar_location != '')
                                                                    <img src="{{ asset('storage/' . $logged_in_user->avatar_location) }}"
                                                                        alt="user" width="100" height="100"
                                                                        style="border-radius: 50%" />
                                                                @else
                                                                    <img src="{{ asset('assets/images/users/user.png') }}"
                                                                        alt="user" width="100" height="100"
                                                                        style="border-radius: 50%" />
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-1"></div>
                                                        <div class="col-lg-9">
                                                            <div class="form-group" id="avatar_location">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="fs-16">@lang('labels.frontend.user.profile.your_photograph')</label>
                                                                {{ html()->file('avatar_location')->class('form-control col-sm-12')->accept('.jpg, .jpeg') }}
                                                                <span
                                                                    class='valid-img-msg form-text'>{{__('labels.frontend.user.profile.format')}}: jpg, jpeg &nbsp;
                                                                <small
                                                                    class="form-text">{{ __('labels.frontend.user.profile.max_size') }}:
                                                                    2MB</small> </span>
                                                            </div>
                                                            <!--form-group-->
                                                        </div>
                                                    </div>

                                                    <div class="row responsive-set-margin" style="margin-top: 40px;">
                                                        <div class="col-md-4">
                                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.first_name') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    id="first_name" name="first_name" maxlength="50"
                                                                    value="@if (Request::old('first_name')) {{ Request::old('first_name') }}@else{{ $logged_in_user->first_name }} @endif"
                                                                    required>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.first_name') }}.
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.middle_name') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    name="middle_name" maxlength="50"
                                                                    value="@if (Request::old('middle_name')) {{ Request::old('middle_name') }}@else{{ $logged_in_user->middle_name }} @endif">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.last_name') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    id="last_name" name="last_name" maxlength="50"
                                                                    value="@if (Request::old('last_name')) {{ Request::old('last_name') }}@else{{ $logged_in_user->last_name }} @endif"
                                                                    required>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.last_name') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row responsive-set-margin mt-3">
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.gender') }}</label>
                                                                <div>
                                                                    <div class="form-check form-check-inline">
                                                                        <input type="radio"
                                                                            class="radio-col-blue border form-check-input"
                                                                            name="gender" id="male" value="male"
                                                                            @if (Request::old('gender') == 'male') checked @elseif($logged_in_user->gender == 'male') checked @endif
                                                                            required>
                                                                        <label
                                                                            class="custom-control-label form-check-label"
                                                                            for="male">{{ __('labels.frontend.user.profile.male') }}</label>
                                                                    </div>
                                                                    <div class="form-check form-check-inline">
                                                                        <input type="radio"
                                                                            class="radio-col-blue border form-check-input"
                                                                            name="gender" id="female" value="female"
                                                                            @if (Request::old('gender') == 'female') checked @elseif($logged_in_user->gender == 'female') checked @endif
                                                                            required>
                                                                        <label
                                                                            class="custom-control-label form-check-label"
                                                                            for="female">{{ __('labels.frontend.user.profile.female') }}</label>
                                                                    </div>
                                                                </div>
                                                                <div class="invalid-feedback">
                                                                    &nbsp;{{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.gender') }}.
                                                                </div>
                                                            </div>
                                                        </div>

                                                        {{-- <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.marital_status') }}</label>
                                                                <div>
                                                                    <div class="form-check form-check-inline">
                                                                        <input type="radio"
                                                                            class="radio-col-blue border form-check-input"
                                                                            name="marital_status" id="single"
                                                                            value="Single"
                                                                            @if (Request::old('marital_status') == 'Single') checked @elseif($userDetails && $userDetails->marital_status == 'Single') checked @endif
                                                                            required>
                                                                        <label
                                                                            class="custom-control-label form-check-label"
                                                                            for="single">{{ __('labels.frontend.user.profile.single') }}</label>
                                                                        <div class="invalid-feedback">
                                                                            &nbsp;{{ __('labels.frontend.user.profile.please_choose') }}
                                                                            {{ __('labels.frontend.user.profile.marital_status') }}.
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-check form-check-inline">
                                                                        <input type="radio"
                                                                            class="radio-col-blue border form-check-input"
                                                                            name="marital_status" id="married"
                                                                            value="married"
                                                                            @if (Request::old('marital_status') == 'married') checked @elseif($userDetails && $userDetails->marital_status == 'married') checked @endif
                                                                            required>
                                                                        <label
                                                                            class="custom-control-label form-check-label"
                                                                            for="married">{{ __('labels.frontend.user.profile.married') }}</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div> --}}
                                                        <div class="col-md-4">
                                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;" class="required-field">@lang('labels.frontend.user.profile.marital_status')</label>
                                                                <div>
                                                                    <select class="form-control form-select shadow-none text-dark border input-box-inner-style"
                                                                        id="marital_status" name="marital_status" required>
                                                                        <option value="">Select</option>
                                                                        <option value="never_married"
                                                                            @if (Request::old('marital_status') == 'never_married') selected @elseif ($userDetails && $userDetails->marital_status == 'never_married') selected @endif>
                                                                            Never Married</option>
                                                                        <option value="married"
                                                                            @if (Request::old('marital_status') == 'married') selected @elseif ($userDetails && $userDetails->marital_status == 'married') selected @endif>
                                                                            Married</option>
                                                                        <option value="engaged"
                                                                            @if (Request::old('marital_status') == 'engaged') selected @elseif ($userDetails && $userDetails->marital_status == 'engaged') selected @endif>
                                                                            Engaged</option>
                                                                        <option value="separated"
                                                                            @if (Request::old('marital_status') == 'separated') selected @elseif ($userDetails && $userDetails->marital_status == 'separated') selected @endif>
                                                                            Separated</option>
                                                                        <option value="divorced"
                                                                            @if (Request::old('marital_status') == 'divorced') selected @elseif ($userDetails && $userDetails->marital_status == 'divorced') selected @endif>
                                                                            Divorced</option>
                                                                        <option value="widowed"
                                                                            @if (Request::old('marital_status') == 'widowed') selected @elseif ($userDetails && $userDetails->marital_status == 'widowed') selected @endif>
                                                                            Widowed</option>
                                                                        <option value="defector"
                                                                            @if (Request::old('marital_status') == 'defector') selected @elseif ($userDetails && $userDetails->marital_status == 'defector') selected @endif>
                                                                            Defector</option>
                                                                        <option value="other"
                                                                            @if (Request::old('marital_status') == 'other') selected @elseif ($userDetails && $userDetails->marital_status == 'other') selected @endif>
                                                                            Other</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            
                                                        <div class="col-md-4" id="select_date_of_marriage"
                                                            @if ($userDetails) 
                                                                @if ($userDetails->marital_status == 'never_married' || $userDetails->marital_status == '') 
                                                                    style="display:none;" 
                                                                @else 
                                                                    style="" @endif
                                                                @else style="display:none;" 
                                                            @endif>
                                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;">Date of Marriage</label>
                                                                <div class="input-group">
                                                                    <input type="text" class="form-control mydatepicker maritalDate input-box-inner-style"
                                                                        id="date_of_marriage" name="date_of_marriage"
                                                                        placeholder="dd-mm-yyyy"
                                                                        value="@if (Request::old('date_of_marriage')) {{ date('d-m-Y', strtotime(Request::old('date_of_marriage'))) }}@elseif($userDetails->date_of_marriage){{ date('d-m-Y', strtotime($userDetails->date_of_marriage)) }} @endif">
                                                                    <div class="input-group-append">
                                                                        <span class="input-group-text" style="height: 100% !important;"><i class="fa fa-calendar"></i></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.date_of_birth') }}</label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control mydatepicker maritalDate input-box-inner-style"
                                                                        id="dateOfBirth" name="dob"
                                                                        placeholder="dd-mm-yyyy"
                                                                        value="@if (Request::old('dob')) {{ date('d-m-Y', strtotime(Request::old('dob'))) }}@elseif($logged_in_user->birthday){{ date('d-m-Y', strtotime($logged_in_user->birthday)) }} @endif"
                                                                        required>
                                                                    <div class="input-group-append">
                                                                        <span class="input-group-text h-100"><i
                                                                                class="fas fa-calendar-alt"></i></span>
                                                                    </div>
                                                                    <div class="invalid-feedback">
                                                                        {{ __('labels.frontend.user.profile.please_choose') }}
                                                                        {{ __('labels.frontend.user.profile.date_of_birth') }}.
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin mt-2">
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">
                                                                    {{ __('labels.frontend.user.profile.nationality') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="nationality" name="nationality" required>
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('nationality') == $country->id) selected @elseif ($userDetails && $country->id == $userDetails->nationality) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.nationality') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.citizenship') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="citizenship" name="citizenship" required>
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('citizenship') == $country->id) selected @elseif ($userDetails && $country->id == $userDetails->citizenship) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.citizenship') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin mt-2">
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.country_of_education') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="country_of_education" name="country_of_education"
                                                                    required>
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('country_of_education') == $country->id) selected @elseif ($userDetails && $country->id == $userDetails->country_of_education) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.country_of_education') }}.
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.highest_level_of_education') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="highest_level_education"
                                                                    name="highest_level_education" required>
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                        {{ __('labels.frontend.user.profile.qualification') }}
                                                                    </option>
                                                                    @foreach (get_student_qualification_levels() as $value)
                                                                        <option value="{{ $value }}"
                                                                            @if (Request::old('qualification') == $value) selected @elseif($userDetails->highest_level_education == $value) selected @endif>
                                                                            {{ $value }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.highest_level_of_education') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row responsive-set-margin">
                                                        <hr class="my-4" style="height:1px;border-width:0;background-color:#b6b4b482">
                                                        <div class="col-md-6">
                                                            <label style="margin-bottom: 0.2rem;"
                                                                class="required-field">{{ __('labels.frontend.user.profile.interested_study_level') }}</label>
                                                            <select
                                                                class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                name="overseas_study_level" id="overseas_study_level"
                                                                required>
                                                                <option value="">
                                                                    {{ __('labels.frontend.user.profile.select') }}
                                                                </option>
                                                                @foreach (get_study_levels() as $key => $value)
                                                                    <option value="{{ $key }}"
                                                                        {{ $logged_in_user->overseas_study_level_selection == $key ? 'selected' : '' }}>
                                                                        {{ $value }}</option>
                                                                @endforeach
                                                            </select>
                                                            <div class="invalid-feedback">
                                                                {{ __('labels.frontend.user.profile.please_choose') }}
                                                                {{ __('labels.frontend.user.profile.interested_study_level') }}.
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <label style="margin-bottom: 0.2rem;"
                                                                class="required-field">{{ __('labels.frontend.user.profile.country_interested') }}</label>
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <select name="country_interested[]"
                                                                    class="form-control form-select shadow-none text-dark select2 input-box-inner-style border"
                                                                    style="width: 100%" multiple="multiple" required>
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                        {{ __('labels.frontend.user.profile.country') }}
                                                                    </option>
                                                                    @foreach ($study_countries as $country)
                                                                        <?php $countryInterest = '';
                                                                        if (Request::old('country_interested')) {
                                                                            $country_interested = Request::old('country_interested');
                                                                        } else {
                                                                            $country_interested = explode(',', $logged_in_user->country_interested);
                                                                        }
                                                                        ?>
                                                                        @foreach ($country_interested as $interest)
                                                                            @if ($interest == $country->title_en)
                                                                                <?php $countryInterest = 'selected'; ?>
                                                                            @endif
                                                                        @endforeach
                                                                        <option value="{{ $country->title_en }}"
                                                                            {{ $countryInterest }}>
                                                                            {{ $country->title_en }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.country_interested') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    @if(env('ADDITIONAL_SERVICES_ENABLE'))
                                                    <div class="row mt-3 responsive-set-margin">
                                                        <div class="col-sm-12 col-md-8">
                                                            <label
                                                                class="mb-1">{{ __('labels.frontend.user.profile.services_interested_in') }}</label>
                                                            <select name="services[]" style="width: 100%"
                                                                class="form-control form-select shadow-none text-dark select2 input-box-inner-style border"
                                                                multiple="multiple">
                                                                {{-- <option value="">{{ __('labels.frontend.user.profile.select') }}</option> --}}
                                                                @foreach (get_services_data() as $service)
                                                                    <?php $serviceInterest = '';
                                                                    if (Request::old('services')) {
                                                                        $service_interested = Request::old('services');
                                                                    } else {
                                                                        $service_interested = explode(',', $logged_in_user->services);
                                                                    }
                                                                    ?>
                                                                    @foreach ($service_interested as $interest)
                                                                        @if ($interest == $service->id)
                                                                            <?php $serviceInterest = 'selected'; ?>
                                                                        @endif
                                                                    @endforeach
                                                                    <option value="{{ $service->id }}"
                                                                        {{ $serviceInterest }}>
                                                                        {{ $service->service_name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    {{-- <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482"> --}}

                                                    {{-- <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482"> --}}
                                                    {{-- //Dynamic fields --}}
                                                    @if (count($custom_attributes))
                                                        <?php
                                                        $attrData = json_decode($userDetails->user_data_js, true);
                                                        ?>
                                                        <div class="form-group row responsive-set-margin">
                                                            <hr class="my-5" style="height:0.5px; border-width:0;background-color:#b6b4b482">
                                                            <h4 class="mb-3">{{ __('labels.frontend.user.profile.additional_information') }}</h4>
                                                            @foreach ($custom_attributes as $custom_attribute)
                                                                @if ($custom_attribute->for_student_mandatory)
                                                                    <?php $red = 'required-field';
                                                                    $mandate = 'required'; ?>
                                                                @else
                                                                    <?php $red = '';
                                                                    $mandate = ''; ?>
                                                                @endif
                                                                @if ($custom_attribute->type == 'textarea')
                                                                    <div class="col-md-12 col-sm-12">
                                                                        <div class="form-group">
                                                                            <label for=""
                                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                                            <div class="">
                                                                                <textarea placeholder="{{ $custom_attribute->placeholder }}" {{ "minLength=$custom_attribute->input_min" }}
                                                                                    {{ "maxLength=$custom_attribute->input_max" }} class="form-control input-box-inner-style border"
                                                                                    name="{{ $custom_attribute->attr_name }}" {{ $mandate }}>
                                                                                @if (isset($attrData[$custom_attribute->attr_name]))
{{ $attrData[$custom_attribute->attr_name] }}@else{{ old("$custom_attribute->attr_name") }}
@endif
                                                                                </textarea>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                @if ($custom_attribute->type == 'input')
                                                                    <div class="col-md-4 col-sm-12">
                                                                        <div class="form-group">
                                                                            <label for=""
                                                                                class="">{{ $custom_attribute->label }}</label>
                                                                            <div class="">
                                                                                <input
                                                                                    type="@if ($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal') {{ 'number' }}@elseif(
                                                                                        $custom_attribute->input_datatype == 'date' ||
                                                                                            $custom_attribute->input_datatype == 'year' ||
                                                                                            $custom_attribute->input_datatype == 'phone'){{ 'text' }}@else{{ $custom_attribute->input_datatype }} @endif"
                                                                                    {{ $custom_attribute->input_datatype == 'decimal' ? 'step=any' : '' }}
                                                                                    @if ($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal') {{ "min=$custom_attribute->input_min" }} {{ "max=$custom_attribute->input_max" }}
                                                            @elseif($custom_attribute->input_datatype == 'date')
                                                            {{-- //No min or max added --}}
                                                            @elseif($custom_attribute->input_datatype == 'year')
                                                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4"
                                                            @elseif($custom_attribute->input_datatype == 'phone')
                                                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)" minlength="10" maxlength="18"
                                                            @else
                                                                {{ "minLength=$custom_attribute->input_min" }} {{ "maxLength=$custom_attribute->input_max" }} @endif
                                                                                    placeholder="{{ $custom_attribute->placeholder }}"
                                                                                    autocomplete="off"
                                                                                    class="form-control input-box-inner-style @if ($custom_attribute->input_datatype == 'date') {{ 'mydatepicker' }} @endif"
                                                                                    name="{{ $custom_attribute->attr_name }}"
                                                                                    value='@if (isset($attrData[$custom_attribute->attr_name])) {{ $attrData[$custom_attribute->attr_name] }}@else{{ old("$custom_attribute->attr_name") }} @endif'
                                                                                    {{ $mandate }}>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                @if ($custom_attribute->type == 'select')
                                                                    <?php
                                                                    $is_multi = $select2 = $wdth = '';
                                                                    $select_vals = explode('|', $custom_attribute->selection_values);
                                                                    if ($custom_attribute->select_multiple) {
                                                                        $is_multi = 'multiple';
                                                                        $select2 = 'select2';
                                                                        $wdth = 'width:100%;';
                                                                    }
                                                                    ?>
                                                                    <div class="col-md-4 col-sm-12">
                                                                        <div class="form-group">
                                                                            <label for=""
                                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                                            <div class="">
                                                                                <select
                                                                                    placeholder="{{ $custom_attribute->placeholder }}"
                                                                                    style="{{ $wdth }}"
                                                                                    class="form-control input-box-inner-style border {{ $select2 }}"
                                                                                    name="{{ $custom_attribute->attr_name }}[]"
                                                                                    {{ $mandate }}
                                                                                    {{ $is_multi }}>
                                                                                    @if (!$is_multi)
                                                                                        <option value="">
                                                                                            {{ $custom_attribute->placeholder }}
                                                                                        </option>
                                                                                    @endif
                                                                                    @foreach ($select_vals as $sel_val)
                                                                                        <option
                                                                                            {{ isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name]) ? ' selected' : '' }}{{ is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name")) ? ' selected' : '' }}
                                                                                            value="{{ $sel_val }}">
                                                                                            {{ $sel_val }}</option>
                                                                                    @endforeach
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                @if ($custom_attribute->type == 'checkbox')
                                                                    <?php
                                                                    $select_vals = explode('|', $custom_attribute->selection_values);
                                                                    ?>
                                                                    <div class="col-md-4 col-sm-12">
                                                                        <div class="form-group">
                                                                            <label for=""
                                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                                            <div class="">
                                                                                @foreach ($select_vals as $sel_val)
                                                                                    <label class="mr-2">
                                                                                        <input class="form-check-input border ms-0 dyna_chkbx {{ $custom_attribute->attr_name }}" type="checkbox"
                                                                                            @if ($mandate) onclick='chk_mend("{{ $custom_attribute->attr_name }}")' @endif
                                                                                            {{ isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name]) ? ' checked' : '' }}
                                                                                            {{ is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name")) ? ' checked' : '' }}
                                                                                           
                                                                                            name="{{ $custom_attribute->attr_name }}[]"
                                                                                            value="{{ $sel_val }}"
                                                                                            @if (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{ '' }} @else{{ $mandate }} @endif
                                                                                            style="position:inherit!important;opacity: 1!important;width:16px;height:16px;vertical-align:middle;">
                                                                                        {{ $sel_val }}
                                                                                    </label>
                                                                                @endforeach
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                @if ($custom_attribute->type == 'radio')
                                                                    <?php
                                                                    $select_vals = explode('|', $custom_attribute->selection_values);
                                                                    ?>
                                                                    <div class="col-md-4 col-sm-12">
                                                                        <div class="form-group">
                                                                            <label for=""
                                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                                            <div class="">
                                                                                @foreach ($select_vals as $sel_val)
                                                                                    <label class="mr-2">
                                                                                        <input
                                                                                            class="mr-0 {{ $custom_attribute->attr_name }}"
                                                                                            @if ($mandate) onclick='chk_mend("{{ $custom_attribute->attr_name }}")' @endif
                                                                                            {{ isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name]) ? ' checked' : '' }}
                                                                                            {{ is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name")) ? ' checked' : '' }}
                                                                                            type="radio"
                                                                                            name="{{ $custom_attribute->attr_name }}[]"
                                                                                            value="{{ $sel_val }}"
                                                                                            @if (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{ '' }} @else{{ $mandate }} @endif
                                                                                            style="position:inherit!important;opacity: 1!important;width:16px;height:16px;vertical-align:middle;">
                                                                                        {{ $sel_val }}
                                                                                    </label>
                                                                                @endforeach
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        </div>
                                                    @endif

                                                    {{-- //Dynamic fields --}}
                                                    <div class="row responsive-set-margin">
                                                        <hr class="my-5" style="height:1px;border-width:0;background-color:#b6b4b482">

                                                        <h4 class="mb-3">
                                                            {{ __('labels.frontend.user.profile.current_address') }}</h4>
                                                        <div class="col-md-12">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.address') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    id="address" name="address" maxlength="200"
                                                                    value="@if (Request::old('address')) {{ Request::old('address') }}@else{{ $logged_in_user->address_1 }} @endif"
                                                                    required>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.address') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.country') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="country-dd" name="country" required>
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('country') == $country->id) selected @elseif ($country->id == $logged_in_user->country) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.country') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.state') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    name="state" id="state-dd" required>
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.state') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field">{{ __('labels.frontend.user.profile.city') }}</label>
                                                                <!-- <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    name="city" id="city"
                                                                    value="@if (Request::old('city')) {{ Request::old('city') }}@else{{ $logged_in_user->city }} @endif"
                                                                    required> -->
                                                             <select class="form-control form-select" name="city" id="city-dd" required>
                            </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.city') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.postal_code') }}</label>
                                                                <input type="text" id="post_code"
                                                                    class="form-control input-box-inner-style"
                                                                    name="post_code" maxlength="20"
                                                                    value="@if (Request::old('post_code')) {{ Request::old('post_code') }}@else{{ $logged_in_user->post_code }} @endif">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <hr class="my-5"
                                                            style="height:1px;border-width:0;background-color:#b6b4b482">
                                                        <h4 class="mt-4 mb-3">
                                                            {{ __('labels.frontend.user.profile.permanent_address') }}</h4>
                                                       
                                                        <div class="col-md-12">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label>
                                                                    <input class="form-check-input border" type="checkbox" id="same_as_current"
                                                                        name="same_as_current"
                                                                        @if (Request::old('same_as_current') == $logged_in_user->address_1) checked @elseif($userDetails && $userDetails->permanent_address == $logged_in_user->address_1) checked @endif
                                                                        value="1"> {{ __('labels.frontend.user.profile.same_as_current_address') }}</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div id="perm_block"
                                                        @if ($userDetails && $userDetails->permanent_address == $logged_in_user->address_1) style="display:none;" @else style="" @endif>
                                                        <div class="row responsive-set-margin">
                                                            <div class="col-md-12">
                                                                <div class="form-group"
                                                                    style="margin-bottom:15px !important;">
                                                                    <label style="margin-bottom: 0.2rem;"
                                                                        class="required-field">{{ __('labels.frontend.user.profile.address') }}</label>
                                                                    <input type="text"
                                                                        class="form-control input-box-inner-style"
                                                                        name="permanent_address" maxlength="200"
                                                                        value="{{ $userDetails ? $userDetails->permanent_address : '' }}">
                                                                    <div class="invalid-feedback">
                                                                        {{ __('labels.frontend.user.profile.please_choose') }}
                                                                        {{ __('labels.frontend.user.profile.address') }}.
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row responsive-set-margin">
                                                            <div class="col-md-4">
                                                                <div class="form-group"
                                                                    style="margin-bottom:15px !important;">
                                                                    <label style="margin-bottom: 0.2rem;"
                                                                        class="required-field">{{ __('labels.frontend.user.profile.country') }}</label>
                                                                    <select
                                                                        class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                        id="per-country-dd" name="permanent_country">
                                                                        <option value="">
                                                                            {{ __('labels.frontend.user.profile.select') }}
                                                                        </option>
                                                                        @foreach ($countries as $country)
                                                                            <option value="{{ $country->id }}"
                                                                                @if (Request::old('permanent_country') == $country->id) selected @elseif($userDetails && $country->id == $userDetails->permanent_country) selected @endif>
                                                                                {{ $country->name }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                    <div class="invalid-feedback">
                                                                        {{ __('labels.frontend.user.profile.please_choose') }}
                                                                        {{ __('labels.frontend.user.profile.country') }}.
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label style="margin-bottom: 0.2rem;"
                                                                        class="required-field">{{ __('labels.frontend.user.profile.state') }}</label>
                                                                    <select
                                                                        class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                        name="permanent_state" id="per-state-dd">
                                                                    </select>
                                                                    <div class="invalid-feedback">
                                                                        {{ __('labels.frontend.user.profile.please_choose') }}
                                                                        {{ __('labels.frontend.user.profile.state') }}.
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label style="margin-bottom: 0.2rem;"
                                                                        class="required-field">{{ __('labels.frontend.user.profile.city') }}</label>
                                                                    <input type="text"
                                                                        class="form-control input-box-inner-style"
                                                                        name="permanent_city" id="per-city"
                                                                        value="@if (Request::old('permanent_city')) {{ Request::old('permanent_city') }}@elseif($userDetails && $userDetails->permanent_city) {{ $userDetails->permanent_city }} @endif">
                                                                    <div class="invalid-feedback">
                                                                        {{ __('labels.frontend.user.profile.please_choose') }}
                                                                        {{ __('labels.frontend.user.profile.city') }}.
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row responsive-set-margin">
                                                            <div class="col-md-4">
                                                                <div class="form-group"
                                                                    style="margin-bottom:15px !important;">
                                                                    <label style="margin-bottom: 0.2rem;"
                                                                        class="">{{ __('labels.frontend.user.profile.postal_code') }}</label>
                                                                    <input type="text"
                                                                        class="form-control input-box-inner-style"
                                                                        name="permanent_post_code" maxlength="20"
                                                                        value="@if (Request::old('permanent_post_code')) {{ Request::old('permanent_post_code') }}@elseif($userDetails && $userDetails->permanent_post_code) {{ $userDetails->permanent_post_code }} @endif">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row responsive-set-margin">
                                                        <hr class="my-5"
                                                            style="height:1px;border-width:0;background-color:#b6b4b482">
                                                        <h4 class="mt-4 mb-3">
                                                            {{ __('labels.frontend.user.profile.passport_information') }}</h4>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.name_as_per_passport') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    name="name_passport" maxlength="150"
                                                                    value="@if (Request::old('name_passport')) {{ Request::old('name_passport') }}@elseif($userDetails && $userDetails->name_passport){{ $userDetails->name_passport }} @endif">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.passport_no') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    name="passport_num" maxlength="50"
                                                                    value="@if (Request::old('passport_num')) {{ Request::old('passport_num') }}@elseif($userDetails && $userDetails->passport_num){{ $userDetails->passport_num }} @endif">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.issue_date') }}</label>
                                                                <input type="text"
                                                                    class="form-control  maritalDate issueDatePicker input-box-inner-style"
                                                                    name="issue_date" maxlength="50" onchange="expiryDate()"
                                                                    value="@if (Request::old('issue_date')) {{ date('d-m-Y', strtotime(Request::old('issue_date'))) }}@elseif($userDetails && $userDetails->passport_issue_date){{ date('d-m-Y', strtotime($userDetails->passport_issue_date)) }}" @endif "
                                                                    autocomplete="off">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.expiry_date') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style passportExpiryDate"
                                                                    name="expiry_date" maxlength="50"
                                                                    value="@if (Request::old('expiry_date')) {{ date('d-m-Y', strtotime(Request::old('expiry_date'))) }}@elseif($userDetails && $userDetails->passport_expiry_date){{ date('d-m-Y', strtotime($userDetails->passport_expiry_date)) }}@endif"
                                                                    autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label
                                                                    style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.issue_country') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    name="passport_country">
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('passport_country') == $country->id) selected @elseif($userDetails && $country->id == $userDetails->passport_country) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label
                                                                    style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.city_of_birth') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    name="city_of_birth"
                                                                    value="@if (Request::old('city_of_birth')) {{ Request::old('city_of_birth') }}@elseif($userDetails && $userDetails->city_of_birth){{ $userDetails->city_of_birth }} @endif">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label
                                                                    style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.country_of_birth') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    name="country_of_birth">
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('country_of_birth') == $country->id) selected @elseif($userDetails && $userDetails->country_of_birth == $country->id) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="row responsive-set-margin">
                                                        <hr class="my-5"
                                                            style="height:0.5px;border-width:0;background-color:#b6b4b482">
                                                        <h4 class="mb-3">
                                                            {{ __('labels.frontend.user.profile.nationality') }}</h4>
                                                        <div class="col-md-6 mt-1">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="mb-2">{{ __('labels.frontend.user.profile.citizen_of_more_than_one_country') }}</label>
                                                                <div>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border  form-check-input"
                                                                        name="dual_citizenship" id="no_dual"
                                                                        value="0"
                                                                        @if (Request::old('dual_citizenship') == '0') checked @elseif($userDetails && $userDetails->dual_citizenship == '0') checked @endif>
                                                                    <label class="custom-control-label ms-0 me-1"
                                                                        for="no_dual">{{ __('labels.general.no') }}</label>

                                                                    <input type="radio"
                                                                        class="radio-col-blue border ms-1 form-check-input"
                                                                        name="dual_citizenship" id="yes_dual"
                                                                        value="1"
                                                                        @if (Request::old('dual_citizenship') == '1') checked @elseif($userDetails && $userDetails->dual_citizenship == '1') checked @endif>
                                                                    <label class="custom-control-label ms-0"
                                                                        for="yes_dual">{{ __('labels.general.yes') }}</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6" id="select_dual_country"
                                                            @if ($userDetails) @if ($userDetails->dual_citizenship == '0' || $userDetails->dual_citizenship == '') style="display:none;" @else style="" @endif
                                                        @else style="display:none;" @endif
                                                            >
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field"> {{ __('labels.frontend.user.profile.country') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="dual_citizenship_country"
                                                                    name="dual_citizenship_country">
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('dual_citizenship_country') == $country->id) selected @elseif($userDetails && $country->id == $userDetails->dual_citizenship_country) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.country') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-6 mt-1">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="mb-2">{{ __('labels.frontend.user.profile.living_and_studying_in_any_other_country') }}</label>
                                                                <div>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border form-check-input"
                                                                        name="studying_abroad" id="no_studying_abroad"
                                                                        value="0"
                                                                        @if (Request::old('studying_abroad') == '0') checked @elseif($userDetails && $userDetails->studying_abroad == '0') checked @endif>
                                                                    <label class="custom-control-label ms-0 me-1"
                                                                        for="no_studying_abroad">{{ __('labels.general.no') }}</label>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border ms-1 form-check-input"
                                                                        name="studying_abroad" id="yes_studying_abroad"
                                                                        value="1"
                                                                        @if (Request::old('studying_abroad') == '1') checked @elseif($userDetails && $userDetails->studying_abroad == '1') checked @endif>
                                                                    <label class="custom-control-label ms-0"
                                                                        for="yes_studying_abroad">{{ __('labels.general.yes') }}</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6" id="select_studying_abroad_country"
                                                            @if ($userDetails) @if ($userDetails->studying_abroad == '0' || $userDetails->studying_abroad == '') style="display:none;" 
                                                    @else 
                                                        style="" @endif
                                                        @else style="display:none;" @endif
                                                            >
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field"> {{ __('labels.frontend.user.profile.country') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="studying_abroad_country"
                                                                    name="studying_abroad_country">
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('studying_abroad_country') == $country->id) selected @elseif($userDetails && $country->id == $userDetails->studying_abroad_country) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.select') }}
                                                                    {{ __('labels.frontend.user.profile.country') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <hr class="my-5"
                                                            style="height:1px;border-width:0;background-color:#b6b4b482">
                                                        <h4 class="mb-3">
                                                            {{ __('labels.frontend.user.profile.background_info') }}</h4>
                                                        <div class="col-md-6 mt-1">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="mb-2">{{ __('labels.frontend.user.profile.applied_for_immigration') }}</label>
                                                                <div>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border form-check-input"
                                                                        name="immigration" id="no_immigration"
                                                                        value="0"
                                                                        @if (Request::old('immigration') == '0') checked @elseif($userDetails && $userDetails->immigration == '0') checked @endif>
                                                                    <label class="custom-control-label ms-0 me-1"
                                                                        for="no_immigration">{{ __('labels.general.no') }}</label>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border ms-1 form-check-input"
                                                                        name="immigration" id="yes_immigration"
                                                                        value="1"
                                                                        @if (Request::old('immigration') == '1') checked @elseif($userDetails && $userDetails->immigration == '1') checked @endif>
                                                                    <label class="custom-control-label ms-0"
                                                                        for="yes_immigration">{{ __('labels.general.yes') }}</label>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6" id="select_immigration_country"
                                                            @if ($userDetails) @if ($userDetails->immigration == '0' || $userDetails->immigration == '') style="display:none;" 
                                                                           @else style="" @endif
                                                        @else style="display:none;" @endif
                                                            >
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field"> {{ __('labels.frontend.user.profile.country') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="immigration_country" name="immigration_country">
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('immigration_country') == $country->id) selected @elseif($userDetails && $country->id == $userDetails->immigration_country) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.country') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-6 mt-1">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="mb-2">{{ __('labels.frontend.user.profile.suffer_serious_medical_condition') }}</label>
                                                                <div>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border form-check-input"
                                                                        name="medical_condition" id="no_medical_condition"
                                                                        value="0"
                                                                        @if (Request::old('medical_condition') == '0') checked @elseif($userDetails && $userDetails->medical_condition == '0') checked @endif>
                                                                    <label class="custom-control-label me-1 ms-0"
                                                                        for="no_medical_condition">{{ __('labels.general.no') }}</label>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border ms-1 form-check-input"
                                                                        name="medical_condition"
                                                                        id="yes_medical_condition" value="1"
                                                                        @if (Request::old('medical_condition') == '1') checked @elseif($userDetails && $userDetails->medical_condition == '1') checked @endif>
                                                                    <label class="custom-control-labelms-2 ms-0"
                                                                        for="yes_medical_condition">{{ __('labels.general.yes') }}</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-6 mt-1">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="mb-2">{{ __('labels.frontend.user.profile.visa_refusal') }}</label>
                                                                <div>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border form-check-input"
                                                                        name="visa_refusal" id="no_visa_refusal"
                                                                        value="0"
                                                                        @if (Request::old('visa_refusal') == '0') checked @elseif($userDetails && $userDetails->visa_refusal == '0') checked @endif>
                                                                    <label class="custom-control-label ms-0 me-1"
                                                                        for="no_visa_refusal">{{ __('labels.general.no') }}</label>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border ms-1 form-check-input"
                                                                        name="visa_refusal" id="yes_visa_refusal"
                                                                        value="1"
                                                                        @if (Request::old('visa_refusal') == '1') checked @elseif($userDetails && $userDetails->visa_refusal == '1') checked @endif>
                                                                    <label class="custom-control-label ms-0"
                                                                        for="yes_visa_refusal">{{ __('labels.general.yes') }}</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6" id="select_visa_refusal_country"
                                                            @if ($userDetails) @if ($userDetails->visa_refusal == '0' || $userDetails->visa_refusal == '') style="display:none;" 
                                        @else 
                                            style="" @endif
                                                        @else style="display:none;" @endif
                                                            >
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="required-field"> {{ __('labels.frontend.user.profile.country') }}</label>
                                                                <select
                                                                    class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                                    id="visa_refusal_country" name="visa_refusal_country">
                                                                    <option value="">
                                                                        {{ __('labels.frontend.user.profile.select') }}
                                                                    </option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if (Request::old('visa_refusal_country') == $country->id) selected @elseif($userDetails && $country->id == $userDetails->visa_refusal_country) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <div class="invalid-feedback">
                                                                    {{ __('labels.frontend.user.profile.please_choose') }}
                                                                    {{ __('labels.frontend.user.profile.country') }}.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-6 mt-1">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="mb-2">{{ __('labels.frontend.user.profile.ever_been_convicted') }}</label>
                                                                <div>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border form-check-input"
                                                                        name="criminal_offence" id="no_criminal_offence"
                                                                        value="0"
                                                                        @if (Request::old('criminal_offence') == '0') checked @elseif($userDetails && $userDetails->criminal_offence == '0') checked @endif>
                                                                    <label class="custom-control-label ms-0 me-1"
                                                                        for="no_criminal_offence">{{ __('labels.general.no') }}</label>
                                                                    <input type="radio"
                                                                        class="radio-col-blue border ms-1 form-check-input"
                                                                        name="criminal_offence" id="yes_criminal_offence"
                                                                        value="1"
                                                                        @if (Request::old('criminal_offence') == '1') checked @elseif($userDetails && $userDetails->criminal_offence == '1') checked @endif>
                                                                    <label class="custom-control-label ms-0"
                                                                        for="yes_criminal_offence">{{ __('labels.general.yes') }}</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row responsive-set-margin">
                                                        <hr class="my-5"
                                                            style="height:1px;border-width:0;background-color:#b6b4b482">
                                                        <h4 class="mb-3">
                                                            {{ __('labels.frontend.user.profile.emergency_contacts') }}</h4>
                                                        <div class="col-md-6">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label
                                                                    style="margin-bottom: 0.2rem;">{{ __('labels.backend.access.users.table.name') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    name="emergency_name" maxlength="20"
                                                                    value="@if (Request::old('emergency_name')) {{ Request::old('emergency_name') }} @elseif($userDetails && $userDetails->emergency_name) {{ $userDetails->emergency_name }} @endif">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;">Relationship with
                                                                    Applicant</label>
                                                                <input type="text" class="form-control validate_inpt" style="height: 39px;"
                                                                    name="emergency_relation" maxlength="20"
                                                                    value="{{ $userDetails ? $userDetails->emergency_relation : '' }}">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label
                                                                    style="margin-bottom: 0.2rem;">{{ __('labels.backend.access.users.table.phone') }}</label>
                                                                <input type="text"
                                                                    class="form-control input-box-inner-style"
                                                                    name="emergency_phone"
                                                                    minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}"
                                                                    maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}"
                                                                    value="@if (Request::old('emergency_phone')) {{ Request::old('emergency_phone') }} @elseif($userDetails && $userDetails->emergency_phone) {{ $userDetails->emergency_phone }} @endif">
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.backend.access.users.table.email') }}</label>
                                                                <input type="email"
                                                                    class="form-control input-box-inner-style"
                                                                    name="emergency_email" maxlength="20"
                                                                    value="@if (Request::old('emergency_email')) {{ Request::old('emergency_email') }} @elseif($userDetails && $userDetails->emergency_email) {{ $userDetails->emergency_email }} @endif">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row responsive-set-margin">
                                                        <div class="col-md-8">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.address') }}</label>
                                                                <input type="text" class="form-control validate_inpt"
                                                                    name="emergency_address" maxlength="100"
                                                                    value="{{ $userDetails ? $userDetails->emergency_address : '' }}">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class=""> {{ __('labels.frontend.user.profile.country') }}</label>
                                                                <select class="form-control form-select shadow-none text-dark border"
                                                                    id="emergency_country-dd" name="emergency_country">
                                                                    <option value="">Select</option>
                                                                    @foreach ($countries as $country)
                                                                        <option value="{{ $country->id }}"
                                                                            @if ($country->id == $userDetails->emergency_country) selected @endif>
                                                                            {{ $country->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.state') }}</label>
                                                                <select class="form-control form-select shadow-none text-dark border"
                                                                    name="emergency_state" id="emergency_state-dd">
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label style="margin-bottom: 0.2rem;">{{ __('labels.frontend.user.profile.city') }}</label>
                                                                <input type="text" class="form-control" maxlength="50"
                                                                    placeholder="City" name="emergency_city"
                                                                    maxlength="100"
                                                                    value="{{ $userDetails ? $userDetails->emergency_city : '' }}"
                                                                    id="emergency_city">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group"
                                                                style="margin-bottom:15px !important;">
                                                                <label style="margin-bottom: 0.2rem;"
                                                                    class="">{{ __('labels.frontend.user.profile.postal_code') }}</label>
                                                                <input type="text" class="form-control"
                                                                    placeholder="Postal Code" name="emergency_postalcode"
                                                                    value="{{ $userDetails ? $userDetails->emergency_postalcode : '' }}"
                                                                    maxlength="10">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="mt-4 mb-4 text-center">
                                                        <button type="submit" class="btn btn-themecolor btn-themecolor"
                                                            style="padding-left:40px;padding-right:40px;">{{ __('labels.general.buttons.save') }}</button>
                                                    </div>
                                        </form>
                                    </div>
                                </div>
                                @if (get_site_config('academic_details_in_profile'))
                                    <div class="card card-outline-info sub-card" style="margin-bottom:0;margin-top:30px;">
                                        <a class="collapsed" href="#collapseAcademic" data-toggle="collapse"
                                            aria-expanded="false" aria-controls="collapseAcademic">
                                            <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-1 d-flex align-items-center"
                                                style="">
                                                <i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>
                                                {{ __('labels.frontend.user.profile.academic_details') }}
                                            </div>
                                        </a>
                                    </div>

                                    <div id="collapseAcademic" class="collapse responsive-set-margin-blocks">
                                        <input type="hidden" name="user_id" value="">
                                        <div class="card-body">
                                            <div class="table-responsive mt-4 sub-card">
                                                <table class="table table-striped table-hover table-bordered fs-15">
                                                    <thead>
                                                        <tr>
                                                            <th style="min-width: 155px !important;">{{ __('labels.frontend.user.profile.education_level') }}</th>
                                                            <th style="min-width: 137px !important;">{{ __('labels.frontend.user.profile.course') }} {{ __('labels.frontend.user.profile.name') }}</th>
                                                            <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.institute') }}</th>
                                                            <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.university_board') }}</th>
                                                            <th style="min-width: 185px !important;">{{ __('labels.frontend.user.profile.country_of_institute') }}</th>
                                                            <th style="min-width: 132px !important;">{{ __('labels.frontend.user.profile.campus_or_city') }}</th>
                                                            <th style="min-width: 126px !important;">{{ __('labels.frontend.user.profile.postal_code') }}</th>
                                                            <th style="min-width: 115px !important;">{{ __('labels.frontend.user.profile.start_year') }}</th>
                                                            <th style="min-width: 165px !important;">{{ __('labels.frontend.user.profile.completion_date') }}</th>
                                                            <th style="min-width: 142px !important;">{{ __('labels.frontend.user.profile.course') }} {{ __('labels.backend.access.users.tabs.content.overview.status') }}</th>
                                                            <th style="min-width: 100px !important;">{{ __('labels.frontend.user.profile.marks') }}  %</th>
                                                            <th style="min-width: 120px !important;">{{ __('labels.general.actions') }} </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if (count($profile_academics) != 0)
                                                            @foreach ($profile_academics as $profile_academic)
                                                                <tr>
                                                                    <td>
                                                                        @if ($profile_academic->education_level == 10 || $profile_academic->education_level == 12)
                                                                            {{ $profile_academic->education_level }}
                                                                            <sup
                                                                                class="text-sm font-weight-bold">th</sup>@else{{ $profile_academic->education_level }}
                                                                        @endif
                                                                    </td>
                                                                    <td style="min-width: 120px;">
                                                                        {{ $profile_academic->course_name }}</td>
                                                                    <td style="min-width: 200px;">
                                                                        {{ $profile_academic->institute }}</td>
                                                                    <td style="min-width: 120px;">
                                                                        {{ $profile_academic->university }}</td>
                                                                    <td>{{ get_country_name($profile_academic->institute_country) }}
                                                                    </td>
                                                                    <td>{{ $profile_academic->campus_city }}</td>
                                                                    <td>{{ $profile_academic->postal_code }}</td>
                                                                    <td>
                                                                        @if ($profile_academic->start_year)
                                                                            {{ $profile_academic->start_year }}
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        @if ($profile_academic->pass_year)
                                                                            {{ $profile_academic->pass_year }}
                                                                        @endif
                                                                    </td>
                                                                    <td>{{ $profile_academic->course_status }}</td>
                                                                    <td>
                                                                        @if ($profile_academic->percent_cgpa)
                                                                            {{ $profile_academic->percent_cgpa }} %
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        <div class="d-flex">
                                                                            <button id="data-id"
                                                                                class="btn btn-sm btn-outline-primary editProfileAcademics "
                                                                                data-id="{{ $profile_academic->id }}"
                                                                                data-placement="top" title="Edit"><i
                                                                                    class="fa fa-edit"></i>
                                                                            </button>

                                                                            <form  action="{{ route('frontend.user.profile.academics_information.delete') }}"
                                                        method="POST"
                                                                                onSubmit="if(!confirm('Are you sure want to delete this Academic Information?')){return false;}">
                                                                                @csrf
                                                                                <input type="hidden" name="id"
                                                                                    value="{{ $profile_academic->id }}">
                                                                                <input type="hidden" name="userid"
                                                                                    value="{{ $profile_academic->userid }}">

                                                                                <button title="Delete" type="submit"
                                                                                    class="btn btn-sm btn-outline-danger mx-1"><i
                                                                                        class="fa fa-trash"></i></button>
                                                                            </form>

                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        @else
                                                            <tr>
                                                                <td colspan="12" class="text-center">No Records
                                                                    Found
                                                                </td>
                                                            </tr>
                                                        @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                            <br>
                                            @if (count($profile_academics) == 0)  
                                                <button class="btn btn-themecolor addProfileAcademics" data-placement="top"
                                                    title="Add More"><i class="fa fa-plus mx-1"></i>
                                                    {{ __('labels.frontend.user.profile.add_new') }}</button>
                                            @else
                                                <button class="btn btn-themecolor addProfileAcademics" data-placement="top"
                                                    title="Add More"><i class="fa fa-plus mx-1"></i>
                                                    {{ __('labels.frontend.user.profile.add_more') }}</button>

                                            @endif
                                        </div>

                                    </div>

                                    <div class="card card-outline-info sub-card" style="margin-bottom:0;margin-top:30px;">
                                        <a class="collapsed" href="#collapseLanguage" data-toggle="collapse"
                                            aria-expanded="false" aria-controls="collapseLanguage">
                                            <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-1 d-flex align-items-center"
                                                style="">
                                                <i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>
                                                {{ __('labels.frontend.user.profile.tests_Foreign_languages') }}
                                            </div>
                                        </a>
                                    </div>
                                    <div id="collapseLanguage" class="collapse responsive-set-margin-blocks">
                                        <form method="post"
                                            action="{{ route('frontend.user.studyabroad.profile.lang.save') }}">
                                            @csrf
                                            @php
                                                $languages = ['IELTS', 'TOEFL', 'PTE'];
                                            @endphp
                                            <input type="hidden" name="user_id" value="{{ Auth::user()->id }}">
                                            <div class=" card-body">
                                                <p class="mb-1 mt-3" id="eng_one_lang_checks">
                                                    <label class="checkbox-inline"
                                                        style="margin-right: 5px;cursor:pointer;">
                                                        <input class="form-check-input border" type="checkbox" value=""
                                                            @if (isset($eng[$languages[0]]) &&
                                                                    ($eng[$languages[0]]['overall_score'] ||
                                                                        $eng[$languages[0]]['speaking'] ||
                                                                        $eng[$languages[0]]['reading'] ||
                                                                        $eng[$languages[0]]['listening'] ||
                                                                        $eng[$languages[0]]['writing'])) checked @endif
                                                            id="IELTS_checkbox" onclick="show_hide_eng('IELTS')"> &nbsp;IELTS
                                                    </label>
                                                    <label class="checkbox-inline"
                                                        style="margin-right: 5px;cursor:pointer;">
                                                        <input class="form-check-input border" type="checkbox" value=""
                                                            @if (isset($eng[$languages[0]]) &&
                                                                    ($eng[$languages[1]]['overall_score'] ||
                                                                        $eng[$languages[1]]['speaking'] ||
                                                                        $eng[$languages[1]]['reading'] ||
                                                                        $eng[$languages[1]]['listening'] ||
                                                                        $eng[$languages[1]]['writing'])) checked @endif
                                                            id="TOEFL_checkbox" onclick="show_hide_eng('TOEFL')"> &nbsp;TOEFL
                                                    </label>
                                                    <label class="checkbox-inline"
                                                        style="margin-right: 5px;cursor:pointer;">
                                                        <input class="form-check-input border" type="checkbox" value=""
                                                            @if (isset($eng[$languages[0]]) &&
                                                                    ($eng[$languages[2]]['overall_score'] ||
                                                                        $eng[$languages[2]]['speaking'] ||
                                                                        $eng[$languages[2]]['reading'] ||
                                                                        $eng[$languages[2]]['listening'] ||
                                                                        $eng[$languages[2]]['writing'])) checked @endif
                                                            id="PTE_checkbox" onclick="show_hide_eng('PTE')"> &nbsp;PTE
                                                    </label>
                                                </p>
                                                <div class="table-responsive mt-4 sub-card" id="english_lang_table"
                                                    @if (!(@isset($eng[$languages[0]]) || @isset($eng[$languages[1]]) || @isset($eng[$languages[2]]))) style="display: none;" @endif>
                                                    <table class="table">
                                                        <thead>
                                                            <tr>
                                                                <th>Exam</th>
                                                                <th>Overall Score</th>
                                                                <th>Speaking</th>
                                                                <th>Reading</th>
                                                                <th>Listening</th>
                                                                <th>Writing</th>
                                                                <th>Score expiry Date</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @for ($i = 0; $i < count($languages); $i++)
                                                                <tr id="{{ $languages[$i] }}"
                                                                    @if (isset($eng[$languages[$i]]) &&
                                                                            !$eng[$languages[$i]]['overall_score'] &&
                                                                            !$eng[$languages[$i]]['speaking'] &&
                                                                            !$eng[$languages[$i]]['reading'] &&
                                                                            !$eng[$languages[$i]]['listening'] &&
                                                                            !$eng[$languages[$i]]['writing']
                                                                    ) style="display: none;" @endif>
                                                                    <td>{{ $languages[$i] }}</td>
                                                                    @isset($eng[$languages[$i]])
                                                                        <td style="min-width: 110px !important;">
                                                                            <input type="text"
                                                                                name='eng[<?= $languages[$i] ?>][overall_score]'
                                                                                class='form-control input-box-inner-style'
                                                                                value="{{ $eng[$languages[$i]]['overall_score'] }}" />
                                                                        </td>
                                                                        <td style="min-width: 110px !important;">
                                                                            <input type="text"
                                                                                name='eng[<?= $languages[$i] ?>][speaking]'
                                                                                class='form-control input-box-inner-style'
                                                                                value="{{ $eng[$languages[$i]]['speaking'] }}" />
                                                                        </td>
                                                                        <td style="min-width: 110px !important;">
                                                                            <input type="text"
                                                                                name='eng[<?= $languages[$i] ?>][reading]'
                                                                                class='form-control input-box-inner-style'
                                                                                value="{{ $eng[$languages[$i]]['reading'] }}" />
                                                                        </td>
                                                                        <td>
                                                                            <input type="text"
                                                                                name='eng[<?= $languages[$i] ?>][listening]'
                                                                                class='form-control input-box-inner-style'
                                                                                value="{{ $eng[$languages[$i]]['listening'] }}" />
                                                                        </td>
                                                                        <td style="min-width: 110px !important;">
                                                                            <input type="text"
                                                                                name='eng[<?= $languages[$i] ?>][writing]'
                                                                                class='form-control input-box-inner-style'
                                                                                value="{{ $eng[$languages[$i]]['writing'] }}" />
                                                                        </td>
                                                                        <td style="min-width: 200px !important;">
                                                                            <input type="text"
                                                                                name='eng[<?= $languages[$i] ?>][expiry_date]'
                                                                                class='form-control mydatepicker input-box-inner-style'
                                                                                placeholder="dd-mm-yyyy" @if ($eng[$languages[$i]]['expiry_date'])
                                                                            value="{{ date('d-m-Y', strtotime($eng[$languages[$i]]['expiry_date'])) }}"
                                                                @endif style="min-width:100px;" />
                                                                </td>
                                                            @else
                                                                <td style="min-width: 110px !important;">
                                                                    <input type="text"
                                                                        name='eng[<?= $languages[$i] ?>][overall_score]'
                                                                        class='form-control input-box-inner-style' value="" />
                                                                </td>
                                                                <td style="min-width: 110px !important;">
                                                                    <input type="text"
                                                                        name='eng[<?= $languages[$i] ?>][speaking]'
                                                                        class='form-control input-box-inner-style' value="" />
                                                                </td>
                                                                <td style="min-width: 110px !important;">
                                                                    <input type="text"
                                                                        name='eng[<?= $languages[$i] ?>][reading]'
                                                                        class='form-control input-box-inner-style' value="" />
                                                                </td>
                                                                <td style="min-width: 110px !important;">
                                                                    <input type="text"
                                                                        name='eng[<?= $languages[$i] ?>][listening]'
                                                                        class='form-control input-box-inner-style' value="" />
                                                                </td>
                                                                <td style="min-width: 110px !important;">
                                                                    <input type="text"
                                                                        name='eng[<?= $languages[$i] ?>][writing]'
                                                                        class='form-control input-box-inner-style' value="" />
                                                                </td>
                                                                <td style="min-width: 200px !important;">
                                                                    <input type="text"
                                                                        name='eng[<?= $languages[$i] ?>][expiry_date]'
                                                                        class='form-control mydatepicker input-box-inner-style'
                                                                        placeholder="dd-mm-yyyy" value=""
                                                                        style="min-width:100px;" />
                                                                </td>
                                                            @endisset
                                                            </tr>
                                @endfor
                                </tbody>
                                </table>
                            </div>

                            <!-- -------------//DET------------ -->
                            <p class="mb-1 mt-3" id="eng_two_lang_checks">
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if ($det_overall_score) checked @endif id="DET_checkbox"
                                        onclick="show_hide_det('DET')"> DET
                                </label>
                            </p>
                            <div class="table-responsive mt-4 sub-card" id="det_lang_table"
                                @if (!$det_overall_score) style="display: none;" @endif>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            {{-- <th>Exam</th> --}}
                                            <th>Overall Score</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr id="DET"
                                            @if (!$det_overall_score) style="display: none;" @endif>
                                            {{-- <td>DET</td> --}}
                                            <td>
                                                <input type="text" name='det_overall_score' class='form-control input-box-inner-style'
                                                    value="{{ $det_overall_score }}" />
                                            </td>
                                            <td>
                                                <input type="text" name='det_expiry_date'
                                                    class='form-control mydatepicker input-box-inner-style' placeholder="dd-mm-yyyy"
                                                    @if ($det_expiry_date) value="{{ date('d-m-Y', strtotime($det_expiry_date)) }}" @endif
                                                    style="min-width:100px;" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- -------------//ACT------------ -->
                            <p class="mb-1 mt-3" id="eng_three_lang_checks">
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if ($act_overall_score || $act_math || $act_reading || $act_writing || $act_science || $act_english) checked @endif id="ACT_checkbox"
                                        onclick="show_hide_act('ACT')"> ACT
                                </label>
                            </p>
                            <div class="table-responsive mt-4 sub-card" id="act_lang_table"
                                @if (!($act_overall_score || $act_math || $act_reading || $act_writing || $act_science || $act_english)) style="display: none;" @endif>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            {{-- <th>Exam</th> --}}
                                            <th>Overall Score</th>
                                            <th>Math</th>
                                            <th>Reading</th>
                                            <th>Writing</th>
                                            <th>Science</th>
                                            <th>English</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr id="ACT"
                                            @if (!($act_overall_score || $act_math || $act_reading || $act_writing || $act_science || $act_english)) style="display: none;" @endif>
                                            {{-- <td>ACT</td> --}}
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='act_overall_score' class='form-control input-box-inner-style'
                                                    value="{{ $act_overall_score }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='act_math' class='form-control input-box-inner-style'
                                                    value="{{ $act_math }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='act_reading' class='form-control input-box-inner-style'
                                                    value="{{ $act_reading }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='act_writing' class='form-control input-box-inner-style'
                                                    value="{{ $act_writing }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='act_science' class='form-control input-box-inner-style'
                                                    value="{{ $act_science }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='act_english' class='form-control input-box-inner-style'
                                                    value="{{ $act_english }}" />
                                            </td>
                                            <td style="min-width: 200px !important;">
                                                <input type="text" name='act_expiry_date'
                                                    class='form-control mydatepicker input-box-inner-style' placeholder="dd-mm-yyyy"
                                                    @if ($act_expiry_date) value="{{ date('d-m-Y', strtotime($act_expiry_date)) }}" @endif
                                                    style="min-width:100px;" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- -------------//SAT------------ -->
                            <p class="mb-1 mt-3" id="eng_four_lang_checks">
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if ($sat_overall_score || $sat_math || $sat_reading || $sat_writing || $sat_essay) checked @endif id="SAT_checkbox"
                                        onclick="show_hide_sat('SAT')"> SAT
                                </label>
                            </p>
                            <div class="table-responsive mt-4 sub-card" id="sat_lang_table"
                                @if (!($sat_overall_score || $sat_math || $sat_reading || $sat_writing || $sat_essay)) style="display: none;" @endif>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            {{-- <th>Exam</th> --}}
                                            <th>Overall Score</th>
                                            <th>Math</th>
                                            <th>Reading</th>
                                            <th>Writing</th>
                                            <th>Essay</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr id="SAT"
                                            @if (!($sat_overall_score || $sat_math || $sat_reading || $sat_writing || $sat_essay)) style="display: none;" @endif>
                                            {{-- <td>SAT</td> --}}
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='sat_overall_score' class='form-control input-box-inner-style'
                                                    value="{{ $sat_overall_score }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='sat_math' class='form-control input-box-inner-style'
                                                    value="{{ $sat_math }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='sat_reading' class='form-control input-box-inner-style'
                                                    value="{{ $sat_reading }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='sat_writing' class='form-control input-box-inner-style'
                                                    value="{{ $sat_writing }}" />
                                            </td>
                                            <td style="min-width: 110px !important;">
                                                <input type="text" name='sat_essay' class='form-control input-box-inner-style'
                                                    value="{{ $sat_essay }}" />
                                            </td>
                                            <td style="min-width: 200px !important;">
                                                <input type="text" name='sat_expiry_date'
                                                    class='form-control mydatepicker input-box-inner-style' placeholder="dd-mm-yyyy"
                                                    @if ($sat_expiry_date) value="{{ date('d-m-Y', strtotime($sat_expiry_date)) }}" @endif
                                                    style="min-width:100px;" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <p class="mb-1 mt-3" id="gre_gmat_lang_checks">
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if (
                                            $exam['gre']['total_score'] ||
                                                $exam['gre']['verbal'] ||
                                                $exam['gre']['quantitative'] ||
                                                $exam['gre']['analytical'] ||
                                                $exam['gre']['integrated']
                                        ) checked @endif id="GRE_checkbox"
                                        onclick="show_hide_gre_gmat('GRE')"> GRE
                                </label>
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if (
                                            $exam['gmat']['total_score'] ||
                                                $exam['gmat']['verbal'] ||
                                                $exam['gmat']['quantitative'] ||
                                                $exam['gmat']['analytical'] ||
                                                $exam['gmat']['integrated']
                                        ) checked @endif id="GMAT_checkbox"
                                        onclick="show_hide_gre_gmat('GMAT')"> GMAT
                                </label>
                            </p>
                            <div class="table-responsive mt-4 sub-card" id="gre_gmat_lang_table"
                                @if (
                                    !(
                                        $exam['gmat']['total_score'] ||
                                        $exam['gmat']['verbal'] ||
                                        $exam['gmat']['quantitative'] ||
                                        $exam['gmat']['analytical'] ||
                                        $exam['gmat']['integrated'] ||
                                        $exam['gre']['total_score'] ||
                                        $exam['gre']['verbal'] ||
                                        $exam['gre']['quantitative'] ||
                                        $exam['gre']['analytical'] ||
                                        $exam['gre']['integrated']
                                    )) style="display: none;" @endif>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Exam</th>
                                            <th>Total Score</th>
                                            <th>Verbal Reasoning</th>
                                            <th>Quantitative</th>
                                            <th>Analytical</th>
                                            <th>Integrated</th>
                                            <th>Expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr id="GRE"
                                            @if (
                                                !(
                                                    $exam['gre']['total_score'] ||
                                                    $exam['gre']['verbal'] ||
                                                    $exam['gre']['quantitative'] ||
                                                    $exam['gre']['analytical'] ||
                                                    $exam['gre']['integrated']
                                                )) style="display: none;" @endif>
                                            <td>GRE</td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gre][total_score]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gre']['total_score'] }}"
                                                    onkeyup='validnum(this.value,"total_gre");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="total_gre_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GRE Total score
                                                    range is: 260 to
                                                    340</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gre][verbal]" class="form-control input-box-inner-style"
                                                    value="{{ $exam['gre']['verbal'] }}"
                                                    onkeyup='validnum(this.value,"verbal_gre");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="verbal_gre_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GRE Verbal
                                                    Reasoning range is: 130 to
                                                    170</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gre][quantitative]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gre']['quantitative'] }}"
                                                    onkeyup='validnum(this.value,"quant_gre");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="quant_gre_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GRE Quantitative
                                                    range is: 130 to
                                                    170</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gre][analytical]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gre']['analytical'] }}"
                                                    onkeyup='validnum(this.value,"ana_gre");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="ana_gre_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GRE Analytical
                                                    score range is: 0 to
                                                    6</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gre][integrated]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gre']['integrated'] }}"
                                                    onkeyup='validnum(this.value,"inte_gre");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="inte_gre_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GRE Integrated
                                                    score range is: 260 to
                                                    340</span>
                                            </td>
                                            <td style="min-width: 200px !important;">
                                                <input type="text" name="exam[gre][expiry_date]"
                                                    class="form-control mydatepicker input-box-inner-style" placeholder="dd-mm-yyyy"
                                                    @if ($exam['gre']['expiry_date']) value="{{ date('d-m-Y', strtotime($exam['gre']['expiry_date'])) }}" @endif
                                                    style="min-width:120px;" autocomplete="off" />
                                            </td>

                                        </tr>
                                        <tr
                                            id="GMAT"@if (
                                                !(
                                                    $exam['gmat']['total_score'] ||
                                                    $exam['gmat']['verbal'] ||
                                                    $exam['gmat']['quantitative'] ||
                                                    $exam['gmat']['analytical'] ||
                                                    $exam['gmat']['integrated']
                                                )) style="display: none;" @endif>
                                            <td>GMAT</td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gmat][total_score]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gmat']['total_score'] }}"
                                                    onkeyup='validnum(this.value,"total_gmat");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="total_gmat_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GMAT Total score
                                                    range is: 200 to
                                                    800</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gmat][verbal]" class="form-control input-box-inner-style"
                                                    value="{{ $exam['gmat']['verbal'] }}"
                                                    onkeyup='validnum(this.value,"verbal_gmat");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="verbal_gmat_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GMAT Verbal
                                                    Reasoning range is: 0 to
                                                    60</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gmat][quantitative]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gmat']['quantitative'] }}"
                                                    onkeyup='validnum(this.value,"quant_gmat");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="quant_gmat_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GMAT
                                                    Quantitative range is: 0 to
                                                    60</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gmat][analytical]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gmat']['analytical'] }}"
                                                    onkeyup='validnum(this.value,"ana_gmat");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="ana_gmat_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GMAT Analytical
                                                    score range is: 0 to
                                                    6</span>
                                            </td>
                                            <td style="min-width: 130px !important;">
                                                <input type="number" name="exam[gmat][integrated]"
                                                    class="form-control input-box-inner-style" value="{{ $exam['gmat']['integrated'] }}"
                                                    onkeyup='validnum(this.value,"inte_gmat");'
                                                    onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                                                <span id="inte_gmat_err" class="text-danger d-none"
                                                    style="font-size: 10px;">GMAT Integrated
                                                    score range is: 1 to
                                                    8</span>
                                            </td>
                                            <td style="min-width: 200px !important;">
                                                <input type="text" name="exam[gmat][expiry_date]"
                                                    class="form-control mydatepicker input-box-inner-style" placeholder="dd-mm-yyyy"
                                                    @if ($exam['gmat']['expiry_date']) value="{{ date('d-m-Y', strtotime($exam['gmat']['expiry_date'])) }}" @endif
                                                    style="min-width:120px;" autocomplete="off" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h5 class="mt-3">Other Language Certifications</h5>
                            @php
                                $languages = ['German', 'French', 'Spanish', 'Japanese'];
                            @endphp
                            <p class="mb-1" id="other_lang_checks">
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if (isset($lang[$languages[0]]) &&
                                                ($lang[$languages[0]]['level'] ||
                                                    $lang[$languages[0]]['overall_score'] ||
                                                    $lang[$languages[0]]['speaking'] ||
                                                    $lang[$languages[0]]['reading'] ||
                                                    $lang[$languages[0]]['writing'] ||
                                                    $lang[$languages[0]]['institute'] ||
                                                    $lang[$languages[0]]['listening'])) checked @endif id="german"
                                        onclick="show_hide_lang('german')"> German
                                </label>
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if (isset($lang[$languages[1]]) &&
                                                ($lang[$languages[1]]['level'] ||
                                                    $lang[$languages[1]]['overall_score'] ||
                                                    $lang[$languages[1]]['speaking'] ||
                                                    $lang[$languages[1]]['reading'] ||
                                                    $lang[$languages[1]]['writing'] ||
                                                    $lang[$languages[1]]['institute'] ||
                                                    $lang[$languages[1]]['listening'])) checked @endif id="french"
                                        onclick="show_hide_lang('french')"> French
                                </label>
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if (isset($lang[$languages[2]]) &&
                                                ($lang[$languages[2]]['level'] ||
                                                    $lang[$languages[2]]['overall_score'] ||
                                                    $lang[$languages[2]]['speaking'] ||
                                                    $lang[$languages[2]]['reading'] ||
                                                    $lang[$languages[2]]['writing'] ||
                                                    $lang[$languages[2]]['institute'] ||
                                                    $lang[$languages[2]]['listening'])) checked @endif id="spanish"
                                        onclick="show_hide_lang('spanish')"> Spanish
                                </label>
                                <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                    <input class="form-check-input border" type="checkbox" value=""
                                        @if (isset($lang[$languages[3]]) &&
                                                ($lang[$languages[3]]['level'] ||
                                                    $lang[$languages[3]]['overall_score'] ||
                                                    $lang[$languages[3]]['speaking'] ||
                                                    $lang[$languages[3]]['reading'] ||
                                                    $lang[$languages[3]]['writing'] ||
                                                    $lang[$languages[3]]['institute'] ||
                                                    $lang[$languages[3]]['listening'])) checked @endif id="japanese"
                                        onclick="show_hide_lang('japanese')"> Japanese
                                </label>
                            </p>
                            <div class="table-responsive sub-card" id="other_lang_table"
                                @if (
                                    !(
                                        @isset($lang[$languages[0]]) ||
                                        @isset($lang[$languages[1]]) ||
                                        @isset($lang[$languages[2]]) ||
                                        @isset($lang[$languages[3]])
                                    )) style="display: none;" @endif>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Language</th>
                                            <th>Level</th>
                                            <th>Overall Score</th>
                                            <th>Speaking</th>
                                            <th>Reading</th>
                                            <th>Listening</th>
                                            <th>Writing</th>
                                            <th>Institute</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @for ($i = 0; $i < count($languages); $i++)
                                            <tr id="{{ strtolower($languages[$i]) }}_tr"
                                                @if (
                                                    !(isset($lang[$languages[$i]]) &&
                                                        ($lang[$languages[$i]]['level'] ||
                                                            $lang[$languages[$i]]['overall_score'] ||
                                                            ($lang[$languages[$i]]['speaking'] && $lang[$languages[$i]]['reading']) ||
                                                            $lang[$languages[$i]]['writing'] ||
                                                            $lang[$languages[$i]]['institute'] ||
                                                            $lang[$languages[$i]]['listening'])
                                                    )) style="display: none;" @endif>
                                                <td>{{ $languages[$i] }}</td>

                                                @isset($lang[$languages[$i]])
                                                    <td style="min-width: 130px !important;">
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][level]'
                                                            class='form-control input-box-inner-style'
                                                            value="{{ $lang[$languages[$i]]['level'] }}" />
                                                    </td>
                                                    <td style="min-width: 130px !important;">
                                                        <input type="text"
                                                            name='lang[<?= $languages[$i] ?>][overall_score]'
                                                            class='form-control input-box-inner-style'
                                                            value="{{ $lang[$languages[$i]]['overall_score'] }}" />
                                                    </td>
                                                    <td style="min-width: 130px !important;">
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][speaking]'
                                                            class='form-control input-box-inner-style'
                                                            value="{{ $lang[$languages[$i]]['speaking'] }}" />
                                                    </td>
                                                    <td style="min-width: 130px !important;">
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][reading]'
                                                            class='form-control input-box-inner-style'
                                                            value="{{ $lang[$languages[$i]]['reading'] }}" />
                                                    </td>
                                                    <td style="min-width: 130px !important;">
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][listening]'
                                                            class='form-control input-box-inner-style'
                                                            value="{{ $lang[$languages[$i]]['listening'] }}" />
                                                    </td>
                                                    <td style="min-width: 130px !important;">
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][writing]'
                                                            class='form-control input-box-inner-style'
                                                            value="{{ $lang[$languages[$i]]['writing'] }}" />
                                                    </td>
                                                    <td style="min-width: 130px !important;">
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][institute]'
                                                            class='form-control input-box-inner-style'
                                                            value="{{ $lang[$languages[$i]]['institute'] }}"
                                                            style="min-width:100px;" />
                                                    </td>
                                                @else
                                                    <td>
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][level]'
                                                            class='form-control input-box-inner-style' value="" />
                                                    </td>
                                                    <td>
                                                        <input type="text"
                                                            name='lang[<?= $languages[$i] ?>][overall_score]'
                                                            class='form-control input-box-inner-style' value="" />
                                                    </td>
                                                    <td>
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][speaking]'
                                                            class='form-control input-box-inner-style' value="" />
                                                    </td>
                                                    <td>
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][reading]'
                                                            class='form-control input-box-inner-style' value="" />
                                                    </td>
                                                    <td>
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][listening]'
                                                            class='form-control input-box-inner-style' value="" />
                                                    </td>
                                                    <td>
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][writing]'
                                                            class='form-control input-box-inner-style' value="" />
                                                    </td>
                                                    <td>
                                                        <input type="text" name='lang[<?= $languages[$i] ?>][institute]'
                                                            class='form-control input-box-inner-style' value=""
                                                            style="min-width:100px;" />
                                                    </td>
                                                @endisset
                                            </tr>
                                        @endfor

                                    </tbody>
                                </table>
                            </div>

                            <div class="mt-4 text-center">
                                <button type="submit" class="btn btn-themecolor"
                                    style="padding-left:40px;padding-right:40px;">{{ __('labels.general.buttons.save') }}</button>
                            </div>
                        </div>
                        </form>
                    </div>

                    <div class="card card-outline-info sub-card" style="margin-bottom:0;margin-top:30px;">
                        <a class="collapsed" href="#collapseInternships" data-toggle="collapse"
                            aria-expanded="false" aria-controls="collapseInternships">
                            <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-1 d-flex align-items-center"
                                style="">
                                <i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>
                                {{ __('labels.frontend.user.profile.internships_and_courses') }}
                            </div>
                        </a>
                    </div>
                    <div id="collapseInternships" class="collapse responsive-set-margin-blocks">

                        <input type="hidden" name="user_id" value="">
                        <div class=" card-body">
                            <h4 class="mt-3">{{ __('labels.frontend.user.profile.internships') }}</h4>

                            <div class="table-responsive mt-4 sub-card">
                                <table class="table table-striped table-hover table-bordered fs-15">
                                    <thead>
                                        <tr>
                                            <th>{{ __('labels.frontend.user.profile.company_name') }}</th>
                                            <th>{{ __('labels.frontend.user.profile.duration') }}</th>
                                            <th>{{ __('labels.frontend.user.profile.place') }}</th>
                                            <th style="width:200px;">{{ __('labels.general.actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if (count($internships) != 0)
                                            @php
                                                $i = 0;
                                            @endphp
                                            @foreach ($internships as $internship)
                                                <tr>
                                                    <td>
                                                        {{ $internship['company'] }}
                                                    </td>
                                                    <td>
                                                        {{ $internship['duration'] }}
                                                    </td>
                                                    <td>
                                                        {{ Str::ucfirst($internship['place']) }}
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center">
                                                            <button id="data-id"
                                                                class="btn btn-sm btn-outline-primary editProfileInternship "
                                                                data-id="{{ $internship['id'] }}" data-placement="top"
                                                                title="Edit"><i class="fa fa-edit"></i> 
                                                            </button>



                                                            <form action="{{ route('frontend.user.profile.internship_information.delete') }}" method="POST"
                                                            onSubmit="if(!confirm('Are you sure want to delete this Internship Information?')){return false;}">
                                                                @csrf
                                                                <input type="hidden" name="id"
                                                                    value="{{ $internship['id'] }}">
                                                                <input type="hidden" name="userid"
                                                                    value="{{ $internship['userid'] }}">

                                                                <button title="Delete" type="submit"
                                                                    class="btn btn-sm btn-outline-danger mx-1"><i
                                                                        class="fa fa-trash"></i></button>
                                                            </form>

                                                        </div>
                                                    </td>
                                                </tr>
                                                @php
                                                    $i++;
                                                @endphp
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="11" class="text-center">No Records Found
                                                </td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>

                            @if (count($internships) != 0)

                                <button class="btn btn-themecolor addProfileinternship" data-placement="top"
                                    title="Add More"><i class="fa fa-plus mx-1"></i> {{ __('labels.frontend.user.profile.add_more') }}</button>
                            @else
                                <button class="btn btn-themecolor addProfileinternship" data-placement="top"
                                    title="Add More"><i class="fa fa-plus mx-1"></i> {{ __('labels.frontend.user.profile.add_new') }}</button>

                            @endif
                            <br>
                            <h4 class="mt-6" style="font-weight: 700 !important;">
                                {{ __('labels.frontend.user.profile.other_courses_completed') }}</h4>


                            <div class="table-responsive mt-4 sub-card">
                                <table class="table table-striped table-hover table-bordered fs-15">
                                    <thead>
                                        <tr>
                                            <th>{{ __('labels.frontend.user.profile.course') }}</th>
                                            <th>{{ __('labels.frontend.user.profile.duration') }}</th>
                                            <th>{{ __('labels.frontend.user.profile.certificate_issued_authority') }}</th>
                                            <th style="width:200px;">{{ __('labels.general.actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if (count($courses) != 0)
                                            @php
                                                $i = 0;
                                            @endphp
                                            @foreach ($courses as $course)
                                                <tr>
                                                    <td>
                                                        {{ $course['course'] }}
                                                    </td>
                                                    <td>
                                                        {{ $course['duration'] }}
                                                    </td>
                                                    <td>
                                                        {{ $course['institute'] }}
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center">
                                                            <button id="data-id"
                                                                class="btn btn-sm btn-outline-primary editProfileCourse "
                                                                data-id="{{ $course['id'] }}" data-placement="top"
                                                                title="Edit"><i class="fa fa-edit"></i></button>


                                                                <form action="{{ route('frontend.user.profile.course_information.delete') }}" method="POST"
                                                                onSubmit="if(!confirm('Are you sure want to delete This Other Course Information?')){return false;}">
                                                                @csrf
                                                                <input type="hidden" name="id"
                                                                    value="{{ $course['id'] }}">
                                                                <input type="hidden" name="userid"
                                                                    value="{{ $course['userid'] }}">

                                                                <button title="Delete" type="submit"
                                                                    class="btn btn-sm btn-outline-danger mx-1"><i
                                                                        class="fa fa-trash"></i></button>
                                                            </form>

                                                        </div>
                                                    </td>
                                                </tr>
                                                @php
                                                    $i++;
                                                @endphp
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="11" class="text-center">No Records Found
                                                </td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>

                            @if (count($courses) != 0)

                                <button class="btn btn-themecolor addProfileCourse" data-placement="top"
                                    title="Add More"><i class="fa fa-plus mx-1"></i> {{ __('labels.frontend.user.profile.add_more') }}</button>
                            @else
                                <button class="btn btn-themecolor addProfileCourse" data-placement="top"
                                    title="Add More"><i class="fa fa-plus mx-1"></i> {{ __('labels.frontend.user.profile.add_new') }}</button>

                            @endif

                        </div>
                    </div>

                    <div class="card card-outline-info sub-card" style="margin-bottom:0;margin-top:30px;">
                        <a class="collapsed" href="#collapseEmploymentDetails" data-toggle="collapse"
                            aria-expanded="false" aria-controls="collapseEmploymentDetails">
                            <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-1 d-flex align-items-center"
                                style="">
                                <i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>
                                {{ __('labels.frontend.user.profile.employment_history') }}
                            </div>
                        </a>
                    </div>
                    <div id="collapseEmploymentDetails" class="collapse">
                        <div id="employment" class="mt-4 table-responsive sub-card">
                            <table class="table table-striped table-hover table-bordered fs-15">
                                <thead>
                                    <tr>
                                        <th>{{ __('labels.frontend.user.profile.employment_type') }}</th>
                                        <th>{{ __('labels.frontend.user.profile.currently_working') }}</th>
                                        <th style="min-width: 130px">{{ __('labels.frontend.user.profile.organisation_name') }}</th>
                                        <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.industry_type') }}</th>
                                        <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.employer_phone') }}</th>
                                        <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.street_address') }}</th>
                                        <th style="min-width: 120px !important;"> {{ __('labels.frontend.user.profile.country') }}</th>
                                        <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.state') }}</th>
                                        <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.city') }}/{{ __('labels.frontend.user.profile.suburb') }}</th>
                                        <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.post_code') }}</th>
                                        <th style="min-width: 150px !important;">{{ __('labels.frontend.user.profile.contact_person_name') }}</th>
                                        <th style="min-width: 150px">{{ __('labels.frontend.user.profile.contact_person_phone') }}</th>
                                        <th style="min-width: 150px">{{ __('labels.frontend.user.profile.contact_person_mobile') }}</th>
                                        <th style="min-width: 150px">{{ __('labels.frontend.user.profile.your_working_designation') }}</th>
                                        <th style="min-width: 150px">{{ __('labels.frontend.user.profile.date_start_from') }}</th>
                                        <th style="min-width: 150px">{{ __('labels.frontend.user.profile.date_working_ended') }}</th>
                                        <th>{{ __('labels.general.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($profile_employment_details) != 0)
                                        @foreach ($profile_employment_details as $profile_employment_detail)
                                            <tr>
                                                <td>{{ $profile_employment_detail->employment_histroy_type }}</td>
                                                <td>{{ $profile_employment_detail->employment_history_currently_working }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_organisation_name }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_industry_type }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_employer_phone }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_address }}</td>
                                                <td>{{ get_country_name($profile_employment_detail->employment_history_country) }}
                                                </td>
                                                <td>{{ get_state_name($profile_employment_detail->employment_history_state) }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_city }}</td>
                                                <td>{{ $profile_employment_detail->employment_history_postcode }}</td>
                                                <td>{{ $profile_employment_detail->employment_history_contact_person_name }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_contact_person_business_phone }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_contact_person_mobile_number }}
                                                </td>
                                                <td>{{ $profile_employment_detail->employment_history_working_position_occupation }}
                                                </td>
                                                <td>
                                                    @if ($profile_employment_detail->employment_history_start_date)
                                                        {{ date('d M Y', strtotime($profile_employment_detail->employment_history_start_date)) }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($profile_employment_detail->employment_history_working_ended)
                                                        {{ date('d M Y', strtotime($profile_employment_detail->employment_history_working_ended)) }}
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <button class="btn btn-sm btn-outline-primary editEmployment "
                                                            data-id="{{ $profile_employment_detail->id }}"
                                                            data-toggle="tooltip" data-placement="top"
                                                            title="Edit"><i class="fa fa-edit"></i></button>

                                                            <form action="{{ route('frontend.user.profile.employment_information.delete') }}" method="POST"
                                                            onSubmit="if(!confirm('Are you sure want to delete this Employment History?')){return false;}">
                                                            @csrf
                                                            <input type="hidden" name="id"
                                                                value="{{ $profile_employment_detail->id }}">
                                                            <button title="Delete" type="submit"
                                                                class="btn btn-sm btn-outline-danger mx-1"><i
                                                                    class="fa fa-trash"></i></button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="18" class="text-center">No Record Found
                                            </td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <br>
                        @if (count($profile_employment_details) == 0)
                            <button class="btn btn-themecolor addEmployment" data-placement="top"
                                title="Add Unemployment History"><i class="fa fa-plus mx-1"></i> Add Employment
                                History</button>
                        @else
                            <button class="btn btn-themecolor addEmployment" data-placement="top" title="Add More"><i
                                    class="fa fa-plus mx-1"></i>{{ __('labels.frontend.user.profile.add_more') }}</button>
                        @endif
                    </div>

                    <div class="card card-outline-info sub-card" style="margin-bottom:0;margin-top:30px;">
                        <a class="collapsed" href="#collapseVisaApplication" data-toggle="collapse"
                            aria-expanded="false" aria-controls="collapseVisaApplication">
                            <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-1 d-flex align-items-center"
                                style="">
                                <i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>
                                {{ __('labels.frontend.user.profile.visa_application_history') }}
                            </div>
                        </a>
                    </div>
                    <div id="collapseVisaApplication" class="collapse">
                        <div id="employment" class="mt-4 table-responsive sub-card">
                            <table class="table table-striped table-hover table-bordered fs-15">
                                <thead>
                                    <tr>
                                        <th>{{ __('labels.frontend.user.profile.country_applied_for') }}</th>
                                        <th>{{ __('labels.frontend.user.profile.name_used') }}</th>
                                        <th>{{ __('labels.frontend.user.profile.visa_name') }}/{{ __('labels.general.type') }}</th>
                                        <th>{{ __('labels.frontend.user.profile.application_date') }}</th>
                                        <th>{{ __('labels.frontend.user.profile.application_number') }}</th>
                                        <th>{{ __('labels.frontend.user.profile.outcome') }}</th>
                                        <th>{{ __('labels.general.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($profile_visa_application_historys) != 0)
                                        @foreach ($profile_visa_application_historys as $profile_visa_application_history)
                                            <tr>
                                                <td>{{ get_country_name($profile_visa_application_history->country_applied_for_visa) }}
                                                </td>
                                                <td>{{ $profile_visa_application_history->name_used_for_visa_apply }}</td>
                                                <td>{{ $profile_visa_application_history->visa_apply_visa_type }}</td>
                                                <td>
                                                    @if ($profile_visa_application_history->visa_apply_application_date)
                                                        {{ date('d M Y', strtotime($profile_visa_application_history->visa_apply_application_date)) }}
                                                    @endif
                                                </td>
                                                <td>{{ $profile_visa_application_history->visa_apply_application_number }}
                                                </td>
                                                <td>{{ $profile_visa_application_history->visa_apply_outcome }}</td>
                                                <td class="d-flex">
                                                    <button class="btn btn-sm btn-outline-primary editVisaHistory "
                                                        data-id="{{ $profile_visa_application_history->id }}"
                                                        data-toggle="tooltip" data-placement="top" title="Edit"><i
                                                            class="fa fa-edit"></i></button>
                                                            <form action="{{ route('frontend.user.profile.visa_information.delete') }}" method="POST"
                                                            onSubmit="if(!confirm('Are you sure want to delete this Visa Application History?')){return false;}">
                                                        @csrf
                                                        <input type="hidden" name="id"
                                                            value="{{ $profile_visa_application_history->id }}">
                                                        <button title="Delete" type="submit"
                                                            class="btn btn-sm btn-outline-danger mx-1"><i
                                                                class="fa fa-trash"></i></button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="8" class="text-center">No Record Found
                                            </td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                            @if (count($profile_visa_application_historys) == 0)

                                <button class="btn btn-themecolor addVisaHistory mb-3 mx-3" data-placement="top"
                                    title="Add Travel History"><i class="fa fa-plus mx-1"></i> Add Visa History</button>
                            @else
                                <button class="btn btn-themecolor addVisaHistory mb-3 mx-3" data-placement="top"
                                    title="Add More"><i class="fa fa-plus mx-1"></i>{{ __('labels.frontend.user.profile.add_more') }}</button>

                            @endif
                        </div>
                    </div>

                    <div class="card card-outline-info sub-card" style="margin-bottom:0;margin-top:30px;">
                        <a class="collapsed" href="#collapseTravelHistory" data-toggle="collapse"
                            aria-expanded="false" aria-controls="collapseTravelHistory">
                            <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-1 d-flex align-items-center"
                                style="">
                                <i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>
                                {{ __('labels.frontend.user.profile.international_travel_history') }}
                            </div>
                        </a>
                    </div>
                    <div id="collapseTravelHistory" class="collapse responsive-set-margin-blocks">
                        <div class="card-body">
                            <div id="employment" class="mt-4 table-responsive sub-card">
                                <table class="table table-striped table-hover table-bordered fs-15">
                                    <thead>
                                        <tr>
                                            <th style="min-width: 152px !important;">{{ __('labels.frontend.user.profile.country_visited') }}</th>
                                            <th style="min-width: 190px !important;">{{ __('labels.frontend.user.profile.name_used_on_entry') }}</th>
                                            <th style="min-width: 114px !important;">{{ __('labels.frontend.user.profile.visa_type') }}</th>
                                            <th style="min-width: 132px !important;">{{ __('labels.frontend.user.profile.visa_issued_at') }}</th>
                                            <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.date_from') }}</th>
                                            <th style="min-width: 120px !important;">{{ __('labels.frontend.user.profile.date_up_to') }}</th>
                                            <th style="min-width: 150px !important;">{{ __('labels.frontend.user.profile.reason_of_visit') }}</th>
                                            <th style="min-width: 120px !important;">{{ __('labels.general.actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if (count($profile_travel_historys) != 0)
                                            @foreach ($profile_travel_historys as $profile_travel_history)
                                                <tr>
                                                    <td>{{ get_country_name($profile_travel_history->country_visited) }}
                                                    </td>
                                                    <td>{{ $profile_travel_history->name_used_on_country }}</td>
                                                    <td>{{ $profile_travel_history->visa_type }}</td>
                                                    <td>{{ $profile_travel_history->visa_issue_at }}</td>
                                                    <td>
                                                        @if ($profile_travel_history->date_from)
                                                            {{ date('d M Y', strtotime($profile_travel_history->date_from)) }}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if ($profile_travel_history->date_up_to)
                                                            {{ date('d M Y', strtotime($profile_travel_history->date_up_to)) }}
                                                        @endif
                                                    </td>
                                                    <td>{{ $profile_travel_history->reason_of_visit }}</td>
                                                    <td>
                                                        <span class="d-flex">
                                                            <button class="btn btn-sm btn-outline-primary editTravelHistory "
                                                                data-id="{{ $profile_travel_history->id }}"
                                                                data-toggle="tooltip" data-placement="top"
                                                                title="Edit"><i class="fa fa-edit"></i></button>
                                                                <form method="POST" action="{{ route('frontend.user.profile.travel_history.delete') }}"
                                                                onSubmit="if(!confirm('Are you sure want to delete this Travel History?')){return false;}">
                                                                @csrf
                                                                <input type="hidden" name="id"
                                                                    value="{{ $profile_travel_history->id }}">
                                                                <button title="Delete" type="submit"
                                                                    class="btn btn-sm btn-outline-danger mx-1"><i
                                                                        class="fa fa-trash"></i></button>
                                                            </form>
                                                        </span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="8" class="text-center">No Record Found
                                                </td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                                @if (count($profile_travel_historys) == 0)
                                    <button class="btn btn-themecolor addTravelHistory mb-3 mx-3" data-placement="top"
                                        title="Add Travel History"><i class="fa fa-plus mx-1"></i> Add Travel
                                        History</button>
                                @else
                                    <button class="btn btn-themecolor addTravelHistory mb-3 mx-3" data-placement="top"
                                        title="Add More"><i class="fa fa-plus mx-1"></i>{{ __('labels.frontend.user.profile.add_more') }}</button>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="card card-outline-info sub-card" style="margin-bottom:0;margin-top:30px;">
                        <a class="collapsed" href="#collapseFamilyDetails" data-toggle="collapse"
                            aria-expanded="false" aria-controls="collapseFamilyDetails">
                            <div class="text-start text-white fs-20 card-header bg-theme ps-4 p-1 d-flex align-items-center"
                                style="">
                                <i class="uil uil-angle-down me-1" style="font-size: 25px;"></i>
                                {{ __('labels.frontend.user.profile.family_details') }}
                            </div>
                        </a>
                    </div>
                    <div id="collapseFamilyDetails" class="collapse responsive-set-margin-blocks">
                        <div>
                            <input type="hidden" name="user_id" value="">
                            <div class=" card-body">
                                <div class="table-responsive mt-4 sub-card">
                                    <table class="table table-striped table-hover table-bordered fs-15">
                                        <thead>
                                            <tr>
                                                <th>{{ __('labels.frontend.user.profile.relationship') }}</th>
                                                <th>{{ __('labels.backend.access.users.table.name') }}</th>
                                                <th>{{ __('labels.backend.access.users.table.email') }}</th>
                                                <th style="min-width: 130px">{{ __('labels.frontend.user.profile.contact') }}</th>
                                                <th style="min-width: 130px">{{ __('labels.frontend.user.profile.date_of_birth') }}</th>
                                                <th style="min-width: 130px">{{ __('labels.frontend.user.profile.country_of_birth') }}</th>
                                                <th style="min-width: 130px">{{ __('labels.frontend.user.profile.country_of_residence') }}</th>
                                                <th>{{ __('labels.general.actions') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if (count($profile_family) != 0)
                                                @foreach ($profile_family as $family)
                                                    <tr>
                                                        <td>
                                                            {{ $family->relationship }}
                                                        </td>
                                                        <td style="min-width: 120px;">
                                                            {{ $family->first_name }} {{ $family->last_name }}</td>
                                                        <td style="min-width: 120px;">
                                                            {{ $family->email }}</td>
                                                        <td style="min-width: 120px;">
                                                            +{{ $family->dial_code }}-{{ $family->mobile }}</td>
                                                        <td>{{ $family->birth_date }}
                                                        </td>
                                                        <td>{{ get_country_name($family->birth_country) }}
                                                        </td>
                                                        <td>{{ get_country_name($family->residence_country) }}
                                                        </td>
                                                        <td>

                                                            <div class="d-flex">
                                                                <button id="data-id"
                                                                    class="btn btn-sm btn-outline-primary editProfileFamily "
                                                                    data-id="{{ $family->id }}" data-placement="top"
                                                                    title="Edit"><i class="fa fa-edit"></i>
                                                                </button>

                                                                <form action="{{ route('frontend.user.family.course_information.delete') }}"
                                                                method="POST"
                                                                onSubmit="if(!confirm('Are you sure want to delete this Family Details?')){return false;}">
                                                                    @csrf
                                                                    <input type="hidden" name="id"
                                                                        value="{{ $family->id }}">
                                                                    <input type="hidden" name="userid"
                                                                        value="{{ $family->userid }}">

                                                                    <button title="Delete" type="submit"
                                                                        class="btn btn-sm btn-outline-danger mx-1"><i
                                                                            class="fa fa-trash"></i></button>
                                                                </form>

                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr>
                                                    <td colspan="8" class="text-center">No Records Found
                                                    </td>
                                                </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                <br>
                                @if (count($profile_family) == 0)
                                    <button class="btn btn-themecolor addProfileFamily mb-3" data-placement="top"
                                        title="Add More"><i class="fa fa-plus mx-1"></i>
                                        {{ __('labels.frontend.user.profile.add_new') }}</button>
                                @else
                                    <button class="btn btn-themecolor addProfileFamily mb-3" data-placement="top"
                                        title="Add More"><i class="fa fa-plus mx-1"></i>
                                        {{ __('labels.frontend.user.profile.add_more') }}</button>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            <div class="my-4 text-center" style="margin-left: auto; width: 150px">
                <button id="coursePrefNext" class="btn btn-success text-white"
                    style="padding-left:40px;padding-right:40px;">{{ __('labels.frontend.user.profile.next') }}
                    >></button>
            </div>
        </div>
    </div>
    </div>
    </div>
    <!-- modal add user hidden -->
    <div class="modal fade" id="addAcademicsDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Add Academic Detail</h5>
                    <button type="button" class="btn-close " data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal edit user hidden -->

    <div class="modal fade" id="editAcademicsDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Academic Detail</h5>
                    <button type="button" class="btn-close " data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal add internship hidden -->
    <div class="modal fade" id="addInternshipDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Add Internship Detail</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal edit internship hidden -->
    <div class="modal fade" id="editInternshipDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0 pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Internship Detail</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal add Course hidden -->
    <div class="modal fade" id="addCourseDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Add Course Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit course hidden -->
    <div class="modal fade" id="editCourseDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Course Detail</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal add Family hidden -->
    <div class="modal fade" id="addFamilyDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('labels.frontend.user.profile.add_family_details') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit family hidden -->
    <div class="modal fade" id="editFamily">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('labels.frontend.user.profile.edit_family_details') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal add employment hidden -->
    <div class="modal fade" id="addEmployment">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Add Employment Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit employment hidden -->

    <div class="modal fade" id="editEmployment">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Employment Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal add Travel history hidden -->
    <div class="modal fade" id="addTravelHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Add Travel History</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit Travel history hidden -->

    <div class="modal fade" id="editTravelHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Travel History</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal add Visa history hidden -->
    <div class="modal fade" id="addVisaHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('labels.frontend.user.profile.add_visa_history') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal edit Visa history hidden -->
    <div class="modal fade" id="editVisaHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header pb-0">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Visa History</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body pt-6 load_modal">

                </div>
            </div>
        </div>
    </div>
@endsection

@push('after-styles')
    <style>
        .select2-selection { background-color: #FEFEFE !important }
        .select2-container--default .select2-selection--multiple:focus-within { border: 2px solid #9fbcf0 !important; }
        .form-control:focus{border: 2px solid #9fbcf0;}
        .form-select{
            box-shadow: none !important;
        }
        .input-box-inner-style {
            padding: 7px 10px !important;
        }

        .responsive-set-margin{
            margin: 0px -41px;
        }
        
        .responsive-set-margin-blocks{
            margin: -41px -41px;
        }

        .tab{
            background-color: #E0E4FA !important; 
            padding: 4px 25px !important; 
        }

        .tab-heading{
            font-size: 18px;
        }
        
        @media (max-width: 769px) {
            .sub-card{
                margin: 10px -25px;
            }
        }

        @media (max-width: 845px) {
            .tab{
                background-color: #E0E4FA !important; 
                padding: 0px 10px !important; 
            }
            .tab-heading{
                font-size: 14px;
            }
        }
    </style>
@endpush

@push('after-scripts')
    <script>
        (() => {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            const forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.from(forms).forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                        form.classList.add('was-validated');
                    }

                    if (form.checkValidity()) {
                        // If it passes the validation                  
                        $('#profile_form').submit();
                    }

                }, false)
            })

        })()

        $(document).ready(function() {
            $('.addProfileAcademics').on('click', function() {
                var base_url = "{{ route('frontend.user.profile.academics_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addAcademicsDetail').on('shown.bs.modal', function() {
                        $('#addAcademicsDetail .load_modal').html(data);
                        $('#add_academics_information_user_id').val(
                            {{ Auth::user()->id }});
                    });
                    $('#addAcademicsDetail').modal('show');
                    $('#addAcademicsDetail').on('hidden.bs.modal', function() {
                        $('#addAcademicsDetail .load_modal').html("");
                    });
                });
            })

            //Editing profile acedemics

            $('.editProfileAcademics').on('click', function() {

                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/overseas/profile/edit_academics_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editAcademicsDetail').on('shown.bs.modal', function() {
                        $('#editAcademicsDetail .load_modal').html(data);
                        $('#edit_academics_information_user_id').val(
                            {{ Auth::user()->id }});
                    });
                    $('#editAcademicsDetail').modal('show');
                    $('#editAcademicsDetail').on('hidden.bs.modal', function() {
                        $('#editAcademicsDetail .load_modal').html("");
                    });
                });
            });
           
            $('.addProfileinternship').on('click', function() {
                var base_url = "{{ route('frontend.user.profile.internship_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addInternshipDetail').on('shown.bs.modal', function() {
                        $('#addInternshipDetail .load_modal').html(data);
                        $('#add_internship_information_user_id').val(
                            {{ Auth::user()->id }});
                    });
                    $('#addInternshipDetail').modal('show');
                    $('#addInternshipDetail').on('hidden.bs.modal', function() {
                        $('#addInternshipDetail .load_modal').html("");
                    });
                });
            })

            $('.editProfileInternship').on('click', function() {

                var this_id = $(this).attr('data-id');
                var base_url = "{{ url('/overseas/profile/edit_internship_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editInternshipDetail').on('shown.bs.modal', function() {
                        $('#editInternshipDetail .load_modal').html(data);
                        $('#edit_internship_information_user_id').val(
                            {{ Auth::user()->id }});
                    });
                    $('#editInternshipDetail').modal('show');
                    $('#editInternshipDetail').on('hidden.bs.modal', function() {
                        $('#editInternshipDetail .load_modal').html("");
                    });
                });
            });

            $('.addProfileCourse').on('click', function() {
                var base_url = "{{ route('frontend.user.profile.course_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addCourseDetail').on('shown.bs.modal', function() {
                        $('#addCourseDetail .load_modal').html(data);
                        $('#add_course_information_user_id').val({{ Auth::user()->id }});
                    });
                    $('#addCourseDetail').modal('show');
                    $('#addCourseDetail').on('hidden.bs.modal', function() {
                        $('#addCourseDetail .load_modal').html("");
                    });
                });
            })

            $('.editProfileCourse').on('click', function() {

                var this_id = $(this).attr('data-id');
                var base_url = "{{ url('/overseas/profile/edit_course_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editCourseDetail').on('shown.bs.modal', function() {
                        $('#editCourseDetail .load_modal').html(data);
                        $('#edit_course_information_user_id').val(
                            {{ Auth::user()->id }});
                    });
                    $('#editCourseDetail').modal('show');
                    $('#editCourseDetail').on('hidden.bs.modal', function() {
                        $('#editCourseDetail .load_modal').html("");
                    });
                });
            });

            //adding profile Family
            $('.addProfileFamily').on('click', function() {
                var base_url = "{{ route('frontend.user.profile.family_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addFamilyDetail').on('shown.bs.modal', function() {
                        $('#addFamilyDetail .load_modal').html(data);
                        $('#add_family_information_user_id').val({{ Auth::user()->id }});
                    });
                    $('#addFamilyDetail').modal('show');
                    $('#addFamilyDetail').on('hidden.bs.modal', function() {
                        $('#addFamilyDetail .load_modal').html("");
                    });
                });
            })

            $('.editProfileFamily').on('click', function() {

                var this_id = $(this).attr('data-id');
                var base_url = "{{ url('/overseas/profile/edit_family_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editFamily').on('shown.bs.modal', function() {
                        $('#editFamily .load_modal').html(data);
                        $('#edit_family_information_user_id').val(
                            {{ Auth::user()->id }});
                    });
                    $('#editFamily').modal('show');
                    $('#editFamily').on('hidden.bs.modal', function() {
                        $('#editFamily .load_modal').html("");
                    });
                });
            });

            // Add  Employment Histroy
            $('.addEmployment').on('click', function() {
                var base_url = "{{ route('frontend.user.profile.employment_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addEmployment').on('shown.bs.modal', function() {
                        $('#addEmployment .load_modal').html(data);
                        $('#add_employment_history_user_id').val({{ Auth::user()->id }});
                    });
                    $('#addEmployment').modal('show');
                    $('#addEmployment').on('hidden.bs.modal', function() {
                        $('#addEmployment .load_modal').html("");
                    });
                });
            });
            // Edit Employment Histroy
            $('.editEmployment').on('click', function() {
                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/overseas/profile/edit_employment/open/') }}/" + this_id;
                $.get(base_url, function(data) {
                    $('#editEmployment').on('shown.bs.modal', function() {
                        $('#editEmployment .load_modal').html(data);
                        $('#edit_employment_history_user_id').val({{ Auth::user()->id }});
                    });
                    $('#editEmployment').modal('show');
                    $('#editEmployment').on('hidden.bs.modal', function() {
                        $('#editEmployment .load_modal').html("");
                    });
                });
            });

            // Add and Edit Travel Histroy
            $('.addTravelHistory').on('click', function() {
                var base_url = "{{ route('frontend.user.profile.travel_history.add') }}";
                $.get(base_url, function(data) {
                    $('#addTravelHistory').on('shown.bs.modal', function() {
                        $('#addTravelHistory .load_modal').html(data);
                        $('#add_travel_history_user_id').val({{ Auth::user()->id }});
                    });
                    $('#addTravelHistory').modal('show');
                    $('#addTravelHistory').on('hidden.bs.modal', function() {
                        $('#addTravelHistory .load_modal').html("");
                    });
                });
            });

            $('.editTravelHistory').on('click', function() {
                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/overseas/profile/edit_travel_history/open/') }}/" + this_id;
                $.get(base_url, function(data) {
                    $('#editTravelHistory').on('shown.bs.modal', function() {
                        $('#editTravelHistory .load_modal').html(data);
                        $('#edit_travel_history_user_id').val({{ Auth::user()->id }});
                    });
                    $('#editTravelHistory').modal('show');
                    $('#editTravelHistory').on('hidden.bs.modal', function() {
                        $('#editTravelHistory .load_modal').html("");
                    });
                });
            });

            // Add and Edit Visa Histroy
            $('.addVisaHistory').on('click', function() {

                var base_url = "{{ route('frontend.user.profile.visa_history.add') }}";
                $.get(base_url, function(data) {
                    $('#addVisaHistory').on('shown.bs.modal', function() {
                        $('#addVisaHistory .load_modal').html(data);
                        $('#add_visa_history_user_id').val({{ Auth::user()->id }});
                    });
                    $('#addVisaHistory').modal('show');
                    $('#addVisaHistory').on('hidden.bs.modal', function() {
                        $('#addVisaHistory .load_modal').html("");
                    });
                });
            });

            $('.editVisaHistory').on('click', function() {
                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/overseas/profile/edit_visa_history/open/') }}/" + this_id;
                $.get(base_url, function(data) {
                    $('#editVisaHistory').on('shown.bs.modal', function() {
                        $('#editVisaHistory .load_modal').html(data);
                        $('#edit_visa_history_user_id').val({{ Auth::user()->id }});
                    });
                    $('#editVisaHistory').modal('show');
                    $('#editVisaHistory').on('hidden.bs.modal', function() {
                        $('#editVisaHistory .load_modal').html("");
                    });
                });
            });


            $('#coursePrefNext').click(function() {
                let profile_complete = @json($logged_in_user->profile_complete);
                if (profile_complete) {
                    window.location.href = "{{ route('frontend.user.studyabroad.coursepreference') }}";
                } else {
                    alert("You must complete your profile details before going to the course preferences");
                }
            });

            $('#country-dd').on('change', function() {
                var idCountry = this.value;
                $("#state-dd").html('');
                $.ajax({
                    url: "{{ url('api/fetch-states') }}",
                    type: "POST",
                    data: {
                        country_id: idCountry,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#state-dd').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            if (value.id == "{{ $logged_in_user->state }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else if (value.id == "{{ old('state') }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else {
                                var selectedState = "";
                            }
                            $("#state-dd").append('<option ' + selectedState +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            });
            $('#per-country-dd').on('change', function() {
                var idCountry = this.value;
                $("#per-state-dd").html('');
                $.ajax({
                    url: "{{ url('api/fetch-states') }}",
                    type: "POST",
                    data: {
                        country_id: idCountry,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#per-state-dd').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            if (value.id ==
                                "{{ $userDetails ? $userDetails->permanent_state : '' }}"
                            ) {
                                var selectedState = "selected=\"'selected'\"";
                            } else if (value.id == "{{ old('permanent_state') }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else {
                                var selectedState = "";
                            }
                            $("#per-state-dd").append('<option ' + selectedState +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            });

            $('#state-dd').on('change', function() {
            // console.log("City Value on state change:"); 
                if (this.value != '') {
                    console.log("City Value on state change:", this.value); 
                    var idState = this.value;
                } else {
                    var idState = '{{ $logged_in_user->state }}';
                }
                $("#city-dd").html('');
                $.ajax({
                    url: "{{ url('api/fetch-cities') }}",
                    type: "POST",
                    data: {
                        state_id: idState,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(res) {
                        $('#city-dd').html('<option value="">Select City</option>');
                        $.each(res.cities, function(key, value) {
                            console.log("City Value:", value); // Logs each city object
                            console.log("Logged-in User state:", '{{ $logged_in_user }}');
                            if (value.name== '{{ $logged_in_user->city }}') {
                                var selectedCity = "selected='selected'";
                            } else {
                                var selectedCity = "";
                            }
                            $("#city-dd").append('<option ' + selectedCity +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            });
            $('#country-dd,#per-country-dd').trigger('change');
            $('#state-dd').trigger('change');



            $('#same_as_current').on("click", function() {
                if ($(this).is(':checked')) {
                    $('#perm_block').hide();
                } else {
                    $('#perm_block').show();
                }
            });


            $('body').on('click', '#yes_dual', function() {
                $('#dual_citizenship_country').attr("required", true);
                $('#select_dual_country').show();
            });

            $('body').on('click', '#no_dual', function() {
                $('#dual_citizenship_country').prop('required', false);
                $('#select_dual_country').hide();
            });

            $('body').on('click', '#yes_studying_abroad', function() {
                $('#studying_abroad_country').attr("required", true);
                $('#select_studying_abroad_country').show();
            });

            $('body').on('click', '#no_studying_abroad', function() {
                $('#studying_abroad_country').prop('required', false);
                $('#select_studying_abroad_country').hide();
            });

            $('body').on('click', '#yes_immigration', function() {
                $('#immigration_country').attr("required", true);
                $('#select_immigration_country').show();
            });

            $('body').on('click', '#no_immigration', function() {
                $('#immigration_country').prop('required', false);
                $('#select_immigration_country').hide();
            });

            $('body').on('click', '#yes_visa_refusal', function() {
                $('#visa_refusal_country').attr("required", true);
                $('#select_visa_refusal_country').show();
            });

            $('body').on('click', '#no_visa_refusal', function() {
                $('#visa_refusal_country').prop('required', false);
                $('#select_visa_refusal_country').hide();
            });


        });

        function chk_mend(elClass) {
            el = document.getElementsByClassName(elClass);
            var atLeastOneChecked = false; //at least one cb is checked
            for (i = 0; i < el.length; i++) {
                if (el[i].checked === true) {
                    atLeastOneChecked = true;
                }
            }

            if (atLeastOneChecked === true) {
                for (i = 0; i < el.length; i++) {
                    el[i].required = false;
                }
            } else {
                for (i = 0; i < el.length; i++) {
                    el[i].required = true;
                }
            }
        }


        function onlyNumberKey(evt) {
            // Only ASCII character in that range allowed
            var ASCIICode = (evt.which) ? evt.which : evt.keyCode
            if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
                return false;
            return true;
        }

        function show_hide(show_id) {
            if ($('#' + show_id).is(':checked')) {
                $('#' + show_id + '_div').show(400);
            } else {
                $('#' + show_id + '_div').hide(400);
            }
        }

        function show_hide_input_field(show_id) {
            if ($('#' + show_id + '_checkbox').is(':checked')) {
                $('#' + show_id).show(200);
            } else {
                $('#' + show_id).hide(200);
            }
        }

        function show_hide_eng(show_id) {
            if (document.querySelectorAll('#eng_one_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#english_lang_table').show(200);
            } else {
                $('#english_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_det(show_id) {
            if (document.querySelectorAll('#eng_two_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#det_lang_table').show(200);
            } else {
                $('#det_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_act(show_id) {
            if (document.querySelectorAll('#eng_three_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#act_lang_table').show(200);
            } else {
                $('#act_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_sat(show_id) {
            if (document.querySelectorAll('#eng_four_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#sat_lang_table').show(200);
            } else {
                $('#sat_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_gre_gmat(show_id) {
            if (document.querySelectorAll('#gre_gmat_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#gre_gmat_lang_table').show(200);
            } else {
                $('#gre_gmat_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_lang(show_id) {
            if (document.querySelectorAll('#other_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#other_lang_table').show(200);
            } else {
                $('#other_lang_table').hide(200);
            }

            if ($('#german').is(':checked')) {
                $('#german_tr').show(200);
            } else {
                $('#german_tr').hide(200);
            }
            if ($('#french').is(':checked')) {
                $('#french_tr').show(200);
            } else {
                $('#french_tr').hide(200);
            }
            if ($('#spanish').is(':checked')) {
                $('#spanish_tr').show(200);
            } else {
                $('#spanish_tr').hide(200);
            }
            if ($('#japanese').is(':checked')) {
                $('#japanese_tr').show(200);
            } else {
                $('#japanese_tr').hide(200);
            }

        }

        function validnum(num, type) {
            if (type == "total_gre") {
                if (num < 260 || num > 340) {
                    $("#total_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#total_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "verbal_gre") {
                if (num < 130 || num > 170) {
                    $("#verbal_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#verbal_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "quant_gre") {
                if (num < 130 || num > 170) {
                    $("#quant_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#quant_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "ana_gre") {
                if (num < 0 || num > 6) {
                    $("#ana_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#ana_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "inte_gre") {
                if (num < 260 || num > 340) {
                    $("#inte_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#inte_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            //GMAT
            if (type == "total_gmat") {
                if (num < 200 || num > 800) {
                    $("#total_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#total_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "verbal_gmat") {
                if (num < 0 || num > 60) {
                    $("#verbal_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#verbal_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "quant_gmat") {
                if (num < 0 || num > 60) {
                    $("#quant_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#quant_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "ana_gmat") {
                if (num < 0 || num > 6) {
                    $("#ana_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#ana_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "inte_gmat") {
                if (num < 1 || num > 8) {
                    $("#inte_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#inte_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }
        }

        // for emergency contact
        $('#emergency_country-dd').on('change', function() {
            var idCountry = this.value;
            $("#emergency_state-dd").html('');
            $.ajax({
                url: "{{ url('api/fetch-states') }}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#emergency_state-dd').html('<option value="">Select State</option>');
                    $.each(result.states, function(key, value) {
                        if (value.id == "{{ $userDetails->emergency_state }}") {
                            var selectedState = "selected=\"'selected'\"";
                        } else if (value.id == "{{ old('state') }}") {
                            var selectedState = "selected=\"'selected'\"";
                        } else {
                            var selectedState = "";
                        }
                        $("#emergency_state-dd").append('<option ' + selectedState +
                            ' value="' + value.id + '">' + value.name +
                            '</option>');
                    });
                }
            });
        });

        var emergency_country = document.getElementById('emergency_country-dd').value;
        if (emergency_country) {
            $.ajax({
                url: "{{ url('api/fetch-states') }}",
                type: "POST",
                data: {
                    country_id: emergency_country,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#emergency_state-dd').html('<option value="">Select State</option>');
                    $.each(result.states, function(key, value) {
                        if (value.id == "{{ $userDetails->emergency_state }}") {
                            var selectedState = "selected=\"'selected'\"";
                        } else if (value.id == "{{ old('emergency_state') }}") {
                            var selectedState = "selected=\"'selected'\"";
                        } else {
                            var selectedState = "";
                        }
                        $("#emergency_state-dd").append('<option ' + selectedState +
                            ' value="' + value.id + '">' + value.name +
                            '</option>');
                    });
                }
            });
        }
        

         // Married Or Not
         $('#marital_status').on('change', function() {
                if ($('#marital_status').val() == "married") {
                    $('#date_of_marriage').attr("required", true);
                    $('#select_date_of_marriage').show();
                    } else {
                    $('#date_of_marriage').prop('required', false);
                    $('#select_date_of_marriage').hide();
                }
            });

            $("#marital_status").trigger("change");
            $('.maritalDate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
                zIndexOffset: 100,
                endDate: 'today' 
            });

            $('.passportExpiryDate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
                zIndexOffset: 100,
                startDate: new Date()
            });

        function expiryDate() {
            if ($(".issueDatePicker").val()) {
                var fromDate = $(".issueDatePicker").val(); 
                
                var dateParts = fromDate.split("-"); 
                var formattedFromDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]); 
                // $('.expiryDatePicker').val("");
                
                // $('.expiryDatePicker').datepicker('setStartDate', formattedFromDate); 
            }
        }
        
    </script>
@endpush
