@extends('frontend.layouts.app')
@section('title'){{'University Details'}}@endsection

@section('content') 
<div class="row page-titles ms-3 mt-5">
    <div class="col-md-8 align-self-center">
        <h3 class="text-themecolor">University Details</h3>
    </div>
    </div>

    <div class="container-fluid">
<div class="row">
    <div class="col-12">
        <div class="card mt-3 mb-3">
            <div class="card-header bg-primary text-white h5 ">{{$university->university_name}}</div>
            <div class="card-body pt-3">
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Country</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->country) {{get_country_name($university->country)}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Institution Type	</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->institution_type) {{$university->institution_type}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Concurrent Course Allowed?</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->concurrent_course_allowed) {{$university->concurrent_course_allowed}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>University Details</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->college_details) {!!$university->college_details!!} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Address</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->address) {{$university->address}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Website</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->website)
                        <?php $link = substr($university->website, 0, 40) . '...'; ?>
                        <a href="{{$university->website}}" target="_blank" class="text-primary"><?php echo $link ?></a>
                        @else --
                        @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>CRICOS Link</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->cricos_link)
                        <?php $crlink = substr($university->cricos_link, 0, 40) . '...'; ?>
                        <a href="{{$university->cricos_link}}" target="_blank" class="text-primary"><?php echo $crlink ?></a>
                        @else --
                        @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Documents Link</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->documents_link)
                        <?php $dclink = substr($university->documents_link, 0, 40) . '...'; ?>
                        <a href="{{$university->documents_link}}" target="_blank" class="text-primary"><?php echo $dclink ?></a>
                        @else --
                        @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Current Fee List Link</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->current_fee_list_link)
                        <?php $cflink = substr($university->current_fee_list_link, 0, 40) . '...'; ?>
                        <a href="{{$university->current_fee_list_link}}" target="_blank" class="text-primary"><?php echo $cflink ?></a>
                        @else --
                        @endif
                    </div>
                </div>
                
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Initial Deposit Options</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->initial_deposit_options) {{$university->initial_deposit_options}} @else -- @endif
                    </div>
                </div>
                <div class="row mt-3 border-bottom">
                    <div class="col-md-3">
                        <b>Admission Process</b>
                    </div>
                    <div class="col-md-6">
                        @if($university->admission_process) {{$university->admission_process}} @else -- @endif
                    </div>
                </div>
            </div>
        </div>
</div>
</div>
@endsection

@push('after-scripts')
<script type="text/javascript">
</script>
@endpush