@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Study Abroad Dashboard</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                

                    <div class="row">
                        <div class="col-md-8 col-sm-12">
                            <div class="ribbon-vwrapper card card-inverse card-success">
                                <div class="ribbon ribbon-primary ribbon-vertical-l"><i class="fa fa-star"></i></div>
                                <p class="ribbon-content" style="color: #fff;">Update your Basic details, Education, Language Certifications, GRE/GMAT, Internships, Professional Experience</p>
                                <div class="p-t-10">
                                    <button type="button" class="btn btn-outline-secondary btn-rounded" onclick="document.location='{{ route('frontend.user.basicinfo') }}'">Tell us About Yourself&nbsp;&nbsp;&nbsp; <i class="fa fa-caret-right"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if(get_site_config('module_country_info'))
                    <div class="row">
                        <div class="col-md-8 col-sm-12">
                            <div class="ribbon-vwrapper card card-inverse card-primary">
                                <div class="ribbon ribbon-info ribbon-vertical-l"><i class="fa fa-star"></i></div>
                                <p class="ribbon-content" style="color: #fff;">Learn about academic requirements, Which courses are available, Specific rules in countries, University Information, University Applications process.</p>
                                <div class="p-t-10">
                                    <button type="button" class="btn btn-secondary btn-rounded" onclick="document.location='{{ route('frontend.user.hostcountryinfo') }}'">Which Country You want to Study In&nbsp;&nbsp;&nbsp; <i class="fa fa-caret-right"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="row">
                        <div class="col-md-8 col-sm-12">
                            <div class="ribbon-vwrapper card card-inverse card-danger">
                                <div class="ribbon ribbon-primary ribbon-vertical-l"><i class="fa fa-star"></i></div>
                                <p class="ribbon-content" style="color: #fff;">Let us know the Country & Course you want to study, We will send you the list of courses suitable for you.</p>
                                <div class="p-t-10">
                                    <button type="button" class="btn btn-secondary btn-rounded" onclick="document.location='{{ route('frontend.user.courseselection') }}'">Country & Course Selection&nbsp;&nbsp;&nbsp; <i class="fa fa-caret-right"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-8 col-sm-12">
                            <div class="ribbon-vwrapper card card-inverse card-warning">
                                <div class="ribbon ribbon-primary ribbon-vertical-l"><i class="fa fa-star"></i></div>
                                <p class="ribbon-content" style="color: #fff;">Our team of experts will evaluate your profile & suggest you the courses.</p>
                                <div class="p-t-10">
                                    <button type="button" class="btn btn-secondary btn-rounded" onclick="document.location='{{ route('frontend.user.coursesuggestion') }}'">Profile Evaluation & Course Suggestion&nbsp;&nbsp;&nbsp; <i class="fa fa-caret-right"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-8 col-sm-12">
                            <div class="ribbon-vwrapper card card-inverse" style="background-color: #333; border-color: #333;">
                                <div class="ribbon ribbon-primary ribbon-vertical-l"><i class="fa fa-star"></i></div>
                                <p class="ribbon-content" style="color: #fff;">Upload your academic certificates, Internship & professional experience letters.</p>
                                <div class="p-t-10">
                                    <button type="button" class="btn btn-secondary btn-rounded" onclick="document.location='{{ route('frontend.user.documents') }}'">Documents Upload&nbsp;&nbsp;&nbsp; <i class="fa fa-caret-right"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if(get_site_config('module_sop'))
                    <div class="row">
                        <div class="col-md-8 col-sm-12">
                            <div class="ribbon-vwrapper card card-inverse card-success">
                                <div class="ribbon ribbon-primary ribbon-vertical-l"><i class="fa fa-star"></i></div>
                                <p class="ribbon-content" style="color: #fff;">Sample Motivation letters, learn how to write a Motivation letter that is impressive.</p>
                                <div class="p-t-10">
                                    <button type="button" class="btn btn-outline-secondary btn-rounded" onclick="document.location='{{ route('frontend.user.sop') }}'">Motivation Letter / SOP&nbsp;&nbsp;&nbsp; <i class="fa fa-caret-right"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="row">
                        <div class="col-md-8 col-sm-12">
                            <div class="ribbon-vwrapper card card-inverse card-primary">
                                <div class="ribbon ribbon-info ribbon-vertical-l"><i class="fa fa-star"></i></div>
                                <p class="ribbon-content" style="color: #fff;">Track University Applications process. Fulfill requirements for University Applications stages.</p>
                                <div class="p-t-10">
                                    <button type="button" class="btn btn-secondary btn-rounded" onclick="document.location='{{ route('frontend.user.applications') }}'">University Applications Process&nbsp;&nbsp;&nbsp; <i class="fa fa-caret-right"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>

</div>
@endsection