@extends('frontend.layouts.app')

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush

@section('content')
<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="align-self-center">
        <h3 class="text text-themecolor">Ticket #{{ $ticket->ticket_id }} - {{ $ticket->subject }}</h3>
    </div>
</div>

<div class="container-fluid mt-3">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')

                    @if($ticket->status == 'new')
                    <span class="badge gradient-1 rounded-pill" style="font-size: 1.3em;padding:10px;">Open</span>
                    @elseif($ticket->status == 'customer_reply')
                    <span class="badge gradient-2 rounded-pill" style="font-size: 1.3em;padding:10px;">You Replied</span>
                    @elseif($ticket->status == 'staff_reply')
                    <span class="badge gradient-6 rounded-pill" style="font-size: 1.3em;padding:10px;">Answered</span>
                    @elseif($ticket->status == 'inprogress')
                    <span class="badge gradient-7 rounded-pill" style="font-size: 1.3em;padding:10px;">In Progress</span>
                    else
                    <span class="badge gradient-4 rounded-pill" style="font-size: 1.3em;padding:10px;">Closed</span>
                    @endif

                    &nbsp;&nbsp;Created On: {{ date('d M Y',strtotime($ticket->created_at)) }}
                    &nbsp;&nbsp;Last Update: @if($ticket->updated_at) {{ date('d M Y, h:i A',strtotime($ticket->updated_at)) }} @endif

                    @if($ticket->status != 'closed')
                    {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.ticket.reply'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    @method('PATCH')
                    <div style="border-bottom: 1px solid rgb(202,202,202); padding-bottom: 30px;">
                        <input type='hidden' name='ticket_id' value='{{ $ticket->ticket_id }}'>
                        <div class="form-group mt-3">
                            <label>Reply</label>
                            <textarea name='message' class="textarea_editor form-control" rows="7" required></textarea>
                        </div>
                        <div class="form-group">
                            <label>Attachments</label>
                            <br /><br><input type="file" id="attachment" multiple name="files[]" class="form-control" accept=".doc,.docx,.pdf,.jpg,.jpeg,.png,.gif,.zip" max="10">
                            <small>Note: Single File size limit is {{env('SUPPPORT_TICKETS_ATTACHMENT_MAX_SIZE')}}MB</small> <br>
                            <small>Note: Only 5 Files can be Uploaded</small>
                            <br /><strong class="small">Allowed File Types: .pdf, .docx, .doc, .jpg, .jpeg, .gif, .png</strong>
                        </div>

                        <div class="form-group" style="text-align: center">
                            {{ form_submit("Submit Reply") }}
                        </div>
                        {{ html()->closeModelForm() }}  
                    </div>
                    @endif

                    <div class="profiletimeline mb-5">
                        @foreach($messages as $message)
                        <div class="d-flex border-bottom py-3">
                            <div class="sl-left">
                                @if($message['reply_by'] == 'user')
                                <img src="../assets/images/users/you.jpg" alt="You" style="width: 50px; height:50px;" />
                                @else
                                <img src="../assets/images/users/support.jpg" alt="Support" style="width: 50px; height:50px;" />
                                @endif
                            </div>
                            <div class="d-flex mx-4 align-items-center">
                                <div>
                                    @if($message['reply_by'] == 'staff')
                                    <span class="text-primary">{{ $message['staff_name'] }}</span>
                                    @else
                                    <span class="text-primary">You</span>
                                    @endif
                                    <span class="sl-date text-primary">{{ date('d M Y, h:i A',strtotime($message['timestamp'])) }}</span>
                                    <p>
                                        {!!  $message['message'] !!}
                                    </p>

                                    @if(isset($message['all_attachment']))
                                        @php $all_attachments = explode("|", $message['all_attachment']) @endphp
                                        <p>
                                            <span class="text-warning">Attachments:</span><br />
                                            @foreach ($all_attachments as $attachments)
                                                @if($attachments)
                                                    <i class="fas fa-download"></i> 
                                                    <a href="<?php echo url('storage/tickets/' . $attachments); ?>" target="_blank">{{ substr($attachments, 8) }}</a>
                                                    <br />
                                                @endif
                                            @endforeach
                                        </p>
                                    @endif
                                </div>
                            </div>
                        </div>                              
                        @endforeach
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>                  
@endsection

@push ('after-scripts')
<script>
    $(document).ready(function() {     
        $("#attachment").on("change", function() {
            if ($("#attachment")[0].files.length > 5) {
                $("#attachment").val("");
                alert("You can select maximum 5 files");
            } 
        });
    });
</script>
@endpush