@extends('frontend.layouts.app')

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush

@section('content')
<div class="row page-titles">
    <div class="col-md-7 align-self-center ms-3">
        <h3 class="text-themecolor">{{ __('labels.frontend.user.profile.create_new_ticket') }}</h3>
    </div>
    {{-- <div class="col-md-5 align-self-center">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ url('home') }}">{{ __('labels.frontend.user.profile.dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ url('tickets') }}">{{ __('labels.frontend.user.profile.tickets') }}</a></li>
            <li class="breadcrumb-item">{{ __('labels.frontend.user.profile.new_ticket') }}</li>
        </ol>
    </div>     --}}
</div>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')
                    {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.ticket.new'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    @method('PATCH')
                    <div style="margin-top:10px;">
                        <div class="form-group">
                            <label class="required-field">{{ __('labels.frontend.user.profile.subject') }}</label>
                            <input type="text" name='subject' class="form-control" maxlength="100" required>
                        </div>
                        <div class="form-group mt-3">
                            <label class="required-field">{{ __('labels.frontend.user.profile.message') }}</label>
                            <textarea name='message' class="textarea_editor form-control" rows="7" required></textarea>
                        </div>

                        <div class="form-group">
                            <label>Attachments</label>
                            <br /><br><input type="file" id="attachment" multiple name="files[]" class="form-control" accept=".doc,.docx,.pdf,.jpg,.jpeg,.png,.gif,.zip" max="10">
                            <small>Note: Single File size limit is {{env('SUPPPORT_TICKETS_ATTACHMENT_MAX_SIZE')}}MB</small> <br>
                            <small>Note: Only 5 Files can be Uploaded</small>
                            <br /><strong class="small">Allowed File Types: .pdf, .docx, .doc, .jpg, .jpeg, .gif, .png</strong>
                        </div>

                        {{-- <div class="form-group mt-3">
                            <label>{{ __('labels.frontend.user.profile.attachments') }}</label>
                            <input name="file1" type="file" class="form-control" >
                            <input name="file2" type="file" class="form-control" >
                            <input name="file3" type="file" class="form-control" >
                            <input name="file4" type="file" class="form-control" >
                            <span class="small">{{ __('labels.frontend.user.profile.allowed_file_types') }}: .pdf, .docx, .doc, .jpg, .jpeg, .gif, .png</span>
                        </div> --}}

                        <div class="form-group mb-3 mt-3 text-center">
                            <button type="submit" class="btn btn-themecolor">{{ __('labels.frontend.user.profile.submit') }}</button>
                        </div>
                        {{ html()->closeModelForm() }}  
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
</div>                
@endsection

@push ('after-scripts')
<script>
    $(document).ready(function() {     
        $("#attachment").on("change", function() {
            if ($("#attachment")[0].files.length > 5) {
                $("#attachment").val("");
                alert("You can select maximum 5 files");
            } 
        });
    });
</script>
@endpush