@extends('frontend.layouts.app')

@section('content')

<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="col-md-5 align-self-center">
        <h3 class="text text-themecolor">{{ __('labels.frontend.user.profile.tickets') }}</h3>
    </div>
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" style="padding-top:10px; padding-bottom: 30px;">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')
                    <div class="d-flex justify-content-end p-2">
                        <div class="ml-auto" style="margin-top: -30px;">
                            <a href="{{ route('frontend.user.ticketnew') }}" class="btn btn-themecolor text-white">+ {{ __('labels.frontend.user.profile.create_new_ticket') }}</a>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table color-table info-table" >
                            <thead style="background-color: rgba(230, 229, 229, 0.999);,">
                                <tr>
                                    <th >#</th>
                                    <th  style="width: 50%;">{{ __('labels.frontend.user.profile.subject') }}</th>
                                    <th >{{ __('labels.backend.access.users.tabs.content.overview.status') }}</th>
                                    <th style="min-width: 140px !important;">{{ __('labels.frontend.user.profile.last_updated') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(count($tickets))
                                @foreach($tickets as $ticket)
                                <tr>
                                    <td>{{ $ticket->ticket_id }}</td>
                                    <td><a href="{{ route('frontend.user.ticket.detail', $ticket->ticket_id) }}">{{ $ticket->subject }}</a></td>
                                    <td>
                                        @if($ticket->status == 'new')
                                        <span class="badge gradient-1 rounded-pill">{{ __('labels.frontend.user.profile.open') }}</span>
                                        @elseif($ticket->status == 'customer_reply')
                                        <span class="badge gradient-2 rounded-pill">{{ __('labels.frontend.user.profile.you_replied') }}</span>
                                        @elseif($ticket->status == 'staff_reply')
                                        <span class="badge gradient-6 rounded-pill">{{ __('labels.frontend.user.profile.answered') }}</span>
                                        @elseif($ticket->status == 'inprogress')
                                        <span class="badge gradient-7 rounded-pill">{{ __('labels.frontend.user.profile.in_progress') }}</span>
                                        else
                                        <span class="badge gradient-4 rounded-pill">{{ __('labels.frontend.user.profile.closed') }}</span>
                                        @endif
                                    </td>
                                    <td>@if($ticket->updated_at) {{ date('d M Y, h:i A',strtotime($ticket->updated_at)) }} @endif</td>
                                </tr>
                                @endforeach
                                @else
                                <tr><td colspan="4">{{ __('labels.frontend.user.profile.no_tickets') }}</td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection