@extends('frontend.layouts.app')

@section('content')

<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="my-2 align-self-center">
        <h3 class="text">Service Application #{{$service_applications->appl_id}}</h3>
    </div>
</div>

<div class="container-fluid" style="padding-top:20px">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')
                    <h5>Service: <span class="text-themecolor">@if($service_applications->service_id){{get_services($service_applications->service_id)}}@else -- @endif</span></h5>
                    <h5>Country: @if($service_applications->country){{get_country_name($service_applications->country)}}@else -- @endif</h5>
                    <h5 class="mb-3">Status: <span class="badge gradient-6 rounded-pill"> @if($service_applications->service_id){{$service_applications->status}}@else -- @endif</span></h5>
                    <div class="row">
                        <h4 class="mb-3 p-3 my-4 w-100 border-bottom" style="background-color: #f5f6f7">{{ __('labels.frontend.user.profile.message_history') }}
                        </h4>
                        <div class="col-11 rounded mx-auto my-4 "
                                style="max-height: 300px; min-height:100px; overflow-y: auto; background-color: #EDF2FC !important; border: 1px solid rgb(220 220 220);">
                                @if (count($app_messages) > 0)
                                    @foreach ($app_messages as $msgs)
                                        <ul class="list-unstyled">
                                            <li class="justify-content-end">
                                                
                                                    <div class="card-body p-0  d-flex w-auto" style="max-width: 75%; min-width:40%; @if ($msgs->user_id == $logged_in_user->id) float:right; @endif" >
                                                        <div class="alert my-2 " style="@if ($msgs->user_id == $logged_in_user->id) background-color: #d4e5ff;@else background-color: #fff;  @endif" role="alert">
                                                            @if ($msgs->staff_id)
                                                                <p
                                                                    class="fw-bold mb-0  @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                    {{ get_user_full_name_by_id($msgs->staff_id) }}</p>
                                                            @else
                                                                <p
                                                                    class="fw-bold mb-0 @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                    {{ get_user_full_name_by_id($msgs->user_id) }}</p>
                                                            @endif
                                                            <p
                                                                class="mb-0 text-muted @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                <small>{{ date('d-M-Y h:i A', strtotime($msgs->created_at)) }}</small>
                                                            </p>
                                                            <div class="rounded-3" style="">
                                                                <p style="font-size: 15px; "
                                                                    class="@if ($msgs->user_id == Auth::user()->id) text-start @endif">
                                                                    {!! nl2br($msgs->message) !!}</p>
                                                                @if ($msgs->attachment_1)
                                                                    <p
                                                                        class="m-0 mt-1 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                        <a style="color: #0d6efd!important;"
                                                                            href="<?php echo url('storage/' . $msgs->attachment_1); ?>"
                                                                            target="_blank">{{ substr($msgs->attachment_1, strpos($msgs->attachment_1, '/') + 1) }}</a>
                                                                    </p>
                                                                @endif
                                                                @if ($msgs->attachment_2)
                                                                    <p
                                                                        class="m-0 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                        <a style="color: #0d6efd!important;"
                                                                            href="<?php echo url('storage/' . $msgs->attachment_2); ?>"
                                                                            target="_blank">{{ substr($msgs->attachment_2, strpos($msgs->attachment_2, '/') + 1) }}</a>
                                                                    </p>
                                                                @endif
                                                                @if ($msgs->attachment_3)
                                                                    <p
                                                                        class="m-0 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                        <a style="color: #0d6efd!important;"
                                                                            href="<?php echo url('storage/' . $msgs->attachment_3); ?>"
                                                                            target="_blank">{{ substr($msgs->attachment_3, strpos($msgs->attachment_3, '/') + 1) }}</a>
                                                                    </p>
                                                                @endif
                                                                @if ($msgs->attachment_4)
                                                                    <p
                                                                        class="m-0 small @if ($msgs->user_id == $logged_in_user->id) text-start @endif">
                                                                        <a style="color: #0d6efd!important;"
                                                                            href="<?php echo url('storage/' . $msgs->attachment_4); ?>"
                                                                            target="_blank">{{ substr($msgs->attachment_4, strpos($msgs->attachment_4, '/') + 1) }}</a>
                                                                    </p>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                
                                            </li>
                                        </ul>
                                    @endforeach
                                @else
                                <div class="container h-100 w-100 d-flex justify-content-center align-items-center">
                                   {{ __('labels.frontend.user.profile.no_messages_found') }}
                                  </div>
                                @endif
                            </div>
                            <div class="col-11 mt-3 my-4 mx-auto" >
                            <h4 class=" timeline-title"></h4>
                            <form action="{{route('frontend.user.service-visa.applications.message.send')}}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="app_id" value="{{$service_applications->id}}">
                                <div class="row">
                                    <div class="col-md-12 p-0">
                                        <div class="form-outline">
                                            <label
                                                class="timeline-title">Send Message to Staff</label>
                                            <div class="row w-75">
                                                <div class="col-9">
                                                <textarea class="form-control"  placeholder="Type a Message..." id="message" name="message" required
                                                rows="2"></textarea>
                                            </div>
                                            <div class="col-3 d-flex align-items-center">
                                                 <input type="submit" id="sendMsg" class="btn btn-themecolor  " 
                                                value="Send Message"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row my-4">
                                    <div class="col-md-6 p-0">
                                    <label
                                        class="timeline-title">Attach files:</label>
                                    <input type="file" name="attachment[]" id="attachment" accept=".doc,.jpeg,.jpg,.pdf,.docx,.png,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document" data-max="4" multiple>
                                    <p class="text-danger m-0" id="fileErr"></p>
                                    </div>
                                </div>
                                
                            </form>
                            </div>
                    </div>

                   
                    <h4  class="mb-3 p-3 w-100 border-bottom border-bottom" style="background-color: #f5f6f7">Service Application Activity</h4>


                    <div class="col-12 mt-3 "> 
                        @if(count($appActivity))
                        <ul class="timeline p-2">
                            @foreach($appActivity as $activity)
                            <div class="d-flex align-items-start mb-4">
                                <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height:50px; color:#EDF2FC">{{$loop->index+1}}</div>
                                <div class="ms-4 p-0">
                                    <div class="d-flex align-items-center ">
                                    <p class="text center h4 m-0">{!!$activity->title!!}</p>
                                </div>
                                <p class="my-1"><small class="text-muted "><i class="fa fa-clock-o"></i> {{ date('d M Y g:i A', strtotime($activity->created_at)) }}</small> </p>

                                    @if($activity->detail)
                                    <p>{!!$activity->detail!!}</p>
                                    @endif
                                    @if($activity->attachment)
                                        <?php $attachments = explode(',',$activity->attachment); ?>
                                            @foreach($attachments as $attachment)
                                            <p class="m-0 mt-1 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/app_activity/' . $attachment) ?>" target="_blank">{{$attachment}}</a></p>
                                            @endforeach
                                        @endif
                                        
                                </div>
                            </div>
                           
                                        <?php $attachments = explode(',',$activity->attachment); ?>
                                          
                            @endforeach

          

                                </ul class="py-4">
                            @else
                                <span
                                    class="ms-6 text-danger ">{{ __('labels.frontend.user.profile.no_activity_yet') }}</span>
                                <br>
                                <br>
                            @endif
                            {{-- @endif --}}

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection