@extends('frontend.layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row page-titles p-4 pb-0 wrapper" >
        <div class="col-md-5 align-self-center">
            <h3 class="text">{{ __('labels.frontend.user.profile.my_visa_and_services') }}</h3>
        </div>
    </div>

    <div class="row" style="padding-top:20px;">
        <div class="col-12">
            <div class="card card-outline-info">
                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4 "
                    style="">
                    {{ __('labels.frontend.user.profile.visa_and_services_applications') }}
                </div>
                <div class="card-body">
                    @include('includes.partials.messages')
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>{{ __('labels.backend.access.users.table.id') }}</th>
                                    <th>{{ __('labels.general.service') }}</th>
                                    <th>{{ __('labels.frontend.user.profile.country') }}</th>
                                    <th>{{ __('labels.general.amount') }}</th>
                                    <th>{{ __('labels.general.details') }}</th>
                                    <th>{{ __('labels.backend.access.users.tabs.content.overview.status') }}</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @if (count($service_applications))
                                    @foreach ($service_applications as $service_application)
                                    <tr>
                                        <td>{{ $service_application->appl_id }}</td>
                                        <td>@if($service_application->service_id){{ get_services($service_application->service_id) }}@else -- @endif</td>
                                        <td>@if($service_application->country){{ get_country_name($service_application->country) }}@else -- @endif</td>
                                        <td>@if($service_application->amount) {{env('APP_CURRENCY_SYMBOL')}} {{ $service_application->amount }}@else -- @endif</td>
                                        <td>@if($service_application->description){{ $service_application->description }}@else -- @endif</td>
                                        <td>@if($service_application->status){{ $service_application->status }}@else -- @endif</td>
                                        <td>
                                            <button onclick="document.location ='{{ route('frontend.user.service-visa.applications.detail', $service_application->id) }}'" type="button" class="btn btn-themecolor btn-rounded text-white">Details <i class="ms-1 fa fa-arrow-right"></i></button>
                                        </td>
                                    </tr>
                                    @endforeach
                                @else
                                <tr>
                                    <td colspan="5">
                                        {{ __('labels.frontend.user.profile.no_visa_and_services_applications_found') }}
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
        @if(get_site_config('student_allow_add_new_university_application'))
        <div class="col-md-5 col-sm-12">
            <div class="card card-outline-info">
                <div class="card-header">
                    <h4 class="m-b-0 text-white">Add New Course</h4>
                </div>
                <div class="card-body">
                    {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.applications.add'))->class('form-horizontal')->open() }}

                    <div class="form-group">
                        <label>Country</label>
                        <select class="form-control" name="country" required>
                            @foreach($countries as $country)
                            <option value="{{$country}}">{{$country}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Course</label>
                        <input type="text" name="course" class='form-control' required />
                    </div>
                    <div class="form-group">
                        <label>University</label>
                        <input type="text" name="university" class='form-control' required />
                    </div>
                    <div class="form-group">
                        <label>Year</label>
                        {{ html()->select('year', $years)->class('form-control') }}
                    </div>
                    <div class="form-group">
                        <label>Intake</label><br />
                        {{ html()->select('intake', $months)->class('form-control') }}
                    </div>
                    <div class="form-group mb-0 clearfix">
                        <input type="submit" name="submit" class="btn btn-themecolor" value="Add Course" />
                    </div>
                </div>
            </div>
        </div>
        @endif
        @endif

    </div>
</div>
@endsection