@extends('frontend.layouts.app')
@section('title'){{'Apply for Overseas'}}@endsection

<?php
$countries = get_study_countries();
?>
@section('content')
<div class="row page-titles">
    <div class="col-md-8 align-self-center">
        <h3 class="text-themecolor">Apply for Overseas</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs customtab2" role="tablist">
                        <li class="nav-item"> <a class="nav-link" href="{{route('frontend.user.studyabroad.profile')}}" role="tab"><span class="hidden-sm-up"><i class="ti-user"></i></span> <span class="hidden-xs-down">Profile</span></a> </li>
                        <li class="nav-item"> <a class="nav-link active" href="{{route('frontend.user.visa.preference')}}" role="tab"><span class="hidden-sm-up"><i class="ti-book"></i></span> <span class="hidden-xs-down">Visa Preferences</span></a> </li>
                        <li class="nav-item"> <a class="nav-link" href="{{route('frontend.user.visa.documents')}}" role="tab"><span class="hidden-sm-up"><i class="ti-folder"></i></span> <span class="hidden-xs-down">Documents Upload</span></a> </li>
                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div class="tab-pane active" id="course" role="tabpanel">
                            <div class="p-t-20">
                                @if($profile_pending)
                                <div class="alert alert-danger" role="alert">
                                    Your must complete your profile details before you can fill this form.
                                </div>
                                @endif
                                @if(!$profile_pending && !$can_edit)
                                <div class="alert alert-success" role="alert">
                                    Your have completed this step.
                                </div>
                                @endif

                                <h6 class="card-subtitle">Choose Country, Visa Type preferences.</h6>
                                <form method="post" action="{{route('frontend.user.visa.preference.save')}}">
                                    @csrf
                                    {{--<div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="required-field">Choose Study Level</label>
                                                <select class="form-control form-select" name="overseas_study_level" required>
                                                    <option value="">Select</option>
                                                    <option value="Pre-Bachelors" @if($logged_in_user->overseas_study_level == 'Pre-Bachelors') selected @endif>Pre-Bachelors /Foundation Course</option>
                                                    <option value="Bachelors" @if($logged_in_user->overseas_study_level == 'Bachelors') selected @endif>Bachelors Degree</option>
                                                    <option value="Pre-Masters" @if($logged_in_user->overseas_study_level == 'Pre-Masters') selected @endif>Pre-Masters / Extension Masters</option>
                                                    <option value="Masters" @if($logged_in_user->overseas_study_level == 'Masters') selected @endif>Masters Degree</option>
                                                    <option value="Ph.D" @if($logged_in_user->overseas_study_level == 'Ph.D') selected @endif>Ph.D</option>
                                                    <option value="Others" @if($logged_in_user->overseas_study_level == 'Others') selected @endif>Others</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>--}}

                                    <div class="row m-t-20">
                                        <div class="col-md-12">
                                            <div class="card card-outline-info">
                                                <div class="card-header">
                                                    <h4 class="m-b-0 text-white">Country, Visa Type Details</h4>
                                                </div>
                                                <div class="card-body">
                                                    <div class="table-responsive">
                                                        <table>
                                                            <thead>
                                                                <tr>
                                                                    <th>Country</th>
                                                                    <th>Service Type</th>
                                                                    <th>Visa Letter Type</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>

                                                                @php
                                                                $i = 0;
                                                                @endphp

                                                                @foreach ($visaprefs as $visapref)
                                                                <tr>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control form-select" name="visa[<?= $i ?>][country]" @if($i==0) required @endif>
                                                                            <option value=""></option>
                                                                            @foreach($countries as $country)
                                                                            <option value="{{$country}}" @if($country==$visapref->country) selected @endif>{{$country}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control form-select servicetypes" id="service_type_<?= $i ?>" name="visa[<?= $i ?>][service_type]" @if($i==0) required @endif>
                                                                            <option value=""></option>
                                                                            @foreach($service_types as $service_type)
                                                                            <option value="{{$service_type->id}}" @if($service_type->id == $visapref->service_type) selected @endif>{{$service_type->title}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control form-select" id="letter_type_<?= $i ?>" name="visa[<?= $i ?>][letter_type]" @if($i==0) required @endif>
                                                                            <option value="{{$visapref->letter_type}}">{{$visapref->letter_type_title}}</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                                @php
                                                                $i++;
                                                                @endphp
                                                                @endforeach

                                                                @for($j = $i; $j < 4; $j++) 
                                                                <tr>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control" name="visa[<?= $j ?>][country]" @if($j==0) required @endif>
                                                                            <option value=""></option>
                                                                            @foreach($countries as $country)
                                                                            <option value="{{$country}}">{{$country}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control form-select servicetypes" id="service_type_<?= $j ?>" data-idx="<?= $j ?>" name="visa[<?= $j ?>][service_type]" @if($j==0) required @endif>
                                                                            <option value=""></option>
                                                                            @foreach($service_types as $service_type)
                                                                            <option value="{{$service_type->id}}">{{$service_type->title}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control form-select" id="letter_type_<?= $j ?>" name="visa[<?= $j ?>][letter_type]" @if($j==0) required @endif>
                                                                            <option value=""></option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                                @endfor
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="mt-4 text-center">
                                        <button @if(!$can_edit) type="button" class="btn btn-secondary" style="cursor:no-drop;" disabled @else type="submit" class="btn btn-themecolor" @endif>Save & Continue</button>
                                    </div>

                                </form>
                            </div>
                        </div>


                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('.servicetypes').on('change', function() {
            var idServiceType = this.value;
            var idx = $(this).data('idx');
            $('#letter_type_'+idx).html('<option value="">Loading...</option>');
            $('#letter_type_'+idx).attr('disabled', 'disabled');
            $.ajax({
                url: "{{url('api/fetch-visa-letter-types')}}",
                type: "POST",
                data: {
                    service_id: idServiceType,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                idx_val: idx,
                currency: '{{config('app.currency_symbol')}}',         
                beforeSend: function(){
                    console.log(new Date().toLocaleString()+":Service type changed..Fetching the letter types...");
                },
                success: function(result) {
                    console.log(new Date().toLocaleString()+":Fetch letter types completed.");
                    $('#letter_type_'+this.idx_val).removeAttr('disabled');
                    $('#letter_type_'+this.idx_val).html('<option value="">Select</option>');
                    //console.log(result.lettertypes);
                    for(var i = 0; i < result.lettertypes.length; i++) {
                        var fees = ' (Price: ' + this.currency + Math.round(result.lettertypes[i].fees) +')';
                        $('#letter_type_'+this.idx_val).append('<option value="' + result.lettertypes[i].id + '">' + result.lettertypes[i].title + fees + '</option>');
                    }
                }
            });
        });       
        
    });
</script>
@endpush