@extends('frontend.layouts.app')

@section('content')



<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="col-md-5  align-self-center">
        <h3 class="text text-themecolor">{{ __('labels.frontend.user.student.webinar_and_events') }}</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" >

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card card-outline-info">
                <div class="text-start text-white fs-20 card-header text-start bg-theme p-2 ps-4 " style="">
                    {{ __('labels.frontend.user.student.upcoming_webinar_and_events') }}
                </div>
                @include('includes.partials.messages') 

                <div class="row ">
                    <div class="col">
                        <div class="table-responsive">
                            <table class="table"> 
                                <thead>
                                    <tr> 
                                        <th>{{ __('labels.general.date') }}</th>
                                        <th>{{ __('labels.general.details') }}</th>
                                        <th><center>{{ __('labels.general.actions') }}</center></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($datas))
                                    @foreach($datas as $data)
                                    <tr>
                                        <td class="text-nowrap"> 
                                            {{implode(' ', array_slice(explode(' ', $data['datetime']), 0, 3));}}
                                            <br>
                                            {{implode(' ', array_slice(explode(' ', $data['datetime']), 3));}}
                                        </td>
                                        <td>
                                            <span style="font-size:1.3rem;font-weight: bold;" class="text-primary">{{$data['topic']}}</span><br> 
                                            <img src="{{asset('/storage/'.$data['image'])}}" style="width: 500px !important" class="img-responsive rounded m-b-10 m-t-10">

                                            {{-- Course&nbsp:&nbsp<b>{{$data['title']}}</b><br> --}}

                                            <br>{{ __('labels.general.venue') }}&nbsp:&nbsp<b>{{$data['venue']}}</b><br>

                                            <div class="p-t-10 p-b-20">{{$data['description']}}</div>
                                        </td>   
                                        <td>  
                                            @if($data['registered'])
                                            <span class="text-success">{{ __('labels.frontend.auth.registered_button') }}</span>
                                            <br>
                                            @else
                                            <a href="{{route('frontend.user.webinar.register',$data['id']) }}" 
                                            id="registerLink"
                                            class="btn btn-themecolor">{{ __('labels.frontend.auth.register_button') }}</a>
                                            <br>
                                            @endif
                                            @if($data['date'] == $ldate && $data['registered'])
                                            @if($data['link'])
                                            <a href="{{$data['link']}}" target="_blank" class="btn btn-success">{{ __('labels.frontend.user.student.join_meeting') }}</a>
                                            @endif
                                            @endif
                                        </td>  
                                    </tr> 
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="3" class="text-center">{{ __('labels.frontend.user.student.no_data_found') }}</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div> 
                </div>   
            </div>
        </div>
    </div>
</div><br>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection
@push('after-scripts')  

<script type="text/javascript">
    function confirmRegister(e, el) {
        e.preventDefault();
        if (confirm('Register for this Event?')) {
            window.location.href = el.href;
        }
    }
</script>
@endpush 