@extends('frontend.layouts.app')

@section('public_content')
<div class="row page-titles wrapper px-5 py-5" style="box-shadow: rgba(0, 0, 0, 0.2) 0px 5px 5px -3px;">
    <h2 class="mb-3">{{ $webinar->topic }}</h2>
    <p><strong>Date:</strong> {{ \Carbon\Carbon::parse($webinar->date)->format('d M Y, h:i A') }}</p>
    <p><strong>Venue:</strong> {{ $webinar->venue ?? 'Online' }}</p>

    @if($webinar->description)
        <div class="mt-3">
            <strong>Description:</strong>
            <p>{{ $webinar->description }}</p>
        </div>
    @endif

    @if($webinar->link)
        <div class="mt-3">
            <a href="{{$webinar->link}}" target="_blank" class="btn btn-primary">🔗 Join Webinar</a>
        </div>
    @endif

    @if($webinar->image)
        <div class="mt-4">
            <img src="{{ asset('storage/' . $webinar->image) }}" alt="Webinar Image" class="img-fluid rounded">
        </div>
    @endif
</div>
@endsection

@if($webinar->topic)
@section('title'){{$webinar->topic}}@endsection
@endif
