<?php

use App\Exceptions\FailedToProcess;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Backend\WebinarController;
use App\Http\Controllers\GoogleSheetSyncController;
use App\Http\Controllers\UnivApplicationsController;
use App\Http\Controllers\Backend\OpenAiApiController;
use App\Http\Controllers\Backend\FormBuilderController;
use App\Http\Controllers\Backend\WebinarAgentController;

/*
 * All route names are prefixed with 'admin.'.
 */

Route::get('webinar', [WebinarController::class, 'index'])->name('admin.webinar.index');
Route::get('webinar', [WebinarController::class, 'index'])->name('webinar.index');
Route::get('form-builder',[FormBuilderController::class,'index'])->name('form-builder');
Route::get('form-builder/{id?}/edit',[FormBuilderController::class,'edit_form'])->name('form-builder.edit-form');
Route::post('store-form',[FormBuilderController::class,'store'])->name('store-form');
Route::get('add-item-to-form',[FormBuilderController::class,'addItemToForm']);
Route::get('add-enquiry-to-form',[FormBuilderController::class,'addEnquiryToForm']);
Route::post('update-form',[FormBuilderController::class,'updateForm']);	
Route::post('update-formitem/{id}',[FormBuilderController::class,'updateFormItem']);
Route::get('delete-formitem/{id}/{key}/{attr_name?}',[FormBuilderController::class,'deleteFormItem']);
Route::get('delete-form/{id}',[FormBuilderController::class,'destroy']);

Route::get('form-builder/{id}/form_html',[FormBuilderController::class,'view_form_html'])->name('form-builder.view_form_html');
Route::get('form-builder/{id}/form_qr',[FormBuilderController::class,'view_form_qr'])->name('form-builder.view_form_qr');

Route::post('api/validate-email-mobile', [HomeController::class, 'validate_email_mobile'])->name('validate-email-mobile');
Route::post('api/search-users', [HomeController::class, 'searchUser'])->name('searchUser');
Route::post('api/search-ref-users', [HomeController::class, 'get_ref_users_list'])->name('get-ref-users');
Route::post('api/search-students', [HomeController::class, 'searchStudent'])->name('searchStudent');
Route::get('generate-student-ref-codes', [HomeController::class, 'generate_student_ref_codes'])->name('generate-student-ref-codes');
Route::post('mailtemplates/ajaxgetmailtpl', 'DashboardController@ajaxgetmailtpl')->name('mailtemplates.ajaxgetmailtpl');
Route::post('cannedtemplates/ajaxgetcannedtpl', 'DashboardController@ajaxgetcannedtpl')->name('cannedtemplates.ajaxgetcannedtpl');

Route::post('clockin', 'DashboardController@clockIn')->name('clockin');
Route::post('clockout', 'DashboardController@clockOut')->name('clockout');

Route::get('my-leaves', 'LeavesManagementController@index')->name('my-leaves');
Route::get('my-leaves/apply', 'LeavesManagementController@apply')->name('my-leaves.apply');
Route::post('my-leaves/save', 'LeavesManagementController@store')->name('my-leaves.save');

//Course Preferences
Route::post('api/search-course', [HomeController::class, 'searchCourse'])->name('searchCourse');
Route::post('api/search-university', [HomeController::class, 'searchUniversity'])->name('searchUniversity');

//For admin order generate
Route::post('create-order/search-student', [HomeController::class, 'search_student'])->name('create-order.search_student');
Route::post('create-order/search-students-data', [HomeController::class, 'searchStudentData'])->name('create-order.searchStudentData');

//Route::redirect('/', '/admin/dashboard', 301);
Route::get('dashboard/{branch?}', 'DashboardController@index')->name('dashboard');
Route::get('agent-dashboard', 'DashboardController@agentIndex')->name('agent.dashboard');
Route::get('dashboard/message', 'DashboardController@showMessage')->name('dashboard.message');
Route::get('agent-announcement/{id}', 'DashboardController@announcementsAgent')->name('agent_announcement');
Route::get('announcements-list', 'DashboardController@announcementslist')->name('announcementslist');

Route::get('country-info/{id?}', 'CountryInfoController@index')->name('countryinfo');
Route::post('addfolder', 'CountryInfoController@addfolder')->name('countryinfo.addfolder');
Route::post('adddoc', 'CountryInfoController@adddoc')->name('countryinfo.adddoc');
Route::get('countryinfo/removefolder/{id}', 'CountryInfoController@removefolder')->name('countryinfo.removefolder');
Route::get('countryinfo/removedoc/{id}', 'CountryInfoController@removedoc')->name('countryinfo.removedoc');

Route::get('tickets/{q?}', 'SupportTicketController@index')->name('ticketlist');
Route::post('tickets/ajaxticketlist', 'SupportTicketController@ajaxticketlist')->name('ajaxticketlist');
Route::get('ticket/{id}', 'SupportTicketController@view')->name('viewticket');
Route::patch('ticketreply', 'SupportTicketController@reply')->name('replyticket');
Route::get('ticketnew/{user_id?}', 'SupportTicketController@new_ticket')->name('newticket');
Route::patch('ticketcreate', 'SupportTicketController@create')->name('createticket');
Route::get('ticketclose/{id}', 'SupportTicketController@close')->name('closeticket');
Route::get('ticketinprogress/{id}', 'SupportTicketController@inprogress')->name('inprogressticket');
Route::get('ticket/filter', 'SupportTicketController@search')->name('filterticket');
Route::get('ticket/user/{id}', 'SupportTicketController@ticketsbyuser')->name('filterticketbyuser');
Route::get('tickets/assign-staff/{staffid}/{ticketid}', 'SupportTicketController@assignStaff')->name('tickets.assignstaff');

Route::get('applications', 'UnivApplicationsController@index')->name('applications');
Route::get('applications/create', 'UnivApplicationsController@create')->name('applications.create');
Route::post('applications/store', 'UnivApplicationsController@store')->name('applications.store');
Route::post('applications/search', 'UnivApplicationsController@search')->name('applicationsearch');
Route::get('application/detail/{id}', 'UnivApplicationsController@detail')->name('applicationdetail');
//Route::get('application/download-documents/{id}', 'UnivApplicationsController@downloadDocuments')->name('application.download-documents');
Route::get('application/download-docs/{id}', 'UnivApplicationsController@downloadDocsZip')->name('application.downloadDocsZip');

Route::post('application/delete', 'UnivApplicationsController@delete')->name('applicationdelete');

Route::post('application/add-task', 'UnivApplicationsController@add_task')->name('application.add-task');
Route::get('application/clear-task/{id}', 'UnivApplicationsController@clear_task')->name('application.clear-task');


Route::post('application/add-activity', 'UnivApplicationsController@add_activity')->name('application.add-activity');
Route::post('application/delete-activity', 'UnivApplicationsController@delete_activity')->name('application.delete-activity');
Route::post('application/activity-done', 'UnivApplicationsController@activity_done')->name('application.activity-done');

Route::post('service-application/add-activity', 'ServiceController@add_activity')->name('service-application.add-activity');
Route::post('service-application/delete-activity', 'ServiceController@delete_activity')->name('service-application.delete-activity');
Route::post('service-application/activity-done', 'ServiceController@activity_done')->name('service-application.activity-done');


Route::post('application/update', 'UnivApplicationsController@updateStatus')->name('applicationedit');
Route::post('application/status-update', 'UnivApplicationsController@status_update')->name('application-status-update');
Route::post('applications/getdata/{q?}', 'UnivApplicationsController@ajaxapplicationdata')->name('applications.ajaxapplicationdata');
Route::get('application/close/{id}', 'UnivApplicationsController@closeCase')->name('applications.close');



Route::post('application/status-update-notes', 'UnivApplicationsController@status_update_notes')->name('application-status-updated-notes');

Route::post('application/update-notes', 'UnivApplicationsController@updateNotes')->name('applications.application-update-notes');

Route::get('application/agent-commission/{id}', 'UnivApplicationsController@agentCommission')->name('applications.agent-commission');
Route::post('applications/agent-commission/update', 'UnivApplicationsController@agentCommissionUpdate')->name('applications.agentcommissionupdate');

Route::post('application/send/message', 'UnivApplicationsController@sendMessage')->name('application.message.send');

Route::get('application/college-assignstaff/{id}', 'UnivApplicationsController@assignCollegeApplStaff')->name('collegeApplication.assignstaff');
Route::post('application/college-assignstaff-update', 'UnivApplicationsController@assignCollegeApplStaffUpdate')->name('collegeApplication.assignstaff.update');

Route::get('application/course-university/edit-view/{course_pref}/{byApplOrCouPref}', 'UnivApplicationsController@courseUniversityEditView')->name('application.course-university.edit.view');
Route::post('application/course-university/edit-save', 'UnivApplicationsController@courseUniversityEditSave')->name('application.course-university.edit.save');

Route::get('mail/{id}', 'CommunicationController@mail')->name('communicate.mail');
Route::post('mail/{id}/send', 'CommunicationController@mailSend')->name('communicate.mail.send');
Route::get('sms/{id}', 'CommunicationController@sms')->name('communicate.sms');
Route::post('sms/{id}/send', 'CommunicationController@smsSend')->name('communicate.sms.send');
Route::get('whatsapp/{id}', 'CommunicationController@whatsapp')->name('communicate.whatsapp');
Route::post('whatsapp/{id}/send', 'CommunicationController@whatsappSend')->name('communicate.whatsapp.send');

Route::get('staff-leaves', 'LeavesManagementController@staffLeaves')->name('staff-leaves');
Route::post('ajaxstaffleaves', 'LeavesManagementController@ajaxstaffleaves')->name('ajaxstaffleaves');
Route::post('staff-leaves/approve', 'LeavesManagementController@approve')->name('staff-leaves.approve');
Route::post('staff-leaves/reject', 'LeavesManagementController@reject')->name('staff-leaves.reject');
Route::get('staff-attendance', 'StaffAttendanceController@index')->name('staff-attendance');
Route::post('ajaxstaffattendance', 'StaffAttendanceController@ajaxstaffattendance')->name('ajaxstaffattendance');

//call
Route::get('communication/call/{user_id}', 'CommunicationController@phoneCall')->name('communicate.phoneCall');


Route::get('settings/holidays', 'SettingsController@holidays')->name('settings.holidays');
Route::post('settings/holidays/save', 'SettingsController@holidaysSave')->name('settings.holidays.save');

//Agent Invoice
Route::get('agent-invoices','AgentInvoiceController@index')->name('agent-invoice');
Route::get('invoices-list','AgentInvoiceController@invoices_list')->name('agent-invoice.invoice-list');
Route::get('invoice/{id?}/viewAgentInvoice', 'AgentInvoiceController@view_invoice')->name('agent-invoice.viewMyInvoice');
Route::get('invoice/{id?}/downloadAgentInvoice', 'AgentInvoiceController@download_invoice')->name('agent-invoice.downloadAgentInvoice');


Route::post('downloads/user-alldocs', 'DownloadsController@user_alldocs')->name('downloads.userdocs');
Route::post('downloads/user-profile', 'DownloadsController@user_profile_pdf')->name('downloads.userprofile');

Route::get('downloads/invoice/{id}', 'DownloadsController@invoice_pdf')->name('downloads.invoice');
Route::get('email/invoice/{id}', 'DownloadsController@email_invoice_pdf')->name('email.invoice');

Route::get('downloads/uni-invoice/{id}', 'DownloadsController@uni_invoice_pdf')->name('downloads.uni-invoice');
Route::get('downloads/uni-apply-agent-invoice/{id}', 'DownloadsController@uni_apply_agent_invoice_pdf')->name('downloads.uni-apply-agent-invoice');
Route::get('downloads/ad-hoc-invoice/{id}', 'DownloadsController@ad_hoc_invoice_pdf')->name('downloads.ad-hoc-invoice');

Route::get('courseinfo', 'CourseInfoController@index')->name('courseinfo');
Route::get('courseinfo/create', 'CourseInfoController@create')->name('courseinfo.create');
Route::post('courseinfo/store', 'CourseInfoController@store')->name('courseinfo.store');
Route::get('courseinfo/{id}/edit', 'CourseInfoController@edit')->name('courseinfo.edit');
Route::patch('courseinfo/{id}', 'CourseInfoController@update')->name('courseinfo.update');
Route::get('courseinfo/{id}', 'CourseInfoController@show')->name('courseinfo.show');
Route::delete('courseinfo/{id}', 'CourseInfoController@destroy')->name('courseinfo.destroy');

Route::get('courses', 'CoursesController@index')->name('courses');
Route::get('courses/addcourse', 'CoursesController@create')->name('course.create');
Route::post('courses/store', 'CoursesController@store')->name('course.store');
Route::get('courses/{id}/edit', 'CoursesController@edit')->name('course.edit');
Route::patch('courses/{id}', 'CoursesController@update')->name('course.update');
Route::delete('courses/{id}/destroy', 'CoursesController@destroy')->name('course.destroy');


//Leads
Route::get('leads/{q?}', 'LeadsController@index')->name('leadmanagementdetails');
Route::post('ajaxleadlist', 'LeadsController@ajaxleadlist')->name('ajaxleadlist');
Route::get('lead/create', 'LeadsController@create')->name('leadmanagementdetails.create');
Route::get('lead/{id}/edit', 'LeadsController@edit')->name('leadmanagement.edit');
Route::post('lead/{id}/update', 'LeadsController@update')->name('leadmanagement.update');
Route::delete('lead/{id}', 'LeadsController@destroyed')->name('leadmanagement.destroy');
//Route::get('lead/{id}', 'LeadsController@view')->name('leadmanagement.view');

Route::post('lead/add-tag', 'LeadsController@add_tag')->name('leadmanagement.add-tag');
Route::post('lead/remove-tag', 'LeadsController@remove_tag')->name('leadmanagement.remove-tag');

// Route::get('lead/changestatus/{leadid}/{status}', 'LeadsController@changestatus')->name('leads.changestatus');
Route::post('lead/changestatus', 'LeadsController@changestatus')->name('leads.changestatus');

Route::post('lead/bulk-changestatus-update', 'LeadsController@bulkChangeStatus')->name('leads.changestatus.update');
Route::post('lead/{id}/convert', 'LeadsController@convert')->name('leadmanagement.convert');
Route::get('lead/assignstaff/{leadid}', 'LeadsController@assignStaff')->name('leads.assignstaff');
Route::post('lead/assignstaff-update', 'LeadsController@assignStaffUpdate')->name('leads.assignstaff.update');
Route::get('lead/{id}/followups', 'LeadsController@followups')->name('leadmanagement.followups');
Route::get('lead/{id}/counselling', 'LeadsController@counselling')->name('leadmanagement.counselling');
Route::post('lead/{id}/update_followups', 'LeadsController@update_followups')->name('leadmanagement.update_followups');
//Route::post('lead/{id}/update_notes', 'LeadsController@update_notes')->name('leadmanagement.update_notes');
Route::post('lead/assign-counseller', 'LeadsController@assignCounseller')->name('leadmanagement.assigncounseller');
Route::post('lead/next-followup-date-view', 'LeadsController@bulkNextFollowupDateView')->name('leads.next-followup-date.view');
Route::post('lead/next-followup-date-update', 'LeadsController@bulkNextFollowupDateUpdate')->name('leads.next-followup-date.update');

Route::post('lead/bulkstatuschange', 'LeadsController@bulkStatusChange')->name('leads.bulkstatuschange');
Route::post('lead/bulkdeletelead', 'LeadsController@bulkDeleteLead')->name('leads.bulkdeletelead');
Route::post('lead/bulkassignstaff', 'LeadsController@bulkAssignStaff')->name('leads.bulkassignstaff');

Route::get('lead/deleted', 'LeadsController@getDeleted')->name('leads.deleted');
Route::get('lead/restore-lead/{id}', 'LeadsController@restoreLead')->name('leads.restore');
Route::get('lead/permanently-delete-lead/{id}', 'LeadsController@delete')->name('leads.delete-permanently');

Route::get('lead/{id}/disqualified', 'LeadsController@disqualified')->name('leadmanagement.disqualified');
Route::post('lead/status-updated-disqualified', 'LeadsController@updateToDisqualified')->name('leadmanagement.update-to-disqualified');

// Route::get('lead/lead-import-open/{currentPage}', 'LeadsController@leadImportOpen')->name('leadmanagement.import.open');



//Counselling
Route::get('counsellings/{q?}', 'CounsellingController@index')->name('counsellingdetails');
Route::post('ajaxcounsellinglist', 'CounsellingController@ajaxcounsellinglist')->name('ajaxcounsellinglist');
Route::get('counselling/changestatus/{leadid}/{status}', 'CounsellingController@changestatus')->name('counselling.changestatus');
Route::post('counselling/{id}/convert', 'CounsellingController@convert')->name('counselling.convert');
Route::get('counselling/{id}/followups', 'CounsellingController@followups')->name('counselling.followups');
Route::post('counselling/{id}/update_followups', 'CounsellingController@update_followups')->name('counselling.update_followups');
//Route::post('counselling/{id}/update_notes', 'CounsellingController@update_notes')->name('counselling.update_notes');





Route::get('broadcast', 'BroadcastMessageController@index')->name('broadcast.index');
Route::post('broadcast/preview', 'BroadcastMessageController@preview')->name('broadcast.preview');
Route::post('broadcast/send', 'BroadcastMessageController@send')->name('broadcast.send');

Route::get('broadcast-history', 'BroadcastMessageController@broadcast_history')->name('broadcast.broadcast-history');
Route::get('broadcast-history-list','BroadcastMessageController@broadcast_history_list')->name('broadcast-history-list');

Route::get('upload', 'UploadDocumentController@index')->name('upload');

Route::post('uploaddoc', 'UploadDocumentController@uploaddoc')->name('upload.uploaddoc');
Route::delete('upload/deletedoc/{id}', 'UploadDocumentController@deletedoc')->name('upload.deletedoc');
Route::get('upload/category', 'UploadDocumentController@create')->name('upload.create');
Route::get('show/category', 'UploadDocumentController@showCategory')->name('show.category');
Route::get('edit/category/{id}', 'UploadDocumentController@editCategory')->name('edit.category');
Route::post('edit/category/store', 'UploadDocumentController@editCategoryStore')->name('edit.category.store');
Route::post('upload/store', 'UploadDocumentController@category')->name('upload.store');
Route::post('upload/category/delete', 'UploadDocumentController@delete')->name('upload.category.delete');

// Agent side Resource
Route::get('agent/agent-resources', 'AgentManagementController@agentResourcesIndex')->name('agent.resources');
Route::get('agent/category/resources/{id}', 'AgentManagementController@agentResourcesCategory')->name('agent.selected.category');
Route::get('resources/video-audio/{id}', 'AgentManagementController@media')->name('agent.viewvideo');
Route::get('mailtemplates', 'MailTemplatesController@index')->name('mailtemplates');
Route::get('mailtemplates/create', 'MailTemplatesController@create')->name('mailtemplates.create');
Route::post('mailtemplates/save', 'MailTemplatesController@store')->name('mailtemplates.store');
Route::get('mailtemplates/{id}/edit', 'MailTemplatesController@edit')->name('mailtemplates.edit');
Route::patch('mailtemplates/{id}', 'MailTemplatesController@update')->name('mailtemplates.update');
Route::delete('mailtemplates/{id}', 'MailTemplatesController@destroy')->name('mailtemplates.delete');
Route::get('mailtemplates/{id}/status/{status}', 'MailTemplatesController@changeStatus')->name('mailtemplates.changestatus');
Route::post('ai-rephrase/open-ai-api-call', [OpenAiApiController::class,'rephrase'])->name('ai_rephrase.openapi.call');

Route::get('announcements', 'AnnouncementsController@index')->name('announcements');
Route::post('announcements-list','AnnouncementsController@ajaxannouncementslist')->name('ajaxannouncementslist');
Route::get('announcements/create', 'AnnouncementsController@create')->name('announcements.create');
Route::post('announcements/save', 'AnnouncementsController@store')->name('announcements.save');
Route::get('announcements/edit/{id}','AnnouncementsController@edit')->name('announcements.edit');
Route::patch('announcements/update/{id}','AnnouncementsController@update')->name('announcements.update');
Route::delete('announcements/{id}', 'AnnouncementsController@destroy')->name('announcements.delete');


Route::get('smstemplates', 'SMSTemplatesController@index')->name('smstemplates');
Route::get('smstemplates/create', 'SMSTemplatesController@create')->name('smstemplates.create');
Route::post('smstemplates/save', 'SMSTemplatesController@store')->name('smstemplates.store');
Route::get('smstemplates/{id}/edit', 'SMSTemplatesController@edit')->name('smstemplates.edit');
Route::patch('smstemplates/{id}', 'SMSTemplatesController@update')->name('smstemplates.update');
Route::delete('smstemplates/{id}', 'SMSTemplatesController@destroy')->name('smstemplates.delete');
Route::post('smstemplates/ajaxgetsmstpl', 'SMSTemplatesController@ajaxgetsmstpl')->name('smstemplates.ajaxgetsmstpl');
Route::get('smstemplates/{id}/status/{status}', 'SMSTemplatesController@changeStatus')->name('smstemplates.changestatus');

Route::get('whatsapptemplates', 'WhatsappTemplatesController@index')->name('whatsapptemplates');
Route::get('whatsapptemplates/create', 'WhatsappTemplatesController@create')->name('whatsapptemplates.create');
Route::post('whatsapptemplates/save', 'WhatsappTemplatesController@store')->name('whatsapptemplates.store');
Route::get('whatsapptemplates/{id}/edit', 'WhatsappTemplatesController@edit')->name('whatsapptemplates.edit');
Route::patch('whatsapptemplates/{id}', 'WhatsappTemplatesController@update')->name('whatsapptemplates.update');
Route::delete('whatsapptemplates/{id}', 'WhatsappTemplatesController@destroy')->name('whatsapptemplates.delete');
Route::post('whatsapptemplates/ajaxgetwhtsptpl', 'WhatsappTemplatesController@ajaxgetwhtsptpl')->name('whatsapptemplates.ajaxgetwhtsptpl');
Route::get('whatsapptemplates/{id}/status/{status}', 'WhatsappTemplatesController@changeStatus')->name('whatsapptemplates.changestatus');

//canned responses
Route::get('cannedresponsetemplates', 'CannedResponsesController@index')->name('cannedresponsetemplates');
Route::get('cannedtemplates/create', 'CannedResponsesController@create')->name('cannedtemplates.create');
Route::post('cannedtemplates/save', 'CannedResponsesController@store')->name('cannedtemplates.store');
Route::get('cannedtemplates/{id}/edit', 'CannedResponsesController@edit')->name('cannedtemplates.edit');
Route::patch('cannedtemplates/{id}', 'CannedResponsesController@update')->name('cannedtemplates.update');
Route::delete('cannedtemplates/{id}', 'CannedResponsesController@destroy')->name('cannedtemplates.delete');
Route::get('cannedtemplates/{id}/status/{status}', 'CannedResponsesController@changeStatus')->name('cannedtemplates.changestatus');
//canned responses

Route::get('coursesuggestion', 'CourseSuggestionController@index')->name('coursesuggestion');
Route::get('coursesuggestion/create', 'CourseSuggestionController@create')->name('coursesuggestion.create');
Route::post('coursesuggestion/store', 'CourseSuggestionController@store')->name('coursesuggestion.store');
Route::get('coursesuggestion/{id}', 'CourseSuggestionController@show')->name('coursesuggestion.show');
Route::get('coursesuggestion/{id}/share', 'CourseSuggestionController@share')->name('coursesuggestion.share');
Route::post('coursesuggestion/{id}/share', 'CourseSuggestionController@share_do')->name('coursesuggestion.share.do');

//automation
Route::get('automation', 'AutomationController@index')->name('automation');
Route::post('ajaxworkflowslist', 'AutomationController@workflowData')->name('ajaxworkflowslist');
Route::get('automation/create/workflow', 'AutomationController@create_workflow')->name('automation.create.workflow');
Route::post('automation/fetchTemplates', 'AutomationController@ajaxgettpl')->name('automation.fetchTemplates');
Route::post('automation/workflow/store', 'AutomationController@store_workflow')->name('automation.store.workflow');

Route::get('automation/workflow/{id}/details', 'AutomationController@workflow_details')->name('automation.workflow.details');
Route::get('automation/workflow/{id}/edit', 'AutomationController@edit_workflow')->name('automation.workflow.edit');
Route::post('automation/workflow/update', 'AutomationController@update_workflow')->name('automation.update.workflow');

Route::get('automation/workflow/{id}/message-history', 'AutomationController@workflow_message_history')->name('automation.workflow.message-history');
Route::post('automation/workflow/message-history-list', 'AutomationController@workflow_message_history_list')->name('automation.workflow.message-history-list');

Route::delete('automation/workflow/delete/{id}', 'AutomationController@destroy')->name('automation.workflow.destroy');
Route::get('automation/workflow/{id}/status/{status}', 'AutomationController@update_status')->name('automation.workflow.updateStatus');
Route::get('automation/workflow/{id}/duplicate', 'AutomationController@duplicate')->name('automation.workflow.duplicate');


Route::post('automation/fetchCriteriaValues', 'AutomationController@fetchCriteriaValues')->name('automation.fetchCriteriaValues');
Route::post('automation/checkTitle', 'AutomationController@check_title')->name('automation.checkTitle');
Route::post('automation/checkCampaignTitle', 'AutomationController@check_campaign_title')->name('automation.checkCampaignTitle');

Route::get('automation/campaigns', 'AutomationController@campaigns')->name('automation.campaigns');
Route::post('ajaxcampaignslist', 'AutomationController@campaignData')->name('ajaxcampaignslist');
Route::get('automation/create/campaign', 'AutomationController@create_campaign')->name('automation.create.campaign');
Route::post('automation/fetchAudienceCount', 'AutomationController@calculate_matched_audience')->name('automation.fetchAudienceCount');

Route::post('automation/campaign/store', 'AutomationController@store_campaign')->name('automation.store.campaign');
Route::post('automation/campaign/test-send', 'AutomationController@test_Send')->name('automation.campaign.test-send');
Route::get('automation/campaign/{id}/details', 'AutomationController@campaign_details')->name('automation.campaign.details');
Route::get('automation/campaign/{id}/status/{status}', 'AutomationController@update_campaign_status')->name('automation.campaign.updateStatus');
Route::get('automation/campaign/{id}/duplicate', 'AutomationController@duplicate_campaign')->name('automation.campaign.duplicate');

Route::get('automation/campaign/{id}/edit', 'AutomationController@edit_campaign')->name('automation.campaign.edit');
Route::post('automation/campaign/update', 'AutomationController@update_campaign')->name('automation.update.campaign');

Route::delete('automation/campaign/delete/{id}', 'AutomationController@destroy_campaign')->name('automation.campaign.destroy');

Route::get('automation/notifications', 'AutomationController@notifications')->name('automation.notifications');
//automation

Route::get('coursemanagement', 'UniversityCourseManagementController@index')->name('coursemanagement');
Route::get('coursemanagement/create', 'UniversityCourseManagementController@create')->name('coursemanagement.create');
Route::post('coursemanagement/fetch-subcat', 'UniversityCourseManagementController@fetchSubCat')->name('coursemanagement.fetchSubCat');

// Creating Course Preference When Course Finder is Approved
Route::get('coursemanagement/create/course-preference/{id}', 'UniversityCourseManagementController@createCoursePreference')->name('coursemanagement.create.course-preference');

Route::post('coursemanagement/fetch-campus', 'UniversityCourseManagementController@fetchCampus')->name('coursemanagement.fetchCampus');
Route::post('coursemanagement/store', 'UniversityCourseManagementController@store')->name('coursemanagement.store');
Route::delete('coursemanagement/{id}', 'UniversityCourseManagementController@destroy')->name('coursemanagement.destroy');
Route::get('coursemanagement/{id}/edit', 'UniversityCourseManagementController@edit')->name('coursemanagement.edit');
Route::post('coursemanagement/{id}/update', 'UniversityCourseManagementController@update')->name('coursemanagement.update');
Route::post('ajaxcoursemanagementlist', 'UniversityCourseManagementController@indexData')->name('ajaxcoursemanagementlist');

//New
Route::post('ajaxcoursefinderlist', 'UniversityCourseManagementController@courseFinderData')->name('ajaxcoursefinderlist');
Route::post('course-finder/course-download', 'UniversityCourseManagementController@downloadCourses')->name('coursemanagement.course-download');
Route::post('finder/suggestion/delete', 'UniversityCourseManagementController@finder_suggestion_delete')->name('findersuggestiondelete');

Route::post('bulkcoursedelete', 'UniversityCourseManagementController@bulk_course_delete')->name('bulkcoursedelete');
Route::post('bulkcourseenable', 'UniversityCourseManagementController@bulk_course_enable')->name('bulkcourseenable');
Route::post('bulkcoursedisable', 'UniversityCourseManagementController@bulk_course_disable')->name('bulkcoursedisable');


Route::get('coursemanagement/categories', 'UniversityCourseManagementController@categories_index')->name('coursemanagement.categories');
Route::get('coursemanagement/create/category', 'UniversityCourseManagementController@create_category')->name('coursemanagement.create.category');
Route::post('coursemanagement/store/category', 'UniversityCourseManagementController@store_category')->name('coursemanagement.store.category');
Route::get('coursemanagement/category/{id}/edit', 'UniversityCourseManagementController@edit_category')->name('coursemanagement.edit-category');
Route::post('coursemanagement/category/{id}', 'UniversityCourseManagementController@update_category')->name('coursemanagement.update-category');
Route::delete('coursemanagement/category/destroy/{id}', 'UniversityCourseManagementController@destroy_category')->name('coursemanagement.destroy-category');

Route::get('coursemanagement/universities', 'UniversityCourseManagementController@universities_index')->name('coursemanagement.universities');
Route::get('coursemanagement/create/university', 'UniversityCourseManagementController@create_university')->name('coursemanagement.create.university');
Route::post('coursemanagement/store/university', 'UniversityCourseManagementController@store_university')->name('coursemanagement.store.university');
Route::get('coursemanagement/university/{id}/edit', 'UniversityCourseManagementController@edit_university')->name('coursemanagement.edit-university');
Route::post('coursemanagement/university/{id}', 'UniversityCourseManagementController@update_university')->name('coursemanagement.update-university');
Route::delete('coursemanagement/university/destroy/{id}', 'UniversityCourseManagementController@destroy_university')->name('coursemanagement.destroy-university');
Route::post('coursemanagement/universities/bulk-hide', 'UniversityCourseManagementController@bulkHideUniversities')->name('coursemanagement.bulkHideUniversities');
Route::post('coursemanagement/universities/bulk-hide', 'UniversityCourseManagementController@bulkHideUniversities')->name('coursemanagement.bulkHideUniversities');


// Route::get('coursemanagement/course-import-open/{currentPage}', 'UniversityCourseManagementController@courseImportOpen')->name('coursemanagement.import.open');

//Course Finder
Route::get('course-finder', 'UniversityCourseManagementController@course_finder')->name('coursemanagement.course-finder');
Route::post('course-finder/get-result', 'UniversityCourseManagementController@course_finder_result')->name('coursemanagement.course-finder.get-result');
Route::get('course-finder/course-details/{id}', 'UniversityCourseManagementController@course_details')->name('coursemanagement.course-details');
Route::get('course-finder/university-details/{id}', 'UniversityCourseManagementController@university_details')->name('coursemanagement.university-details');
Route::post('course-finder/search-student', 'UniversityCourseManagementController@search_student')->name('search.my.student');
Route::post('course-finder/search-student-data', 'UniversityCourseManagementController@search_student_data')->name('search.my.studentData');
Route::get('course-finder/course-info/{id}', 'UniversityCourseManagementController@course_info')->name('coursemanagement.course-info');
Route::post('course-finder/suggest-to-student', 'UniversityCourseManagementController@suggestCourseToStudent')->name('coursemanagement.suggestcourse');


Route::get('attendance', 'AttendanceController@index')->name('attendance.index');
Route::get('attendance/approve/{id}', 'AttendanceController@approved')->name('attendance.approved');
Route::post('attendance/feedback', 'AttendanceController@ajaxfeedbackdata')->name('attendance.ajaxfeedbackdata');


Route::get('trainerattendance', 'TrainerAttendanceController@index')->name('trainerattendance.index');
Route::post('trainerattendance/getdata', 'TrainerAttendanceController@ajaxattendancedata')->name('attendance.ajaxattendancedata');


Route::get('democlass/{id?}', 'DemoClassController@index')->name('democlass');
Route::post('democlass/addfolder', 'DemoClassController@addfolder')->name('democlass.addfolder');
Route::post('democlass/adddoc', 'DemoClassController@adddoc')->name('democlass.adddoc');
Route::get('democlass/removefolder/{id}', 'DemoClassController@removefolder')->name('democlass.removefolder');
Route::get('democlass/removedoc/{id}', 'DemoClassController@removedoc')->name('democlass.removedoc');

Route::get('webinar', 'WebinarController@index')->name('webinar.index');
Route::get('webinarlist/{id}/{type?}', 'WebinarController@details')->name('webinar.details');
Route::get('webinar/create', 'WebinarController@create')->name('webinar.create');
Route::post('webinar/store', 'WebinarController@store')->name('webinar.store');
Route::get('webinar/{id}', 'WebinarController@view')->name('webinar.view');
Route::get('webinar/{id}/edit', 'WebinarController@edit')->name('webinar.edit');
Route::post('webinar/{id}', 'WebinarController@update')->name('webinar.update');
Route::delete('webinar/{id}', 'WebinarController@destroy')->name('webinar.destroy');

Route::get('orders','OrdersController@orders')->name('orders');
Route::get('orders-list','OrdersController@orders_list')->name('orders.orders-list');
Route::get('view-order/{id}','OrdersController@view_order')->name('orders.view-order');
Route::post('change-payment-status','OrdersController@change_payment_status')->name('orders.change-payment-status');
Route::post('change-delivery-status','OrdersController@change_delivery_status')->name('orders.change-delivery-status');

// Order Generate
Route::get('order/generate', 'OrdersController@generate_order')->name('order.generate');
Route::post('order/generate/save', 'OrdersController@generate_order_save')->name('order.generate.save');
// Order Generate

Route::get('products','ProductController@index')->name('products');
Route::get('products-list','ProductController@products_list')->name('products.products-list');
Route::get('create-product','ProductController@create_product')->name('products.create-product');
Route::post('save-product','ProductController@save_product')->name('products.save-product');
Route::get('edit-product/{slug}','ProductController@edit_product')->name('products.edit-product');
Route::get('delete-product/{slug}','ProductController@delete_product')->name('products.delete-product');
Route::post('update-product','ProductController@update_product')->name('products.update-product');
Route::post('upload-products-images','ProductController@upload_products_images')->name('products.upload-products-images');
Route::get('removeimg/{filename}/{slug}','ProductController@removeimg')->name('products.removeimg');

Route::get('product-downloads/{slug}','ProductController@product_downloads')->name('products.product-downloads');
Route::post('associate-downloads','ProductController@associate_downloads')->name('products.associate-downloads');
Route::get('download-list/{slug}','ProductController@download_list')->name('products.downloads-list');
Route::get('download-document/{id}','ProductController@download_file')->name('products.download-document');
Route::get('remove-product-download/{id}','ProductController@remove_product_download')->name('products.remove-product-download');

Route::get('create-downloads','DownloadManagementController@create_downloads')->name('downloads-management.create-downloads');
Route::post('save-downloads','DownloadManagementController@save_downloads')->name('downloads-management.save-downloads');
Route::get('download-file/{id}','DownloadManagementController@download_file')->name('downloads-management.download-file');
Route::get('remove-download/{id}','DownloadManagementController@remove_download')->name('downloads-management.remove-download');
Route::get('downloads-management','DownloadManagementController@index')->name('downloads-management');
Route::get('downloads-list','DownloadManagementController@downloads_list')->name('downloads-management.downloads-list');


Route::get('category','CategoriesController@index')->name('category');
Route::get('create-category','CategoriesController@create_category')->name('category.create-category');
Route::post('save-category','CategoriesController@save_category')->name('category.save-category');
Route::get('edit-category/{slug}','CategoriesController@edit_category')->name('category.edit-category');
Route::get('removeimg/{slug}','CategoriesController@removeimg')->name('category.removeimg');
Route::post('update-category','CategoriesController@update_category')->name('category.update-category');
Route::get('delete-category/{slug}','CategoriesController@delete_category')->name('category.delete-category');


Route::get('zones', 'ZoneController@index')->name('zones');
Route::get('zone-list', 'ZoneController@zonelist')->name('zone.zone-list');
Route::get('add-zone', 'ZoneController@addzone')->name('zone.add-zone');
Route::post('save-zone', 'ZoneController@save_zone')->name('zone.save-zone');
Route::get('viewzone/{id}', 'ZoneController@view_zone')->name('zone.view-zone');
Route::get('delete-zone/{id}', 'ZoneController@delete_zone')->name('zone.delete-zone');

Route::get('shipping-configuration', 'ShippingConfigurationController@index')->name('shipping-configuration');
Route::get('shipping-list', 'ShippingConfigurationController@shipping_list')->name('shipping.shipping-list');
Route::get('add-shipping', 'ShippingConfigurationController@add_shipping')->name('shipping.add-shipping');
Route::post('save-shipping', 'ShippingConfigurationController@save_shipping')->name('shipping.save-shipping');
Route::get('edit-shipping/{id}', 'ShippingConfigurationController@edit_shipping')->name('shipping.edit-shipping');
Route::post('update-shipping', 'ShippingConfigurationController@update_shipping')->name('shipping.update-shipping');
Route::get('delete-shipping/{id}', 'ShippingConfigurationController@delete_shipping')->name('shipping.delete-shipping');
    

Route::get('meetingroom', 'MeetingRoomController@index')->name('meetingroom.index');
Route::get('meetingroom/create', 'MeetingRoomController@create')->name('meetingroom.create');
Route::post('meetingroom/store', 'MeetingRoomController@store')->name('meetingroom.store');
Route::get('meetingroom/{value}/list', 'MeetingRoomController@bookinglist')->name('meetingroom.bookinglist');
Route::delete('meetingroom/{id}', 'MeetingRoomController@destroyed')->name('meetingroom.destroy');


//User Edit
Route::get('student/{id}/edit', 'StudentProfileController@edit_student')->name('student.edit');
Route::get('profile/add_academics_details/open', 'StudentProfileController@addAcademicsInformation')->name('profile.academics_information.add');
Route::get('profile/add_internship_details/open', 'StudentProfileController@addInternshipInformation',)->name('profile.internship_information.add');
Route::get('profile/add_course_details/open', 'StudentProfileController@addCourseInformation',)->name('profile.course_information.add');
Route::get('profile/add_family_details/open', 'StudentProfileController@addFamilyInformation')->name('profile.family_information.add');
Route::get('profile/add_employment_details/open', 'StudentProfileController@addEmployment')->name('profile.employment_information.add');
Route::get('profile/add_travel_history/open', 'StudentProfileController@addTravelHistory')->name('profile.travel_history.add');                                        
Route::get('profile/add_visa_history/open', 'StudentProfileController@addVisaHistory')->name('profile.visa_history.add');                                        
Route::get('profile/edit_academics_details/open/{id}', 'StudentProfileController@editAcademicsInformation')->name('profile.academics_information.edit');
Route::get('profile/edit_internship_details/open/{id}', 'StudentProfileController@editInternshipInformation')->name('profile.internship_information.edit');
Route::get('profile/edit_course_details/open/{id}', 'StudentProfileController@editCourseInformation')->name('profile.course_information.edit');
Route::get('profile/edit_family_details/open/{id}', 'StudentProfileController@editFamilyInformation')->name('profile.family_information.edit');
Route::get('profile/edit_employment/open/{id}', 'StudentProfileController@editEmployment')->name('profile.employment_information.edit');
Route::get('profile/edit_travel_history/open/{id}', 'StudentProfileController@editTravelHistory')->name('profile.travel_history.edit');                                        
Route::get('profile/edit_visa_history/open/{id}', 'StudentProfileController@editVisaHistory')->name('profile.visa_history.edit');                                        
Route::post('study-abroad/profile/basic/save', 'StudentProfileController@storeBasicProfile')->name('studyabroad.profile.basic.save');
Route::post('profile/academics_details/save', 'StudentProfileController@storeAcademicProfile')->name('profile.academics_information.save');
Route::post('profile/internship_details/save', 'StudentProfileController@storeInternshipProfile')->name('profile.internship_information.save');
Route::post('profile/course_details/save', 'StudentProfileController@storeCourseProfile')->name('profile.course_information.save');
Route::post('profile/family_details/save', 'StudentProfileController@storeFamilyProfile')->name('family.course_information.save');
Route::post('profile/employment_details/save', 'StudentProfileController@employmentSave')->name('profile.employment.save');
Route::post('profile/travel_history/save', 'StudentProfileController@travelHistorySave')->name('profile.travel_history.save');                                        
Route::post('profile/visa_history/save', 'StudentProfileController@visaHistorySave')->name('profile.visa_history.save');                                        
Route::post('profile/academics_details/delete', 'StudentProfileController@academicsInformationDelete')->name('profile.academics_information.delete');
Route::post('profile/internship_details/delete', 'StudentProfileController@InternshipProfileDelete')->name('profile.internship_information.delete');
Route::post('profile/course_details/delete', 'StudentProfileController@CourseProfileDelete')->name('profile.course_information.delete');
Route::post('profile/employment_details/delete', 'StudentProfileController@EmploymentDelete')->name('profile.employment_information.delete');
Route::post('profile/visa_details/delete', 'StudentProfileController@VisaDelete')->name('profile.visa_information.delete');
Route::post('profile/travel_history/delete', 'StudentProfileController@travelHistoryDelete')->name('profile.travel_history.delete');                                        
Route::post('profile/family_details/delete', 'StudentProfileController@FamilyProfileDelete')->name('family.course_information.delete');
Route::post('study-abroad/profile/academic/save', 'StudentProfileController@storeAcademicProfile')->name('studyabroad.profile.academic.save');
Route::post('study-abroad/profile/lang/save', 'StudentProfileController@storeLanguagesProfile')->name('studyabroad.profile.lang.save');
Route::post('study-abroad/profile/gre/save', 'StudentProfileController@storeGreGmatProfile')->name('studyabroad.profile.gre.save');
Route::post('study-abroad/profile/internship/save', 'StudentProfileController@storeInternshipsProfile')->name('studyabroad.profile.internship.save');
Route::post('study-abroad/profile/experince/save', 'StudentProfileController@storeExperienceProfile')->name('studyabroad.profile.experience.save');

Route::get('study-abroad/course-preference/{id}/edit', 'StudentProfileController@coursePreferenceEdit')->name('studyabroad.coursepref.edit');

// Route::get('study-abroad/application/{id}/add', 'StudentProfileController@addApplication')->name('studyabroad.application.add');
Route::post('study-abroad/application/add', 'StudentProfileController@addApplication')->name('studyabroad.application.add');
Route::get('study-abroad/application/{id}/view', 'StudentProfileController@viewApplicationByCoursePref')->name('studyabroad.application.view');
Route::post('study-abroad/study-level/save', 'StudentProfileController@storeStudyLevel')->name('studyabroad.studyLevel.save');

Route::post('study-abroad/course-preference/save', 'StudentProfileController@storeCoursePreference')->name('studyabroad.coursepref.save');
Route::post('course-preference/assign', 'StudentProfileController@assignCoursePreference')->name('coursepref.assign');

Route::post('study-abroad/course-preference/update', 'StudentProfileController@updateCoursePreference')->name('studyabroad.coursepref.update');
Route::delete('study-abroad/course-preference/{id}/delete', 'StudentProfileController@deleteCoursePref')->name('studyabroad.coursepref.delete');

Route::post('user/{id}/update_followup', 'StudentProfileController@update_followup')->name('user.update_followup');

Route::post('user/{id}/add_notes', 'StudentProfileController@add_notes')->name('user.add_notes');
// Route::get('convert-student-lead/{id}', ['StudentProfileController@convertStudentLead'])->name('user.convertStudentLead');
Route::post('user/update-convert-student-lead', 'StudentProfileController@updateConvertStudentLead')->name('user.update.convert-student-lead');


Route::get('study-abroad/visa-application/{id}/view', 'StudentProfileController@viewApplicationByVisaaAppl')->name('studyabroad.visaapplication.view');

// New changes in Course Preference tab
Route::post('study-abroad/course-preference/search-course-by-id', 'StudentProfileController@searchCourseById')->name('studyabroad.coursepref.search-course-by-id');

//Docs
Route::post('study-abroad/docs/save', 'StudentProfileController@storeDocuments')->name('studyabroad.documents.save');
Route::post('study-abroad/docs/cv', 'StudentProfileController@storeDocumentsCv')->name('studyabroad.documents.cv.upload');
Route::post('study-abroad/docs/stu-photo', 'StudentProfileController@storeDocumentsStuPhoto')->name('studyabroad.documents.stu-photo.upload');
Route::post('study-abroad/docs/passport', 'StudentProfileController@storeDocumentsPassport')->name('studyabroad.documents.pass.upload');
Route::post('study-abroad/docs/lor', 'StudentProfileController@storeDocumentsLor')->name('studyabroad.documents.lor.upload');
Route::post('study-abroad/docs/exp', 'StudentProfileController@storeDocumentsExp')->name('studyabroad.documents.exp.upload');
Route::post('study-abroad/docs/other', 'StudentProfileController@storeDocumentsOther')->name('studyabroad.documents.other.upload');
Route::post('study-abroad/docs/delete-edu', 'StudentProfileController@deleteDocumentEdu')->name('studyabroad.documents.edu.delete');
Route::post('study-abroad/docs/delete-pro', 'StudentProfileController@deleteDocumentPro')->name('studyabroad.documents.pro.delete');
Route::post('study-abroad/docs/save-sop', 'StudentProfileController@storeDocumentsSop')->name('studyabroad.documents.sop.upload');

Route::post('study-abroad/docs/save-additional', 'StudentProfileController@storeDocumentsAdditional')->name('studyabroad.documents.additional.upload');
Route::post('study-abroad/docs/delete-additional', 'StudentProfileController@deleteDocumentsAdditional')->name('studyabroad.documents.additional.delete');

Route::post('study-abroad/docs/save-essay', 'StudentProfileController@storeDocumentsEssay')->name('studyabroad.documents.essay.upload');

// Route::post('study-abroad/docs/save', 'StudentProfileController@storeDocuments')->name('studyabroad.documents.save');
Route::post('study-abroad/docs/upload-complete', 'StudentProfileController@markDocumentsUploadDone')->name('studyabroad.documents.mark-done');

// Online course pages
Route::get('onlinecourses', 'OnlineCoursesController@index')->name('onlinecourses');
Route::get('onlinecourses/add', 'OnlineCoursesController@create')->name('onlinecourses.create');
Route::post('onlinecourses/store', 'OnlineCoursesController@store')->name('onlinecourses.store');
Route::get('onlinecourses/{id}/edit', 'OnlineCoursesController@edit')->name('onlinecourses.edit');
Route::patch('onlinecourses/{id}', 'OnlineCoursesController@update')->name('onlinecourses.update');
Route::delete('onlinecourses/{id}/delete', 'OnlineCoursesController@destroy')->name('onlinecourses.destroy');

Route::get('chapters', 'CourseChaptersController@index')->name('chapters.index');
Route::get('chapters/add', 'CourseChaptersController@create')->name('chapters.create');
Route::post('chapters/store', 'CourseChaptersController@store')->name('chapters.store');
Route::get('chapters/{id}/edit', 'CourseChaptersController@edit')->name('chapters.edit');
Route::patch('chapters/{id}', 'CourseChaptersController@update')->name('chapters.update');
Route::delete('chapters/{id}', 'CourseChaptersController@destroy')->name('chapters.destroy');

//Route::get('quiz', 'ChaptersQuizController@index')->name('quiz.index');
Route::get('quiz/add', 'ChaptersQuizController@create')->name('quiz.create');
Route::post('quiz/store', 'ChaptersQuizController@store')->name('quiz.store');
Route::get('quiz/{id}/edit', 'ChaptersQuizController@edit')->name('quiz.edit');
Route::patch('quiz/{id}', 'ChaptersQuizController@update')->name('quiz.update');
Route::delete('quiz/{id}', 'ChaptersQuizController@destroy')->name('quiz.destroy');



Route::get('q_a', 'QuestionsAnswersController@index')->name('q_a.index');
Route::get('q_a/add', 'QuestionsAnswersController@create')->name('q_a.create');
Route::post('q_a/store', 'QuestionsAnswersController@store')->name('q_a.store');
Route::get('q_a/{id}/edit', 'QuestionsAnswersController@edit')->name('q_a.edit');
Route::patch('q_a/{id}', 'QuestionsAnswersController@update')->name('q_a.update');
Route::delete('q_a/{id}', 'QuestionsAnswersController@destroy')->name('q_a.destroy');


Route::get('comprehension/create', 'ComprehensionController@create')->name('comprehension.create');
Route::post('comprehension/store', 'ComprehensionController@store')->name('comprehension.store');
Route::get('comprehension/list', 'ComprehensionController@list_all')->name('comprehension.list');
Route::get('comprehension/edit/{id}', 'ComprehensionController@edit')->name('comprehension.edit');
Route::delete('comprehension/{id}', 'ComprehensionController@destroy')->name('comprehension.destroy');

Route::get('studentexam', 'ExamController@index')->name('studentexam.index');
Route::get('essayexam', 'ExamController@essay_exam')->name('essayexam.essay_exam');
Route::get('oralexam', 'ExamController@oral_exam')->name('oralexam.oral_exam');
Route::post('studentexam/ajaxexamresult', 'ExamController@ajaxexamresult')->name('studentexam.ajaxexamresult');



Route::get('course-category', 'CourseCategoryController@index')->name('course-category.index');
Route::get('course-category/create', 'CourseCategoryController@create')->name('course-category.create');
Route::post('course-category/store', 'CourseCategoryController@store')->name('course-category.store');
Route::get('course-category/edit/{id}', 'CourseCategoryController@edit')->name('course-category.edit');
Route::patch('course-category/{id}', 'CourseCategoryController@update')->name('course-category.update');
Route::delete('course-category-delete/{id}', 'CourseCategoryController@destroy')->name('course-category.destroy');
Route::post('course-category/ajaxcoursecategory', 'CourseCategoryController@ajaxcoursecategorydata')->name('course-category.ajaxcoursecategory');


/* Cms Routes */
Route::get('articles', 'ArticlesController@articles')->name('articles');
Route::post('articles-list','ArticlesController@ajaxarticleslist')->name('ajaxarticleslist');
Route::get('articles/create','ArticlesController@articles_create')->name('articles-create');
Route::post('articles/store','ArticlesController@store')->name('articles.store');
Route::get('articles/edit/{id}','ArticlesController@edit')->name('articles.edit');
Route::patch('articles/update/{id}','ArticlesController@update')->name('articles.update');
//Route::get('articles/show/{id}','ArticlesController@show')->name('articles.show');
Route::delete('articles/delete/{id}','ArticlesController@destroy')->name('articles.delete');
//Route::get('articles/removeimg/{id}','ArticlesController@removeimg')->name('articles.removeimg');
Route::post('articles/storeimage','ArticlesController@storeimage')->name('articles.storeimage');
Route::post('articles/ajaxvalidatedata','ArticlesController@ajaxValidateData')->name('articles.ajaxValidateData');

//Settings
Route::get('settings', 'SettingsController@index')->name('settings');
Route::post('settings/general', 'SettingsController@saveGeneral')->name('settings.general');
Route::post('settings/homepage', 'SettingsController@saveHome')->name('settings.homepage');
Route::post('settings/modules', 'SettingsController@saveModules')->name('settings.modules');
Route::post('settings/smtp', 'SettingsController@saveSMTP')->name('settings.smtp');
Route::post('settings/advanced', 'SettingsController@saveAdvanced')->name('settings.advanced');
//Route::get('settings/student', 'SettingsController@student')->name('settings.student');
//Route::post('settings/student/save', 'SettingsController@saveStudent')->name('settings.student.save');
Route::get('settings/student', 'SettingsStudentsController@student')->name('settings.student');
Route::post('settings/student/save', 'SettingsStudentsController@saveStudent')->name('settings.student.save');


Route::post('settings/google-leads-webhook-key/save', 'SettingsController@saveGoogle')->name('settings.google-leads-webhook-key.save');


Route::get('settings/notifications', 'SettingsNotificationsController@notifications')->name('settings.notifications');
Route::post('settings/notifications/save', 'SettingsNotificationsController@saveNotifications')->name('settings.notifications.save');

Route::get('settings/additional-docs', 'AdditionalDocsController@additionalDocs')->name('additional-docs');
Route::post('settings/additional-docs/save', 'AdditionalDocsController@saveAdditionalDocs')->name('additional-docs.save');
Route::get('settings/additional-docs/{id}/status/{status}', 'AdditionalDocsController@changeStatus')->name('additional-docs.changestatus');
Route::get('settings/update-order','AdditionalDocsController@updateOrder')->name('additional-docs.updateOrder');
Route::delete('settings/additional-docs/delete/{id}', 'AdditionalDocsController@deleteDocConfig')->name('additional-docs.delete');
Route::post('settings/additional-docs/update', 'AdditionalDocsController@updateAdditionalDocs')->name('additional-docs.update');

Route::get('settings/banners', 'SettingsController@banners')->name('banners');
Route::post('settings/banners/save', 'SettingsController@saveBanner')->name('banners.save');
Route::get('settings/banners/{id}/edit', 'SettingsController@editBanner')->name('banners.edit');
Route::delete('settings/banners/delete/{id}', 'SettingsController@deleteBanner')->name('banners.delete');
Route::get('settings/country', 'SettingsController@country')->name('country-settings');
Route::post('settings/ajaxcountrylist', 'SettingsController@ajaxcountrylist')->name('ajaxcountrylist');
Route::get('settings/change-country-status/{country}', 'SettingsController@changeCountrySatus')->name('changeCountrySatus');

Route::get('settings/country-state/{country_id}', 'SettingsController@viewCountryState')->name('view-country.state');
Route::post('settings/ajaxstatelist', 'SettingsController@ajaxstatelist')->name('ajaxstatelist');
Route::post('settings/bulk-states/enable-disable', 'SettingsController@bulkStateEnableDisable')->name('setting.state.bulkEnableDisable');
Route::post('settings/add/country/state/save', 'SettingsController@addCountryState')->name('add.country.state');
Route::post('settings/country-state/edit/save', 'SettingsController@editCountryState')->name('view-country.state.edit.update');
Route::delete('settings/country-state/delete/{state_id}/{country_id}', 'SettingsController@deleteCountryState')->name('view-country.state.delete');

Route::get('settings/state-city/{state_id}', 'SettingsController@viewStateCity')->name('view-state.city');
Route::post('settings/ajaxcitylist', 'SettingsController@ajaxcitylist')->name('ajaxcitylist');
Route::post('settings/bulk-cities/enable-disable', 'SettingsController@bulkCitiesEnableDisable')->name('setting.cities.bulkEnableDisable');
Route::post('settings/add/state/city/save', 'SettingsController@addStateCity')->name('add.state.city');
Route::post('settings/state-city/edit/save', 'SettingsController@editStateCity')->name('view-state.city.edit.update');
Route::delete('settings/state-city/delete/{city_id}/{state_id}', 'SettingsController@deleteStateCity')->name('view-state.city.delete');

Route::get('settings/leads', 'SettingsController@leads')->name('leads-settings');
Route::post('settings/lead-status/save', 'SettingsController@saveLeadStatus')->name('lead-status.save');
Route::post('settings/lead-status/update', 'SettingsController@updateLeadStatus')->name('lead-status.update');
Route::post('settings/lead-sources/update', 'SettingsController@updateLeadSettings')->name('leads-settings.update');
Route::post('settings/lead-disqualified-status/update', 'SettingsController@updateDisqualifiedStatus')->name('leads-settings.disqualified-status.update');
Route::delete('settings/remove-lead-status/{status}', 'SettingsController@removeLeadStatus')->name('removeLeadStatus');
Route::get('settings/web-to-lead', 'SettingsController@webToLead')->name('web-to-lead');
Route::get('settings/web-to-lead-save', 'SettingsController@webToLeadSave')->name('web-to-lead-save');

Route::get('settings/meta-lead', 'SettingsController@metaLead')->name('meta-lead');
Route::get('settings/meta-lead-save', 'SettingsController@metaLeadSave')->name('meta-lead-save');

Route::get('settings/web-to-lead/get-staff-branch/{staff_id}', 'ImportExportController@get_staff_branch')->name('web-to-lead.get-staff-branch');

Route::get('settings/email-smtp', 'SettingsController@emailSmtp')->name('email-smtp');

Route::get('settings/integrations', 'SettingsController@integrations')->name('integrations');

Route::get('settings/email-sync', 'EmailSyncController@email_sync')->name('email-sync');
Route::post('settings/email-sync-store', 'EmailSyncController@email_sync_store')->name('email-sync.store');
Route::post('settings/email-sync-update', 'EmailSyncController@email_sync_update')->name('email-sync.update');
Route::get('settings/email-sync-update-status','EmailSyncController@updateStatus')->name('email-sync.updateStatus');
Route::get('settings/email-sync/delete/{id}', 'EmailSyncController@destroy')->name('settings.email-sync.destroy');

Route::get('settings/outbound-call', 'SettingsController@outbound_call')->name('settings.outbound-call');
Route::post('settings/outbound-call/save', 'SettingsController@save_outbound_call')->name('settings.outbound-call.save');

Route::get('settings/landing-pages', 'LandingPagesController@index')->name('landing-pages');

Route::post('show-landing-page', 'LandingPagesController@show_page')->name('show-page');

Route::get('settings/whatsapp', 'SettingsController@whatsapp')->name('settings.whatsapp');
Route::post('settings/whatsapp/save', 'SettingsController@save_whatsapp')->name('settings.whatsapp.save');

Route::get('settings/sms', 'SettingsController@sms')->name('settings.sms');
Route::post('settings/sms/save', 'SettingsController@saveSms')->name('settings.sms.save');

Route::get('settings/course-certificate-configuration', 'SettingsController@course_certificate_configuration')->name('course-certificate-configuration');

Route::post('settings/course-certificate-configuration/save', 'SettingsController@save_course_certificate_configuration')->name('settings.course-certificate-configuration-save');

Route::get('settings/content-blocks', 'SettingsController@contentBlocks')->name('content-blocks');
Route::post('settings/content-blocks/save', 'SettingsController@saveContentBlock')->name('content-blocks.save');
Route::get('settings/content-blocks/{id}/edit', 'SettingsController@editContentBlock')->name('content-blocks.edit');
Route::delete('settings/content-blocks/delete/{id}', 'SettingsController@deleteContentBlock')->name('content-blocks.delete');

Route::get('settings/uni-apply-agents', 'SettingsController@uniApplyAgents')->name('uni-apply-agents');
Route::post('settings/uni-apply-agent/save', 'SettingsController@saveUniApplyAgent')->name('uni-apply-agent.save');
Route::get('settings/uni-apply-agent/{id}/edit', 'SettingsController@editUniApplyAgent')->name('uni-apply-agent.edit');
Route::delete('settings/uni-apply-agent/delete/{id}', 'SettingsController@deleteUniApplyAgent')->name('uni-apply-agent.delete');

Route::get('settings/study-levels', 'StudyLevelsController@index')->name('settings.study-levels');
Route::post('settings/study-levels/store', 'StudyLevelsController@store')->name('settings.study-levels.store');
Route::post('settings/study-levels/update/{id}', 'StudyLevelsController@update')->name('settings.study-levels.update');
Route::delete('settings/study-levels/delete/{id}', 'StudyLevelsController@destroy')->name('settings.study-levels.destroy');

Route::post('settings/email/test/individual', 'SettingsController@emailTestIndividual')->name('settings.email.test.individual');
Route::post('settings/email/test/bulk', 'SettingsController@emailTestBulk')->name('settings.email.test.bulk');

//Student status settings
Route::get('settings/student-status', 'StudentStatusController@index')->name('settings.student-status');
Route::post('settings/student-status/store', 'StudentStatusController@store')->name('settings.student-status.store');
Route::post('settings/student-status/update/{id}', 'StudentStatusController@update')->name('settings.student-status.update');
Route::get('settings/student-status/delete/{id}', 'StudentStatusController@destroy')->name('settings.student-status.destroy');

//App. stages settings
Route::get('settings/application-stages', 'ApplicationStagesController@index')->name('settings.application-stages');
Route::post('settings/application-stages/store', 'ApplicationStagesController@store')->name('settings.application-stages.store');
Route::post('settings/application-stages/update/{id}', 'ApplicationStagesController@update')->name('settings.application-stages.update');
Route::get('settings/application-stages/delete/{id}', 'ApplicationStagesController@destroy')->name('settings.application-stages.destroy');

//service stages settings
Route::get('settings/service-stages', 'ServiceStagesController@index')->name('settings.service-stages');
Route::post('settings/service-stage/store', 'ServiceStagesController@store')->name('settings.service-stage.store');
Route::post('settings/service-stage/update/{id}', 'ServiceStagesController@update')->name('settings.service-stage.update');
Route::get('settings/service-stage/delete/{id}', 'ServiceStagesController@destroy')->name('settings.service-stage.destroy');

// Services

Route::get('referral-signups', 'ReferralController@referral_signups')->name('referral-signups');
Route::get('referral-signups/status-update/model/{id}', 'ReferralController@confirmedAmountModel')->name('referral-signups.referral-status.model');
Route::post('referral-signups/status-update', 'ReferralController@referral_status_update')->name('referral-signups.referral-status.update');
Route::get('referral-payout', 'ReferralController@referral_payout')->name('referral-payout');

Route::post('referral/get-referrals', 'ReferralController@getReferrals')->name('referral.getReferrals');
Route::post('referral/make-payout', 'ReferralController@referral_make_payout')->name('referral.make-payout');

// Settings
Route::get('settings/services-list', 'ServiceController@showServicesList')->name('settings.services.list');
Route::post('settings/services-list/store', 'ServiceController@servicesListStore')->name('settings.services.list.store');
Route::post('settings/services-list/edit-store', 'ServiceController@servicesListEditStore')->name('settings.services.list.edit-store');
Route::get('settings/services-list/delete/{id}', 'ServiceController@servicesDestroy')->name('settings.services.list.destroy');

//business configs settings
Route::get('settings/business-configs', 'BusinessConfigsController@index')->name('settings.business-configs');
Route::post('settings/business-configs/store', 'BusinessConfigsController@store')->name('settings.business-configs.store');
Route::post('settings/business-configs/update/{id}', 'BusinessConfigsController@update')->name('settings.business-configs.update');
Route::get('settings/business-configs/delete/{id}', 'BusinessConfigsController@destroy')->name('settings.business-configs.destroy');

Route::get('settings/branch', 'BranchController@index')->name('settings.branch');
Route::get('settings/branch/create', 'BranchController@create')->name('settings.branch.create');
Route::post('settings/branch/store', 'BranchController@store')->name('settings.branch.store');
Route::get('settings/branch/{id}/edit', 'BranchController@edit')->name('settings.branch.edit');
Route::patch('settings/branch/{id}', 'BranchController@update')->name('settings.branch.update');
Route::get('settings/branch/{id}/delete', 'BranchController@destroy')->name('settings.branch.destroy');

// User Profile Page
Route::post('user/add-service-request/store', 'ServiceController@addServiceRequestStore')->name('service-request.store');
Route::get('user/service-request/edit/{id}', 'ServiceController@serviceRequestEdit')->name('service-request.edit');
Route::post('user/service-request/edit-store', 'ServiceController@serviceRequestEditStore')->name('service-request.edit.store');
Route::delete('user/service-request/delete/{id}', 'ServiceController@serviceRequestDelete')->name('service-request.delete');

// Services List From Side Bar
Route::get('service-and-visa/list', 'ServiceController@serviceAndVisaList')->name('service-visa.list');
Route::post('service-and-visa/getdata/{q?}', 'ServiceController@ajaxvisaapplicationdata')->name('service-visa.ajaxapplicationdata');
Route::get('service-and-visa/assigned-to/{id}', 'ServiceController@assignVisaApplicationStaff')->name('service-visa.assignstaff');
Route::post('service-and-visa/assigned-to/store', 'ServiceController@assignVisaApplicationStaffStore')->name('service-visa.assignstaff.store');
Route::delete('service-and-visa/delete/{id}', 'ServiceController@visaServicesDelete')->name('service-visa.delete');

Route::get('service-and-visa/view/{id}', 'ServiceController@viewVisaAndServices')->name('service-visa.view');
Route::post('service-and-visa/update-notes/', 'ServiceController@visaServiceUpdateNotes')->name('service-visa.update-notes');
Route::post('service-and-visa/visa-services-message/send', 'ServiceController@visaServiceMessageSend')->name('service-visa.visa-services-message.send');
Route::post('service-and-visa/status/update', 'ServiceController@visaServiceStatusUpdate')->name('service-visa.status.update');


Route::post('service-and-visa/fetch-status', 'ServiceController@fetchStatus')->name('service-and-visa.fetchStatus');
Route::post('api/search-service-country', 'ServiceController@search_service_country')->name('search.service.country');
Route::post('api/search-staff', 'UnivApplicationsController@search_staff')->name('search.staff');


//custom-attributes settings
Route::get('settings/custom-attributes', 'CustomAttributesController@index')->name('settings.custom-attributes');
Route::post('settings/custom-attributes/store', 'CustomAttributesController@store')->name('settings.custom-attributes.store');
Route::post('settings/custom-attributes/update/{id}', 'CustomAttributesController@update')->name('settings.custom-attributes.update');
Route::get('settings/custom-attributes/updateOrder','CustomAttributesController@updateOrder')->name('settings.custom-attributes.updateOrder');
Route::get('settings/custom-attributes/delete/{id}', 'CustomAttributesController@destroy')->name('settings.custom-attributes.destroy');

//custom-labels settings
Route::get('settings/custom-labels', 'CustomLabelsController@index')->name('settings.custom-labels');
Route::post('settings/custom-labels/update/{label}', 'CustomLabelsController@update')->name('settings.custom-labels.update');

Route::get('settings/master-setup', 'SettingsController@masterSetup')->name('master-setup');
Route::post('settings/master-setup-check', 'SettingsController@masterSetupCheck')->name('master-setup.check');
//

//inovice
Route::get('university-invoices', 'InvoiceController@university_invoices')->name('invoice.university-invoices');

Route::get('student-invoices', 'InvoiceController@student_invoices')->name('invoice.student-invoices');

Route::get('invoice/{id?}/view-student-invoice', 'InvoiceController@view_student_invoice')->name('invoice.view-student-invoice');
Route::delete('invoice/{id}/delete-student-invoice', 'InvoiceController@delete_student_invoice')->name('invoice.delete-student-invoice');
Route::get('invoice/{id?}/student-invoice-add-payment', 'InvoiceController@student_invoice_add_payment')->name('invoice.student-invoice-add-payment');
Route::post('invoice/student-invoicestore-payment', 'InvoiceController@student_invoice_store_payment')->name('invoice.student-invoice-payment.store');
Route::delete('invoice/remove/student-invoice-payment-record/{id}', 'InvoiceController@remove_student_invoice_payment_record')->name('remove.student-invoice-payment-record');
Route::get('invoices/student-invoice-generate/{user_id?}', 'InvoiceController@generate_student_invoice')->name('invoice.student-invoice-generate');
Route::post('api/search-student', 'InvoiceController@search_student')->name('search.student');
Route::post('api/search-student-data', 'InvoiceController@search_student_data')->name('search.studentData');
Route::post('invoices/tax-data', 'InvoiceController@getTax')->name('invoice.getTax');
Route::post('api/getCourse', 'InvoiceController@get_course')->name('search.get_course');
Route::post('invoices/student-invoice-generate/store', 'InvoiceController@store_student_invoice')->name('invoice.student-invoice-generate.store');

Route::get('invoice/{id}/student-invoice-edit', 'InvoiceController@edit_student_invoice')->name('invoice.student-invoice.edit');
Route::post('invoice/student-invoice-edit/store', 'InvoiceController@edit_student_invoice_store')->name('invoice.student-invoice.edit.store');



Route::get('invoices/generate/enrolled-student-invoice', 'InvoiceController@generate_enrolled_student_invoice')->name('invoice.generate-enrolled-student-invoice');
Route::post('invoices/generate/enrolled-student-invoice/step-two', 'InvoiceController@generate_enrolled_student_invoice_step_two')->name('invoice.generate-enrolled-student-invoice.step-two');
Route::post('invoices/generate/enrolled-student-invoice/save', 'InvoiceController@generate_enrolled_student_invoice_save')->name('invoice.generate-enrolled-student-invoice.save');

Route::delete('uni-invoice/{id}/delete', 'InvoiceController@deleteUniInvoice')->name('invoice.uni-invoice.delete');

Route::get('invoice/{id?}/view-uni-invoice', 'InvoiceController@view_uni_invoice')->name('invoice.view-uni-invoice');
Route::get('invoice/{id?}/add-uni-payment', 'InvoiceController@add_uni_payment')->name('invoice.add-uni-payment');
Route::post('invoice/store-uni-payment', 'InvoiceController@store_uni_payment')->name('uni-payment.store');
Route::delete('invoice/remove/uni-record-payment/{id}', 'InvoiceController@remove_uni_payment')->name('remove.uni-record-payment');



Route::get('invoices/generate/uni-apply-agent-invoice', 'InvoiceController@generate_uni_apply_agent_invoice')->name('invoice.generate-uni-apply-agent-invoice');
Route::post('invoices/generate/uni-apply-agent-invoice/step-two', 'InvoiceController@generate_uni_apply_agent_invoice_step_two')->name('invoice.generate-uni-apply-agent-invoice.step-two');
Route::post('api/search-uni-apply-agent-data', 'InvoiceController@search_uni_apply_agent_data')->name('search.uniApplyAgentData');
Route::post('invoices/generate/uni-apply-agent-invoice/save', 'InvoiceController@generate_uni_apply_agent_invoice_save')->name('invoice.generate-uni-apply-agent-invoice.save');

Route::delete('uni-apply-agent-invoice/{id}/delete', 'InvoiceController@deleteUniApplyAgentInvoice')->name('invoice.uni-apply-agent-invoice.delete');

Route::get('invoice/{id?}/view-uni-apply-agent-invoice', 'InvoiceController@view_uni_apply_agent_invoice')->name('invoice.view-uni-apply-agent-invoice');
Route::get('invoice/{id?}/add-uni-apply-agent-payment', 'InvoiceController@add_uni_apply_agent_payment')->name('invoice.add-uni-apply-agent-payment');
Route::post('invoice/store-uni-apply-agent-payment', 'InvoiceController@store_uni_apply_agent_payment')->name('uni-apply-agent-payment.store');
Route::delete('invoice/remove/uni-apply-agent-record-payment/{id}', 'InvoiceController@remove_uni_apply_agent_payment')->name('remove.uni-apply-agent-record-payment');

Route::post('invoices/get-applications', 'InvoiceController@getApplications')->name('invoice.getApplications');
Route::post('invoices/get-uni-apply-agent-applications', 'InvoiceController@getAgentApplications')->name('invoice.getAgentApplications');

Route::get('invoices/generate/ad-hoc', 'InvoiceController@generate_ad_hoc_invoice')->name('invoice.generate-ad-hoc');
Route::post('api/search-university-data', 'InvoiceController@search_university_data')->name('search.universityData');
Route::post('invoices/generate/ad-hoc-invoice/save', 'InvoiceController@generate_ad_hoc_invoice_save')->name('invoice.generate-ad-hoc-invoice.save');
Route::get('invoice/{id?}/view-ad-hoc-invoice', 'InvoiceController@view_ad_hoc_invoice')->name('invoice.view-ad-hoc-invoice');
Route::get('invoice/{id?}/add-ad-hoc-payment', 'InvoiceController@add_ad_hoc_payment')->name('invoice.add-ad-hoc-payment');
Route::post('invoice/store-ad-hoc-payment', 'InvoiceController@store_ad_hoc_payment')->name('ad-hoc-payment.store');

Route::delete('invoice/remove/ad-hoc-record-payment/{id}', 'InvoiceController@remove_ad_hoc_payment')->name('remove.ad-hoc-record-payment');

Route::delete('ad-hoc-invoice/{id}/delete', 'InvoiceController@deleteAdhocInvoice')->name('invoice.ad-hoc-invoice.delete');

//inovice

Route::get('online-course-enrollment', 'OnlineCourseEnrollmentController@index')->name('online-course-enrollment.index');
Route::post('ajaxonlinecourseenrollmentlist', 'OnlineCourseEnrollmentController@ajaxonlinecourseenrollmentlist')->name('ajaxonlinecourseenrollmentlist');
Route::get('online-course-enrollment/create', 'OnlineCourseEnrollmentController@create')->name('online-course-enrollment.create');
Route::post('online-course-enrollment/save', 'OnlineCourseEnrollmentController@store')->name('online-course-enrollment.store');
Route::delete('online-course-enrollment/{id}/delete', 'OnlineCourseEnrollmentController@destroy')->name('online-course-enrollment.destroy');

Route::get('import-export/{currentPage}', 'ImportExportController@index')->name('import-export.index');
Route::post('import-export/upload-students', 'ImportExportController@uploadStudents')->name('import-export.upload.students');
Route::post('import-export/upload-leads', 'ImportExportController@uploadLeads')->name('import-export.upload.leads');
Route::get('import-custom', 'ImportExportController@custom')->name('import-export.custom');
Route::post('import-export/upload-custom', 'ImportExportController@uploadCustom')->name('import-export.upload.custom');
Route::post('import-export/upload-course', 'ImportExportController@uploadCourse')->name('import-export.upload.course');
Route::post('import-export/upload-any-leads', 'ImportExportController@anyCsvLeads')->name('import-export.anycsvleads');
Route::post('import-export/upload-any-leads/save', 'ImportExportController@anyCsvLeadsSave')->name('import-export.anycsvleads.save');

Route::post('import-export/upload-any-coursemanagement', 'ImportExportController@anyCsvCourseManagement')->name('import-export.anycsvcoursemanagement');
Route::post('import-export/upload-any-course/save', 'ImportExportController@anyCsvCourseSave')->name('import-export.anycsvcourse.save');

Route::post('import-export/upload-any-university-coursemanagement', 'ImportExportController@anyCsvUniversityCourseManagement')->name('import-export.anyCsvUniversityCourseManagement');
Route::post('import-export/upload-any-university-course/save', 'ImportExportController@anyCsvUniversityCourseSave')->name('import-export.anycsvuniversitycourse.save');

Route::get('analytics', 'AnalyticsController@index')->name('analytics');
Route::get('analytics/students', 'AnalyticsController@studentsReport')->name('analytics.studentsreport');
Route::post('analytics/students-data', 'AnalyticsController@studentsReportData')->name('analytics.studentsreportdata');
Route::get('analytics/leads', 'AnalyticsController@leadsReport')->name('analytics.leadsreport');

Route::get('analytics/student-referrals-data', 'AnalyticsController@studentReferralsReport')->name('analytics.student-referrals-report');

Route::get('analytics/staff', 'AnalyticsController@staffReport')->name('analytics.staffreport');
Route::get('analytics/applications', 'AnalyticsController@applicationsReport')->name('analytics.applicationsreport');
Route::get('analytics/sales', 'AnalyticsController@salesReport')->name('analytics.salesreport');

Route::get('analytics/agents', 'AnalyticsController@agentsReport')->name('analytics.agentsreport');
//Route::post('analytics/leads-data', 'AnalyticsController@leadsReportData')->name('analytics.leadsreportdata');
Route::get('analytics/students-graph', 'AnalyticsController@studentsGraph')->name('analytics.studentsgraph');
Route::get('analytics/leads-graph', 'AnalyticsController@leadsGraph')->name('analytics.leadsgraph');
Route::get('analytics/sales-graph', 'AnalyticsController@salesGraph')->name('analytics.salesgraph');

Route::get('agents-list', 'AgentManagementController@index')->name('agents.index');
Route::post('agents-data', 'AgentManagementController@agents_list')->name('agents.agents-list');
Route::get('agents-list/create', 'AgentManagementController@create')->name('agents.create');
Route::post('agents/store', 'AgentManagementController@store')->name('agents.store');
Route::get('agents/referrals', 'AgentManagementController@referrals')->name('agents.referrals');
Route::post('agents/referralsdata', 'AgentManagementController@referralsdata')->name('agents.referralsdata');

Route::get('agents/commission', 'AgentManagementController@commission')->name('agents.commission');
Route::post('agents/commission-data', 'AgentManagementController@commission_data')->name('agents.commission-data');
Route::post('agents/update-commission', 'AgentManagementController@update_commission')->name('agents.update.commission');
Route::post('agents/myagent_commissiondata', 'AgentManagementController@myagent_commissiondata')->name('agents.myagent_commissiondata');


Route::get('agents/my-commission', 'AgentCommissionController@myCommission')->name('agents.my-commission');
Route::post('agents/mycommissiondata', 'AgentCommissionController@mycommissiondata')->name('agents.mycommissiondata');
Route::get('agents/{id?}/download-invoice', 'AgentCommissionController@download_invoice')->name('agents.download-invoice');

Route::get('agents/payout', 'AgentManagementController@payout')->name('agents.payout');
Route::post('agents/payout/process-payment/step-two', 'AgentManagementController@process_payment_step_two')->name('agents.process-payment.step-two');
Route::post('agents/payout/process-payment/save', 'AgentManagementController@process_payment_save')->name('agents.process-payment.save');
// Route::post('agents/payout-data', 'AgentManagementController@payout_data')->name('agents.payout-data');

Route::post('agents/bulkpay', 'AgentManagementController@bulkPay')->name('agents.bulkpay');
Route::get('agents/pay/{applid}', 'AgentManagementController@pay')->name('agents.pay');


Route::get('agents/deleted', 'AgentManagementController@deleted')->name('agents.deleted');
Route::get('agents-deleted-data', 'AgentManagementController@agents_deleted_list')->name('agents.agents-deleted-list');

//New Routes
Route::get('agent/{id}/details', 'AgentManagementController@agent_details')->name('agent.details');
Route::post('agent/my-referral-list', 'AgentManagementController@my_referrals')->name('agent.my-referral-list');


//this will show the referrals page(tab)
Route::get('agent/{id}/referrals', 'AgentManagementController@agent_referrals')->name('agent.referrals');

//this will fetch datatable data in the referrals table
Route::post('agent/get-referrals-data/{id}', 'AgentManagementController@agent_referrals_data')->name('agent.get-referrals-data');

//this will show the commission page(tab)
Route::get('agent/{id}/commissions', 'AgentManagementController@agent_commissions')->name('agent.commissions');

//this will fetch datatable data in the commission table
Route::post('agent/get-commissions-data/{id}', 'AgentManagementController@agent_commissions_data')->name('agent.get-commissions-data');
//New Routes

Route::get('agents-list/{id}/edit', 'AgentManagementController@edit')->name('agents.edit');
Route::post('agents/{id}', 'AgentManagementController@update')->name('agents.update');

Route::get('agent/{id}/approved-or-disapproved/business-logo', 'AgentManagementController@approvedOrDisapproved')->name('agent.agent-details.approved-disapproved');

Route::get('trainers', 'TrainerManagementController@index')->name('trainers.index');
Route::get('trainers-data', 'TrainerManagementController@trainers_list')->name('trainers.trainers-list');
Route::get('trainers/create', 'TrainerManagementController@create')->name('trainers.create');
Route::post('trainers/store', 'TrainerManagementController@store')->name('trainers.store');
Route::get('trainers/deleted', 'TrainerManagementController@deleted')->name('trainers.deleted');
Route::get('trainers-deleted-data', 'TrainerManagementController@trainers_deleted_list')->name('trainers.trainers-deleted-list');
Route::get('trainers/{id}/edit', 'TrainerManagementController@edit')->name('trainers.edit');
Route::post('trainers/{id}', 'TrainerManagementController@update')->name('trainers.update');

Route::resource('visa-service-type', VisaServiceTypeController::class);
Route::resource('visa-letter-type', VisaLetterTypeController::class);
Route::delete('overseas/visa-preference/{id}/delete', 'StudentProfileController@deleteVisaPref')->name('overseas.visapref.delete');
Route::post('overseas/visa-preference/save', 'StudentProfileController@storeVisaPreference')->name('overseas.visapref.save');
Route::get('overseas/visa-application/{id}/add', 'StudentProfileController@addVisaApplication')->name('overseas.visaapplication.add');
Route::get('overseas/visa-application/{id}/view', 'StudentProfileController@viewApplicationByVisaPref')->name('overseas.visaapplication.view');

Route::delete('overseas/abroad-job-preference/{id}/delete', 'StudentProfileController@deleteAbroadJobPref')->name('overseas.abroad_jobpref.delete');
Route::post('overseas/abroad-job-preference/save', 'StudentProfileController@storeAbroadJobPreference')->name('overseas.abroad_jobpref.save');
Route::get('overseas/abroad-job-application/{id}/add', 'StudentProfileController@addAbroadJobApplication')->name('overseas.abroad_jobapplication.add');
Route::get('overseas/abroad-job-application/{id}/view', 'StudentProfileController@viewApplicationByAbroadJobPref')->name('overseas.abroad_jobapplication.view');

Route::get('unread-noti-count', 'NotificationController@unread_noti')->name('unread-noti-count');
Route::get('noti-list', 'NotificationController@noti_list')->name('noti-list');
Route::get('view-all-noti', 'NotificationController@view_all_noti')->name('view-all-noti');
Route::post('noti-seen', 'NotificationController@noti_seen')->name('noti-seen');

Route::get('mark-all-noti-seen/{user_id}', 'NotificationController@mark_all_noti_seen')->name('mark-all-noti-seen');


//demo-specific////////////////////////////
Route::get('demo-restriction', 'DemoModeController@disabled')->name('demo-restriction');
Route::get('demo-user-restriction', 'DemoModeController@demo_user_restriction')->name('demo-user-restriction');

// Route::get('countryinfo/removefolder/{id}', 'DemoModeController@disabled')->name('countryinfo.removefolder');
// Route::get('countryinfo/removedoc/{id}', 'DemoModeController@disabled')->name('countryinfo.removedoc');
// Route::get('democlass/removefolder/{id}', 'DemoModeController@disabled')->name('democlass.removefolder');
// Route::get('democlass/removedoc/{id}', 'DemoModeController@disabled')->name('democlass.removedoc');
// Route::delete('courseinfo/{id}', 'DemoModeController@disabled')->name('courseinfo.destroy');
// Route::delete('courses/{id}', 'DemoModeController@disabled')->name('course.destroy');
// Route::delete('leads/{id}', 'DemoModeController@disabled')->name('leadmanagement.destroy');
// Route::delete('batch/{id}', 'DemoModeController@disabled')->name('batch.destroy');
// Route::delete('upload/deletedoc/{id}', 'DemoModeController@disabled')->name('upload.deletedoc');
// Route::delete('webinar/{id}', 'DemoModeController@disabled')->name('webinar.destroy');
// Route::delete('meetingroom/{id}', 'DemoModeController@disabled')->name('meetingroom.destroy');
// Route::delete('branch/{id}', 'DemoModeController@disabled')->name('branch.destroy');
// Route::get('onlinecourses/{id}/delete', 'DemoModeController@disabled')->name('onlinecourses.destroy');
// Route::delete('chapters/{id}', 'DemoModeController@disabled')->name('chapters.destroy');
// Route::delete('quiz/{id}', 'DemoModeController@disabled')->name('quiz.destroy');
// Route::delete('q_a/{id}', 'DemoModeController@disabled')->name('q_a.destroy');
// Route::delete('comprehension/{id}', 'DemoModeController@disabled')->name('comprehension.destroy');
// Route::delete('course-category/{id}', 'DemoModeController@disabled')->name('course-category.destroy');
// Route::delete('articles/delete/{id}','DemoModeController@disabled')->name('articles.delete');

///////////////////////////////////////////

// Application Commission
Route::post('application/add-fee-commission', 'UnivApplicationsController@setFeeCommission')->name('application.set-fee-commission');

Route::post('application/add-college-fee-payment', 'UnivApplicationsController@addCollegeFeePayment')->name('application.add-college-fee-payment');
Route::get('application/edit-college-fee-payment/{id}', 'UnivApplicationsController@editCollegeFeePayment')->name('application.edit-college-fee-payment');
Route::post('application/edit-save-college-fee-payment', 'UnivApplicationsController@editSaveCollegeFeePayment')->name('application.edit.save-college-fee-payment');
Route::delete('application/delete-college-fee-payment/{id}/{application_id}', 'UnivApplicationsController@deleteCollegeFeePayment')->name('application.delete-college-fee-payment');

Route::post('application/add-my-commission', 'UnivApplicationsController@addMyCommission')->name('application.add-my-commission');
Route::get('application/edit-my-commission/{id}', 'UnivApplicationsController@editMyCommission')->name('application.edit-my-commission');
Route::post('application/edit-save-my-commission', 'UnivApplicationsController@editSaveMyCommission')->name('application.edit.save-my-commission');
Route::delete('application/delete-my-commission/{id}/{application_id}', 'UnivApplicationsController@deleteMyCommission')->name('application.delete-my-commission');

Route::post('application/add-agent-commission', 'UnivApplicationsController@addAgentCommission')->name('application.add-agent-commission');
Route::get('application/edit-agent-commission/{id}', 'UnivApplicationsController@editAgentCommission')->name('application.edit-agent-commission');
Route::post('application/edit-save-agent-commission', 'UnivApplicationsController@editSaveAgentCommission')->name('application.edit.save-agent-commission');
Route::delete('application/delete-agent-commission/{id}/{application_id}', 'UnivApplicationsController@deleteAgentCommission')->name('application.delete-agent-commission');

// Request a Document
Route::post('application/request-document', 'UnivApplicationsController@requestDocument')->name('application.request-document');
Route::post('application/upload/document-request', 'UnivApplicationsController@uploadRequestedDocument')->name('application.upload-requested-document');

// Agent Resources
Route::get('upload/agent-resources', 'AgentResourceController@index')->name('upload.agent-resources');
Route::get('upload/agent-resources/create-category', 'AgentResourceController@createCategory')->name('upload.agent-resources.create-category');
Route::post('upload/agent-resources/store', 'AgentResourceController@categoryStore')->name('upload.agent-resources.category.store');
Route::post('agent-resources/uploaddoc', 'AgentResourceController@uploaddoc')->name('agent-resources.uploaddoc');
Route::delete('upload/agent-resources/deletedoc/{id}', 'AgentResourceController@deletedoc')->name('upload.agent-resources.deletedoc');

Route::get('upload/agent-resources/category', 'AgentResourceController@showCategory')->name('agent-resources.upload.show.category');
Route::get('upload/agent-resources/edit/category/{id}', 'AgentResourceController@editCategory')->name('agent-resources.upload.edit.category');
Route::post('upload/agent-resources/edit/category/store', 'AgentResourceController@editCategoryStore')->name('agent-resources.upload.edit.category.store');
Route::post('upload/agent-resources/category/delete', 'AgentResourceController@delete')->name('agent-resources.upload.category.delete');

// Document Signature
// Route::post('document/signature', 'LeadsController@storeDocumentSignature')->name('document.signature');

// Tax
Route::get('settings/tax-index', 'TaxController@settingsTaxIndex')->name('settings.tax-index');
Route::post('settings/tax-index/tax-info/save', 'TaxController@settingTaxInfoSave')->name('settings.save.tax-info');
Route::post('settings/tax-index/tax-rates/save', 'TaxController@settingTaxRatesSave')->name('settings.tax.rates.save');
Route::patch('settings/tax-index/tax-rates/edit-save', 'TaxController@settingTaxRatesEditSave')->name('settings.tax_rates.edit');
Route::delete('settings/tax-index/tax-rates/delete/{id}', 'TaxController@settingTaxRatesDelete')->name('settings.tax_rates.delete');

Route::get('backups', 'BackupController@index')->name('backups.index');
Route::get('/backups/export', 'BackupController@exportDatabase')->name('backups.export');

// Gallery MediaLibrary
Route::get('gallery', 'MediaLibrary@galleryIndex')->name('gallery');
Route::get('gallery-edit', 'MediaLibrary@galleryEdit')->name('gallery.edit');
Route::post('gallery/store','MediaLibrary@store')->name('gallery.store');
Route::post('gallery/delete-image', 'MediaLibrary@deleteImage')->name('delete.image');

// agent-webinars
Route::post('/agent/webinar/register', [WebinarAgentController::class, 'storeAgentRegistration'])->name('agent.webinar.register');
Route::get('/agent/webinars', [WebinarAgentController::class, 'index'])->name('agent.webinars.index');
Route::post('/agent/register', [WebinarAgentController::class, 'store'])->name('agent.register');
Route::post('/admin/webinars', [WebinarController::class, 'store'])->name('admin.webinars.store');
Route::post('/agent-register', [WebinarController::class, 'store'])->name('agent.register');
Route::get('/agent/register', [WebinarController::class, 'showRegisterForm'])->name('frontend.auth.agentwebinarregister');


// //////////////// One time execution ///////////////// //
// Update Referral code of users
Route::get('updatereferralcode', 'DashboardController@updateReferralCode')->name('updatereferralcode');

// //////////////// ////////////////// ///////////////// //

// GOOGLE SHEET API
Route::get('/google/connect', [GoogleSheetSyncController::class, 'redirect'])->name('google.redirect');
Route::get('/google/sheets', [GoogleSheetSyncController::class, 'sheets'])->name('google.sheets');
Route::post('/google/sheets/select', [GoogleSheetSyncController::class, 'selectSheet'])->name('google.sheets.select');
Route::post('/google/upload-credentials', [GoogleSheetSyncController::class, 'googleUploadCredentials'])->name('google.upload.credentials');

// ESIGNATURE ROUTES 

Route::get('get-esignature-form/{id}', 'StudentProfileController@showEsignatureForm')->name('get-esignature-form');
// Route::get('esign/templates', 'StudentProfileController@fetchTemplates')->name('esign.templates');
Route::post('esign/getStatus/{send_request_id}', 'StudentProfileController@getsignaturestatus')->name('esign.getStatus');
Route::post('esign/send', 'StudentProfileController@sendDocumentForSignature')->name('esign.send');

//bulk operations in application
Route::match(['get', 'post'], 'applications/bulk-assign-view', 'UnivApplicationsController@bulkAssignView')->name('applications.bulkassignview');
Route::post('applications/bulk-assign-update', 'UnivApplicationsController@bulkAssignUpdate')->name('application.bulkassign.update');

Route::post('applications/bulk-statuschange-view', 'UnivApplicationsController@bulkStatusChangeView')->name('applications.bulkstatuschangeview');
Route::post('applications/bulk-status-update', 'UnivApplicationsController@bulkStatusUpdate')->name('application.bulkstatus.update');

Route::post('applications/bulk-delete-view', 'UnivApplicationsController@bulkDeleteView')->name('applications.bulkdeleteview');
Route::post('applications/bulk-delete', 'UnivApplicationsController@bulkDelete')->name('application.bulkdelete');

// Route::post('applications/bulk-assign', 'UnivApplicationsController@bulkAssign')->name('applications.bulkassign');
// Route::post('applications/bulk-change-status', 'UnivApplicationsController@bulkChangeStatus')->name('applications.bulkchangestatus');

