<?php

use App\Http\Controllers\Backend\Auth\Role\RoleController;
use App\Http\Controllers\Backend\Auth\User\UserController;
use App\Http\Controllers\Backend\Auth\User\UserAccessController;
use App\Http\Controllers\Backend\Auth\User\UserSocialController;
use App\Http\Controllers\Backend\Auth\User\UserStatusController;
use App\Http\Controllers\Backend\Auth\User\UserSessionController;
use App\Http\Controllers\Backend\Auth\User\UserPasswordController;
use App\Http\Controllers\Backend\Auth\User\UserConfirmationController;
use App\Http\Controllers\Backend\Auth\User\StaffController;
use App\Http\Controllers\Backend\Auth\User\AccountController;
use App\Http\Controllers\Backend\AgentManagementController;
use App\Http\Controllers\Backend\TrainerManagementController;
use App\Http\Controllers\Backend\LeadsController;
use App\Http\Controllers\Backend\DemoModeController;
use App\Http\Controllers\StaffWorkExpController;
use App\Http\Controllers\StaffEduDetailsController;
use App\Http\Controllers\StaffDependentDetailsController;
use App\Http\Controllers\StaffAditionalDocumentController;

/*
 * All route names are prefixed with 'admin.auth'.
 */
Route::group([
    'prefix'     => 'auth',
    'as'         => 'auth.',
    'namespace'  => 'Auth',
], function () {
    /*
     * User Management
     */
    Route::group(['namespace' => 'User'], function () {

        /*
         * User Status'
         */
        Route::get('user/deactivated', [UserStatusController::class, 'getDeactivated'])->name('user.deactivated');
        Route::get('user/deleted', [UserStatusController::class, 'getDeleted'])->name('user.deleted');
        Route::post('user/search', [UserController::class, 'search'])->name('user.search');

        // Archive
        Route::get('user/archive/show/student', [UserController::class, 'archiveShowStudent'])->name('user.archived-student');
        Route::post('bulk-archive/student', [UserController::class, 'bulkArchiveStudent'])->name('user.bulk.archived-student');
        
        
        /*
         * User CRUD
         */
        Route::get('user', [UserController::class, 'index'])->name('user.index');
        // Route::get('user/view/{query?}', [UserController::class, 'index'])->name('user.index');
        Route::get('user/create', [UserController::class, 'create'])->name('user.create');
        //Route::post('user', [UserController::class, 'store'])->name('user.store');
        Route::get('user/create', [UserController::class, 'studentCreate'])->name('student.create');
        Route::post('client/store', [UserController::class, 'studentstore'])->name('student.store');
        Route::post('user/userdata', [UserController::class, 'ajaxuserdata'])->name('user.ajaxuserdata');
        Route::post('user/add-tag', [UserController::class, 'add_tag'])->name('user.add-tag');
        Route::post('user/remove-tag', [UserController::class, 'remove_tag'])->name('user.remove-tag');
        Route::get('assignclient/{studentid}', [UserController::class, 'assignStudent'])->name('user.assignStudent');
        Route::post('assignclient-update', [UserController::class, 'assignStudentUpdate'])->name('user.assignstudent.update');
        Route::post('bulkassignclient', [UserController::class, 'bulkAssignStudent'])->name('user.bulkassignstudent');
        Route::post('bulkdeleteclient', [UserController::class, 'bulkDeleteStudent'])->name('user.bulkdeletestudent');
        Route::post('bulk-action/deleted', [UserController::class, 'bulkDeletedStudentAction'])->name('deleted.bulk-action');
        
        Route::get('account', [AccountController::class, 'index'])->name('adminaccount');
        Route::patch('update-apassword', [AccountController::class, 'updateAdminPassword'])->name('user.update-apassword');
        //Route::get('basic-info', [AccountController::class, 'basicinfo'])->name('abasicinfo');
        Route::get('basic-info', [StaffController::class, 'basicinfo'])->name('abasicinfo');
        Route::get('basic-info-edit', [StaffController::class, 'basicinfoedit'])->name('abasic.info.edit');
        Route::get('marklock/{user}/{status}', [UserStatusController::class, 'markStaffLock'])->name('staff.marklock')->where(['status' => '[0,1]']);


//upload documents for staff
       Route::post('/update-passport-doc/{staff_id}', [AccountController::class, 'updatePassportDoc'])->name('update-passport-doc');
       Route::post('/update-national-insurance-doc/{staff_id}', [AccountController::class, 'updateNationalIdDoc'])->name('update-national-id-doc');
       Route::post('/update-hmrc-doc/{staff_id}', [AccountController::class, 'updateHmrcDoc'])->name('update-hmrc-doc');
       Route::post('/update-contract-doc/{staff_id}', [AccountController::class, 'updateContractDoc'])->name('update-contract-doc');
       Route::post('/update-offer-letter/{staff_id}', [AccountController::class, 'updateOfferLetter'])->name('update-offer-letter');
       Route::post('/update-resume-doc/{staff_id}', [AccountController::class, 'updateResumeDoc'])->name('update-resume-doc');
       Route::post('/staff-file-upload/{staff_id}/{document_column_name}', [AccountController::class, 'staffFileUpload'])->name('staff-file-upload');

        Route::post('agents/update-business-logo', [AccountController::class, 'updateBusinessLogo'])->name('agents.update.business-logo');
        Route::patch('update-abasicinfo', [AccountController::class, 'updateBasicinfo'])->name('update-abasicinfo');
        Route::post('email-signature', [AccountController::class, 'emailSignature'])->name('save-email-signature');
        Route::delete('agent/account-removal', [AccountController::class, 'accountRemoval'])->name('agent.account.removal');

        Route::get('/download/{filename}', [AccountController::class, 'downloadFile'])
       ->where('filename', '.*')
       ->name('file.download');
        
        //Staff
        //Route::get('staff', [UserController::class, 'staff'])->name('staff');
        Route::get('staff', [StaffController::class, 'index'])->name('staff');
        Route::post('staff/search', [StaffController::class, 'search'])->name('staff.search');
        Route::get('staff/create', [StaffController::class, 'staffCreate'])->name('staff.create');
        Route::post('staff/store', [StaffController::class, 'staffStore'])->name('staff.store');
        Route::get('staff/deactivated', [StaffController::class, 'getDeactivated'])->name('staff.deactivated');
        Route::get('staff/deleted', [StaffController::class, 'getDeleted'])->name('staff.deleted');
        
        Route::post('staff/userdata', [StaffController::class, 'ajaxuserdata'])->name('staff.ajaxuserdata');


               //particular file upload according to staff input 
      
       Route::post('/update-staff-doc', [StaffAditionalDocumentController::class, 'updateStaffAdditionalDoc'])->name('update-staff-doc');
       Route::delete('/delete-staff-additional-doc/{document_id}/{staff_id}', [StaffAditionalDocumentController::class, 'deleteadditionalDoc'])->name('delete-staff-additional-doc');
       //download particular documents
       Route::get('/download-document/{id}', [StaffAditionalDocumentController::class, 'downloadDocument'])->name('download.additional.document');

        //delete documet section 
        Route::delete('/delete-passport-doc', [AccountController::class, 'deletePassportDoc'])->name('delete-passport-doc');
        Route::delete('/delete-national-id-doc', [AccountController::class, 'deleteNationalIdDoc'])->name('delete-national-id-doc');
        Route::delete('/delete-hmrc-doc', [AccountController::class, 'deleteHmrcDoc'])->name('delete-hmrc-doc');
        Route::delete('/delete-contract-agreement-doc', [AccountController::class, 'deleteContractAgreementDoc'])->name('delete-contract-agreement-doc');
        Route::delete('/delete-pan-doc', [AccountController::class, 'deletePanCardDoc'])->name('delete-pan-doc');

        Route::delete('/delete-all-doc/{staff_id}/{filename}', [AccountController::class, 'deleteAlldocument'])->name('delete-all-doc');

        // staff work experience

        Route::get('work-info-create', [StaffWorkExpController::class, 'create'])->name('work-info-create');
        
        Route::post('create-work-exp', [StaffWorkExpController::class, 'workexpstore'])
        ->name('create-work-exp');
        Route::get('work-info-edit', [StaffWorkExpController::class, 'workexpedit'])->name('work-info-edit');
        Route::post('update-staff-workexp-info' , [StaffWorkExpController::class , 'updatestaffworkexpinfo'])
        ->name('update-staff-workexp-info');


        //staff educational details
        Route::get('store-education-info', [StaffEduDetailsController::class, 'create'])->name('store-education-info');

        Route::post('add-education-info', [StaffEduDetailsController::class, 'staffeducationdetailstore'])
        ->name('add-education-info');
        Route::get('load-education-edit-modal', [StaffEduDetailsController::class, 'loadEducationEditModal'])
        ->name('load-education-edit-modal');
        Route::post('update-staff-education-info' , [StaffEduDetailsController::class , 'updatestaffeducationinfo'])
        ->name('update-staff-education-info');
        Route::delete('/delete-edu-info/{education_id}', [StaffEduDetailsController::class, 'deleteEducationInfo'])
        ->name('delete-edu-info');
      
    //staff dependent details

    Route::get('dependent-info', [StaffDependentDetailsController::class, 'create'])->name('dependent-info');
    Route::post('add-dependent-info/', [StaffDependentDetailsController::class, 'dependentdetailstore'])
    ->name('add-dependent-info');
   
    Route::get('load-dependent-edit-modal' , [StaffDependentDetailsController::class , 'loadDependentEditModal'])
    ->name('load-dependent-edit-modal');
    Route::post('update-staff-dependent-info' , [StaffDependentDetailsController::class , 'updatedependentinfo'])
    ->name('update-staff-dependent-info');
  
    //delete dependent info
    Route::delete('delete-dependent-info/{dependent_id}', [StaffDependentDetailsController::class, 'destroy'])
    ->name('delete-dependent-info');
    
  
       Route::delete('/delete-workexp-info/{workexp_id}', [StaffWorkExpController::class, 'destroy'])
        ->name('delete-workexp-info');

        //Lead
        Route::post('lead/store', [LeadsController::class, 'store'])->name('leadmanagement.store');
        
        /*
         * Specific Staff
         */
        Route::group(['prefix' => 'staff/{user}'], function () {
            Route::get('/', [StaffController::class, 'show'])->name('staff.show');

            Route::get('edit', [StaffController::class, 'edit'])->name('staff.edit');
            Route::get('edit-profile', [StaffController::class, 'editStaffDetails'])->name('staff.edit.profile');
            Route::post('save-profile', [StaffController::class, 'updateStaffDetails'])->name('staff.edit.save');

            Route::get('login-as', [UserAccessController::class, 'loginAs'])->name('staff.login-as');
            Route::get('password/change', [UserPasswordController::class, 'editStaff'])->name('staff.change-password');
            Route::get('mark/{status}', [UserStatusController::class, 'markStaff'])->name('staff.mark')->where(['status' => '[0,1]']);
            Route::get('account/confirm/resend', [UserConfirmationController::class, 'sendConfirmationEmail'])->name('staff.account.confirm.resend');
            Route::get('delete', [UserStatusController::class, 'deleteStaff'])->name('staff.delete-permanently');
            Route::get('restore', [UserStatusController::class, 'restoreStaff'])->name('staff.restore');
            Route::delete('/', [StaffController::class, 'destroy'])->name('staff.destroy');
            
            Route::patch('/', [StaffController::class, 'update'])->name('staff.update');
            Route::patch('password/change', [UserPasswordController::class, 'updateStaff'])->name('staff.change-password.post');
            
            //demo-specific////////////////////////////
            // Route::get('delete', [DemoModeController::class, 'disabled'])->name('staff.delete-permanently');
            // Route::delete('/', [DemoModeController::class, 'disabled'])->name('staff.destroy');
            ///////////////////////////////////////////

        }) ;
        
        /*
         * Specific Agent
         */        
        Route::group(['prefix' => 'agent/{user}'], function () {
            Route::get('login-as', [UserAccessController::class, 'loginAs'])->name('agent.login-as');

            Route::get('password/change', [UserPasswordController::class, 'editAgent'])->name('agent.change-password');
            Route::patch('password/change', [UserPasswordController::class, 'updateAgent'])->name('agent.change-password.post');

            Route::get('mark/{status}', [UserStatusController::class, 'markAgent'])->name('agent.mark')->where(['status' => '[0,1]']);
            Route::delete('/', [AgentManagementController::class, 'destroy'])->name('agent.destroy');            
            Route::get('delete', [UserStatusController::class, 'deleteAgent'])->name('agent.delete-permanently');
            Route::get('restore', [UserStatusController::class, 'restoreAgent'])->name('agent.restore');

        }) ;        
                
        /*
         * Specific Trainer
         */        
        Route::group(['prefix' => 'trainer/{user}'], function () {
            Route::get('login-as', [UserAccessController::class, 'loginAs'])->name('trainer.login-as');

            Route::get('password/change', [UserPasswordController::class, 'editTrainer'])->name('trainer.change-password');
            Route::patch('password/change', [UserPasswordController::class, 'updateTrainer'])->name('trainer.change-password.post');

            Route::delete('/', [TrainerManagementController::class, 'destroy'])->name('trainer.destroy');            
            Route::get('delete', [UserStatusController::class, 'deleteTrainer'])->name('trainer.delete-permanently');
            Route::get('restore', [UserStatusController::class, 'restoreTrainer'])->name('trainer.restore');

        }) ;   


        Route::post('student/overseas-status', [UserController::class, 'change_overseas_status'])->name('user.change-overseas-status');
        Route::get('student/{id}/disqualified', [UserController::class, 'student_disqualified'])->name('user.student.disqualified');
        Route::post('student/student-disqualified', [UserController::class, 'updateStudentToDisqualified'])->name('user.student.update-disqualified');
        /*
         * Specific User
         */
        Route::group(['prefix' => 'user/{user}'], function () {
            // User
            Route::get('/', [UserController::class, 'show'])->name('user.show');
            Route::get('edit', [UserController::class, 'edit'])->name('user.edit');
            Route::patch('/', [UserController::class, 'update'])->name('user.update');
            Route::delete('/', [UserController::class, 'destroy'])->name('user.destroy');

            Route::get('convert-student-lead', [UserController::class, 'convertStudentLead'])->name('user.convertStudentLead');
            // Route::post('update/convert-student-lead', [UserController::class, 'updateStudentLead'])->name('user.update.convertStudentLead');

            Route::get('agent-details-view/add-agent', 'UserController@addStudentToAgent')->name('add.student-to.agent');
            Route::post('agent-details-view/add-agent/save', 'UserController@addStudentToAgentSave')->name('add.student-to.agent.save');

            Route::get('unlink-agent/{agent}', 'UserController@unlinkAgent')->name('unlink.agent');
            
            Route::post('coursesuggestion', [UserController::class, 'coursesuggestion'])->name('user.coursesuggestion');
            Route::post('addapplication', [UserController::class, 'addapplication'])->name('user.addapplication');

            Route::get('countrypermission', [UserController::class, 'permission'])->name('user.countrypermission');            
            Route::post('countrypermissionupdate', [UserController::class, 'permissionUpdate'])->name('user.countrypermissionupdate');                        

            Route::get('democlasspermission', [UserController::class, 'democlasspermission'])->name('user.democlasspermission');            
            Route::post('democlasspermissionupdate', [UserController::class, 'democlasspermissionUpdate'])->name('user.democlasspermissionupdate');                        
                        
            // Account
            Route::get('account/confirm/resend', [UserConfirmationController::class, 'sendConfirmationEmail'])->name('user.account.confirm.resend');

            // Status
            Route::get('mark/{status}', [UserStatusController::class, 'mark'])->name('user.mark')->where(['status' => '[0,1]']);

            // Social
            Route::delete('social/{social}/unlink', [UserSocialController::class, 'unlink'])->name('user.social.unlink');

            // Confirmation
            Route::get('confirm', [UserConfirmationController::class, 'confirm'])->name('user.confirm');
            Route::get('unconfirm', [UserConfirmationController::class, 'unconfirm'])->name('user.unconfirm');

            Route::get('agent-confirm', [UserConfirmationController::class, 'agentConfirm'])->name('agent.confirm');

            // Password
            Route::get('password/change', [UserPasswordController::class, 'edit'])->name('user.change-password');
            Route::patch('password/change', [UserPasswordController::class, 'update'])->name('user.change-password.post');

            Route::get('lead/password/change', [UserPasswordController::class, 'editLead'])->name('lead.change-password');

            // Access
            Route::get('login-as', [UserAccessController::class, 'loginAs'])->name('user.login-as');

            // Session
            Route::get('clear-session', [UserSessionController::class, 'clearSession'])->name('user.clear-session');

            // Archive
            Route::get('archive/student', [UserController::class, 'archiveStudent'])->name('user.archive-user');
            Route::get('un-archive/student', [UserController::class, 'unArchiveStudent'])->name('user.un-archive-user');

            // Deleted
            Route::get('delete', [UserStatusController::class, 'delete'])->name('user.delete-permanently');
            Route::get('restore', [UserStatusController::class, 'restore'])->name('user.restore');
            
            //demo-specific////////////////////////////
            //Route::delete('/', [DemoModeController::class, 'disabled'])->name('user.destroy');
            //Route::get('delete', [DemoModeController::class, 'disabled'])->name('user.delete-permanently');
            ///////////////////////////////////////////

        });
    });

    /*
     * Role Management
     */
    Route::group(['namespace' => 'Role'], function () {
        Route::get('role', [RoleController::class, 'index'])->name('role.index');
        Route::get('role/create', [RoleController::class, 'create'])->name('role.create');
        Route::post('role', [RoleController::class, 'store'])->name('role.store');

        Route::group(['prefix' => 'role/{role}'], function () {
            Route::get('edit', [RoleController::class, 'edit'])->name('role.edit');
            Route::patch('/', [RoleController::class, 'update'])->name('role.update');
            Route::delete('/', [RoleController::class, 'destroy'])->name('role.destroy');

            //demo-specific////////////////////////////
            //Route::delete('/', [DemoModeController::class, 'disabled'])->name('role.destroy');
            ///////////////////////////////////////////

        });
    });

});
