<?php

Breadcrumbs::for('admin.auth.user.index', function ($trail) {
    if(auth()->user()->isAgent()) {
        $trail->parent('admin.agent.dashboard');
    } else {
        $trail->parent('admin.dashboard');
    }

    $trail->push(__('labels.backend.access.users.management'), route('admin.auth.user.index'));
});

Breadcrumbs::for('admin.auth.user.deactivated', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.deactivated'), route('admin.auth.user.deactivated'));
});

Breadcrumbs::for('admin.auth.user.deleted', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.deleted'), route('admin.auth.user.deleted'));
});

Breadcrumbs::for('admin.auth.user.create', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('labels.backend.access.users.create'), route('admin.auth.user.create'));
});

Breadcrumbs::for('admin.auth.user.archived-student', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push("Archived Students", route('admin.auth.user.archived-student'));
});

Breadcrumbs::for('admin.auth.student.create', function ($trail) {
$trail->parent('admin.auth.user.index');
$trail->push("Create", route('admin.auth.student.create'));
});

Breadcrumbs::for('admin.auth.user.show', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push("View", route('admin.auth.user.show', $id));
});
Breadcrumbs::for('admin.student.edit', function ($trail, $id) {
    // $trail->parent('admin.auth.user.show', $id);
    // $trail->push("Edit Profile", route('admin.student.edit', $id));
    $trail->parent('admin.auth.user.index')->push("Edit Profile", route('admin.student.edit', $id));
});

Breadcrumbs::for('admin.auth.user.edit', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.edit'), route('admin.auth.user.edit', $id));
});

Breadcrumbs::for('admin.auth.user.change-password', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.change-password'), route('admin.auth.user.change-password', $id));
});

Breadcrumbs::for('admin.auth.staff', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push('Staff Management', route('admin.auth.staff'));
});

Breadcrumbs::for('admin.auth.staff.edit', function ($trail, $id) {
    $trail->parent('admin.auth.staff');
    $trail->push('Edit Staff', route('admin.auth.staff.edit', $id));
});

Breadcrumbs::for('admin.auth.staff.edit.profile', function ($trail, $id) {
    $trail->parent('admin.auth.staff');
    $trail->push('Edit Staff Profile', route('admin.auth.staff.edit.profile', $id));
});

Breadcrumbs::for('admin.auth.staff.show', function ($trail, $id) {
    $trail->parent('admin.auth.staff');
    $trail->push('View Staff', route('admin.auth.staff.show', $id));
});

Breadcrumbs::for('admin.auth.staff.change-password', function ($trail, $id) {
    $trail->parent('admin.auth.staff');
    $trail->push(__('menus.backend.access.users.change-password'), route('admin.auth.staff.change-password', $id));
});


Breadcrumbs::for('admin.auth.staff.create', function ($trail) {
    $trail->parent('admin.auth.staff');
    $trail->push('Create User', route('admin.auth.staff.create'));
});

Breadcrumbs::for('admin.auth.staff.deleted', function ($trail) {
    $trail->parent('admin.auth.staff');
    $trail->push('Deleted Users', route('admin.auth.staff.deleted'));
});
