<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\Frontend\Trainer\TrainerController;
use App\Http\Controllers\Frontend\DemoModeController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\RazorpayController;
use App\Http\Controllers\PayPalPaymentController;
use App\Http\Controllers\FacebookLeadsController;
use App\Http\Controllers\GoogleLeadsController;
use App\Http\Controllers\DiagnosisController;
use App\Http\Controllers\CallyzerWebhookController;
use App\Http\Controllers\CurrencyRatesChangerController;
use App\Http\Controllers\UpgradeDataController;
use App\Http\Controllers\Frontend\User\CourseFinderController;
/*
 * Frontend Controllers
 * All route names are prefixed with 'frontend.'.
 */

//Course Preferences
Route::get('lang/{language}', ['as' => 'lang.switch', 'uses' => 'App\Http\Controllers\Frontend\LanguageController@swap']);
Route::post('api/search-course', [HomeController::class, 'searchCourse'])->name('searchCourse');
Route::post('api/search-university', [HomeController::class, 'searchUniversity'])->name('searchUniversity');

//open course finder
Route::get('course-finder', [CourseFinderController::class, 'course_finder'])->name('course-finder');
Route::post('fetch-subcat', [CourseFinderController::class, 'fetchSubCat'])->name('fetchSubCat');
Route::post('course-finder/fetch-result', [CourseFinderController::class, 'course_finder_fetch_result'])->name('course-finder.fetch-result');
Route::post('course-finder/bookmark', [CourseFinderController::class, 'addBookmark'])->name('course-finder.add-bookmark');
Route::get('course-finder/apply-course', [CourseFinderController::class, 'applyCourse'])->name('course-finder.apply-course');
Route::get('course-finder/{id}/course-details', [CourseFinderController::class, 'course_details'])->name('course-finder.course-details');
Route::get('course-finder/fetch-course-info/{id}', [CourseFinderController::class, 'fetch_course_info'])->name('course-finder.fetch-course-info');
Route::get('course-finder/{id}/university-details', [CourseFinderController::class, 'university_details'])->name('course-finder.university-details');


Route::get('facebook_leads', [FacebookLeadsController::class, 'leads_webhook'])->name('facebook-leads-webhook');

Route::post('google_leads', [GoogleLeadsController::class, 'leads_webhook'])->name('google-leads-webhook');

Route::post('callyzer_calls', [CallyzerWebhookController::class, 'calls_webhook'])->name('callyzer-webhook');

Route::get('web-lead-error-page', [HomeController::class, 'web_lead_error'])->name('web-lead-error-page');
Route::get('contact', 'ContactController@index')->name('contact');
Route::post('contact/send', 'ContactController@send')->name('contact.send');
Route::get('offers', 'OffersController@index')->name('offers');
Route::get('page/{slug}', [HomeController::class, 'viewArticle'])->name('view-article');
Route::get('course-info/{id}', [HomeController::class, 'viewCourseDetail'])->name('view-course');
Route::get('online-course-info/{id}', [HomeController::class, 'viewOnlineCourseDetail'])->name('view-online-course');
Route::get('country-info/{id}', [HomeController::class, 'viewCountryDetail'])->name('view-country');


Route::get('shop', 'ShopController@shop')->name('shop');
Route::get('shop/category/{slug}', 'ShopController@shop_products')->name('shop-products');
Route::get('shop/{slug}', 'ShopController@shop_product_details')->name('shop-product-details');

Route::get('cart', 'ShopController@cart')->name('cart');
Route::get('addToCart/{id}/{type?}', 'ShopController@addToCart')->name('addToCart');
Route::get('removeFromCart/{id}', 'ShopController@removeFromCart')->name('removeFromCart');
Route::get('updateCart', 'ShopController@updateCart')->name('updateCart');
Route::get('checkout', 'ShopController@checkout')->name('checkout');
Route::post('place-order', 'ShopController@place_order')->name('place-order');
Route::post('fetch-shipping-charges', 'ShopController@getShippingCost')->name('fetch-shipping-charges');


Route::get('razorpay', [RazorpayController::class, 'razorpay'])->name('razorpay');
Route::post('razorpaypayment', [RazorpayController::class, 'payment'])->name('razorpay.payment');
Route::post('razorpay/webhook', [RazorpayController::class, 'webhook'])->name('razorpay.webhook');

Route::get('stripe', [StripeController::class, 'stripe'])->name('stripe.get');
Route::post('stripe', [StripeController::class, 'stripePost'])->name('stripe.post');
Route::post('stripe/webhook', [StripeController::class, 'webhook'])->name('stripe.webhook');

Route::get('paypal/payment', [PayPalPaymentController::class, 'handlePayment'])->name('make.payment');
Route::get('paypal/cancel', [PayPalPaymentController::class, 'paymentCancel'])->name('paypal.cancel');
Route::get('paypal/success', [PayPalPaymentController::class, 'paymentReturn'])->name('paypal.return');
Route::post('paypal/webhook', [PayPalPaymentController::class, 'webhook'])->name('paypal.webhook');

Route::get('payment/success', [HomeController::class, 'paymentSuccess'])->name('payment.success');
Route::get('payment/cancel', [HomeController::class, 'paymentCancel'])->name('payment.cancel');
Route::get('invoice-payment/cancel', [HomeController::class, 'invoicepaymentCancel'])->name('invoice.payment.cancel');
Route::get('invoice-payment/success', [HomeController::class, 'invoicePaymentSuccess'])->name('invoice.payment.success');

Route::get('getversioninfo', [HomeController::class, 'getVersionInfo'])->name('getversioninfo');


/*
 * These frontend controllers require the user to be logged in
 * All route names are prefixed with 'frontend.'
 * These routes can not be hit if the password is expired
 */
Route::group(['middleware' => ['auth', 'password_expires']], function () {

        Route::get('home', 'UserHomeController@index')->name('home');

        Route::get('trainer', [TrainerController::class, 'index'])->name('trainer.dashboard');
        Route::get('trainer/myclasses', [TrainerController::class, 'classes'])->name('trainer.myclasses');
        Route::get('trainer/manage/{id}', [TrainerController::class, 'manage'])->name('trainer.attendance');
        Route::post('trainer/manage/store/{id}', [TrainerController::class, 'store'])->name('trainer.attendance.save');
        Route::get('trainer/messages/{id}', [TrainerController::class, 'messages'])->name('trainer.messages');
        Route::get('trainer/exams/{id}', [TrainerController::class, 'exams'])->name('trainer.exams');
        Route::get('trainer/exams/students-attended/{type}/{term}/{id}', [TrainerController::class, 'exams_attended'])->name('trainer.students_attended');
        Route::get('trainer/exams/students-answers/{type}/{question_type}/{student_id}/{exam_id}', [TrainerController::class, 'student_exams_answers'])->name('trainer.student_exams_answers');
        Route::get('trainer/exams/download-answers/{essay_exam_id}', [TrainerController::class, 'download_exam_answers'])->name('trainer.download_exam_answers');
        Route::post('trainer/exams/student-correct-answers/{type}/{question_type}/{student_id}/{student_exam_id}', [TrainerController::class, 'student_correct_answers'])->name('trainer.student_correct_answers');

        Route::get('agent', 'Agent\AgentController@index')->name('agent.dashboard');
        Route::get('agent/students', 'Agent\AgentController@students')->name('agent.students');
        Route::post('agent/studentsdata', 'Agent\AgentController@studentsdata')->name('agent.studentsdata');
        Route::get('agent/students/add', 'Agent\AgentController@addStudent')->name('agent.students.add');
        Route::get('agent/students/{id}/view', 'Agent\AgentController@viewStudent')->name('agent.students.view');
        Route::post('agent/students/store', 'Agent\AgentController@storeStudent')->name('agent.students.store');
        Route::get('agent/applications', 'Agent\AgentController@applications')->name('agent.applications');
        Route::post('agent/applicationsdata', 'Agent\AgentController@applicationsdata')->name('agent.applicationsdata');

        Route::group(['namespace' => 'User', 'as' => 'user.'], function () {

                Route::get('digi-prod-download/{file}', 'MyOrdersController@digi_prod_download')->name('digi_prod_download');

                Route::get('account', 'AccountController@index')->name('account');
                Route::get('profile', 'StudentBasicInfoController@index')->name('profile');

                Route::get('add-new-address', 'AccountController@add_new_address')->name('add_new_address');
                Route::post('store-shipping-address', 'AccountController@store_shipping_address')->name('store_shipping_address');

                Route::get('my-invoices', 'MyInvoicesController@index')->name('my-invoices');
                Route::get('invoices-list', 'MyInvoicesController@invoices_list')->name('my-invoices.invoices-list');
                Route::get('invoice/{id?}/viewMyInvoice', 'MyInvoicesController@view_invoice')->name('invoice.viewMyInvoice');
                Route::get('invoice/{id?}/payMyInvoice', 'MyInvoicesController@pay_invoice')->name('invoice.payMyInvoice');
                Route::get('invoice/{id?}/downloadMyInvoice', 'MyInvoicesController@download_invoice')->name('invoice.downloadMyInvoice');

                Route::get('my-orders', 'MyOrdersController@index')->name('my-orders');
                Route::get('orders-list', 'MyOrdersController@orders_list')->name('my-orders.orders-list');
                Route::get('view-order/{id}', 'MyOrdersController@view_order')->name('my-orders.view-order');

                Route::delete('account-removal', 'StudentBasicInfoController@accountRemoval')->name('account.removal');

                //Course Finder
                // Route::get('course-finder', 'CourseFinderController@course_finder')->name('course-finder');
                // Route::post('fetch-subcat', 'CourseFinderController@fetchSubCat')->name('fetchSubCat');
                // Route::post('fetch-campus', 'CourseFinderController@fetchCampus')->name('fetchCampus');
                // Route::post('course-finder/get-result', 'CourseFinderController@course_finder_result')->name('course-finder.get-result');
                Route::get('course-finder/course-details/{id}', 'CourseFinderController@course_details')->name('course-details');
                Route::get('course-finder/university-details/{id}', 'CourseFinderController@university_details')->name('university-details');
                // Route::post('course-finder/bookmark', 'CourseFinderController@addBookmark')->name('course-finder.add-bookmark');
                Route::post('course-finder/bookmark-remove', 'CourseFinderController@removeBookmark')->name('course-finder.remove-bookmark');

                // Route::get('academics', 'StudentAcademicsController@index')->name('academics');
                // Route::get('langs', 'StudentLangsController@index')->name('langs');
                // Route::get('gregmat', 'StudentGreGmatController@index')->name('gregmat');
                // Route::get('internships', 'StudentInternshipsController@index')->name('internships');
                // Route::get('experience', 'StudentExperienceController@index')->name('experience');

                // Route::get('my-docs', 'StudentDocsController@index')->name('documents');
                // Route::patch('my-docs/upload', 'StudentDocsController@upload')->name('documents.upload');
                // Route::patch('my-docs/upload-internship', 'StudentDocsController@uploadInternshipDocs')->name('documents.uploadinternshipdocs');
                // Route::patch('my-docs/upload-offerletter', 'StudentDocsController@uploadOfferLetterDocs')->name('documents.uploadofferletterdocs');
                // Route::patch('my-docs/upload-experience', 'StudentDocsController@uploadExperienceLetterDocs')->name('documents.uploadexperiencedocs');
                // Route::patch('my-docs/upload-payslips', 'StudentDocsController@uploadPayslipsDocs')->name('documents.uploadpayslipsdocs');
                // Route::patch('my-docs/upload-other', 'StudentDocsController@uploadOtherDocs')->name('documents.uploadotherdocs');
                // Route::patch('my-docs/upload-sop', 'StudentDocsController@uploadSop')->name('documents.uploadsop');
                // Route::patch('my-docs/upload-lor', 'StudentDocsController@uploadLor')->name('documents.uploadlor');

                Route::patch('profile/update', 'ProfileController@update')->name('profile.update');
                Route::patch('profile/updatebasicinfo', 'ProfileController@updatebasicinfo')->name('profile.updatebasicinfo');
                // Route::patch('profile/updateacademics', 'ProfileController@updateacademics')->name('profile.updateacademics');
                // Route::patch('profile/updatelangs', 'ProfileController@updatelangs')->name('profile.updatelangs');
                // Route::patch('profile/updategregmat', 'ProfileController@updategregmat')->name('profile.updategregmat');
                // Route::patch('profile/updateinternships', 'ProfileController@updateinternships')->name('profile.updateinternships');
                // Route::patch('profile/updateexperience', 'ProfileController@updateexperience')->name('profile.updateexperience');

                //Route::get('study-abroad-dashboard', 'StudyAbroadDashboardController@index')->name('studyabroad_dashboard');
                Route::get('overseas/profile', 'OverseasController@showProfilePage')->name('studyabroad.profile');
                Route::post('overseas/profile/basic/save', 'OverseasController@storeBasicProfile')->name('studyabroad.profile.basic.save');
                Route::get('overseas/profile/add_academics_details/open', 'OverseasController@addAcademicsInformation')->name('profile.academics_information.add');
                Route::get('overseas/profile/add_internship_details/open', 'OverseasController@addInternshipInformation',)->name('profile.internship_information.add');
                Route::get('overseas/profile/add_course_details/open', 'OverseasController@addCourseInformation',)->name('profile.course_information.add');
                Route::get('overseas/profile/add_family_details/open', 'OverseasController@addFamilyInformation')->name('profile.family_information.add');
                Route::get('overseas/profile/add_employment_details/open', 'OverseasController@addEmployment')->name('profile.employment_information.add');
                Route::get('overseas/profile/add_travel_history/open', 'OverseasController@addTravelHistory')->name('profile.travel_history.add');
                Route::get('overseas/profile/add_visa_history/open', 'OverseasController@addVisaHistory')->name('profile.visa_history.add');
                Route::get('overseas/profile/edit_academics_details/open/{id}', 'OverseasController@editAcademicsInformation')->name('profile.academics_information.edit');
                Route::get('overseas/profile/edit_internship_details/open/{id}', 'OverseasController@editInternshipInformation')->name('profile.internship_information.edit');
                Route::get('overseas/profile/edit_course_details/open/{id}', 'OverseasController@editCourseInformation')->name('profile.course_information.edit');
                Route::get('overseas/profile/edit_family_details/open/{id}', 'OverseasController@editFamilyInformation')->name('profile.family_information.edit');
                Route::get('overseas/profile/edit_employment/open/{id}', 'OverseasController@editEmployment')->name('profile.employment_information.edit');
                Route::get('overseas/profile/edit_travel_history/open/{id}', 'OverseasController@editTravelHistory')->name('profile.travel_history.edit');
                Route::get('overseas/profile/edit_visa_history/open/{id}', 'OverseasController@editVisaHistory')->name('profile.visa_history.edit');
                Route::post('overseas/profile/course_details/save', 'OverseasController@storeCourseProfile')->name('profile.course_information.save');
                Route::post('overseas/profile/academics_details/save', 'OverseasController@storeAcademicProfile')->name('profile.academics_information.save');
                Route::post('overseas/profile/family_details/save', 'OverseasController@storeFamilyProfile')->name('family.course_information.save');
                Route::post('overseas/profile/employment_details/save', 'OverseasController@employmentSave')->name('profile.employment.save');
                Route::post('overseas/profile/travel_history/save', 'OverseasController@travelHistorySave')->name('profile.travel_history.save');
                Route::post('overseas/profile/visa_history/save', 'OverseasController@visaHistorySave')->name('profile.visa_history.save');
                // Route::post('overseas/profile/academic/save', 'OverseasController@storeAcademicProfile')->name('studyabroad.profile.academic.save');
                Route::post('overseas/profile/internship_details/save', 'OverseasController@storeInternshipProfile')->name('profile.internship_information.save');
                Route::post('overseas/profile/lang/save', 'OverseasController@storeLanguagesProfile')->name('studyabroad.profile.lang.save');
                Route::post('overseas/profile/gre/save', 'OverseasController@storeGreGmatProfile')->name('studyabroad.profile.gre.save');
                // Route::post('overseas/profile/internship/save', 'OverseasController@storeInternshipsProfile')->name('studyabroad.profile.internship.save');
                Route::post('overseas/profile/experince/save', 'OverseasController@storeExperienceProfile')->name('studyabroad.profile.experience.save');
                Route::post('profile/academics_details/delete', 'OverseasController@academicsInformationDelete')->name('profile.academics_information.delete');
                Route::post('profile/internship_details/delete', 'OverseasController@InternshipProfileDelete')->name('profile.internship_information.delete');
                Route::post('profile/course_details/delete', 'OverseasController@CourseProfileDelete')->name('profile.course_information.delete');
                Route::post('profile/employment_details/delete', 'OverseasController@EmploymentDelete')->name('profile.employment_information.delete');
                Route::post('profile/visa_details/delete', 'OverseasController@VisaDelete')->name('profile.visa_information.delete');
                Route::post('profile/travel_history/delete', 'OverseasController@travelHistoryDelete')->name('profile.travel_history.delete');
                Route::post('profile/family_details/delete', 'OverseasController@FamilyProfileDelete')->name('family.course_information.delete');
                Route::get('overseas/course-preference', 'OverseasController@showCoursePreference')->name('studyabroad.coursepreference');
                Route::post('overseas/update-study-level', 'OverseasController@updateStudyLevel')->name('studyabroad.updatestudylevel');
                Route::post('overseas/course-preference/save', 'OverseasController@storeCoursePreference')->name('studyabroad.coursepreference.save');
                Route::get('overseas/docs', 'OverseasController@showDocumentsUpload')->name('studyabroad.documents');
                Route::post('overseas/docs/save', 'OverseasController@storeDocuments')->name('studyabroad.documents.save');

                Route::get('overseas/add/course-preference/{id}', 'OverseasController@addCoursePreference')->name('studyabroad.add.course-preference');

                Route::post('overseas/docs/save-cv', 'OverseasController@storeDocumentsCv')->name('studyabroad.documents.cv.upload');
                Route::post('overseas/docs/passport', 'OverseasController@storeDocumentsPassport')->name('studyabroad.documents.passport.upload');
                Route::post('overseas/docs/save-sop', 'OverseasController@storeDocumentsSop')->name('studyabroad.documents.sop.upload');
                Route::post('overseas/docs/save-essay', 'OverseasController@storeDocumentsEssay')->name('studyabroad.documents.essay.upload');
                Route::post('overseas/docs/save-lor', 'OverseasController@storeDocumentsLor')->name('studyabroad.documents.lor.upload');
                Route::post('overseas/docs/save-experience', 'OverseasController@storeDocumentsExperience')->name('studyabroad.documents.experience.upload');
                Route::post('overseas/docs/save-other', 'OverseasController@storeDocumentsOther')->name('studyabroad.documents.other.upload');
                Route::post('overseas/submit-application', 'OverseasController@submitApplication')->name('studyabroad.documents.submitapplication');

                Route::post('overseas/docs/save-additional', 'OverseasController@storeDocumentsAdditional')->name('studyabroad.documents.additional.upload');
                Route::post('overseas/docs/delete-additional', 'OverseasController@deleteDocumentsAdditional')->name('studyabroad.documents.additional.delete');

                Route::post('overseas/docs/delete-pass', 'OverseasController@deleteDocumentsPass')->name('studyabroad.documents.pass.delete');
                Route::post('overseas/docs/delete-lor', 'OverseasController@deleteDocumentsLor')->name('studyabroad.documents.lor.delete');
                Route::post('overseas/docs/delete-exp', 'OverseasController@deleteDocumentsExp')->name('studyabroad.documents.exp.delete');
                Route::post('overseas/docs/delete-other', 'OverseasController@deleteDocumentsOther')->name('studyabroad.documents.other.delete');
                Route::post('overseas/docs/delete-essay', 'OverseasController@deleteDocumentsEssay')->name('studyabroad.documents.essay.delete');

                Route::get('overseas/visa-preference', 'OverseasController@showVisaPreference')->name('visa.preference');
                Route::post('overseas/visa-preference/save', 'OverseasController@storeVisaPreference')->name('visa.preference.save');
                Route::get('overseas/visa-docs', 'OverseasController@showVisaDocumentsUpload')->name('visa.documents');
                Route::post('overseas/submit-visa-application', 'OverseasController@submitVisaApplication')->name('visa.documents.submitapplication');

                Route::get('overseas/abroad-job-preference', 'OverseasController@showAbroadJobPreference')->name('abroad_job.preference');
                Route::post('overseas/abroad-job-preference/save', 'OverseasController@storeAbroadJobPreference')->name('abroad_job.preference.save');
                Route::get('overseas/abroad-job-docs', 'OverseasController@showAbroadJobDocumentsUpload')->name('abroad_job.documents');
                Route::post('overseas/submit-abroad-job-application', 'OverseasController@submitAbroadJobApplication')->name('abroad_job.documents.submitapplication');

                Route::get('applications', 'ApplicationsController@index')->name('applications');
                Route::get('applications/detail/{id}', 'ApplicationsController@detail')->name('applications.detail');

                Route::post('applications/send/message', 'ApplicationsController@sendMessage')->name('applications.message.send');

                Route::post('applications/add', 'ApplicationsController@add')->name('applications.add');

                Route::post('application/detail/upload-requested-document', 'ApplicationsController@uploadRequestedDocument')->name('application.upload-requested-document');

                // Services and Visa 
                Route::get('service-and-visa/applications', 'ServiceAndVisaApplicationsController@index')->name('service-visa.applications');
                Route::get('service-and-visa/applications/detail/{id}', 'ServiceAndVisaApplicationsController@detail')->name('service-visa.applications.detail');
                Route::post('service-and-visa/applications/send/message', 'ServiceAndVisaApplicationsController@sendMessage')->name('service-visa.applications.message.send');

                Route::get('sop', 'SOPController@index')->name('sop');
                Route::get('sop/request', 'SOPController@request')->name('soprequest');
                // Route::get('course-selection', 'CourseSelectionController@index')->name('courseselection');
                // Route::patch('course-selection/save', 'CourseSelectionController@save')->name('courseselection.save');
                Route::get('course-suggestion', 'CourseSuggestionController@index')->name('coursesuggestion');
                Route::get('course-suggestion/feedback/{id}/{value}', 'CourseSuggestionController@feedback')->name('coursesuggestion.feedback');
                Route::get('course-suggestion/approve/{id}', 'CourseSuggestionController@approve')->name('coursesuggestion.approve');
                Route::get('hostcountryinfo/{id?}', 'HostCountryInfoController@index')->name('hostcountryinfo');


                Route::get('certificate', 'CertificateController@index')->name('certificate');
                Route::get('certificate/request', 'CertificateController@requests')->name('certificate.request');

                Route::get('my-classes', 'MyCoursesController@myCoachingClasses')->name('myclasses');
                Route::get('all-classes', 'TrainingCoursesController@coachingClasses')->name('allclasses');

                Route::get('my-online-courses', 'MyCoursesController@myOnlineCourses')->name('myonlinecourses');
                Route::get('all-online-courses', 'TrainingCoursesController@onlineCourses')->name('allonlinecourses');

                Route::get('review/{id}', 'MyCoursesController@rating')->name('review.rating');
                Route::post('review/store/{id}', 'MyCoursesController@stored')->name('review.store');
                Route::get('messages/{id}', 'MyCoursesController@messages')->name('messages');
                Route::get('write-exam/{batch_id}/{type}/{exam_id}', 'MyExamController@exams')->name('write.exam');
                Route::any('write-exam/{batch_id}/{type}/{exam_id}/{action}', 'MyExamController@exams')->name('write.exam.start');
                Route::get('view-score/{batch_id}/{exam_id}', 'MyExamController@results')->name('view.score');

                Route::get('online-course/{id}', 'MyOnlineCoursesController@onlineCourseInfo')->name('online-course-info');
                Route::get('online-course/detail/{id}', 'MyOnlineCoursesController@onlineCourseDetail')->name('online-course-detail');

                Route::get('demovideo/{id?}', 'DemoVideoController@index')->name('demovideo');

                Route::get('studentchat/group/{id}', 'ChatController@classannouncement')->name('classannouncements.get');
                Route::get('studentchat/get/{id}', 'ChatController@studentchatget')->name('studentchat.get');
                Route::post('studentchat/send', 'ChatController@studentchatstore')->name('studentchat.save');
                Route::post('trainerchat/group/send', 'ChatController@classannouncementstore')->name('trainerchat.group.save');
                Route::get('trainerchat/private/get/{studentid}', 'ChatController@privatemsgget')->name('privatemsg.get');
                Route::post('trainerchat/private/send/{studentid}', 'ChatController@privatemsgstore')->name('privatemsg.store');


                Route::get('tickets', 'TicketsController@index')->name('tickets');
                Route::get('ticketdetail/{id}', 'TicketsController@detail')->name('ticket.detail');
                Route::patch('ticketreply', 'TicketsController@reply')->name('ticket.reply');
                Route::get('ticket-new', 'TicketsController@create')->name('ticketnew');
                Route::patch('ticketnew', 'TicketsController@create')->name('ticket.new');

                Route::get('webinar', 'WebinarStudentController@index')->name('webinar.index');
                Route::get('student-webinar/{id}', 'WebinarStudentController@register')->name('webinar.register');

                Route::get('resources', 'ResourcesController@index')->name('resources');
                Route::get('resources/{id}', 'ResourcesController@category')->name('selectedcategory');
                Route::get('resources/video-audio/{id}', 'ResourcesController@media')->name('viewvideo');
        });
});

Route::get('diagnosis/sendtestemail', [DiagnosisController::class, 'sendtestemail'])->name('diagnosis.sendtestemail');

//demo-specific////////////////////////////
Route::get('demo-restriction', [DemoModeController::class, 'disabled'])->name('demo-restriction');
Route::get('demo-user-restriction', [DemoModeController::class, 'demo_user_restriction'])->name('demo-user-restriction');
//////////////////////////////////////////

// Update Curreny Rates Route
Route::get('update-currency-rates', [CurrencyRatesChangerController::class, 'sendCurrencyRatesChangeRequest'])->name('update.currencyRates');

// Update old invoice data
Route::get('update-old-invoices-data', [UpgradeDataController::class, 'updateOldInvoicesDataRequest'])->name('update.oldInvoices');
