<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\DependantDropdownController;
use App\Http\Controllers\Backend\BirthdayController;
use App\Http\Controllers\Backend\WebinarNotifyController;
use App\Http\Controllers\WebtoleadController;
use App\Http\Controllers\WatiWebhookController;
use App\Http\Controllers\WhatsAppWebhookController;
use App\Http\Controllers\FacebookLeadWebhookController;
use App\Http\Controllers\FormsController;
use App\Http\Controllers\GoogleSheetSyncController;
/*
 * Global Routes
 * Routes that are used between both frontend and backend.
 */
Route::get('/google/callback', [GoogleSheetSyncController::class, 'callback'])->name('google.callback');
Route::get('/oauth/gmail', function (){
    return LaravelGmail::redirect();
});

Route::get('/oauth/gmail/callback', function (){
    LaravelGmail::makeToken();
    return redirect()->to('/');
});

Route::get('/oauth/gmail/logout', function (){
    LaravelGmail::logout(); //It returns exception if fails
    return redirect()->to('/');
});
/* ======== Whatsapp Webhook ======== */
Route::get('whatsapp/webhook', [WhatsAppWebhookController::class, 'verify']);
Route::post('whatsapp/webhook', [WhatsAppWebhookController::class, 'receive'])
    ->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);


/* ========= Facebook Lead Webhook ========= */
Route::get('/facebook/webhook', [FacebookLeadWebhookController::class, 'verifyWebhook']);
Route::post('/facebook/webhook', [FacebookLeadWebhookController::class, 'handleWebhook'])->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);



// form builder forms
Route::get('lead-forms/{form_id}/form', [FormsController::class, 'view_form'])->name('form-builder.view-form');
Route::get('lead-forms-embed/{form_id}/form', [FormsController::class, 'view_form_embed'])->name('form-builder.view-form-embed');
Route::post('form-builder-lead-tracking', [FormsController::class, 'formBuilderLeadTracking'])->name('form-builder-lead-tracking');

Route::post('api/validate-email', [FormsController::class, 'validate_email'])->name('validate-email');
Route::post('api/validate-mobile', [FormsController::class, 'validate_mobile'])->name('validate-mobile');
Route::post('api/validate-email-mobile', [FormsController::class, 'validate_email_mobile'])->name('validate-email-mobile');
// form builder forms

Route::get('/', [HomeController::class, 'index'])->name('index');
Route::post('web-to-lead-tracking', [WebtoleadController::class, 'webToLeadTracking'])->name('web-to-lead-tracking');
Route::post('wati-webhook-1700746459', [WatiWebhookController::class, 'index'])->name('wati-webhook');

// WEBINAR PUBLIC URI
Route::get('/webinar/{webinar_id}', [HomeController::class, 'showPublicWebinar'])->name('public.webinar.show');

// Switch between the included languages
Route::get('lang/{lang}', [LanguageController::class, 'swap']);
Route::get('birthdaywish/send', [BirthdayController::class, 'birthdayWishes']);
Route::get('cron/webinarnotify', [WebinarNotifyController::class, 'notify']);

Route::post('api/fetch-states', [DependantDropdownController::class, 'fetchState'])->name('fetchState');
Route::post('api/fetch-cities', [DependantDropdownController::class, 'fetchCity'])->name('fetchCity');

Route::post('api/fetch-cities-by-country', [DependantDropdownController::class, 'fetchCitiesByCountry'])->name('fetchCitiesByCountry');


Route::post('api/fetch-university', [DependantDropdownController::class, 'fetchUniversity'])->name('fetchUniverstiy');
Route::post('api/fetch-course', [DependantDropdownController::class, 'fetchCourse'])->name('fetchCourse');

Route::post('api/fetch-visa-letter-types', [DependantDropdownController::class, 'fetchVisaLetterType'])->name('fetchVisaLetterType');

/*
 * Frontend Routes
 * Namespaces indicate folder structure
 */
Route::group(['namespace' => 'App\Http\Controllers\Frontend', 'as' => 'frontend.'], function () {
    include_route_files(__DIR__.'/frontend/');
});

/*
 * Backend Routes
 * Namespaces indicate folder structure
 */
Route::group(['namespace' => 'App\Http\Controllers\Backend', 'prefix' => 'admin', 'as' => 'admin.', 'middleware' => 'admin'], function () {
    /*
     * These routes need view-backend permission
     * (good if you want to allow more than one group in the backend,
     * then limit the backend features by different roles or permissions)
     *
     * Note: Administrator has all permissions so you do not have to specify the administrator role everywhere.
     * These routes can not be hit if the password is expired
     */
    include_route_files(__DIR__.'/backend/');
});
